// KissConfig.cpp
// Vicente Soriano - victek@gmail.com
// Gestor centralizado de configuración persistente

#include "KissConfig.h"

// ========== IMPLEMENTACIÓN PRIVADA ==========
bool KissConfig::getBool(const char* key, bool defaultValue) {
  if (!nvs.begin("kiss_suite", true)) return defaultValue;
  bool value = nvs.getBool(key, defaultValue);
  nvs.end();
  return value;
}

bool KissConfig::setBool(const char* key, bool value) {
  if (!nvs.begin("kiss_suite", false)) return false;
  nvs.putBool(key, value);
  nvs.end();
  return true;
}

int KissConfig::getInt(const char* key, int defaultValue) {
  if (!nvs.begin("kiss_suite", true)) return defaultValue;
  int value = nvs.getInt(key, defaultValue);
  nvs.end();
  return value;
}

bool KissConfig::setInt(const char* key, int value) {
  if (!nvs.begin("kiss_suite", false)) return false;
  nvs.putInt(key, value);
  nvs.end();
  return true;
}

unsigned long KissConfig::getULong(const char* key, unsigned long defaultValue) {
  if (!nvs.begin("kiss_suite", true)) return defaultValue;
  unsigned long value = nvs.getULong(key, defaultValue);
  nvs.end();
  return value;
}

bool KissConfig::setULong(const char* key, unsigned long value) {
  if (!nvs.begin("kiss_suite", false)) return false;
  nvs.putULong(key, value);
  nvs.end();
  return true;
}

String KissConfig::getString(const char* key, const char* defaultValue) {
  if (!nvs.begin("kiss_suite", true)) return String(defaultValue);
  String value = nvs.getString(key, defaultValue);
  nvs.end();
  return value;
}

bool KissConfig::setString(const char* key, const char* value) {
  if (!nvs.begin("kiss_suite", false)) return false;
  nvs.putString(key, value);
  nvs.end();
  return true;
}