#ifndef LANG_EN_H
#define LANG_EN_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Hello.\nCommunication established\n\n🔨 Compiled: %s\n🔢 Hash: 0x%08X\n📦 Version: %s\n📊 Status:\nRestarts: %d\nUptime: %lu sec\nFree RAM: %d bytes\nPending messages: %d\n📡 WiFi Signal: %d dBm (%s)"

// WiFi signal quality
#define LANG_WIFI_EXCELLENT "Excellent"
#define LANG_WIFI_GOOD "Good"
#define LANG_WIFI_FAIR "Fair"
#define LANG_WIFI_WEAK "Weak"

// /estado command
#define LANG_STATUS_TITLE_RELIABILITY "🎯 SYSTEM RELIABILITY"
#define LANG_STATUS_SYSTEM "System"
#define LANG_STATUS_RELIABLE "RELIABLE"
#define LANG_STATUS_CHECK "CHECK"
#define LANG_STATUS_SENT "Messages sent"
#define LANG_STATUS_PENDING "Pending messages"
#define LANG_STATUS_LOST "Lost messages"
#define LANG_STATUS_DISCARDED "Discarded (queue full)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 EXTERNAL ADVERSITIES"
#define LANG_STATUS_ERRORS "Total errors"
#define LANG_STATUS_RECOVERED "Recovered (fallback)"
#define LANG_STATUS_WIFI_DROPS "WiFi drops"
#define LANG_STATUS_TITLE_TECHNICAL "📊 TECHNICAL INFORMATION"
#define LANG_STATUS_UPTIME "Uptime"
#define LANG_STATUS_FREE_RAM "Free RAM"
#define LANG_STATUS_FREE_PSRAM "Free PSRAM"
#define LANG_STATUS_FREE_FS "Free FS"
#define LANG_STATUS_MAX_FS "Max. in FS"
#define LANG_STATUS_MESSAGES "Messages"
#define LANG_STATUS_POWER_MODE "Power Mode"
#define LANG_STATUS_WIFI_SIGNAL "WiFi Signal"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SECURE"
#define LANG_STATUS_SSL_INSECURE "INSECURE"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "ACTIVE"
#define LANG_STATUS_INACTIVE "INACTIVE"
#define LANG_STATUS_AUTO_MSGS "Auto-messages"
#define LANG_STATUS_YES "YES"
#define LANG_STATUS_NO "NO"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA already in progress"
#define LANG_OTA_PIN_BLOCK "🔒 PIN LOCKED\n\nTo unlock the OTA function, type /otapuk [PUK]\nOnce unlocked, you can start a new process with /ota\n\nIf you don't have the PUK, contact the administrator."
#define LANG_OTA_INI_1 "📦 OTA UPDATE\n\nWe are going to start a firmware update for the device.\n\nDuring the update:\n• Messages are stored on the device\n• You will not lose messages\n• You will not receive command messages\n• To cancel the process, send /otacancel\n\nType /otapin [PIN] to start the process\n\n⏱️ You have 60 seconds"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nThe time to enter the PIN has expired.\nProcess cancelled.\n\nStart again with /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ OTA TIMEOUT\n\nThe process has exceeded the maximum time of 7 minutes.\nProcess cancelled.\n\nThe system returns to normal operation.\nStart again with /ota"
#define LANG_OTA_PIN_OK "✅ CORRECT PIN\n\nStarting update process...\n\n• Messages paused\n• Checking available space\n• Creating backup of current firmware\n\n⏱️ Process timeout: 7 minutes\n\nDo not turn off the device."
#define LANG_OTA_ERROR_BACKUP "❌ BACKUP ERROR\n\nCould not create a backup of the current firmware.\nProcess cancelled.\n\nThe system returns to normal operation.\nStart again with /ota"
#define LANG_OTA_INI_2 "✅ BACKUP COMPLETED\n\nCurrent firmware saved correctly.\n\n📤 Send the .bin file of the new firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN BLOCKED\n\nYou have exceeded the maximum of 3 attempts.\nThe current process is cancelled.\n\nTo unlock the OTA function, type /otapuk [PUK]\nOnce unlocked, you can start a new process with /ota\n\nIf you don't have the PUK, contact the administrator."
#define LANG_OTA_PIN_FAIL "❌ Incorrect PIN\n\nRemaining attempts: %d\n\nType /otapin [PIN] to retry"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA UNLOCKED\n\nThe PIN has been unlocked successfully.\nPIN attempts have been reset.\n\nTo start an update, type /ota"
#define LANG_OTA_PUK_WRONG "❌ Incorrect PUK"
#define LANG_OTA_PR_INACTI "❌ No active OTA process"
#define LANG_OTA_REVERT "🔄 STARTING ROLLBACK\n\nRestoring previous firmware...\nThe device will reboot.\n\nDo not turn off the device."
#define LANG_OTA_CANCEL "🛑 PROCESS CANCELLED\n\nThe update has been cancelled.\nNo changes have been made to the firmware.\n\nThe system returns to normal operation."
#define LANG_OTA_FLASH "🔥 FLASHING FIRMWARE\n\nWriting to flash memory...\nThis may take several minutes.\n\n⚠️ DO NOT DISCONNECT THE DEVICE"
#define LANG_OTA_FLASH_F "❌ FLASH ERROR\n\nFirmware writing failed.\nStarting automatic rollback...\n\nThe device will reboot with the previous firmware.\n\nDo not turn off the device."
#define LANG_OTA_VALIDATED "✅ FIRMWARE VALIDATED\n\nThe update completed successfully.\nBackup deleted.\n\nThe system returns to normal operation.\nPending messages will be processed now.(You can ignore the previous validation message)"
#define LANG_OTA_NONVALID "❌ INVALID FILE\n\nInvalid filename.\n\nSend a .bin firmware file"
#define LANG_OTA_WRONG_EXT "❌ INVALID FILE\n\nThe file must be .bin\nReceived: %s\n\nSend a valid firmware file."
#define LANG_OTA_TOO_BIG "❌ FILE TOO LARGE\n\nSize: %.2f MB\nMaximum: %.2f MB\n\nSend a smaller file."
#define LANG_OTA_TOO_SMALL "⚠️ FILE VERY SMALL\n\nSize: %.1f KB\n\nAre you sure this is a valid firmware?"
#define LANG_OTA_DOWNLOADING "📥 DOWNLOADING FIRMWARE\n\nReceiving file: %s\nSize: %.2f MB\n\nDo not disconnect the device."
#define LANG_OTA_DOWN_FAIL "❌ DOWNLOAD FAILED\n\nCould not download the firmware after 3 attempts.\nPossible cause: unstable WiFi connection.\n\nProcess cancelled.\nStart again with /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 VERIFYING INTEGRITY\n\nChecking firmware checksum..."
#define LANG_OTA_CHKSUM_WRONG "❌ VERIFICATION FAILED\n\nThe file is corrupt or incomplete.\n\nProcess cancelled.\nStart again with /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VERIFIED\n\nFile: %s\nSize: %.2f MB\nCRC32: 0x%08X\n⚠️CONFIRM FLASH\n\n/otaconfirm - Flash now\n/otacancel - Cancel process\n\nTimeout: 3 minutes"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- The time to enter the PIN has expired.\n- Process aborted. The system returns to normal state.\n\n- Start again with /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ VALIDATION TIMEOUT\n\nNo confirmation received in 60 seconds.\nStarting automatic rollback...\n\nThe device will reboot with the previous firmware"
#define LANG_OTA_TIMEOUT "⏱️ OTA TIMEOUT\n\nThe process has exceeded the maximum time of 7 minutes.\nProcess cancelled.\n\nThe system returns to normal operation.\nStart again with /ota"
#define LANG_OTA_CHECK_FS "❌ SYSTEM ERROR\n\nCould not access the file system.\nProcess cancelled."
#define LANG_OTA_NOT_ENOUGH "❌ INSUFFICIENT SPACE\n\nNot enough space available to create the backup.\n\nRequired: %.1f MB\nAvailable: %.1f MB\n\nFree up space and retry with /ota"
#define LANG_OTA_BEF_REBOOT "✅ FLASH COMPLETED\n\nFirmware written successfully.\nThe device will now reboot.\n\nAfter rebooting, you will have 60 seconds to validate with /otaok\nIf not validated, an automatic rollback will be executed."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA INTERRUPTED\n\nThe device rebooted during the OTA process.\nPartial download deleted.\n\nThe system returns to normal operation.\nStart again with /ota"
#define LANG_OTA_MAINT_MODE "🔄 FIRMWARE VALIDATION\n\nThe device has booted.\n\n⏱️ You have 60 seconds to validate\n\n/otaok - Confirm it is working correctly\n/otacancel - Force rollback to previous firmware\n\nIf no response, automatic rollback will be executed."
#define LANG_OTA_CRITI_ERROR "🔥 CRITICAL ERROR\n\nRollback has failed.\nThe system may be unstable.\n\nRequires manual intervention.\nContact the administrator."
#define LANG_OTA_ERROR_RECOVER "🔥 CRITICAL ERROR\n\nRecovery has failed.\nThe system may be unstable.\n\nRequires manual intervention.\nContact the administrator."
#define LANG_OTA_RECOVER_ERROR "❌ NO BACKUP AVAILABLE\n\nRecovery cannot be performed.\nThe system keeps the current firmware."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ LittleFS initialization error"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram destroyed"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Maintenance mode enabled: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Maintenance mode disabled"
#define LANG_INFO_CON_RESUME "🔗 Reusing previous connection"
#define LANG_INFO_CON_DIE "🔌 Cleaning dead connection"
#define LANG_INFO_CON_CLEAN "🔌 Error %d - cleaning connection"
#define LANG_INFO_FS_NEAR "❌ FS at %.1f%% - message discarded"
#define LANG_INFO_FS_FULL "❌ FS no space - message discarded"
#define LANG_ERROR_FS_SAVE "❌ Error saving to LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d sent (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Error sending message from queue"
#define LANG_WARN_MSG_DUP "⚠️ Duplicate update ignored: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Message with invalid length: %d bytes"
#define LANG_WARN_NOID "⚠️ Message without valid chat_id - ignored"
#define LANG_WARN_WRLEN "⚠️ file_id with invalid length: %d bytes"
#define LANG_WARN_TSSL "🔒 Attempting secure SSL connection..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "YES" : "NO"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 CA Certificate configured"
#define LANG_ERROR_SSLCLI "❌ sslClient is NULL"
#define LANG_INFO_TEST_BASIC "💡 Testing basic connectivity..."
#define LANG_INFO_CON_BASIC "💡 Basic connectivity: %s in %lu ms"
#define LANG_INFO_SSL_TEST "💡 SSL Connection: %s in %lu ms", connected ? "SUCCESSFUL" : "FAILED"
#define LANG_INFO_SSL_SUCC "✅ SSL connection successful in %lu ms"
#define LANG_INFO_CERT_VERI "✅ Certificate verified correctly"
#define LANG_INFO_CERT_FAIL "❌ Certificate verification failed"
#define LANG_WARN_CERT_FAIL "⚠️ Certificate not verified (time not synced)"
#define LANG_ERROR_SSL_FAIL "❌ SSL connection failed after %lu ms"
#define LANG_INFO_FRRAM "💡 RAM Header: %d"
#define LANG_WARN_INSECURE "⚠️ Insecure connection successful in %lu ms"
#define LANG_ERROR_INSECURE "❌ Insecure connection failed after %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Secure: %s\n - Time synced: %s\n - Free memory: %d bytes\n - Client: %s", sslSecure ? "YES" : "NO", KissTime::getInstance().isTimeSynced() ? "YES" : "NO", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "CONNECTED" : "DISCONNECTED") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Storage completely cleaned"
#define LANG_ERROR_MSG_TOLA "❌ Message too long"
#define LANG_ERROR_MSG_WRIT "❌ Error writing message"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d messages deleted"
#define LANG_INFO_FLUSH "🗑️ Final flush - empty queue"
#define LANG_INFO_MSG_QUEUE "📤 Processed %d messages from queue"
#define LANG_INFO_POWER_MODE "\n🔋 POWER:"
#define LANG_INFO_TUR_ACT "🚀 TURBO MODE ACTIVATED"
#define LANG_INFO_TUR_DEAC "🐢 TURBO MODE DEACTIVATED - %d msgs in %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 KISSTELEGRAM DIAGNOSTIC:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - Pending: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "STABLE" : "UNSTABLE"
#define LANG_INFO_DIAG_4 " - Maintenance: %s", maintenanceMode ? "ACTIVE" : "INACTIVE"
#define LANG_INFO_DIAG_5 " - Memory: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 STORAGE (Direct FS):"
#define LANG_INFO_STOR_2 " - Pending: %d"
#define LANG_INFO_STATS_1 "\n🎯 STATUS:"
#define LANG_INFO_STATS_2 " - Pending: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "YES" : "NO"
#define LANG_INFO_STATS_4 "\n⚙️ CONFIG:"
#define LANG_INFO_STATS_5 " - Interval: %d ms"
#define LANG_INFO_STATS_6 " - Max storage: %d"
#define LANG_INFO_FS_PEND "💾 Direct FS:\n - Pending: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-Direct-FS\n - Pending: %d\n - Memory: %d"
#define LANG_INFO_CLOSE_CON "🕒 Closing connection due to age (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTHORIZED"
#define LANG_INFO_SSL "🔒 SSL INFO (sent to serial)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: Testing SSL connection..."
#define LANG_INFO_SSL_TEST_1 "📍 CALLED from testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: SSL Test SUCCESSFUL"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: SSL Test FAILED"
#define LANG_INFO_CON_LIM "⏱️ Too fast Telegram connection limited to (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 Auto-adjusting SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ SSL connection successful"
#define LANG_ERROR_SSL_FAIL_1 "❌ SSL connection failed"
#define LANG_INFO_PING_TG "💓 Keep-alive ping to Telegram..."
#define LANG_INFO_PING_REP "💓 Ping result: %s (%d bytes)", foundOK ? "OK" : "FAIL"

#endif