#ifndef LANG_ES_H
#define LANG_ES_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Hola.\nComunicación estable\n\n🔨 Compilado: %s\n🔢 Hash: 0x%08X\n📦 Versión: %s\n📊 Estado:\nReinicios: %d\nTiempo iniciado: %lu seg\nRAM libre: %d bytes\nMensajes pendientes: %d\n📡 Señal WiFi: %d dBm (%s)"

// Calidad de señal WiFi
#define LANG_WIFI_EXCELLENT "Excelente"
#define LANG_WIFI_GOOD "Buena"
#define LANG_WIFI_FAIR "Regular"
#define LANG_WIFI_WEAK "Débil"

// Comando /estado
#define LANG_STATUS_TITLE_RELIABILITY "🎯 FIABILIDAD SISTEMA"
#define LANG_STATUS_SYSTEM "Sistema"
#define LANG_STATUS_RELIABLE "FIABLE"
#define LANG_STATUS_CHECK "REVISAR"
#define LANG_STATUS_SENT "Mensajes enviados"
#define LANG_STATUS_PENDING "Mensajes pendientes"
#define LANG_STATUS_LOST "Mensajes perdidos"
#define LANG_STATUS_DISCARDED "Descartes (cola llena)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 ADVERSIDADES EXTERNAS"
#define LANG_STATUS_ERRORS "Errores totales"
#define LANG_STATUS_RECOVERED "Recuperados (fallback)"
#define LANG_STATUS_WIFI_DROPS "Caídas WiFi"
#define LANG_STATUS_TITLE_TECHNICAL "📊 INFORMACIÓN TÉCNICA"
#define LANG_STATUS_UPTIME "Tiempo funcionamiento"
#define LANG_STATUS_FREE_RAM "RAM libre"
#define LANG_STATUS_FREE_PSRAM "PSRAM libre"
#define LANG_STATUS_FREE_FS "FS libre"
#define LANG_STATUS_MAX_FS "Max. en FS"
#define LANG_STATUS_MESSAGES "Mensajes"
#define LANG_STATUS_POWER_MODE "Modo Energía"
#define LANG_STATUS_WIFI_SIGNAL "Señal WiFi"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SEGURO"
#define LANG_STATUS_SSL_INSECURE "INSEGURO"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "ACTIVO"
#define LANG_STATUS_INACTIVE "INACTIVO"
#define LANG_STATUS_AUTO_MSGS "Auto-mensajes"
#define LANG_STATUS_YES "SI"
#define LANG_STATUS_NO "NO"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA ya en progreso"
#define LANG_OTA_PIN_BLOCK "🔒 PIN BLOQUEADO\n\nPara desbloquear la función OTA escriba /otapuk [PUK]\nUna vez desbloqueado podrá iniciar un nuevo proceso con /ota\n\nSi no dispone del PUK contacte con el administrador."
#define LANG_OTA_INI_1 "📦 ACTUALIZACIÓN OTA\n\nVamos a iniciar una actualización del firmware del dispositivo.\n\nDurante la actualización:\n• Los mensajes quedan almacenados en el dispositivo\n• No perderá mensajes\n• No recibirá comandos mensajes\n• Si quiere cancelar el proceso envíe /otacancel\n\nEscriba /otapin [PIN] para iniciar el proceso\n\n⏱️ Dispone de 60 segundos"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nEl tiempo para introducir el PIN ha expirado.\nProceso cancelado.\n\nInicie de nuevo con /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ TIMEOUT OTA\n\nEl proceso ha excedido el tiempo máximo de 7 minutos.\nProceso cancelado.\n\nEl sistema vuelve a operación normal.\nInicie de nuevo con /ota"
#define LANG_OTA_PIN_OK "✅ PIN CORRECTO\n\nIniciando proceso de actualización...\n\n• Mensajes pausados\n• Verificando espacio disponible\n• Creando backup del firmware actual\n\n⏱️ Timeout proceso: 7 minutos\n\nNo apague el dispositivo."
#define LANG_OTA_ERROR_BACKUP "❌ ERROR EN BACKUP\n\nNo se pudo crear el backup del firmware actual.\nProceso cancelado.\n\nEl sistema vuelve a operación normal.\nInicie de nuevo con /ota"
#define LANG_OTA_INI_2 "✅ BACKUP COMPLETADO\n\nFirmware actual guardado correctamente.\n\n📤 Envíe el archivo .bin del nuevo firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN BLOQUEADO\n\nHa superado el máximo de 3 intentos.\nEl proceso actual se cancela.\n\nPara desbloquear la función OTA escriba /otapuk [PUK]\nUna vez desbloqueado podrá iniciar un nuevo proceso con /ota\n\nSi no dispone del PUK contacte con el administrador."
#define LANG_OTA_PIN_FAIL "❌ PIN incorrecto\n\nIntentos restantes: %d\n\nEscriba /otapin [PIN] para reintentar"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA DESBLOQUEADO\n\nEl PIN ha sido desbloqueado correctamente.\nLos intentos de PIN se han restablecido.\n\nPara iniciar una actualización escriba /ota"
#define LANG_OTA_PUK_WRONG "❌ PUK incorrecto"
#define LANG_OTA_PR_INACTI "❌ No hay proceso OTA activo"
#define LANG_OTA_REVERT "🔄 INICIANDO ROLLBACK\n\nRestaurando firmware anterior...\nEl dispositivo se reiniciará.\n\nNo apague el dispositivo."
#define LANG_OTA_CANCEL "🛑 PROCESO CANCELADO\n\nLa actualización ha sido cancelada.\nNo se han realizado cambios en el firmware.\n\nEl sistema vuelve a operación normal."
#define LANG_OTA_FLASH "🔥 FLASHEANDO FIRMWARE\n\nEscribiendo en memoria flash...\nEsto puede tardar varios minutos.\n\n⚠️ NO DESCONECTE EL DISPOSITIVO"
#define LANG_OTA_FLASH_F "❌ ERROR DE FLASH\n\nLa escritura del firmware ha fallado.\nIniciando rollback automático...\n\nEl dispositivo se reiniciará con el firmware anterior.\n\nNo apague el dispositivo."
#define LANG_OTA_VALIDATED "✅ FIRMWARE VALIDADO\n\nLa actualización se completó con éxito.\nBackup eliminado.\n\nEl sistema vuelve a operación normal.\nLos mensajes pendientes se procesarán ahora.(Puede ignorar el mensaje anterior de validación)"
#define LANG_OTA_NONVALID "❌ ARCHIVO INVÁLIDO\n\nNombre de archivo no válido.\n\nEnvíe un archivo de firmware .bin"
#define LANG_OTA_WRONG_EXT "❌ ARCHIVO INVÁLIDO\n\nEl archivo debe ser .bin\nRecibido: %s\n\nEnvíe un archivo de firmware válido."
#define LANG_OTA_TOO_BIG "❌ ARCHIVO DEMASIADO GRANDE\n\nTamaño: %.2f MB\nMáximo: %.2f MB\n\nEnvíe un archivo más pequeño."
#define LANG_OTA_TOO_SMALL "⚠️ ARCHIVO MUY PEQUEÑO\n\nTamaño: %.1f KB\n\n¿Seguro que es un firmware válido?"
#define LANG_OTA_DOWNLOADING "📥 DESCARGANDO FIRMWARE\n\nRecibiendo archivo: %s\nTamaño: %.2f MB\n\nNo desconecte el dispositivo."
#define LANG_OTA_DOWN_FAIL "❌ DESCARGA FALLIDA\n\nNo se pudo descargar el firmware tras 3 intentos.\nPosible causa: conexión WiFi inestable.\n\nProceso cancelado.\nInicie de nuevo con /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 VERIFICANDO INTEGRIDAD\n\nComprobando checksum del firmware..."
#define LANG_OTA_CHKSUM_WRONG "❌ VERIFICACIÓN FALLIDA\n\nEl archivo está corrupto o incompleto.\n\nProceso cancelado.\nInicie de nuevo con /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VERIFICADO\n\nArchivo: %s\nTamaño: %.2f MB\nCRC32: 0x%08X\n⚠️CONFIRMAR FLASH\n\n/otaconfirm - Flashear ahora\n/otacancel - Cancelar proceso\n\nTimeout: 3 minutos"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- El tiempo para introducir el PIN ha expirado.\n- Proceso abortado, El sistema vuelve a estado normal.\n\n- Inicie de nuevo con /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ TIMEOUT VALIDACIÓN\n\nNo se recibió confirmación en 60 segundos.\nIniciando rollback automático...\n\nEl dispositivo se reiniciará con el firmware anterior"
#define LANG_OTA_TIMEOUT "⏱️ TIMEOUT OTA\n\nEl proceso ha excedido el tiempo máximo de 7 minutos.\nProceso cancelado.\n\nEl sistema vuelve a operación normal.\nInicie de nuevo con /ota"
#define LANG_OTA_CHECK_FS "❌ ERROR DE SISTEMA\n\nNo se pudo acceder al sistema de archivos.\nProceso cancelado."
#define LANG_OTA_NOT_ENOUGH "❌ ESPACIO INSUFICIENTE\n\nNo hay espacio disponible para crear el backup.\n\nNecesario: %.1f MB\nDisponible: %.1f MB\n\nLibere espacio y reintente con /ota"
#define LANG_OTA_BEF_REBOOT "✅ FLASH COMPLETADO\n\nFirmware escrito correctamente.\nEl dispositivo se reiniciará ahora.\n\nTras reiniciar tendrá 60 segundos para validar con /otaok\nSi no valida se ejecutará vuelta atrás automática."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA INTERRUMPIDO\n\nEl dispositivo se reinició durante el proceso OTA.\nDescarga parcial eliminada.\n\nEl sistema vuelve a operación normal.\nInicie de nuevo con /ota"
#define LANG_OTA_MAINT_MODE "🔄 VALIDACIÓN FIRMWARE\n\nEl dispositivo ha arrancado.\n\n⏱️ Tiene 60 segundos para validar\n\n/otaok - Confirmar que funciona correctamente\n/otacancel - Forzar rollback al firmware anterior\n\nSi no responde se ejecutará rollback automático."
#define LANG_OTA_CRITI_ERROR "🔥 ERROR CRÍTICO\n\nEl rollback ha fallado.\nEl sistema puede estar inestable.\n\nRequiere intervención manual.\nContacte con el administrador."
#define LANG_OTA_ERROR_RECOVER "🔥 ERROR CRÍTICO\n\nLa recuperación ha fallado.\nEl sistema puede estar inestable.\n\nRequiere intervención manual.\nContacte con el administrador."
#define LANG_OTA_RECOVER_ERROR "❌ NO HAY COPIA DE SEGURIDAD\n\nNo se puede realizar recuperación.\nEl sistema mantiene el firmware actual."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ Error inicialización LittleFS"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram destruido"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Modo mantenimiento activado: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Modo mantenimineto desactivado"
#define LANG_INFO_CON_RESUME "🔗 Aprovechando conexión anterior"
#define LANG_INFO_CON_DIE "🔌 Limpiando conexión muerta"
#define LANG_INFO_CON_CLEAN "🔌 Error %d - limpiando conexión"
#define LANG_INFO_FS_NEAR "❌ FS al %.1f%% - mensaje descartado"
#define LANG_INFO_FS_FULL "❌ FS sin espacio - mensaje descartado"
#define LANG_ERROR_FS_SAVE "❌ Error guardando en LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d enviados (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Error enviando mensaje desde cola"
#define LANG_WARN_MSG_DUP "⚠️ Update duplicado ignorado: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Mensaje con longitud inválida: %d bytes"
#define LANG_WARN_NOID "⚠️ Mensaje sin chat_id válido - ignorado"
#define LANG_WARN_WRLEN "⚠️ file_id con longitud inválida: %d bytes"
#define LANG_WARN_TSSL "🔒 Intentando conexión SSL segura..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "SI" : "NO"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 Certificado CA configurado"
#define LANG_ERROR_SSLCLI "❌ sslClient es NULL"
#define LANG_INFO_TEST_BASIC "💡 Probando conectividad básica..."
#define LANG_INFO_CON_BASIC "💡 Conectividad básica: %s en %lu ms"
#define LANG_INFO_SSL_TEST "💡 Conexión SSL: %s en %lu ms", connected ? "EXITOSA" : "FALLIDA"
#define LANG_INFO_SSL_SUCC "✅ Conexión SSL exitosa en %lu ms"
#define LANG_INFO_CERT_VERI "✅ Certificado verificado correctamente"
#define LANG_INFO_CERT_FAIL "❌ Falló verificación de certificado"
#define LANG_WARN_CERT_FAIL "⚠️ Certificado no verificado (tiempo no sincronizado)"
#define LANG_ERROR_SSL_FAIL "❌ Falló conexión SSL después de %lu ms"
#define LANG_INFO_FRRAM "💡 Cabecera RAM: %d"
#define LANG_WARN_INSECURE "⚠️ Conexión insegura exitosa en %lu ms"
#define LANG_ERROR_INSECURE "❌ Falló conexión insegura después de %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Seguro: %s\n - Hora sincronizada: %s\n - Memoria libre: %d bytes\n - Cliente: %s", sslSecure ? "SI" : "NO", KissTime::getInstance().isTimeSynced() ? "SI" : "NO", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "CONECTADO" : "DESCONECTADO") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Storage limpiado completamente"
#define LANG_ERROR_MSG_TOLA "❌ Mensaje demasiado largo"
#define LANG_ERROR_MSG_WRIT "❌ Error escribiendo mensaje"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d mensajes eliminados"
#define LANG_INFO_FLUSH "🗑️ Flush final - cola vacía"
#define LANG_INFO_MSG_QUEUE "📤 Procesados %d mensajes de cola"
#define LANG_INFO_POWER_MODE "\n🔋 ENERGIA:"
#define LANG_INFO_TUR_ACT "🚀 TURBO MODE ACTIVADO"
#define LANG_INFO_TUR_DEAC "🐢 TURBO MODE DESACTIVADO - %d msgs en %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 DIAGNÓSTICO KISSTELEGRAM:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - Pendientes: %d", pending
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "ESTABLE" : "INESTABLE"
#define LANG_INFO_DIAG_4 " - Mantenimiento: %s", maintenanceMode ? "ACTIVO" : "INACTIVO"
#define LANG_INFO_DIAG_5 " - Memoria: %d bytes", getFreeMemory()
#define LANG_INFO_STOR_1 "\n💾 STORAGE (FS directo):"
#define LANG_INFO_STOR_2 " - Pendientes: %d", countPendingMessages()
#define LANG_INFO_STATS_1 "\n🎯 ESTADO:"
#define LANG_INFO_STATS_2 " - Pendientes: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "SÍ" : "NO"
#define LANG_INFO_STATS_4 "\n⚙️ CONFIG:"
#define LANG_INFO_STATS_5 " - Intervalo: %d ms", minMessageInterval
#define LANG_INFO_STATS_6 " - Max storage: %d", maxQueueStorage
#define LANG_INFO_FS_PEND "💾 FS Directo:\n - Pendientes: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-FS-Direct\n - Pendientes: %d\n - Memoria: %d"
#define LANG_INFO_CLOSE_CON "🕒 Cerrando conexión por antigüedad (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTORIZADO"
#define LANG_INFO_SSL "🔒 INFOS SSL (se envía a serial)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: Probando conexión SSL..."
#define LANG_INFO_SSL_TEST_1 "📍 LLAMADA desde testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: Test SSL EXITOSO"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: Test SSL FALLIDO"
#define LANG_INFO_CON_LIM "⏱️ Conexión demasiado rápida a Telegram limitada a (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 Auto-ajustando SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ Conexión SSL exitosa"
#define LANG_ERROR_SSL_FAIL_1 "❌ Falló conexión SSL"
#define LANG_INFO_PING_TG "💓 Ping keep-alive a Telegram..."
#define LANG_INFO_PING_REP "💓 Ping resultado: %s (%d bytes)", foundOK ? "OK" : "FAIL"


#endif