#ifndef LANG_FR_H
#define LANG_FR_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Bonjour.\nCommunication établie\n\n🔨 Compilé: %s\n🔢 Hash: 0x%08X\n📦 Version: %s\n📊 Statut:\nRedémarrages: %d\nTemps activé: %lu sec\nRAM libre: %d bytes\nMessages en attente: %d\n📡 Signal WiFi: %d dBm (%s)"

// Qualité du signal WiFi
#define LANG_WIFI_EXCELLENT "Excellent"
#define LANG_WIFI_GOOD "Bon"
#define LANG_WIFI_FAIR "Moyen"
#define LANG_WIFI_WEAK "Faible"

// Commande /estado
#define LANG_STATUS_TITLE_RELIABILITY "🎯 FIABILITÉ SYSTÈME"
#define LANG_STATUS_SYSTEM "Système"
#define LANG_STATUS_RELIABLE "FIABLE"
#define LANG_STATUS_CHECK "VÉRIFIER"
#define LANG_STATUS_SENT "Messages envoyés"
#define LANG_STATUS_PENDING "Messages en attente"
#define LANG_STATUS_LOST "Messages perdus"
#define LANG_STATUS_DISCARDED "Rejetés (file pleine)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 ADVERSITÉS EXTERNES"
#define LANG_STATUS_ERRORS "Erreurs totales"
#define LANG_STATUS_RECOVERED "Récupérés (fallback)"
#define LANG_STATUS_WIFI_DROPS "Chutes WiFi"
#define LANG_STATUS_TITLE_TECHNICAL "📊 INFORMATIONS TECHNIQUES"
#define LANG_STATUS_UPTIME "Temps de fonctionnement"
#define LANG_STATUS_FREE_RAM "RAM libre"
#define LANG_STATUS_FREE_PSRAM "PSRAM libre"
#define LANG_STATUS_FREE_FS "FS libre"
#define LANG_STATUS_MAX_FS "Max. dans FS"
#define LANG_STATUS_MESSAGES "Messages"
#define LANG_STATUS_POWER_MODE "Mode d'alimentation"
#define LANG_STATUS_WIFI_SIGNAL "Signal WiFi"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SÉCURISÉ"
#define LANG_STATUS_SSL_INSECURE "NON SÉCURISÉ"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "ACTIF"
#define LANG_STATUS_INACTIVE "INACTIF"
#define LANG_STATUS_AUTO_MSGS "Messages auto"
#define LANG_STATUS_YES "OUI"
#define LANG_STATUS_NO "NON"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA déjà en cours"
#define LANG_OTA_PIN_BLOCK "🔒 PIN BLOQUÉ\n\nPour débloquer la fonction OTA, tapez /otapuk [PUK]\nUne fois débloqué, vous pourrez démarrer un nouveau processus avec /ota\n\nSi vous n'avez pas le PUK, contactez l'administrateur."
#define LANG_OTA_INI_1 "📦 MISE À JOUR OTA\n\nNous allons démarrer une mise à jour du firmware de l'appareil.\n\nPendant la mise à jour :\n• Les messages sont stockés sur l'appareil\n• Vous ne perdrez pas de messages\n• Vous ne recevrez pas de messages de commande\n• Pour annuler le processus, envoyez /otacancel\n\nTapez /otapin [PIN] pour démarrer le processus\n\n⏱️ Vous avez 60 secondes"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nLe temps pour saisir le PIN a expiré.\nProcessus annulé.\n\nRedémarrez avec /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ TIMEOUT OTA\n\nLe processus a dépassé le temps maximum de 7 minutes.\nProcessus annulé.\n\nLe système revient à un fonctionnement normal.\nRedémarrez avec /ota"
#define LANG_OTA_PIN_OK "✅ PIN CORRECT\n\nDémarrage du processus de mise à jour...\n\n• Messages en pause\n• Vérification de l'espace disponible\n• Création d'une sauvegarde du firmware actuel\n\n⏱️ Délai d'expiration du processus : 7 minutes\n\nN'éteignez pas l'appareil."
#define LANG_OTA_ERROR_BACKUP "❌ ERREUR DE SAUVEGARDE\n\nImpossible de créer une sauvegarde du firmware actuel.\nProcessus annulé.\n\nLe système revient à un fonctionnement normal.\nRedémarrez avec /ota"
#define LANG_OTA_INI_2 "✅ SAUVEGARDE TERMINÉE\n\nFirmware actuel sauvegardé correctement.\n\n📤 Envoyez le fichier .bin du nouveau firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN BLOQUÉ\n\nVous avez dépassé le maximum de 3 tentatives.\nLe processus actuel est annulé.\n\nPour débloquer la fonction OTA, tapez /otapuk [PUK]\nUne fois débloqué, vous pourrez démarrer un nouveau processus avec /ota\n\nSi vous n'avez pas le PUK, contactez l'administrateur."
#define LANG_OTA_PIN_FAIL "❌ PIN incorrect\n\nTentatives restantes : %d\n\nTapez /otapin [PIN] pour réessayer"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA DÉBLOQUÉ\n\nLe PIN a été débloqué avec succès.\nLes tentatives de PIN ont été réinitialisées.\n\nPour démarrer une mise à jour, tapez /ota"
#define LANG_OTA_PUK_WRONG "❌ PUK incorrect"
#define LANG_OTA_PR_INACTI "❌ Aucun processus OTA actif"
#define LANG_OTA_REVERT "🔄 DÉMARRAGE DU ROLLBACK\n\nRestauration du firmware précédent...\nL'appareil va redémarrer.\n\nN'éteignez pas l'appareil."
#define LANG_OTA_CANCEL "🛑 PROCESSUS ANNULÉ\n\nLa mise à jour a été annulée.\nAucune modification n'a été apportée au firmware.\n\nLe système revient à un fonctionnement normal."
#define LANG_OTA_FLASH "🔥 ÉCRITURE DU FIRMWARE\n\nÉcriture en mémoire flash...\nCela peut prendre plusieurs minutes.\n\n⚠️ NE DÉBRANCHEZ PAS L'APPAREIL"
#define LANG_OTA_FLASH_F "❌ ERREUR D'ÉCRITURE\n\nL'écriture du firmware a échoué.\nDémarrage du retour arrière automatique...\n\nL'appareil redémarrera avec le firmware précédent.\n\nN'éteignez pas l'appareil."
#define LANG_OTA_VALIDATED "✅ FIRMWARE VALIDÉ\n\nLa mise à jour s'est terminée avec succès.\nSauvegarde supprimée.\n\nLe système revient à un fonctionnement normal.\nLes messages en attente seront traités maintenant. (Vous pouvez ignorer le message de validation précédent)"
#define LANG_OTA_NONVALID "❌ FICHIER INVALIDE\n\nNom de fichier invalide.\n\nEnvoyez un fichier de firmware .bin"
#define LANG_OTA_WRONG_EXT "❌ FICHIER INVALIDE\n\nLe fichier doit être .bin\nReçu : %s\n\nEnvoyez un fichier de firmware valide."
#define LANG_OTA_TOO_BIG "❌ FICHIER TROP VOLUMINEUX\n\nTaille : %.2f Mo\nMaximum : %.2f Mo\n\nEnvoyez un fichier plus petit."
#define LANG_OTA_TOO_SMALL "⚠️ FICHIER TRÈS PETIT\n\nTaille : %.1f Ko\n\nÊtes-vous sûr qu'il s'agit d'un firmware valide ?"
#define LANG_OTA_DOWNLOADING "📥 TÉLÉCHARGEMENT DU FIRMWARE\n\nRéception du fichier : %s\nTaille : %.2f Mo\n\nNe déconnectez pas l'appareil."
#define LANG_OTA_DOWN_FAIL "❌ ÉCHEC DU TÉLÉCHARGEMENT\n\nImpossible de télécharger le firmware après 3 tentatives.\nCause possible : connexion WiFi instable.\n\nProcessus annulé.\nRedémarrez avec /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 VÉRIFICATION DE L'INTÉGRITÉ\n\nVérification du checksum du firmware..."
#define LANG_OTA_CHKSUM_WRONG "❌ ÉCHEC DE LA VÉRIFICATION\n\nLe fichier est corrompu ou incomplet.\n\nProcessus annulé.\nRedémarrez avec /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VÉRIFIÉ\n\nFichier : %s\nTaille : %.2f Mo\nCRC32 : 0x%08X\n⚠️CONFIRMER L'ÉCRITURE\n\n/otaconfirm - Écrire maintenant\n/otacancel - Annuler le processus\n\nDélai d'expiration : 3 minutes"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- Le temps pour saisir le PIN a expiré.\n- Processus interrompu. Le système revient à l'état normal.\n\n- Redémarrez avec /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ DÉLAI DE VALIDATION DÉPASSÉ\n\nAucune confirmation reçue en 60 secondes.\nDémarrage du retour arrière automatique...\n\nL'appareil redémarrera avec le firmware précédent"
#define LANG_OTA_TIMEOUT "⏱️ TIMEOUT OTA\n\nLe processus a dépassé le temps maximum de 7 minutes.\nProcessus annulé.\n\nLe système revient à un fonctionnement normal.\nRedémarrez avec /ota"
#define LANG_OTA_CHECK_FS "❌ ERREUR SYSTÈME\n\nImpossible d'accéder au système de fichiers.\nProcessus annulé."
#define LANG_OTA_NOT_ENOUGH "❌ ESPACE INSUFFISANT\n\nEspace insuffisant pour créer la sauvegarde.\n\nNécessaire : %.1f Mo\nDisponible : %.1f Mo\n\nLibérez de l'espace et réessayez avec /ota"
#define LANG_OTA_BEF_REBOOT "✅ ÉCRITURE TERMINÉE\n\nFirmware écrit avec succès.\nL'appareil va maintenant redémarrer.\n\nAprès le redémarrage, vous aurez 60 secondes pour valider avec /otaok\nSi non validé, un retour arrière automatique sera exécuté."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA INTERROMPU\n\nL'appareil a redémarré pendant le processus OTA.\nTéléchargement partiel supprimé.\n\nLe système revient à un fonctionnement normal.\nRedémarrez avec /ota"
#define LANG_OTA_MAINT_MODE "🔄 VALIDATION DU FIRMWARE\n\nL'appareil a démarré.\n\n⏱️ Vous avez 60 secondes pour valider\n\n/otaok - Confirmer qu'il fonctionne correctement\n/otacancel - Forcer le retour au firmware précédent\n\nSi aucune réponse, le retour arrière automatique sera exécuté."
#define LANG_OTA_CRITI_ERROR "🔥 ERREUR CRITIQUE\n\nLe retour arrière a échoué.\nLe système peut être instable.\n\nIntervention manuelle requise.\nContactez l'administrateur."
#define LANG_OTA_ERROR_RECOVER "🔥 ERREUR CRITIQUE\n\nLa récupération a échoué.\nLe système peut être instable.\n\nIntervention manuelle requise.\nContactez l'administrateur."
#define LANG_OTA_RECOVER_ERROR "❌ AUCUNE SAUVEGARDE DISPONIBLE\n\nRécupération impossible.\nLe système conserve le firmware actuel."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ Erreur initialisation LittleFS"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram détruit"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Mode maintenance activé: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Mode maintenance désactivé"
#define LANG_INFO_CON_RESUME "🔗 Réutilisation connexion précédente"
#define LANG_INFO_CON_DIE "🔌 Nettoyage connexion morte"
#define LANG_INFO_CON_CLEAN "🔌 Erreur %d - nettoyage connexion"
#define LANG_INFO_FS_NEAR "❌ FS à %.1f%% - message ignoré"
#define LANG_INFO_FS_FULL "❌ FS espace insuffisant - message ignoré"
#define LANG_ERROR_FS_SAVE "❌ Erreur sauvegarde dans LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d envoyés (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Erreur envoi message depuis file"
#define LANG_WARN_MSG_DUP "⚠️ Update dupliqué ignoré: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Message avec longueur invalide: %d bytes"
#define LANG_WARN_NOID "⚠️ Message sans chat_id valide - ignoré"
#define LANG_WARN_WRLEN "⚠️ file_id avec longueur invalide: %d bytes"
#define LANG_WARN_TSSL "🔒 Tentative connexion SSL sécurisée..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "OUI" : "NON"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 Certificat CA configuré"
#define LANG_ERROR_SSLCLI "❌ sslClient est NULL"
#define LANG_INFO_TEST_BASIC "💡 Test connectivité de base..."
#define LANG_INFO_CON_BASIC "💡 Connectivité de base: %s en %lu ms"
#define LANG_INFO_SSL_TEST "💡 Connexion SSL: %s en %lu ms", connected ? "RÉUSSIE" : "ÉCHOUÉE"
#define LANG_INFO_SSL_SUCC "✅ Connexion SSL réussie en %lu ms"
#define LANG_INFO_CERT_VERI "✅ Certificat vérifié correctement"
#define LANG_INFO_CERT_FAIL "❌ Échec vérification certificat"
#define LANG_WARN_CERT_FAIL "⚠️ Certificat non vérifié (heure non synchronisée)"
#define LANG_ERROR_SSL_FAIL "❌ Échec connexion SSL après %lu ms"
#define LANG_INFO_FRRAM "💡 En-tête RAM: %d"
#define LANG_WARN_INSECURE "⚠️ Connexion non sécurisée réussie en %lu ms"
#define LANG_ERROR_INSECURE "❌ Échec connexion non sécurisée après %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Sécurisé: %s\n - Heure synchronisée: %s\n - Mémoire libre: %d bytes\n - Client: %s", sslSecure ? "OUI" : "NON", KissTime::getInstance().isTimeSynced() ? "OUI" : "NON", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "CONNECTÉ" : "DÉCONNECTÉ") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Stockage complètement nettoyé"
#define LANG_ERROR_MSG_TOLA "❌ Message trop long"
#define LANG_ERROR_MSG_WRIT "❌ Erreur écriture message"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d messages supprimés"
#define LANG_INFO_FLUSH "🗑️ Flush final - file vide"
#define LANG_INFO_MSG_QUEUE "📤 Traités %d messages de la file"
#define LANG_INFO_POWER_MODE "\n🔋 ÉNERGIE:"
#define LANG_INFO_TUR_ACT "🚀 MODE TURBO ACTIVÉ"
#define LANG_INFO_TUR_DEAC "🐢 MODE TURBO DÉSACTIVÉ - %d msgs en %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 DIAGNOSTIC KISSTELEGRAM:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - En suspens: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "STABLE" : "INSTABLE"
#define LANG_INFO_DIAG_4 " - Maintenance: %s", maintenanceMode ? "ACTIVE" : "INACTIVE"
#define LANG_INFO_DIAG_5 " - Mémoire: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 STOCKAGE (FS direct):"
#define LANG_INFO_STOR_2 " - En suspens: %d"
#define LANG_INFO_STATS_1 "\n🎯 ÉTAT:"
#define LANG_INFO_STATS_2 " - En suspens: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "OUI" : "NON"
#define LANG_INFO_STATS_4 "\n⚙️ CONFIG:"
#define LANG_INFO_STATS_5 " - Intervalle: %d ms"
#define LANG_INFO_STATS_6 " - Max stockage: %d"
#define LANG_INFO_FS_PEND "💾 FS Direct:\n - En suspens: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-FS-Direct\n - En suspens: %d\n - Mémoire: %d"
#define LANG_INFO_CLOSE_CON "🕒 Fermeture connexion par ancienneté (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTORISÉ"
#define LANG_INFO_SSL "🔒 INFO SSL (envoyé vers série)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: Test connexion SSL..."
#define LANG_INFO_SSL_TEST_1 "📍 APPELÉ depuis testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: Test SSL RÉUSSI"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: Test SSL ÉCHOUÉ"
#define LANG_INFO_CON_LIM "⏱️ Connexion trop rapide à Telegram limitée à (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 Auto-ajustement SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ Connexion SSL réussie"
#define LANG_ERROR_SSL_FAIL_1 "❌ Échec connexion SSL"
#define LANG_INFO_PING_TG "💓 Ping keep-alive à Telegram..."
#define LANG_INFO_PING_REP "💓 Résultat ping: %s (%d bytes)", foundOK ? "OK" : "FAIL"

#endif