#ifndef LANG_PT_H
#define LANG_PT_H

// ========== MENSAJES DE suite_kiss.ino ==========
#define LANG_HELLO_MESSAGE "🔌 Olá.\nComunicação estabelecida\n\n🔨 Compilado: %s\n🔢 Hash: 0x%08X\n📦 Versão: %s\n📊 Status:\nReinicializações: %d\nTempo ativo: %lu seg\nRAM livre: %d bytes\nMensagens pendentes: %d\n📡 Sinal WiFi: %d dBm (%s)"

// Qualidade do sinal WiFi
#define LANG_WIFI_EXCELLENT "Excelente"
#define LANG_WIFI_GOOD "Bom"
#define LANG_WIFI_FAIR "Regular"
#define LANG_WIFI_WEAK "Fraco"

// Comando /estado
#define LANG_STATUS_TITLE_RELIABILITY "🎯 CONFIABILIDADE DO SISTEMA"
#define LANG_STATUS_SYSTEM "Sistema"
#define LANG_STATUS_RELIABLE "CONFIÁVEL"
#define LANG_STATUS_CHECK "VERIFICAR"
#define LANG_STATUS_SENT "Mensagens enviadas"
#define LANG_STATUS_PENDING "Mensagens pendentes"
#define LANG_STATUS_LOST "Mensagens perdidas"
#define LANG_STATUS_DISCARDED "Descartadas (fila cheia)"
#define LANG_STATUS_TITLE_EXTERNAL "🌐 ADVERSIDADES EXTERNAS"
#define LANG_STATUS_ERRORS "Erros totais"
#define LANG_STATUS_RECOVERED "Recuperadas (fallback)"
#define LANG_STATUS_WIFI_DROPS "Quedas WiFi"
#define LANG_STATUS_TITLE_TECHNICAL "📊 INFORMAÇÕES TÉCNICAS"
#define LANG_STATUS_UPTIME "Tempo de funcionamento"
#define LANG_STATUS_FREE_RAM "RAM livre"
#define LANG_STATUS_FREE_PSRAM "PSRAM livre"
#define LANG_STATUS_FREE_FS "FS livre"
#define LANG_STATUS_MAX_FS "Máx. no FS"
#define LANG_STATUS_MESSAGES "Mensagens"
#define LANG_STATUS_POWER_MODE "Modo de energia"
#define LANG_STATUS_WIFI_SIGNAL "Sinal WiFi"
#define LANG_STATUS_SSL "SSL"
#define LANG_STATUS_SSL_SECURE "SEGURO"
#define LANG_STATUS_SSL_INSECURE "INSEGURO"
#define LANG_STATUS_TURBO "Turbo"
#define LANG_STATUS_ACTIVE "ATIVO"
#define LANG_STATUS_INACTIVE "INATIVO"
#define LANG_STATUS_AUTO_MSGS "Mensagens automáticas"
#define LANG_STATUS_YES "SIM"
#define LANG_STATUS_NO "NÃO"

// ========== KISSOTA.CPP =============
#define LANG_OTA_RUN_RUNN "⚠️ OTA já em andamento"
#define LANG_OTA_PIN_BLOCK "🔒 PIN BLOQUEADO\n\nPara desbloquear a função OTA, digite /otapuk [PUK]\nUma vez desbloqueado, você pode iniciar um novo processo com /ota\n\nSe não tiver o PUK, contate o administrador."
#define LANG_OTA_INI_1 "📦 ATUALIZAÇÃO OTA\n\nVamos iniciar uma atualização de firmware do dispositivo.\n\nDurante a atualização:\n• As mensagens são armazenadas no dispositivo\n• Você não perderá mensagens\n• Não receberá mensagens de comando\n• Para cancelar o processo, envie /otacancel\n\nDigite /otapin [PIN] para iniciar o processo\n\n⏱️ Você tem 60 segundos"
#define LANG_OTA_INI_TIMEOUT "⏱️ TIMEOUT\n\nO tempo para inserir o PIN expirou.\nProcesso cancelado.\n\nReinicie com /ota"
#define LANG_OTA_GLOB_TIMEOUT "⏱️ TIMEOUT OTA\n\nO processo excedeu o tempo máximo de 7 minutos.\nProcesso cancelado.\n\nO sistema retorna à operação normal.\nReinicie com /ota"
#define LANG_OTA_PIN_OK "✅ PIN CORRETO\n\nIniciando processo de atualização...\n\n• Mensagens pausadas\n• Verificando espaço disponível\n• Criando backup do firmware atual\n\n⏱️ Timeout do processo: 7 minutos\n\nNão desligue o dispositivo."
#define LANG_OTA_ERROR_BACKUP "❌ ERRO DE BACKUP\n\nNão foi possível criar um backup do firmware atual.\nProcesso cancelado.\n\nO sistema retorna à operação normal.\nReinicie com /ota"
#define LANG_OTA_INI_2 "✅ BACKUP CONCLUÍDO\n\nFirmware atual salvo corretamente.\n\n📤 Envie o arquivo .bin do novo firmware"
#define LANG_OTA_PIN_BLOCKED "🔒 PIN BLOQUEADO\n\nVocê excedeu o máximo de 3 tentativas.\nO processo atual é cancelado.\n\nPara desbloquear a função OTA, digite /otapuk [PUK]\nUma vez desbloqueado, você pode iniciar um novo processo com /ota\n\nSe não tiver o PUK, contate o administrador."
#define LANG_OTA_PIN_FAIL "❌ PIN incorreto\n\nTentativas restantes: %d\n\nDigite /otapin [PIN] para tentar novamente"
#define LANG_OTA_PIN_UBLOCK "🔓 OTA DESBLOQUEADO\n\nO PIN foi desbloqueado com sucesso.\nAs tentativas de PIN foram redefinidas.\n\nPara iniciar uma atualização, digite /ota"
#define LANG_OTA_PUK_WRONG "❌ PUK incorreto"
#define LANG_OTA_PR_INACTI "❌ Nenhum processo OTA ativo"
#define LANG_OTA_REVERT "🔄 INICIANDO ROLLBACK\n\nRestaurando firmware anterior...\nO dispositivo reiniciará.\n\nNão desligue o dispositivo."
#define LANG_OTA_CANCEL "🛑 PROCESSO CANCELADO\n\nA atualização foi cancelada.\nNenhuma alteração foi feita no firmware.\n\nO sistema retorna à operação normal."
#define LANG_OTA_FLASH "🔥 GRAVANDO FIRMWARE\n\nGravando na memória flash...\nIsso pode levar vários minutos.\n\n⚠️ NÃO DESCONECTE O DISPOSITIVO"
#define LANG_OTA_FLASH_F "❌ ERRO DE GRAVAÇÃO\n\nA gravação do firmware falhou.\nIniciando rollback automático...\n\nO dispositivo reiniciará com o firmware anterior.\n\nNão desligue o dispositivo."
#define LANG_OTA_VALIDATED "✅ FIRMWARE VALIDADO\n\nA atualização foi concluída com sucesso.\nBackup excluído.\n\nO sistema retorna à operação normal.\nMensagens pendentes serão processadas agora. (Você pode ignorar a mensagem de validação anterior)"
#define LANG_OTA_NONVALID "❌ ARQUIVO INVÁLIDO\n\nNome de arquivo inválido.\n\nEnvie um arquivo de firmware .bin"
#define LANG_OTA_WRONG_EXT "❌ ARQUIVO INVÁLIDO\n\nO arquivo deve ser .bin\nRecebido: %s\n\nEnvie um arquivo de firmware válido."
#define LANG_OTA_TOO_BIG "❌ ARQUIVO MUITO GRANDE\n\nTamanho: %.2f MB\nMáximo: %.2f MB\n\nEnvie um arquivo menor."
#define LANG_OTA_TOO_SMALL "⚠️ ARQUIVO MUITO PEQUENO\n\nTamanho: %.1f KB\n\nTem certeza de que é um firmware válido?"
#define LANG_OTA_DOWNLOADING "📥 FAZENDO DOWNLOAD DO FIRMWARE\n\nRecebendo arquivo: %s\nTamanho: %.2f MB\n\nNão desconecte o dispositivo."
#define LANG_OTA_DOWN_FAIL "❌ DOWNLOAD FALHOU\n\nNão foi possível baixar o firmware após 3 tentativas.\nPossível causa: conexão WiFi instável.\n\nProcesso cancelado.\nReinicie com /ota"
#define LANG_OTA_CHKSUM_VERI "🔍 VERIFICANDO INTEGRIDADE\n\nVerificando checksum do firmware..."
#define LANG_OTA_CHKSUM_WRONG "❌ VERIFICAÇÃO FALHOU\n\nO arquivo está corrompido ou incompleto.\n\nProcesso cancelado.\nReinicie com /ota"
#define LANG_OTA_FILE_VERIFIED "✅ FIRMWARE VERIFICADO\n\nArquivo: %s\nTamanho: %.2f MB\nCRC32: 0x%08X\n⚠️CONFIRMAR GRAVAÇÃO\n\n/otaconfirm - Gravar agora\n/otacancel - Cancelar processo\n\nTimeout: 3 minutos"
#define LANG_OTA_PIN_OUTTIME "TIMEOUT\n\n- O tempo para inserir o PIN expirou.\n- Processo abortado. O sistema retorna ao estado normal.\n\n- Reinicie com /ota"
#define LANG_OTA_PIN_OUT_VAL "⏱️ TIMEOUT DE VALIDAÇÃO\n\nNenhuma confirmação recebida em 60 segundos.\nIniciando rollback automático...\n\nO dispositivo reiniciará com o firmware anterior"
#define LANG_OTA_TIMEOUT "⏱️ TIMEOUT OTA\n\nO processo excedeu o tempo máximo de 7 minutos.\nProcesso cancelado.\n\nO sistema retorna à operação normal.\nReinicie com /ota"
#define LANG_OTA_CHECK_FS "❌ ERRO DE SISTEMA\n\nNão foi possível acessar o sistema de arquivos.\nProcesso cancelado."
#define LANG_OTA_NOT_ENOUGH "❌ ESPAÇO INSUFICIENTE\n\nEspaço insuficiente para criar o backup.\n\nNecessário: %.1f MB\nDisponível: %.1f MB\n\nLibere espaço e tente novamente com /ota"
#define LANG_OTA_BEF_REBOOT "✅ GRAVAÇÃO CONCLUÍDA\n\nFirmware gravado com sucesso.\nO dispositivo reiniciará agora.\n\nApós a reinicialização, você terá 60 segundos para validar com /otaok\nSe não validado, o rollback automático será executado."
#define LANG_OTA_QUEUE_MESS "⚠️ OTA INTERROMPIDO\n\nO dispositivo reiniciou durante o processo OTA.\nDownload parcial excluído.\n\nO sistema retorna à operação normal.\nReinicie com /ota"
#define LANG_OTA_MAINT_MODE "🔄 VALIDAÇÃO DE FIRMWARE\n\nO dispositivo foi iniciado.\n\n⏱️ Você tem 60 segundos para validar\n\n/otaok - Confirmar que está funcionando corretamente\n/otacancel - Forçar rollback para o firmware anterior\n\nSe nenhuma resposta, o rollback automático será executado."
#define LANG_OTA_CRITI_ERROR "🔥 ERRO CRÍTICO\n\nO rollback falhou.\nO sistema pode estar instável.\n\nIntervenção manual necessária.\nContate o administrador."
#define LANG_OTA_ERROR_RECOVER "🔥 ERRO CRÍTICO\n\nA recuperação falhou.\nO sistema pode estar instável.\n\nIntervenção manual necessária.\nContate o administrador."
#define LANG_OTA_RECOVER_ERROR "❌ NENHUM BACKUP DISPONÍVEL\n\nRecuperação não pode ser realizada.\nO sistema mantém o firmware atual."

// ========== KISSTELEGRAM.CPP ========
#define LANG_ERROR_CRITICAL_FS "❌ Erro inicialização LittleFS"
#define LANG_ERROR_SYSTEM_DES "🛑 KissTelegram destruído"
#define LANG_INFO_MAINTENANCE_ON "⏸️ Modo manutenção ativado: %s"
#define LANG_INFO_MAINTENANCE_OFF "▶️ Modo manutenção desativado"
#define LANG_INFO_CON_RESUME "🔗 Reutilizando conexão anterior"
#define LANG_INFO_CON_DIE "🔌 Limpando conexão morta"
#define LANG_INFO_CON_CLEAN "🔌 Erro %d - limpando conexão"
#define LANG_INFO_FS_NEAR "❌ FS em %.1f%% - mensagem descartada"
#define LANG_INFO_FS_FULL "❌ FS sem espaço - mensagem descartada"
#define LANG_ERROR_FS_SAVE "❌ Erro salvando no LittleFS"
#define LANG_INFO_MSG_SENT "🚀 Turbo: %d enviados (%.1f msg/s)"
#define LANG_WARN_MSG_SEND "⚠️ Erro enviando mensagem da fila"
#define LANG_WARN_MSG_DUP "⚠️ Update duplicado ignorado: %ld"
#define LANG_WARN_MSG_LEN "⚠️ Mensagem com comprimento inválido: %d bytes"
#define LANG_WARN_NOID "⚠️ Mensagem sem chat_id válido - ignorado"
#define LANG_WARN_WRLEN "⚠️ file_id com comprimento inválido: %d bytes"
#define LANG_WARN_TSSL "🔒 Tentando conexão SSL segura..."
#define LANG_INFO_TSYNC "💡 TimeSynced: %s", timeSynced ? "SIM" : "NÃO"
#define LANG_INFO_FRAM "💡 Free Heap: %d"
#define LANG_INFO_CERT "💡 Certificado CA configurado"
#define LANG_ERROR_SSLCLI "❌ sslClient é NULL"
#define LANG_INFO_TEST_BASIC "💡 Testando conectividade básica..."
#define LANG_INFO_CON_BASIC "💡 Conectividade básica: %s em %lu ms"
#define LANG_INFO_SSL_TEST "💡 Conexão SSL: %s em %lu ms", connected ? "BEM-SUCEDIDA" : "FALHOU"
#define LANG_INFO_SSL_SUCC "✅ Conexão SSL bem-sucedida em %lu ms"
#define LANG_INFO_CERT_VERI "✅ Certificado verificado corretamente"
#define LANG_INFO_CERT_FAIL "❌ Falhou verificação de certificado"
#define LANG_WARN_CERT_FAIL "⚠️ Certificado não verificado (tempo não sincronizado)"
#define LANG_ERROR_SSL_FAIL "❌ Falhou conexão SSL após %lu ms"
#define LANG_INFO_FRRAM "💡 Cabeçalho RAM: %d"
#define LANG_WARN_INSECURE "⚠️ Conexão insegura bem-sucedida em %lu ms"
#define LANG_ERROR_INSECURE "❌ Falhou conexão insegura após %lu ms"
#define LANG_INFO_SSL_MSG "SSL Info:\n - Seguro: %s\n - Hora sincronizada: %s\n - Memória livre: %d bytes\n - Cliente: %s", sslSecure ? "SIM" : "NÃO", KissTime::getInstance().isTimeSynced() ? "SIM" : "NÃO", ESP.getFreeHeap(), sslClient ? (sslClient->connected() ? "CONECTADO" : "DESCONECTADO") : "NULL"
#define LANG_INFO_STOR_CLEAN "🗑️ Storage limpo completamente"
#define LANG_ERROR_MSG_TOLA "❌ Mensagem muito longa"
#define LANG_ERROR_MSG_WRIT "❌ Erro escrevendo mensagem"
#define LANG_INFO_MSG_DEL "🗑️ Batch delete: %d mensagens eliminadas"
#define LANG_INFO_FLUSH "🗑️ Flush final - fila vazia"
#define LANG_INFO_MSG_QUEUE "📤 Processadas %d mensagens da fila"
#define LANG_INFO_POWER_MODE "
🔋 ENERGIA:"
#define LANG_INFO_TUR_ACT "🚀 TURBO MODE ATIVADO"
#define LANG_INFO_TUR_DEAC "🐢 TURBO MODE DESATIVADO - %d msgs em %lu ms (%.1f msg/s)"
#define LANG_INFO_DIAG_1 "\n📊 DIAGNÓSTICO KISSTELEGRAM:" KISS_SUITE_VERSION
#define LANG_INFO_DIAG_2 " - Pendentes: %d"
#define LANG_INFO_DIAG_3 " - WiFi: %s", isWifiStable() ? "ESTÁVEL" : "INSTÁVEL"
#define LANG_INFO_DIAG_4 " - Manutenção: %s", maintenanceMode ? "ATIVO" : "INATIVO"
#define LANG_INFO_DIAG_5 " - Memória: %d bytes"
#define LANG_INFO_STOR_1 "\n💾 STORAGE (FS direto):"
#define LANG_INFO_STOR_2 " - Pendentes: %d"
#define LANG_INFO_STATS_1 "\n🎯 STATUS:"
#define LANG_INFO_STATS_2 " - Pendentes: %d", countPendingMessages()
#define LANG_INFO_STATS_3 " - WiFi: %s", isWifiStable() ? "SIM" : "NÃO"
#define LANG_INFO_STATS_4 "\n⚙️ CONFIG:"
#define LANG_INFO_STATS_5 " - Intervalo: %d ms"
#define LANG_INFO_STATS_6 " - Max storage: %d"
#define LANG_INFO_FS_PEND "💾 FS Direto:\n - Pendentes: %d"
#define LANG_INFO_FS_DIAG "📊 " KISS_SUITE_VERSION"-FS-Direto\n - Pendentes: %d\n - Memória: %d"
#define LANG_INFO_CLOSE_CON "🕒 Fechando conexão por antiguidade (10 min)"
#define LANG_INFO_OTA_AUTHO "✅ OTA AUTORIZADO"
#define LANG_INFO_SSL "🔒 INFO SSL (enviado para serial)"
#define LANG_INFO_SSL_TEST_0 "🧪 KissTelegram: Testando conexão SSL..."
#define LANG_INFO_SSL_TEST_1 "📍 CHAMADA desde testSSLConnection"
#define LANG_INFO_SSL_TEST_2 "✅ KissTelegram: Test SSL BEM-SUCEDIDO"
#define LANG_ERROR_SSL_TEST_3 "❌ KissTelegram: Test SSL FALHOU"
#define LANG_INFO_CON_LIM "⏱️ Conexão muito rápida para Telegram limitada a (%lu ms)"
#define LANG_INFO_SSL_INTELL "🔄 Auto-ajustando SSL: %s → %s"
#define LANG_INFO_SSL_SUCC_1 "✅ Conexão SSL bem-sucedida"
#define LANG_ERROR_SSL_FAIL_1 "❌ Falhou conexão SSL"
#define LANG_INFO_PING_TG "💓 Ping keep-alive para Telegram..."
#define LANG_INFO_PING_REP "💓 Resultado ping: %s (%d bytes)", foundOK ? "OK" : "FALHOU"

#endif