/*
 * Copyright 2005 by Gemtek Technology Co., Ltd
 * 
 * All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
/*
 * udhcpc scripts
 *
 * Copyright 2005, Broadcom Corporation
 * All Rights Reserved.
 * 
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 *
 * $Id$
 */

#include <ap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <net/route.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include <time.h>
#include <unistd.h>

#include <bcmnvram.h>
#include <netconf.h>
#include <shutils.h>
#include <rc.h>

#ifdef __CONFIG_NAT__
static int
expires(char *wan_ifname, unsigned int in)
{
	time_t now;
	FILE *fp;
	char tmp[100];
	int unit;

	if ((unit = wan_ifunit(wan_ifname)) < 0)
		return -1;
	
	time(&now);
	snprintf(tmp, sizeof(tmp), "/tmp/udhcpc%d.expires", unit); 
	if (!(fp = fopen(tmp, "w"))) {
		perror(tmp);
		return errno;
	}
	fprintf(fp, "%d", (unsigned int) now + in);
	fclose(fp);
	return 0;
}	

/* 
 * deconfig: This argument is used when udhcpc starts, and when a
 * leases is lost. The script should put the interface in an up, but
 * deconfigured state.
*/
static int
deconfig(void)
{
	char *wan_ifname = safe_getenv("interface");

	ifconfig(wan_ifname, IFUP,
		 "0.0.0.0", NULL);
	expires(wan_ifname, 0);

	wan_down(wan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * bound: This argument is used when udhcpc moves from an unbound, to
 * a bound state. All of the paramaters are set in enviromental
 * variables, The script should configure the interface, and set any
 * other relavent parameters (default gateway, dns server, etc).
*/
static int
bound(void)
{
	char *wan_ifname = safe_getenv("interface");
	char *value;
	char tmp[100], prefix[] = "wanXXXXXXXXXX_";
	int unit;
#ifdef DanielAdd
	char *p, *q ;
	char sub_ipaddr[13] ;	
	int index = 1 ;
	
	p = q = NULL ;
	system("/sbin/kill_easyconf");
#endif

	if ((unit = wan_ifunit(wan_ifname)) < 0)
		return -1;

	snprintf(prefix, sizeof(prefix), "wan%d_", unit);
	
	if ((value = getenv("ip")))
#ifdef DanielAdd
	{		
		p = strchr( value, ' ' ) ;
		if( p != NULL )
			*p = 0x00 ;
		
		nvram_set("wan_ipaddr", value);		
		DanielDBG(fprintf(stderr, "wan_ipaddr=<%s>\n", value);)
		
		for( p=value, q=value ; *q ; q++ )
		{
			if( *q == '.' )
			{
				*q = 0x00 ;
				memset( sub_ipaddr, '\0', sizeof(sub_ipaddr) );				
				sprintf( sub_ipaddr, "wan_ipaddr_%d", index );
				DanielDBG(fprintf(stderr, "%s=<%s>\n", sub_ipaddr, p );)
				nvram_set( sub_ipaddr, p );
				
				memset( sub_ipaddr, '\0', sizeof(sub_ipaddr) );				
				sprintf( sub_ipaddr, "log_ipaddr_%d", index );
				DanielDBG(fprintf(stderr, "%s=<%s>\n", sub_ipaddr, p );)
				nvram_set( sub_ipaddr, p );				
				index++ ;
				p = q + 1 ;
			}
		}		
		
		memset( sub_ipaddr, '\0', sizeof(sub_ipaddr) );				
		sprintf( sub_ipaddr, "wan_ipaddr_%d", index );
		DanielDBG(fprintf(stderr, "%s=<%s>\n", sub_ipaddr, p );)
		nvram_set( sub_ipaddr, p );
	}
#else /* !DanielAdd */		
		nvram_set(strcat_r(prefix, "ipaddr", tmp), value);
#endif /* end of DanielAdd */	
	if ((value = getenv("subnet")))
#ifdef BCM4712APBOARD	
		nvram_set("wan_netmask", value);	
#else		
		nvram_set(strcat_r(prefix, "netmask", tmp), value);
#endif	
        if ((value = getenv("router")))
#ifdef BCM4712APBOARD	
		nvram_set("wan_gateway", value);	
#else		
		nvram_set(strcat_r(prefix, "gateway", tmp), value);
#endif	
	if ((value = getenv("dns")))
		nvram_set(strcat_r(prefix, "dns", tmp), value);
	if ((value = getenv("wins")))
		nvram_set(strcat_r(prefix, "wins", tmp), value);
	if ((value = getenv("hostname")))
		sethostname(value, strlen(value) + 1);
	if ((value = getenv("domain")))
		nvram_set(strcat_r(prefix, "domain", tmp), value);
	if ((value = getenv("lease"))) {
		nvram_set(strcat_r(prefix, "lease", tmp), value);
		expires(wan_ifname, atoi(value));
	}

#ifdef BCM4712APBOARD	
	ifconfig(wan_ifname, IFUP,nvram_safe_get("wan_ipaddr"),nvram_safe_get("wan_netmask"));	
#else		
	ifconfig(wan_ifname, IFUP,
		 nvram_safe_get(strcat_r(prefix, "ipaddr", tmp)),
		 nvram_safe_get(strcat_r(prefix, "netmask", tmp)));
#endif

	wan_up(wan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * renew: This argument is used when a DHCP lease is renewed. All of
 * the paramaters are set in enviromental variables. This argument is
 * used when the interface is already configured, so the IP address,
 * will not change, however, the other DHCP paramaters, such as the
 * default gateway, subnet mask, and dns server may change.
 */
static int
renew(void)
{
	bound();

	dprintf("done\n");
	return 0;
}

int
udhcpc_wan(int argc, char **argv)
{
	if (!argv[1])
		return EINVAL;
	else if (strstr(argv[1], "deconfig"))
		return deconfig();
	else if (strstr(argv[1], "bound"))
		return bound();
	else if (strstr(argv[1], "renew"))
		return renew();
	else
		return EINVAL;
}
#endif	/* __CONFIG_NAT__ */

static int
expires_lan(char *lan_ifname, unsigned int in)
{
	time_t now;
	FILE *fp;
	char tmp[100];

	time(&now);
	snprintf(tmp, sizeof(tmp), "/tmp/udhcpc-%s.expires", lan_ifname); 
	if (!(fp = fopen(tmp, "w"))) {
		perror(tmp);
		return errno;
	}
	fprintf(fp, "%d", (unsigned int) now + in);
	fclose(fp);
	return 0;
}	

/* 
 * deconfig: This argument is used when udhcpc starts, and when a
 * leases is lost. The script should put the interface in an up, but
 * deconfigured state.
*/
static int
deconfig_lan(void)
{
	char *lan_ifname = safe_getenv("interface");

	ifconfig(lan_ifname, IFUP, "0.0.0.0", NULL);
	expires_lan(lan_ifname, 0);

	lan_down(lan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * bound: This argument is used when udhcpc moves from an unbound, to
 * a bound state. All of the paramaters are set in enviromental
 * variables, The script should configure the interface, and set any
 * other relavent parameters (default gateway, dns server, etc).
*/
static int
bound_lan(void)
{
	char *lan_ifname = safe_getenv("interface");
	char *value;
	
	if ((value = getenv("ip")))
		nvram_set("lan_ipaddr", value);
	if ((value = getenv("subnet")))
		nvram_set("lan_netmask", value);
        if ((value = getenv("router")))
		nvram_set("lan_gateway", value);
	if ((value = getenv("lease")))
		expires_lan(lan_ifname, atoi(value));

	ifconfig(lan_ifname, IFUP, nvram_safe_get("lan_ipaddr"),
		nvram_safe_get("lan_netmask"));

	lan_up(lan_ifname);

	dprintf("done\n");
	return 0;
}

/*
 * renew: This argument is used when a DHCP lease is renewed. All of
 * the paramaters are set in enviromental variables. This argument is
 * used when the interface is already configured, so the IP address,
 * will not change, however, the other DHCP paramaters, such as the
 * default gateway, subnet mask, and dns server may change.
 */
static int
renew_lan(void)
{
	bound_lan();

	dprintf("done\n");
	return 0;
}

/* dhcp client script entry for LAN (AP) */
int
udhcpc_lan(int argc, char **argv)
{
	if (!argv[1])
		return EINVAL;
	else if (strstr(argv[1], "deconfig"))
		return deconfig_lan();
	else if (strstr(argv[1], "bound"))
		return bound_lan();
	else if (strstr(argv[1], "renew"))
		return renew_lan();
	else
		return EINVAL;
}
