/*
 * Copyright 2005 by Gemtek Technology Co., Ltd
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
/*
 * Broadcom Home Gateway Reference Design
 * Web Page Configuration Support Routines
 *
 * Copyright 2001-2003, Broadcom Corporation
 * All Rights Reserved.
 *
 * THIS SOFTWARE IS OFFERED "AS IS", AND BROADCOM GRANTS NO WARRANTIES OF ANY
 * KIND, EXPRESS OR IMPLIED, BY STATUTE, COMMUNICATION OR OTHERWISE. BROADCOM
 * SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A SPECIFIC PURPOSE OR NONINFRINGEMENT CONCERNING THIS SOFTWARE.
 * $Id$
 */


#ifdef WEBS
#include <webs.h>
#include <uemf.h>
#include <ej.h>

#else /* !WEBS */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <httpd.h>
#endif /* WEBS */

#include <typedefs.h>
#include <proto/ethernet.h>
#include <bcmnvram.h>
#include <bcmutils.h>
#include <shutils.h>
#include <ap.h>
#include <ap_cgi.h> /* DanielAdd */
#include <ap_shared.h> /* DanielAdd */

#ifdef DanielAdd

#ifdef Link
#include <netconf.h>
#include <net/if.h>
typedef u_int64_t u64;
typedef u_int32_t u32;
typedef u_int16_t u16;
typedef u_int8_t  u8;
#include <linux/ethtool.h>
#include <linux/sockios.h>
#include <sys/ioctl.h>
#endif

/* global varables */
#ifdef LinuxMozillaBug
extern char user_agent[1000] ;
#endif /* LinuxMozillaBug */
/* end of global varables */

/* for action_table */
int do_Apply(webs_t wp);
int do_GenKey(webs_t wp);
int do_GenKeyWEP(webs_t wp);
int do_GenKeyRadius(webs_t wp);
int do_mac(webs_t wp);
int do_Conf(webs_t wp);
int do_Log(webs_t wp);
int do_Filters(webs_t wp);
int do_SNMP(webs_t wp);
int do_dummy_view_log(webs_t wp);
int do_view_log(webs_t wp);
int do_clear_log(webs_t wp);
int do_change_page(webs_t wp);
int do_Nvram(webs_t wp);
int do_kmsg(webs_t wp);
int do_test(webs_t wp);
int do_macfilter(webs_t wp);
int do_Restore_Defaults(webs_t wp);
int do_ap_client(webs_t wp);
#ifdef BCM4712APBOARD
int do_APC(webs_t wp);
int do_WebShell(webs_t wp);
#endif /* end of BCM4712APBOARD */
#ifdef AP_Repeater
int do_AutoScan(webs_t wp);
int do_DetectWDSLink(webs_t wp);
#endif /* end of AP_Repeater */

// Vic Yu added
int do_GTK_Submit(webs_t wp);
int do_GTK_SES_Submit(webs_t wp);
int do_FCC_Process(webs_t wp);
int do_FCC_Run(webs_t wp);
int do_GTK_DebugTest_Submit(webs_t wp);


/* for global function */
int start_restore_settings(webs_t wp);
static int ej_GTK_nvram_get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_ses_button_display(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_setup_page_get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_security_page_get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_Web_function_init(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_SES_Encrypt_Get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_SES_Status_Get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_DebugTest_Get(int eid, webs_t wp, int argc, char_t **argv);
static int ej_GTK_MemorySpace(int eid, webs_t wp, int argc, char_t **argv);
//static int ej_GTK_MemorySpace(int eid, webs_t wp, int argc, char_t **argv);
static int GTK_convert_nvram_parameter(void);

struct action_handler {
	char *action ;
	int (*execute)(webs_t wp);	/* -1:error and goto DoNotThing ; 0:goto DoNotThing ;
									1:restart ; 2:reboot 3:save */
} action_table[] = {
	{	"Apply",			do_Apply			},
	{	"GenKey",			do_GenKey			},
	{	"GenKeyWEP",		do_GenKeyWEP		},
	{	"GenKeyRadius",		do_GenKeyRadius		},
	{	"mac",				do_mac				},
	{	"Conf",				do_Conf				},
	{	"Log",				do_Log				},
	{	"Filters",			do_Filters			},
	{	"SNMP",				do_SNMP				},
	{	"dummy_view_log",	do_dummy_view_log	},
	{	"view_log",			do_view_log			},
	{	"clear_log",		do_clear_log		},
	{	"change_page",		do_change_page		},
	{	"Nvram",			do_Nvram			},
	{	"kmsg",				do_kmsg				},
	{	"test",				do_test				},
	{	"macfilter",		do_macfilter		},
	{	"Restore_Defaults",	do_Restore_Defaults	},
	{	"ap_client",		do_ap_client		},
#ifdef BCM4712APBOARD
	{	"APC",				do_APC				},
#if 0
	{	"web_shell_apply",	do_WebShell			},
#endif
#endif /* end of BCM4712APBOARD */
#ifdef AP_Repeater
	{	"AutoScan",			do_AutoScan			},
	{	"DetectWDSLink",	do_DetectWDSLink	},
#endif /* end of AP_Repeater */

// +++ Vic Yu added, New action function
	{	"GTK_Submit",			do_GTK_Submit			},
	{	"GTK_SES_Submit",		do_GTK_SES_Submit			},
	{	"GTK_DebugTest_Submit",		do_GTK_DebugTest_Submit			},
#ifdef FCCTesting
	{	"FCC_Process",	do_FCC_Process			},
	{	"FCC_Run",		do_FCC_Run			},
#endif
// - - - Vic Yu added, New action function
	{	0,					0		    		},
};

#ifdef DectectSpecialCharacters
struct special_character {
	char *name ;
	int flag ;
} special_character_name_table[] = {
	{	"radio_key",	   	0	},
	{	"wl_ssid",	    	0	},
	{	"wpa_psk",	    	0	},
	{	"ap_name",	    	0	},
	{	"wan_hostname",		0	},
	{	"wl_ssid_5G",		0	},
	{	"ap_client_wep_key",		0	},
	{	"GTK_wl_wpa_psk",		0	},
	{	0,					0	},

};
#endif

#ifdef SiteSurvay
#include <wlioctl.h>
#include <net/if.h>
#include <sys/ioctl.h>
struct site_survay_t {
	char SSID[33];
	char Mode[10];
	int  RSSI;
	char noise[4];
	char Channel[3];
	char BSSID[18];
	char Capability[30];
	char SupRate;
	char WPA;
} site_survay_table[100] ;
#endif /* SiteSurvay */

char *local_time;
time_t current_time;

#ifdef HTTP_POST_METHOD
char query_string[QUERY_LENGTH]; /* for POST Method */
#endif /* HTTP_POST_METHOD */

#endif /* end of DanielAdd */

#if defined(linux)

#include <fcntl.h>
#include <signal.h>
#include <time.h>
#include <sys/klog.h>
#include <sys/wait.h>

#define sys_restart() kill(1, SIGHUP)
#define sys_reboot() kill(1, SIGTERM)
#define sys_upgrade(url) eval("write", (url), "linux")
#define sys_stats(url) eval("stats", (url))

static int GeneratePassPhraseKey();

#ifdef SITESURVEY_QUEUE
SITESURVEY_LIST *SL = NULL ;
#endif /* end of SITESURVEY_QUEUE */

int start_restore_settings(webs_t wp)
{
	FILE *fp = NULL ;
	char buf[1024];
	char *p, *base, *b ;
	int hit = 0, count = 0 ;

	char *unrestored_name[] = {
		"sdram_config", "sdram_refresh", "sdram_init",
		"et0macaddr", "et0mdcport", "et0phyaddr",
		"et1macaddr", "et1mdcport", "et1phyaddr",
		"lan_hwaddr", "d11g_hwaddr",
		"wl0_hwaddr", "wl_hwaddr",
		"il0macaddr",
		"boardtype", "boardnum", "boardrev", 0
	};
	char **u = NULL ;
	int restored = 1 ;

	DanielDBG(cprintf("%s();\n", __FUNCTION__);)

	base = b = p = NULL ;

	fp = fopen( "/tmp/config.txt", "r" ) ;

	if( fp == NULL )
	{
		DanielDBG(cprintf("open config.txt error \n");)
		return -1 ;
	}

	while(!feof(fp))
	{
		memset( buf, '\0' , sizeof(buf) );
		fgets( buf, sizeof(buf), fp );

		if( count == 0 && strncmp( buf, "nvram_", 6 ) )
		{
			hit = 0 ;
			break ;
		}

		if( !strncmp( buf, "nvram_", 6 ) )
		{
			p = buf ;
			p += 6 ;
			hit = 1 ;
			base = strchr( buf, '=' );

			if( base != NULL )
			{
				*base++ = 0x00 ;
				DanielDBG(cprintf("name=<%s>\t", p);)

				for( b = base ; *b != 0x0a ; b++ ) ;
				*b = 0x00 ;
				DanielDBG(cprintf("value=<%s>\n", base);)

				for( u = unrestored_name ; *u ; u++ )
				{
					if( !strcmp( *u, p ) )
					{
						DanielDBG(cprintf("unrestored name %s\n", p);)
						restored = 0 ;
						break ;
					}
				}

				if(restored)
				{
					DanielDBG(cprintf("nvram set %s\n", p);)
					nvram_set( p, base);
				}
				else
					restored = 1 ;

				count++ ;
			}
		}
	}

	DanielDBG(cprintf("count=<%d>\n", count);)
	DanielDBG(cprintf("hit=<%d>\n", hit);)
	DanielDBG(cprintf("close config.txt\n");)
	fclose(fp);

	if( hit == 0 )
		return -1 ;
	else
		return 0 ;
}
char *ToUpperCase ( char *AnyString )
{
	char *ReplyString = AnyString;
	int	Counter = 0;

	for ( Counter = 0 ; *(ReplyString + Counter ) != '\0' ; Counter++ )
	{
		if ( *(ReplyString + Counter ) == 'a' )
		{
			*(ReplyString + Counter ) = 'A';
		}
		else if ( *(ReplyString + Counter ) == 'b' )
		{
			*(ReplyString + Counter ) = 'B';
		}
		else if ( *(ReplyString + Counter ) == 'c' )
		{
			*(ReplyString + Counter ) = 'C';
		}
		else if ( *(ReplyString + Counter ) == 'd' )
		{
			*(ReplyString + Counter ) = 'D';
		}
		else if ( *(ReplyString + Counter ) == 'e' )
		{
			*(ReplyString + Counter ) = 'E';
		}
		else if ( *(ReplyString + Counter ) == 'f' )
		{
			*(ReplyString + Counter ) = 'F';
		}
	}

	return ReplyString;
}

/* Deal with side effects before committing */
static int sys_commit(void)
{
	nvram_commit();
	sleep(1);
	return 1;
}

#elif defined(vxworks)

extern int restart_firewall(void);
extern int sys_upgrade(char *url);
extern int get_vxleaseinfo(char *macaddr, char **ipaddr,int *expires, bool *staticIP);
#define sys_restart() restart_firewall()
#define sys_reboot() reboot()
#define sys_commit() nvram_commit()
#define sys_stats(server) http_stats(server)

/* Report time in RFC-822 format */
static int ej_localtime(int eid, webs_t wp, int argc, char_t **argv)
{
	return 0;
}

/* Dump firewall log */
static int ej_dumplog(int eid, webs_t wp, int argc, char_t **argv)
{
	return 0;
}

/* Dump leases in <tr><td>MAC</td><td>IP</td><td>expires</td></tr> format */
static int ej_dumpleases(int eid, webs_t wp, int argc, char_t **argv)
{
	char macaddr[32], **ipaddr, *format;
	int expires;
	bool staticIP;
	int ret = 0;

	if (ejArgs(argc, argv, "%s", &format) < 1) {
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	/* get lease info */
	if (get_vxleaseinfo(macaddr, &ipaddr, &expires, &staticIP) == ERROR)	{
		websError(wp, 400, "Failed to get lease info\n");
		return -1;
	}

	ret += websWrite(wp, "<tr><td>%s", format);
	ret += websWrite(wp, "%s", macaddr);
	ret += websWrite(wp, "</td><td>%s%s</td><td>%s", format, ipaddr, format);

	if (staticIP) {
		ret += websWrite(wp, "STATIC");
	}
	else {
		if (!expires)
			ret += websWrite(wp, "expired");
		else {
			if (expires > 60*60*24) {
				ret += websWrite(wp, "%ld days, ", expires / (60*60*24));
				expires %= 60*60*24;
			}
			if (expires > 60*60) {
				ret += websWrite(wp, "%ld hours, ", expires / (60*60));
				expires %= 60*60;
			}
			if (expires > 60) {
				ret += websWrite(wp, "%ld minutes, ", expires / 60);
				expires %= 60;
			}
			ret += websWrite(wp, "%ld seconds", expires);
		}
	}

	ret += websWrite(wp, "</td></tr>");

	return ret;
}

/* Return PPPoE link state */
static int ej_ppplink(int eid, webs_t wp, int argc, char_t **argv)
{
	return 0;
}

#endif

/*
 * Example:
 * lan_ipaddr=192.168.1.1
 * <% nvram_get("lan_ipaddr"); %> produces "192.168.1.1"
 * <% nvram_get("undefined"); %> produces ""
 */
static int ej_nvram_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *c;
	int ret = 0;

	if (ejArgs(argc, argv, "%s", &name) < 1)
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	for( c = nvram_safe_get(name); *c ;  c++ )
	{
#ifdef DanielAdd
		if( *c == 0x22 ) /* " */
			ret += websWrite( wp, "%c%c", 0x5c, 0x22 );
		else if( *c == 0x27 ) /* ' */
			ret += websWrite( wp, "%c%c", 0x5c, 0x27 );
		else if( *c == 0x5c ) /* \ */
			ret += websWrite( wp, "%c%c", 0x5c, 0x5c );
		else
			ret += websWrite(wp, "%c", *c);
#else
		if (isprint(*c) &&
		    *c != '"' && *c != '&' && *c != '<' && *c != '>')
			ret += websWrite(wp, "%c", *c);
		else
			ret += websWrite(wp, "&#%d", *c);
#endif
	}

	return ret;
}

/*
 * Example:
 * wan_proto=dhcp
 * <% nvram_match("wan_proto", "dhcp", "selected"); %> produces "selected"
 * <% nvram_match("wan_proto", "static", "selected"); %> does not produce
 */
static int ej_nvram_match(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name, *match, *output;

	if (ejArgs(argc, argv, "%s %s %s", &name, &match, &output) < 3)
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if (nvram_match(name, match))
		return websWrite(wp, output);

	return 0;
}

/*
 * Example:
 * filter_mac=00:12:34:56:78:00 00:87:65:43:21:00
 * <% nvram_list("filter_mac", 1); %> produces "00:87:65:43:21:00"
 * <% nvram_list("filter_mac", 100); %> produces ""
 */
static int ej_nvram_list(int eid, webs_t wp, int argc, char_t **argv)
{
	char *name;
	int which;
	char word[256], *next;
	int ret = 0;

	if (ejArgs(argc, argv, "%s %d", &name, &which) < 2)
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	foreach(word, nvram_safe_get(name), next)
	{
		if (which-- == 0)
			ret += websWrite(wp, word);
	}

	return ret;
}
struct variable
{
	char *name;
	char *longname;
	void (*validate)(webs_t wp, char *value, struct variable *v);
	char **argv;
	int nullok;
};

#define ARGV(args...) ((char *[]) { args, NULL })

#ifdef CheckParameterStatus
#define SERV_UDP_PORT 514
static int do_change_value( char *original_val, char *changed_val, char *text )
{
	FILE *fp = NULL ;

	fp = fopen( "/tmp/results", "a+" );
	if( fp == NULL )
	{
		fprintf( stderr, "fopen /tmp/results error\n" );
		return -1 ;
	}

	fprintf( fp, "change %s to %s\n", text, changed_val );

	fclose(fp);
	return 0 ;
}
struct check_parameters_handle {
	char *name ;
	int (*print_result)( char *original_val, char *changed_val, char *text ) ;
	char *text ;
} check_table[]	= {
	{	"wl_ssid",      do_change_value,	"SSID"	     },
	{	"wan_ipaddr",   do_change_value,	"IP Address" },
	{	"wan_hostname", do_change_value,	"AP Name"    },
	{	0,			    0,				    0            },
};
static int send_log_msg(void)
{
	char *remote_ipaddr = NULL ;
	char *log_ipaddr_4 = NULL ;
	int sockfd ;
	struct sockaddr_in serv_addr, cli_addr ;
	int n ;
	char buf[1024] ;
	FILE *fp = NULL ;

	/* get log_ipaddr */
	remote_ipaddr = nvram_get( "log_ipaddr" );
	log_ipaddr_4 = nvram_get( "log_ipaddr_4" );

	fp = fopen( "/tmp/results", "r" );
	if( fp == NULL )
	{
		fprintf( stderr, "fopen /tmp/results error\n" );
		return -1 ;
	}

	if( remote_ipaddr != NULL &&
		strcmp(remote_ipaddr, "0.0.0.0") &&
		log_ipaddr_4 != NULL )
	{	/* Log enable */
		bzero( (char *)&serv_addr, sizeof(serv_addr) ) ;
		serv_addr.sin_family = AF_INET ;
		serv_addr.sin_addr.s_addr = inet_addr(remote_ipaddr) ;
		serv_addr.sin_port = htons(SERV_UDP_PORT) ;

		/* bind any local address for us */
		bzero( (char *)&cli_addr, sizeof(cli_addr) ) ;
		cli_addr.sin_family = AF_INET ;
		cli_addr.sin_addr.s_addr = htonl(INADDR_ANY) ;
		cli_addr.sin_port = htons(0) ;

		/* open a UDP socket */
		if( (sockfd = socket( AF_INET, SOCK_DGRAM, 0 )) < 0 )
		{
			perror( "open a UDP socket fail " );
			return -1 ;
		}

		if( bind( sockfd, (struct sockaddr *)&cli_addr, sizeof(cli_addr)) < 0 )
		{
			perror( "client: can't bind local address " );
			return -1 ;
		}

		while( !feof( fp ) )
		{
			memset( buf, '\0', sizeof(buf) );
			fgets( buf, sizeof(buf), fp );
			n = strlen( buf ) ;

			if( n != 0 &&
				sendto( sockfd, buf, n, 0, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) != n )
			{
				perror( "sendto error " );
				return -1 ;
			}
		}
	}

	close(sockfd) ;
	fclose(fp);

	return 0;
}
static void start_check_parameters( char *name, char *val, char *where )
{
	char *v = nvram_safe_get( name ) ;
	struct check_parameters_handle *t ;
	struct special_character *s ;
	int isSent = 0 ;

	if( strcmp( v, val ) )
	{
		for( t=check_table ; t->name ; t++ )
		{
			if( !strcmp( t->name, name ) && !strcmp( where, "validate_cgi" ) )
			{
				for( s=special_character_name_table ; s->name ; s++ )
				{
					if( !strcmp( t->name, s->name ) )
						isSent = 1 ;
				}

				if( !isSent )
					t->print_result( v, val, t->text ) ;
			}
			else if( !strcmp( t->name, name ) && !strcmp( where, "do_sysconf_post" ) )
				t->print_result( v, val, t->text ) ;
		}
	}
}
#endif /* End of CheckParameterStatus */

static void validate_list(webs_t wp, char *value, struct variable *v,
						  int (*valid)(webs_t, char *, struct variable *))
{
	int n, i;
	char name[100];
	char buf[1000] = "", *cur = buf;

	n = atoi(value);

	for (i = 0; i < n; i++) {
		snprintf(name, sizeof(name), "%s%d", v->name, i);
		if (!(value = websGetVar(wp, name, NULL)))
			return;
		if (!*value && v->nullok)
			continue;
		if (!valid(wp, value, v))
			continue;
		cur += snprintf(cur, buf + sizeof(buf) - cur, "%s%s",
				cur == buf ? "" : " ", value);
	}

	nvram_set(v->name, buf);
}

static int valid_ipaddr(webs_t wp, char *value, struct variable *v)
{
	struct in_addr ipaddr, netaddr, netmask;

	if (!inet_aton(value, &ipaddr)) {
		websWrite(wp, "Invalid <b>%s</b> %s: not an IP address<br>",
			  v->longname, value);
		return FALSE;
	}

	if (v->argv) {
		inet_aton(nvram_safe_get(v->argv[0]), &netaddr);
		inet_aton(nvram_safe_get(v->argv[1]), &netmask);
		netaddr.s_addr &= netmask.s_addr;
		if (netaddr.s_addr != (ipaddr.s_addr & netmask.s_addr)) {
			websWrite(wp, "Invalid <b>%s</b> %s: not in the %s/",
				  v->longname, value, inet_ntoa(netaddr));
			websWrite(wp, "%s network<br>", inet_ntoa(netmask));
			return FALSE;
		}
	}

	return TRUE;
}

static void validate_ipaddr(webs_t wp, char *value, struct variable *v)
{
	if (valid_ipaddr(wp, value, v))
		nvram_set(v->name, value);
}

static void validate_ipaddrs(webs_t wp, char *value, struct variable *v)
{
	validate_list(wp, value, v, valid_ipaddr);
}

static int valid_choice(webs_t wp, char *value, struct variable *v)
{
	char **choice;

	for (choice = v->argv; *choice; choice++) {
		if (!strcmp(value, *choice))
			return TRUE;
	}

	websWrite(wp, "Invalid <b>%s</b> %s: not one of ", v->longname, value);
	for (choice = v->argv; *choice; choice++)
		websWrite(wp, "%s%s", choice == v->argv ? "" : "/", *choice);
	websWrite(wp, "<br>");
	return FALSE;
}

static void validate_choice(webs_t wp, char *value, struct variable *v)
{
	if (valid_choice(wp, value, v))
		nvram_set(v->name, value);
}

static int valid_range(webs_t wp, char *value, struct variable *v)
{
	int n, start, end;

	n = atoi(value);
	start = atoi(v->argv[0]);
	end = atoi(v->argv[1]);

	if (n < start || n > end) {
		websWrite(wp, "Invalid <b>%s</b> %s: out of range %d-%d<br>",
			  v->longname, value, start, end);
		return FALSE;
	}

	return TRUE;
}

static void validate_range(webs_t wp, char *value, struct variable *v)
{
	if (valid_range(wp, value, v))
		nvram_set(v->name, value);
}

static int valid_name(webs_t wp, char *value, struct variable *v)
{
	int n, max;

	n = atoi(value);
	max = atoi(v->argv[0]);

	if (strlen(value) > max)
	{
		websWrite(wp, "Invalid <b>%s</b> %s: greater than 255 characters<br>",
			  v->longname, value);
		return FALSE;
	}

	return TRUE;
}

static void validate_name(webs_t wp, char *value, struct variable *v)
{
	if (valid_name(wp, value, v))
	    nvram_set(v->name, value);
}

static int valid_hwaddr(webs_t wp, char *value, struct variable *v)
{
	unsigned int hwaddr[6];

	/* Make exception for "NOT IMPLELEMENTED" string */
	if (!strcmp(value,"NOT_IMPLEMENTED"))
		return(TRUE);

	/* Check for bad, multicast, broadcast, or null address */
	if (sscanf(value, "%x:%x:%x:%x:%x:%x",
		   &hwaddr[0], &hwaddr[1], &hwaddr[2],
		   &hwaddr[3], &hwaddr[4], &hwaddr[5]) != 6 ||
	    (hwaddr[0] & 1) ||
	    (hwaddr[0] & hwaddr[1] & hwaddr[2] & hwaddr[3] & hwaddr[4] & hwaddr[5]) == 0xff ||
	    (hwaddr[0] | hwaddr[1] | hwaddr[2] | hwaddr[3] | hwaddr[4] | hwaddr[5]) == 0x00) {
		websWrite(wp, "Invalid <b>%s</b> %s: not a MAC address<br>",
			  v->longname, value);
		return FALSE;
	}

	return TRUE;
}

static void validate_hwaddr(webs_t wp, char *value, struct variable *v)
{
	if (valid_hwaddr(wp, value, v))
		nvram_set(v->name, value);
}

static void validate_hwaddrs(webs_t wp, char *value, struct variable *v)
{
	validate_list(wp, value, v, valid_hwaddr);
}

static void validate_auth_mode(webs_t wp, char *value, struct variable *v)
{
	if (!valid_choice(wp, value, v))
		return;

	if (!strcmp(value, "disabled"))
	{
		if (nvram_match("wl_wep", "enabled"))
		{
			websWrite(wp, "Invalid <b>WEP Encryption</b>: must be <b>Disabled</b> when <b>Network Authentication</b> is <b>%s</b><br>", value);
			return;
		}
	}

	if (!strcmp(value, "shared") || !strcmp(value, "open"))
	{
		if (nvram_match("wl_wep", "disabled"))
		{
			websWrite(wp, "Invalid <b>WEP Encryption</b>: must be <b>Enabled</b> when <b>Network Authentication</b> is <b>%s</b><br>", value);
			return;
		}
	}

	if (!strcmp(value, "radius") || !strcmp(value, "wpa"))
	{
		if (nvram_match("radius_ipaddr", ""))
		{
			websWrite(wp, "Invalid <b>%s</b>: must first specify a valid <b>RADIUS Server</b><br>", v->longname);
			return;
		}
	}

	if (!strcmp(value, "psk"))
	{
		if (nvram_match("wpa_psk", ""))
		{
			websWrite(wp, "Invalid <b>%s</b>: must first specify a valid <b>WPA Pre-Shared Key</b><br>", v->longname);
			return;
		}
	}

	if (!strcmp(value, "wpa") || !strcmp(value, "psk"))
	{
		if( !nvram_match("wl_crypto", "tkip") &&
			!nvram_match("wl_crypto", "aes") &&
		    !nvram_match("wl_crypto", "tkip+aes") ) // Modified by Vic Yu , wl_wep ==> wl_crypto
		{
			websWrite(wp, "Invalid <b>%s</b>: <b>Data Encryption</b> mode must be TKIP or AES or TKIP+AES<br>", v->longname);
			return;
		}
		nvram_set("wl_auth", "0");
#ifdef DanielAdd
		nvram_set("wl_auth_type", "2"); /* auth mode is auto in Advanced Wireless page */
#endif
	}
	else
	{
#ifndef DanielAdd
		if (!nvram_match("wl_wep", "disabled") && !nvram_match("wl_wep", "enabled"))
		{
			websWrite(wp, "Invalid <b>%s</b>: <b>Data Encryption</b> mode must be Off or WEP<br>", v->longname);
			return;
		}
#endif
	}

	/* 802.11 authentication */
	if (!strcmp(value, "shared"))
		nvram_set("wl_auth", "1");
	else
		nvram_set("wl_auth", "0");

	nvram_set(v->name, value);
}

static void validate_wl_wpa_psk(webs_t wp, char *value, struct variable *v)
{
	int len = strlen(value);
	char *c;
	int ret ;

	if (len == 64)
	{
		for (c = value; *c; c++)
		{
			ret = isxdigit((int) *c) ;
			DanielDBG(fprintf(stderr, "ret=<%d>\n", ret);)

			if(!ret)
			{
				websWrite(wp, "Invalid <b>%s</b>: character %c is not a hexadecimal digit<br>", v->longname, *c);
				return;
			}
		}
	}
	else if (len < 8 || len > 63)
	{
		websWrite(wp, "Invalid <b>%s</b>: must be between 8 and 63 ASCII characters or 64 hexadecimal digits<br>", v->longname);
		return;
	}

	nvram_set(v->name, value);
}
static void validate_wl_key(webs_t wp, char *value, struct variable *v)
{
	char *c;

	switch (strlen(value)) {
	case 5:
	case 13:
		break;
	case 10:
	case 26:
		for (c = value; *c; c++) {
			if (!isxdigit(*c)) {
				websWrite(wp, "Invalid <b>%s</b>: character %c is not a hexadecimal digit<br>", v->longname, *c);
				return;
			}
		}
		break;
	default:
		websWrite(wp, "Invalid <b>%s</b>: must be 5 or 13 ASCII characters or 10 or 26 hexadecimal digits<br>", v->longname);
		return;
	}

	nvram_set(v->name, value);
}

static void validate_wl_wep(webs_t wp, char *value, struct variable *v)
{
	if (!valid_choice(wp, value, v))
		return;

	if( !strcmp(value, "wep") || !strcmp(value, "enabled") || !strcmp(value, "restricted"))
	{
		char wl_key[] = "wl_keyXXX";

		snprintf(wl_key, sizeof(wl_key), "wl_key%s", nvram_safe_get("wl_key"));

		if (!strlen(nvram_safe_get(wl_key)))
		{
			websWrite(wp, "Invalid <b>%s</b>: must first specify a valid <b>Network Key</b><br>", v->longname);
			return;
		}
	}

	nvram_set(v->name, value);
}

static void validate_apname(webs_t wp, char *value, struct variable *v)
{
	printf("### Validate AP Name... ");
	printf("v-name : %s, value : %s\n", v->name, value);
	nvram_set(v->name, value);
}


static void validate_wl_auth(webs_t wp, char *value, struct variable *v)
{
	if (!valid_choice(wp, value, v))
		return;

	if (atoi(value) == 1)
	{
		char wl_key[] = "wl_keyXXX";

		snprintf(wl_key, sizeof(wl_key), "wl_key%s", nvram_safe_get("wl_key"));
		if (!strlen(nvram_safe_get(wl_key)))
		{
			websWrite(wp, "Invalid <b>%s</b>: must first specify a valid <b>Network Key</b><br>", v->longname);
			return;
		}
	}

	nvram_set(v->name, value);
}

static void validate_d11_channel(webs_t wp, char *value, struct variable *v)
{
	char *country = nvram_safe_get("wl_country");
	int channel = atoi(value), min = 0, max = 0;

	if (!strcmp(v->name, "d11b_channel"))
	{
		if (!channel)
			channel = 11;

		if (!strcmp(country, "USA"))
		{
			min = 1; max = 11;
		}
		else if (!strcmp(country, "Europe"))
		{
			min = 1; max = 13;
		}
		else if (!strcmp(country, "Japan"))
		{
			min = 14; max = 14;
		}
		else if (!strcmp(country, "France"))
		{
			min = 10; max = 13;
		}
		else if (!strcmp(country, "Spain"))
		{
			min = 10; max = 11;
		}
		else
			return;

		if (channel < min || channel > max)
		{
			websWrite(wp, "Invalid <b>%s</b>: valid %s channels are %d-%d<br>", v->longname, country, min, max);
			return;
		}
	}
	else if (!strcmp(v->name, "d11a_channel"))
	{
		if (!channel)
			channel = 64;

		if (!strcmp(country, "USA"))
		{
			if (channel < 36 || channel > 64 || channel & 3)
			{
				websWrite(wp, "Invalid <b>%s</b>: valid %s channels are ", v->longname, country);
				for (channel = 36; channel <= 64; channel += 4)
					websWrite(wp, "%d%s", channel, channel == 64 ? "<br>" : "/");
				return;
			}
		}
	}

	nvram_set(v->name, value);
}

// +++   Added by Vic Yu
static void
validate_wl_crypto(webs_t wp, char *value, struct variable *v)
{
	if (!valid_choice(wp, value, v))
		return;

	nvram_set(v->name, value);
}
static void
validate_wl_akm(webs_t wp, char *value, struct variable *v)
{
	char akms[WLC_IOCTL_SMLEN] = "";
	char *wpa, *psk;
	char *wpa2, *psk2;

	wpa = websGetVar(wp, "wl_akm_wpa", NULL);
	psk = websGetVar(wp, "wl_akm_psk", NULL);
	wpa2 = websGetVar(wp, "wl_akm_wpa2", NULL);
	psk2 = websGetVar(wp, "wl_akm_psk2", NULL);
	if (!wpa || !psk
	    || !wpa2 || !psk2
	    ) {
		return;
	}

	if (!strcmp(wpa, "enabled")
	    || !strcmp(wpa2, "enabled")
	    ) {
		char *ipaddr = websGetVar(wp, "wl_radius_ipaddr", "");
		if (!ipaddr || !strcmp(ipaddr, "")) {
			return;
		}
	}

	if (!strcmp(psk, "enabled")
	    || !strcmp(psk2, "enabled")
	    ) {
		char *key = websGetVar(wp, "wl_wpa_psk", "");
		if (!key || !strcmp(key, "")) {
			return;
		}
	}

	if (!strcmp(wpa, "enabled") || !strcmp(psk, "enabled")
	    || !strcmp(wpa2, "enabled") || !strcmp(psk2, "enabled")
	    ) {
		char *crypto = websGetVar(wp, "wl_crypto", "");
		if (!crypto || (strcmp(crypto, "tkip") && strcmp(crypto, "aes") &&
			strcmp(crypto, "tkip+aes"))) {
			return;
		}
	}

	if (!strcmp(wpa, "enabled"))
		strcat(akms, "wpa ");
	if (!strcmp(psk, "enabled"))
		strcat(akms, "psk ");
	if (!strcmp(wpa2, "enabled"))
		strcat(akms, "wpa2 ");
	if (!strcmp(psk2, "enabled"))
		strcat(akms, "psk2 ");

	nvram_set("wl_akm", akms);
}
// - - -    Added by Vic Yu

/*
 * Variables are set in order (put dependent variables later). Set
 * nullok to TRUE to ignore zero-length values of the variable itself.
 * For more complicated validation that cannot be done in one pass or
 * depends on additional form components or can throw an error in a
 * unique painful way, write your own validation routine and assign it
 * to a hidden variable (e.g. filter_ip).
 */
struct variable variables[] =
{
#ifdef SETDEFVALS
	{ "def_wl_ssid", "", NULL, NULL, TRUE },
	{ "def_wl_key1", "", NULL, NULL, TRUE },
	{ "def_wl_key2", "", NULL, NULL, TRUE },
	{ "def_wl_key3", "", NULL, NULL, TRUE },
	{ "def_wl_key4", "", NULL, NULL, TRUE },
	{ "def_wl_wep", "", NULL, NULL, TRUE },
	{ "def_auth_mode", "", NULL, NULL, TRUE },
#endif /* SETDEFVALS */
#ifdef BCM4712APBOARD
	{ "web_shell", "", NULL, NULL, TRUE },
	{ "ap_client_wep", "", NULL, NULL, TRUE },
	{ "ap_client_wep_key", "", NULL, NULL, TRUE },
	{ "ap_client_wep_mode", "", NULL, NULL, TRUE },
	{ "et0macaddr", "", NULL, NULL, TRUE },
	{ "wl_country_code", "", NULL, NULL, TRUE },
	{ "il0macaddr", "", NULL, NULL, TRUE },
#endif /* BCM4712APBOARD */
#if defined(DetectDownGrade)
	{ "chk_downgrade_hdr", "", NULL, NULL, TRUE },
#endif /* DetectDownGrade */
#if defined(DetectModleNumber)
	{ "chk_fw_hdr", "", NULL, NULL, TRUE },
#endif /* DetectModleNumber */
#ifdef SetAntDiv
	{ "antenna_selection", "", NULL, NULL, TRUE },
#endif
	{ "security_mode_page", "", NULL, NULL, TRUE },
	{ "sitesurvay", "", NULL, NULL, TRUE },
#ifdef WiFi
	{ "EnableLAN", "", NULL, NULL, TRUE },
	{ "d11g_rts_cts", "", NULL, NULL, TRUE },
#endif
	{ "ap_name", "", validate_apname, NULL, FALSE},
	{ "lan_ipaddr", "", validate_ipaddr, NULL, FALSE },
	{ "wan_hostname", "", validate_name, ARGV("255"), TRUE },
	{ "wan_ipaddr", "", validate_ipaddr, NULL, FALSE },
	{ "wan_netmask", "", validate_ipaddr, NULL, FALSE },
	{ "wan_gateway", "", validate_ipaddr, NULL, TRUE },
	{ "wan_proto", "WAN Protocol", validate_choice, ARGV("dhcp", "static", "pppoe"), FALSE },
	{ "http_username", "", validate_name, ARGV("63"), TRUE },
	{ "http_passwd", "", validate_name, ARGV("63"), TRUE },
	{ "wl_ssid", "", validate_name, ARGV("32"), TRUE },
	{ "wl_channel", "Channel", validate_range, ARGV("0", "216"), FALSE},
	{ "wl_closed", "", validate_choice, ARGV("0", "1"), FALSE },
	{ "wl_country", "", validate_choice, ARGV("Worldwide", "Europe", "Japan", "France", "Spain"), FALSE },
	{ "wl_plcphdr", "", validate_choice, ARGV("long", "short"), FALSE },
#ifdef DanielAdd
	{ "log_ipaddr", "", validate_ipaddr, NULL, TRUE },
	{ "log_ipaddr_1", "", validate_range, ARGV("0", "255"), FALSE },
	{ "log_ipaddr_2", "", validate_range, ARGV("0", "255"), FALSE },
	{ "log_ipaddr_3", "", validate_range, ARGV("0", "255"), FALSE },
	{ "log_ipaddr_4", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wl_mode", "", validate_choice, ARGV("ap", "wds", "sta", "wet"), FALSE },
	{ "wl_wds", "", validate_hwaddrs, NULL, TRUE },
	{ "wl_lazywds", "", validate_choice, ARGV("0", "1"), FALSE },
	{ "wl_auth_type", "", validate_range, ARGV("0", "2"), FALSE },
	{ "wl_passphrase", "", NULL, NULL, FALSE },
	{ "passphrase", "", NULL, NULL, FALSE },
	{ "ap_mode", "", validate_range, ARGV("0", "3"), FALSE },
	{ "wds0", "", NULL, NULL, TRUE },
	{ "wds1", "", NULL, NULL, TRUE },
	{ "wds2", "", NULL, NULL, TRUE },
	{ "wds3", "", NULL, NULL, TRUE },
	{ "SNMPEnable", "", validate_range, ARGV("0", "1"), FALSE },
	{ "SYSContact", "", NULL, NULL, TRUE },
	{ "SYSName", "", NULL, NULL, TRUE },
	{ "SYSLocation", "", NULL, NULL, TRUE },
	{ "SNMPCommunityOne", "", NULL, NULL, TRUE },
	{ "SNMPCommunityTwo", "", NULL, NULL, TRUE },
	{ "RWEnableOne", "", NULL, NULL, TRUE },
	{ "RWEnableTwo", "", NULL, NULL, TRUE },
	{ "et1macaddr", "", NULL, NULL, TRUE },
	{ "et0phyaddr", "", NULL, NULL, TRUE },
	{ "et1phyaddr", "", NULL, NULL, TRUE },
#endif /* DanielAdd */
	/* Order and index matters for WEP keys so enumerate them separately */
	{ "wl_key", "", validate_range, ARGV("1", "4"), FALSE },
	{ "wl_key1", "", validate_wl_key, NULL, TRUE },
	{ "wl_key2", "", validate_wl_key, NULL, TRUE },
	{ "wl_key3", "", validate_wl_key, NULL, TRUE },
	{ "wl_key4", "", validate_wl_key, NULL, TRUE },
	//{ "wl_wep", "", validate_wl_wep, ARGV("off", "on", "restricted", "tkip", "aes", "wep", "tkip+aes" ), FALSE },
	{ "wl_wep", "", validate_wl_wep, ARGV("disabled", "enabled" ), FALSE },// Modified by Vic Yu
	//{ "wl_auth", "", validate_wl_auth, ARGV("0", "1"), FALSE },
	{ "wl_auth", "", NULL, ARGV("0", "1"), FALSE },
	{ "wl_mac", "", validate_hwaddrs, NULL, TRUE },
	{ "wl_mac_hwaddr", "", validate_hwaddrs, NULL, TRUE },
	{ "wl_frameburst", "", validate_choice, ARGV("off", "on"), FALSE },
	/* WPA parameters */
	{ "wl_wpa_psk", "", validate_wl_wpa_psk, ARGV("64"), TRUE },
	{ "wl_wpa_gtk_rekey", "", NULL, NULL, TRUE },
	{ "radius_ipaddr", "", validate_ipaddr, NULL, TRUE },
	{ "radius_ipaddr_1", "", NULL, NULL, TRUE },
	{ "radius_ipaddr_2", "", NULL, NULL, TRUE },
	{ "radius_ipaddr_3", "", NULL, NULL, TRUE },
	{ "radius_ipaddr_4", "", NULL, NULL, TRUE },
	{ "radius_port", "", validate_range, ARGV("0", "65535"), FALSE },
	{ "radius_key", "", validate_name, ARGV("255"), TRUE },
	//{ "auth_mode", "", validate_auth_mode, ARGV("disabled", "radius", "wpa", "psk"), TRUE },
	{ "auth_mode", "", validate_auth_mode, ARGV("disabled", "open", "shared", "radius", "wpa", "psk"), TRUE },// Modified by Vic Yu
	{ "wl_crypto", "WPA Encryption", validate_wl_crypto, ARGV("tkip", "aes", "tkip+aes"), TRUE },//Added by Vic Yu
	{ "wl_akm", "Authenticated Key Management", validate_wl_akm, NULL, FALSE },
	/* end of for WPA */

#ifdef DanielAdd
#if defined(LinksysWAP54GJP) || defined(LinksysWAP54GEU) || \
	defined(WhiteWAP54GJP)   || defined(WhiteWAP54GEU) || \
	defined(WX5520G)         || defined(BeWANAP54) || \
	defined(WX5520G4712)     || defined(LinksysWAP54GEU4712) || \
	defined(BeWANAP544712)   || defined(LinksysWAP54GJP4712)
	{ "d11g_channel", "", NULL, NULL, TRUE },
#else
	{ "d11g_channel", "", validate_d11_channel, NULL, FALSE },
#endif
	{ "d11g_rate", "", validate_choice, ARGV("0", "1000000", "2000000", "5500000", "6000000", "9000000", "11000000", "12000000", "18000000", "24000000", "36000000", "48000000", "54000000"), FALSE },
	{ "d11g_rateset", "", validate_choice, ARGV("all", "default", "12", "brs1", "brs2"), FALSE },
	{ "d11g_frag", "", validate_range, ARGV("256", "2346"), FALSE },
	{ "d11g_rts", "", validate_range, ARGV("0", "2346"), FALSE },
	{ "d11g_dtim", "", validate_range, ARGV("1", "255"), FALSE },
	{ "d11g_bcn", "", validate_range, ARGV("1", "65535"), FALSE },
	{ "d11g_mode", "", validate_range, ARGV("0", "6"), FALSE },
	{ "d11g_shortslot_override", "", validate_range, ARGV("-1", "1"), FALSE },
	{ "d11g_shortslot_restrict", "", validate_range, ARGV("0", "3"), FALSE },
#endif /* DanielAdd */

#ifdef FCCTesting
	{ "FCCTesting", "", NULL, NULL, TRUE },
	{ "client_ipaddr", "", NULL, NULL, TRUE },
	{ "ip_1", "", NULL, NULL, TRUE },
	{ "ip_2", "", NULL, NULL, TRUE },
	{ "ip_3", "", NULL, NULL, TRUE },
	{ "ip_4", "", NULL, NULL, TRUE },
	{ "sockbufsize", "", NULL, NULL, TRUE },
	{ "buflen", "", NULL, NULL, TRUE },
	{ "nbuf", "", NULL, NULL, TRUE },
	{ "b_channel", "", NULL, NULL, TRUE },
	{ "b_rate", "", NULL, NULL, TRUE },
	{ "pwr", "", NULL, NULL, TRUE },
	{ "rate", "", NULL, NULL, TRUE },
	{ "receive", "", NULL, NULL, TRUE },
	{ "pa0maxpwr", "", NULL, NULL, TRUE },
	{ "pa0b0", "", NULL, NULL, TRUE },
	{ "pa0b1", "", NULL, NULL, TRUE },
	{ "pa0b2", "", NULL, NULL, TRUE },
	{ "opo", "", NULL, NULL, TRUE },
	{ "single_carrier", "", NULL, NULL, TRUE },
#endif /* FCCTesting */
#ifdef AP_Client
	{ "ap_client_mac", "", NULL, NULL, TRUE },
	{ "ap_client_ssid", "", NULL, NULL, TRUE },
#endif /* AP_Client */
	{ "ap_repeater_mac", "", NULL, NULL, TRUE },
	{ "ap_repeater_ssid", "", NULL, NULL, TRUE },
	{ "ap_repeater_channel", "", NULL, NULL, TRUE },
	{ "ap_repeater_mode", "", NULL, NULL, TRUE },
#ifdef AP_Repeater
	{ "key1_auth", "", NULL, NULL, TRUE },
	{ "key2_auth", "", NULL, NULL, TRUE },
	{ "key3_auth", "", NULL, NULL, TRUE },
	{ "key4_auth", "", NULL, NULL, TRUE },
#endif
	{ "FilterSwitch", "", validate_choice, ARGV("0", "1"), FALSE },
	{ "FilterMACGroupNum", "", validate_choice, ARGV("1", "11", "21"), FALSE },
	{ "wan_ipaddr_1", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_ipaddr_2", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_ipaddr_3", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_ipaddr_4", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_netmask_1", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_netmask_2", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_netmask_3", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_netmask_4", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_gateway_1", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_gateway_2", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_gateway_3", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wan_gateway_4", "", validate_range, ARGV("0", "255"), FALSE },
	{ "wl_macmode", "", validate_choice, ARGV("disabled", "allow", "deny"), FALSE },
	{ "wl_rate", "Rate", validate_range, ARGV("0", "54000000"), FALSE, 0 },
	{ "wl_rateset", "Supported Rates", validate_choice, ARGV("all", "default", "12"), FALSE},
	{ "wl_mrate", "Multicast Rate", validate_range, ARGV("0", "54000000"), FALSE},
	{ "wl_frag", "Fragmentation Threshold", validate_range, ARGV("256", "2346"), FALSE},
	{ "wl_rts", "RTS Threshold", validate_range, ARGV("0", "2347"), FALSE},
	{ "wl_dtim", "DTIM Period", validate_range, ARGV("1", "255"), FALSE },
	{ "wl_bcn", "Beacon Interval", validate_range, ARGV("1", "65535"), FALSE},
	{ "wl_gmode_protection", "54g Protection", validate_choice, ARGV("off", "auto"), FALSE},
	{ "wl_gmode", "54g Mode", validate_choice, ARGV(XSTR(GMODE_AUTO), XSTR(GMODE_ONLY), XSTR(GMODE_PERFORMANCE), XSTR(GMODE_LRS), XSTR(GMODE_LEGACY_B)), FALSE},

	/* MUST leave this entry here after all wl_XXXX variables */
	{ "wl_unit", "802.11 Instance", NULL, NULL, TRUE }
};

static void validate_cgi(webs_t wp)
{
	struct variable *v;
	char *value;
#ifdef DectectSpecialCharacters
	struct special_character *sc ;
#endif

	DanielDBG(fprintf( stderr, "/**start to save parameters in NVRAM**/\n" );)

	/* Validate and set variables in table order */
	for (v = variables; v < &variables[sizeof(variables)/sizeof(variables[0])]; v++)
	{
		if (!(value = websGetVar(wp, v->name, NULL)))
			continue;

#ifdef DectectSpecialCharacters
		for( sc=special_character_name_table ; sc->name ; sc++ )
		{
			if( !strcmp( v->name, sc->name ) )
			{
				sc->flag = 1 ;
				break ;
			}
		}

		if( sc->flag == 1 )
		{
			DanielDBG(fprintf( stderr, "%s=<%s> No saving !!!\n", v->name, value);)
			continue ;
		}
#endif

#ifdef CheckParameterStatus
		start_check_parameters( v->name, value, "validate_cgi" );
#endif

		if( (!*value && v->nullok) || !v->validate )
		{
			nvram_set(v->name, value);
		}
		else
			v->validate(wp, value, v);

		DanielDBG(fprintf( stderr, "%s=<%s>\n", v->name, value);)
	}

#ifdef CheckParameterStatus
	send_log_msg();
#endif

	// Vic Yu added
	GTK_convert_nvram_parameter();
}




enum
{
	NOTHING,
	REBOOT,
	RESTART,
};
char *RedirectPage(char *buf, char *page)
{
	DanielDBG(cprintf("%s();\n", __FUNCTION__);)

	if( page == NULL )
		return NULL ;

	sprintf( buf, "<head>\n"
				  "<title>Rediect %s</title>\n"
				  "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n"
				  "<meta http-equiv=\"refresh\" content=\"0; url=%s\">\n"
				  "<script language=\"javascript\">\n"
				  "<!--\n"
				  "	window.location.href = \"%s\" ;\n"
				  "//-->\n"
				  "</script>\n"
				  "</head>\n"
				  "<body>\n"
				  "&nbsp;\n"
				  "</body>", page, page, page );

	return buf ;
}
int do_Apply(webs_t wp)
{	/* Apply values */
	char *nvram_ssid, *nvram_channel ;
	char *html_ssid, *html_channel ;
	char *html_ap_mode, *check_log, *page ;
	char messages[100] ;
	DanielDBG(time_t tm ;)

	page = NULL ;
	nvram_ssid = nvram_channel = html_ssid = html_channel = NULL ;
	html_ap_mode = check_log = NULL ;

	page = websGetVar(wp, "page", "") ;

	/* check if ssid is changed and send log */
	DanielDBG(cprintf("check if ssid is changed and send log\n");)
	check_log = websGetVar(wp, "check_log", "") ;

	if( !strcmp(check_log, "1") )
	{
		nvram_ssid = nvram_safe_get("wl_ssid") ;
		nvram_channel = nvram_safe_get("wl_channel") ;
		html_ssid = websGetVar(wp, "wl_ssid", "") ;
		html_channel = websGetVar(wp, "wl_channel", "") ;
		html_ap_mode = websGetVar(wp, "wl_mode", "") ;

		if( nvram_ssid )
		{
			if( strcmp( nvram_ssid, html_ssid ) || strcmp( nvram_channel, html_channel ) )
			{
				DanielDBG(cprintf("nvram_ssid/nvram_channel is not equal to html_ssid/html_channel\n");)
				DanielDBG(cprintf("html_ap_mode=<%s>\n", html_ap_mode);)
				DanielDBG(cprintf("html_channel=<%s>\n",html_channel);)
				DanielDBG(cprintf("nvram_channel=<%s>\n",nvram_channel);)
				DanielDBG(cprintf("html_ssid=<%s>\n",html_ssid);)
				DanielDBG(cprintf("nvram_ssid=<%s>\n",nvram_ssid);)

				sprintf( messages, "%s mode start. Channel=%s SSID=%s",
									html_ap_mode, html_channel,	html_ssid );

				DanielDBG(cprintf("messages=%s\n", messages );)
				DanielDBG(cprintf("messages_len=%d\n", strlen(messages) );)
				//syslog( LOG_INFO, "%s", messages ) ;
				DanielDBG(time(&tm);)
				DanielDBG(cprintf("tm=%s\n", ctime(&tm));)
				DanielDBG(cprintf("seconds=%d\n", tm );)
				set_log_info( messages ) ;
			}
		}
	}

	validate_cgi(wp);

	DanielDBG(fprintf(stderr, "(%s:%d)page=<%s>\n", __FUNCTION__, __LINE__, page);)

	if( !strcmp(page, "save") )
	{
		return 3 ;  //Just save parameters, no reboot and restart
	}
	else
	{
		return 2 ;// Save and reboot
	}

	return 2 ;
#if 0
if( !strcmp(page, "setup")   || !strcmp(page, "ap_mode")  ||
		!strcmp(page, "filters") || !strcmp(page, "wireless") ||
		!strcmp(page, "dummy")   || !strcmp(page, "wep") 	  ||
		!strcmp(page, "wep_5G")  || !strcmp(page, "log") 	  ||
		!strcmp(page, "snmp")    || !strcmp(page, "password") ||
		!strcmp(page, "site")    || !strcmp(page, "Preshared")||
		!strcmp(page, "Radius")	 || !strcmp(page, "MD5")      ||
		!strcmp(page, "fcc")     || !strcmp(page, "country") )
	{
		return 2 ; /* reboot the device */
	}
	else if( !strcmp(page, "save") )
	{
		return 3 ; /* Just save parameters, no reboot and restart  */
	}
	else
	{
		return 1 ; /* restart */
	}
#endif
}
int do_GenKey(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set PassphraseKeyLength */
	nvram_set("PassphraseKeyLength", websGetVar(wp, "Key_Length_24G", ""));
	DanielDBG(fprintf(stderr, "PassphraseKeyLength=<%s>\n", websGetVar(wp, "Key_Length_24G", ""));		)

	/* set wl_passphrase */
	nvram_set("wl_passphrase", websGetVar(wp, "wl_passphrase", ""));
	DanielDBG(fprintf(stderr, "wl_passphrase=<%s>\n", websGetVar(wp, "wl_passphrase", ""));)

	GeneratePassPhraseKey() ;

	sys_commit();

	//websWrite(wp, (char_t *) GenPassPhraseKey);
	websWrite(wp, (char_t *) RedirectPage(buf, "SharedKeys.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_GenKeyWEP(webs_t wp)
{
	char buf[1024];
	char *page;

	bzero(buf, sizeof(buf));

	page=websGetVar(wp, "Gen_page", "");
	/* set PassphraseKeyLength */
	nvram_set("PassphraseKeyLength", websGetVar(wp, "Key_Length_24G", ""));
	DanielDBG(fprintf(stderr, "PassphraseKeyLength=<%s>\n", websGetVar(wp, "Key_Length_24G", ""));		)

	/* set wl_passphrase */
	nvram_set("wl_passphrase", websGetVar(wp, "wl_passphrase", ""));
	DanielDBG(fprintf(stderr, "wl_passphrase=<%s>\n", websGetVar(wp, "wl_passphrase", ""));)


	GeneratePassPhraseKey() ;


	//sys_commit();

	if(*page && strcmp(page,"AP_client")==0) // Passphrase Generate from AP client mode
		websWrite(wp, (char_t *) RedirectPage(buf, "WEP.asp"));
	else
		websWrite(wp, (char_t *) RedirectPage(buf, "WSecurity_WEP.asp"));

	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_GenKeyRadius(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set PassphraseKeyLength */
	nvram_set("PassphraseKeyLength", websGetVar(wp, "Key_Length_24G", ""));
	DanielDBG(fprintf(stderr, "PassphraseKeyLength=<%s>\n", websGetVar(wp, "Key_Length_24G", ""));		)

	/* set wl_passphrase */
	nvram_set("wl_passphrase", websGetVar(wp, "wl_passphrase", ""));
	DanielDBG(fprintf(stderr, "wl_passphrase=<%s>\n", websGetVar(wp, "wl_passphrase", ""));)

	GeneratePassPhraseKey() ;

	//sys_commit();

	websWrite(wp, (char_t *) RedirectPage(buf, "WSecurity_Radius_WEP.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_mac(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set mac_index */
	nvram_set("wl_mac_index", websGetVar(wp, "wl_mac_index", ""));
	DanielDBG(fprintf(stderr, "wl_mac_index=<%s>\n", websGetVar(wp, "wl_mac_index", ""));)
	sys_commit();

	websWrite(wp, (char_t *) RedirectPage(buf, "WMACFilter.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_Conf(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set wan_proto */
	nvram_set( "wan_proto", websGetVar(wp, "wan_proto", ""));
	DanielDBG(fprintf(stderr, "wan_proto=<%s>\n",  websGetVar(wp, "wan_proto", ""));)
	sys_commit();

	websWrite(wp, (char_t *) RedirectPage(buf, "setup.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_Log(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set log_ipaddr */
	nvram_set( "log_ipaddr", websGetVar(wp, "log_ipaddr", ""));
	DanielDBG(fprintf(stderr, "log_ipaddr=<%s>\n", websGetVar(wp, "log_ipaddr", ""));)
	sys_commit();

	websWrite(wp, (char_t *) RedirectPage(buf, "Log.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_Filters(webs_t wp)
{
	char *p = NULL ;
	char buf[1024];

	bzero(buf, sizeof(buf));
	p = websGetVar(wp, "FilterSwitch", "") ;

	/* set FilterSwitch */
	if( p != NULL )
	{
		nvram_set( "FilterSwitch", p);
		sys_commit();
	}

	DanielDBG(fprintf(stderr, "FilterSwitch=<%s>\n", p);)
	websWrite(wp, (char_t *) RedirectPage(buf, "WMACFilter.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_SNMP(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* set FilterSwitch */
	nvram_set( "SNMPEnable", websGetVar(wp, "SNMPEnable", ""));
	DanielDBG(fprintf(stderr, "SNMPEnable=<%s>\n", websGetVar(wp, "SNMPEnable", ""));)
	sys_commit();

	websWrite(wp, (char_t *) RedirectPage(buf, "SNMP.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_dummy_view_log(webs_t wp)
{	/* Dummy View Log Page */
	websWrite(wp, (char_t *) DummyViewLogPage);
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_view_log(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* Redirect View Log Page */
	/* get local time */
	local_time = websGetVar(wp, "time", "");
	DanielDBG(cprintf("local_time=%s\n", local_time );)
	/* get current time */
	time(&current_time) ;
	DanielDBG(cprintf("current_time=%d\n", current_time );)

	websWrite(wp, (char_t *) RedirectPage(buf, "view_log.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_clear_log(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* Clear Log Page */
	DanielDBG(cprintf("clear log (/tmp/log_info.txt) ...\n");)
	nvram_set( "curpage", "1" );
	nvram_set( "lastpage", "1" );
	unlink( "/tmp/log_info.txt" );

	websWrite(wp, (char_t *) RedirectPage(buf, "view_log.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_change_page(webs_t wp)
{
	char buf[1024];

	bzero(buf, sizeof(buf));
	/* Change Log Page */
	/* set curpage */
	nvram_set("curpage", websGetVar(wp, "curpage", ""));

	websWrite(wp, (char_t *) RedirectPage(buf, "view_log.asp"));
	websFooter(wp);
	websDone(wp, 200);

	return 0 ;
}
int do_Nvram(webs_t wp)
{	/* Show Nvram values */
	char *p, *base ;
	char *name, *value, *nvram_buf, *buf ;

	p = base = name = value = nvram_buf = buf = NULL ;

	/* Allocate buffer */
	if( !(nvram_buf = malloc(NVRAM_SPACE)) || !(buf = malloc(1024)) ||
		!(name = malloc(1024))             || !(value = malloc(1024)) )
	{
		fprintf( stderr, "allocate buffer error \n" );
		return -1 ;
	}

	memset( nvram_buf, '\0', NVRAM_SPACE );
	memset( buf, '\0', 1024 );

	sprintf( buf, "%s", "<center><b><font face=\"Arial, Helvetica, sans-serif\" size=\"2\"\
									color=\"blue\">Parameters in NVRAM</font></b></center><br>\n" );
	websWrite(wp, "%s", buf);
	memset( buf, '\0', 1024 );

	/* get name & value in nvram */
	nvram_getall(nvram_buf, NVRAM_SPACE);

	/* parse name and value */
	for( p = nvram_buf ; *p ; p += strlen(p) + 1 )
	{
		memset( buf, '\0', 1024 );
		memset( name , '\0', 1024 );
		memset( value , '\0', 1024 );

		base = strchr( p, '=' ) ;
		strncpy( name, p, base-p );
		//DanielDBG(fprintf( stderr, "name=<%s>\t\t", name );)
		base++ ;
		strncpy( value, base, strlen(base) );
		//DanielDBG(fprintf( stderr, "value=<%s>\n", value );)
		sprintf( buf, "<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" \
				 color=\"#000000\"><b>%s</b></font> = \
				 <font face=\"Arial, Helvetica, sans-serif\" size=\"2\" color=\"red\"><b>\"%s\"</b>\
				 </font><br>\n",
				 name, value);
		websWrite(wp, "%s", buf);
	}

	websFooter(wp);
	websDone(wp, 200);

	/* free buffer */
	free(buf);
	free(nvram_buf);
	free(name);
	free(value);

	return 0 ;
}
int do_kmsg(webs_t wp)
{	/* Show /proc/kmsg */
	FILE *kmsg_fp = NULL ;
	char kmsg_buf[1024] ;
	char k_buf[2048] ;
	int i ;

	kmsg_fp = fopen( "/proc/kmsg", "r" );
	if( kmsg_fp == NULL )
	{
		fprintf( stderr, "open /proc/kmsg error !!!\n" );
		return -1 ;
	}

	for( i=0 ; i<80 ; i++ )
	{
		fprintf( stderr, "i=%d, ", i );
		memset( kmsg_buf, '\0', 1024 );
		memset( k_buf, '\0', 2048 );
		fgets( kmsg_buf, sizeof(kmsg_buf), kmsg_fp );
		fprintf( stderr, "kmsg_buf[0]=%XH\n", kmsg_buf[0] );
		if( kmsg_buf[0] == 0x00 )
			break ;
		sprintf( k_buf, "<font face=\"Arial, Helvetica, sans-serif\" size=\"2\" \
				 color=\"#000000\"><b>%s</b></font><br>\n",
				 kmsg_buf );
		websWrite(wp, "%s", k_buf);
	}

	websFooter(wp);
	websDone(wp, 200);

	fclose(kmsg_fp);

	return 0 ;
}
int do_test(webs_t wp)
{
#if 0
	FILE *p_fp = NULL ;
	char buf[1024] ;
	char **p ;
	char *exetab[] =
	{
		"/usr/sbin/wl dump",
		"/usr/sbin/wl status",
		0
	};

	for( p=exetab ; *p ; p++ )
	{
		p_fp = popen( *p, "r" );
		if( p_fp == NULL )
		{
			perror( "popen" );
			return 0 ;
		}

		while( !feof(p_fp) )
		{
			memset( buf, '\0', sizeof(buf) );
			fgets( buf, sizeof(buf), p_fp );
			websWrite(wp, "%s<br>", buf);
		}
		websWrite(wp, "%s", "<br>");
		pclose(p_fp);
	}
#endif

	return 0 ;
}
int do_macfilter(webs_t wp)
{	/* Filters Page */
	char *TempString ;
	char *page ;

	validate_cgi(wp);

	nvram_set("wl_mac_hwaddr", nvram_get("wl_mac"));
	nvram_set("wl0_mac_hwaddr", nvram_get("wl_mac"));
	TempString = websGetVar(wp, "FilterSwitch", "");

	if (!strcmp(TempString, "0"))
		nvram_set("wl_mac", "");

	nvram_commit();

	page = websGetVar(wp, "page", "") ;
	DanielDBG(fprintf(stderr, "(%s:%d)page=<%s>\n", __FUNCTION__, __LINE__, page);)

	if( !strcmp(page, "filters") )
		return 2 ; /* reboot */
	else
		return 1 ; /* restart */
}
int do_Restore_Defaults(webs_t wp)
{	/* Restore defaults */
	nvram_set("restore_defaults", "1");
	nvram_set("wl_akm", "");
	nvram_set("wl0_akm", "");
	return 2 ; /* reboot */
}
#ifdef AddLinkedList
LIST *get_tmp_nvram()
{	/* open /tmp/var/tmp/nvram */
	FILE *fp = NULL ;
	char buf[1024] ;
	char *p, *q ;
	LIST *lp = NULL ;

	p = q = NULL ;

	fp = fopen( "/tmp/var/tmp/nvram", "r" ) ;

	if( fp == NULL )
	{
		DanielDBG(cprintf("open nvram error \n");)
		return NULL ;
	}

	while(!feof(fp))
	{
		memset( buf, '\0' , sizeof(buf) );
		fgets( buf, sizeof(buf), fp );

		if( !strncmp( buf, "nvram_", 6 ) )
		{
			p = buf ;
			p += 6 ;
			q = strchr( p, '=' );
			if( q != NULL )
			{
				*q = 0x00 ;
				fprintf( stderr, "name=<%s>\n", p );
				sprintf( buf, "%s", p );
				fprintf( stderr, "buf=<%s>\n", buf );
				lp = AddItemToQueue(lp, buf) ;
			}
		}
	}

	fclose(fp);
	PrintQueue(lp);

	return lp ;
}
#endif /* AddLinkedList */
int do_ap_client(webs_t wp)
{
	char boardtype[10] ;
	char buf[1024];

	bzero(buf, sizeof(buf));
	memset(boardtype,0,10);
	strcpy(boardtype ,nvram_safe_get("boardtype"));
	validate_cgi(wp);
	nvram_set( "wl0_mode", "wet" );
	nvram_set( "wl0_wep", "disabled" );// Modified by Vic Yu , off ==> disabled

	websWrite(wp, (char_t *) RedirectPage(buf, "none.asp"));
	websFooter(wp);
	websDone(wp, 200);

	if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
	{
		eval("wlconf", "eth1", "down");
		eval("wlconf", "eth1", "up");
	}
	else
	{
#ifdef BCM4712APBOARD
		eval("wlconf", "eth2", "down");
		eval("wlconf", "eth2", "up");
#else /* !BCM4712APBOARD */
		eval("wlconfig", "eth2");
#endif /* end of BCM4712APBOARD */
	}

	return 0 ; /* DoNotThing */
	/*return 1 ; *//* restart */
}
#if 0
int do_WebShell(webs_t wp)
{
	char buf[1024];
	char *value = NULL ;
	FILE *p_fp = NULL ;

	bzero(buf, sizeof(buf));
	DanielDBG(fprintf(stderr,"%s()...\n", __FUNCTION__ );)
	validate_cgi(wp);

	value = websGetVar(wp, "web_shell", "");

	p_fp = popen( value, "r" );
	if( p_fp == NULL )
		websWrite(wp, "popen %s error\n", value);
	else
	{
		while(!feof(p_fp))
		{
			fgets( buf, sizeof(buf), p_fp );
			websWrite(wp, "%s<br>", buf);
		}
	}

	websFooter(wp);
	websDone(wp, 200);

	return 0 ; /* DoNotThing */
}
#endif
int do_APC(webs_t wp)
{
#ifdef AP_Repeater
	char *restart_argv[2] ;
	int ret ;
	pid_t pid ;
	char *page = NULL ;
#endif
	char buf[1024];
#if defined(THESAMESSID)
	char *val = NULL ;
#endif

	DanielDBG(fprintf(stderr,"%s()...\n", __FUNCTION__ );)

#if defined(THESAMESSID)
	val = websGetVar(wp, "ap_client_ssid", "") ;
	DanielDBG(fprintf(stderr,"val=<%s>\n", val);)
	fprintf(stderr,"val=<%s>\n", val);
	if( val != NULL )
		nvram_set( "wl_ssid", val );
#endif

	bzero(buf, sizeof(buf));
	validate_cgi(wp);
	nvram_commit();

#ifdef AP_Repeater
	page = websGetVar(wp, "page", "") ;

	if( !strcmp(page, "wep") )
	{
		nvram_set("wl_wep", "enabled");// Modified by Vic Yu ,wep ==> enabled
		nvram_set("wl0_wep", "enabled");
		ap_repeater_script("/tmp/ap_repeater_wep");
		restart_argv[0] = "/tmp/ap_repeater_wep" ;
		//make_ap_repeater_mode_script("wep");
	}
	else
	{
		nvram_set("wl_wep", "disabled");// Modified by Vic Yu ,off ==> disabled
		nvram_set("wl0_wep", "disabled");
		ap_repeater_script("/tmp/ap_repeater");
		restart_argv[0] = "/tmp/ap_repeater" ;
		//make_ap_repeater_mode_script("start");
	}

	restart_argv[1] = NULL ;
	websWrite(wp, (char_t *) self_close);
	websFooter(wp);
	websDone(wp, 200);

	ret = _eval( restart_argv, NULL, 0, &pid);
	waitpid(pid, &ret, WUNTRACED);
	//unlink("/tmp/ap_repeater_mode_restart");
#else
	websWrite(wp, (char_t *) RedirectPage(buf, "ap_client_restart.asp"));
	websFooter(wp);
	websDone(wp, 200);
#endif

	return 0 ; /* DoNotThing */
}
#ifdef AP_Repeater
int do_AutoScan(webs_t wp)
{
	char buf[1024];
#ifdef SITESURVEY_QUEUE
	SITESURVEY_LIST *p ;
	site_survey_t *t ;
	char *q = NULL ;
	char *restart_argv[2] ;
	int ret ;
	pid_t pid ;
#endif

	system( "/tmp/scan" );
	ParseScanresults( "/tmp/scanresults", "queue" );
	ap_repeater_script("/tmp/ap_repeater");
	system( "/tmp/ap_repeater" );

#ifdef SITESURVEY_QUEUE
	SL = SortQueue(SL);
	p = SL ;
	t = &p->content[0] ;

	fprintf(stderr,"SSID=<%s> BSSID=<%s> Channel=<%s>\n", t->SSID, t->BSSID, t->Channel);

	if( t->BSSID != (char *)0)
		nvram_set( "ap_repeater_mac", t->BSSID );
	if( t->SSID != (char *)0)
		nvram_set( "ap_repeater_ssid", t->SSID );
	if( t->Channel != (char *)0)
		nvram_set( "ap_repeater_channel", t->Channel );

	q = strstr( t->Capability, "WEP" );
	if( q != NULL )
	{
		nvram_set("wl_wep", "enabled");// Modified by Vic Yu ,wep ==> enabled
		nvram_set("wl0_wep", "enabled");
		ap_repeater_script("/tmp/ap_repeater_wep");
		restart_argv[0] = "/tmp/ap_repeater_wep" ;
		//make_ap_repeater_mode_script("wep");
	}
	else
	{
		nvram_set("wl_wep", "disabled");// Modified by Vic Yu ,off ==> disabled
		nvram_set("wl0_wep", "disabled");
		ap_repeater_script("/tmp/ap_repeater");
		restart_argv[0] = "/tmp/ap_repeater" ;
		//make_ap_repeater_mode_script("start");
	}

	restart_argv[1] = NULL ;
	ret = _eval( restart_argv, NULL, 0, &pid);
	waitpid(pid, &ret, WUNTRACED);
	//unlink("/tmp/ap_repeater_mode_restart");
	ClearQueue(SL);
#endif /* end of SITESURVEY_QUEUE */

	websWrite(wp, (char_t *) RedirectPage(buf, "none.asp"));
	websFooter(wp);
	websDone(wp, 200);
	unlink("/tmp/scanresults");

	return 0 ; /* DoNotThing */
}
int do_DetectWDSLink(webs_t wp)
{
	int ret ;

	make_ap_repeater_connect_script();
	ret = do_detect_wdslink();

	if( !ret )
		system( "/tmp/ap_repeater" );
	else
		system( "/tmp/connect" );

	return 0 ; /* DoNotThing */
}
#endif /* end of AP_Repeater */
static int apply_cgi(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg,
					 char_t *url, char_t *path, char_t *query)
{
	int action = NOTHING;
	char *value = NULL ;
#ifdef DanielAdd
	char buf[1024] ;
	struct action_handler *p ;
	int ret, hit = 0 ;
#endif

	websHeader(wp);

	if (!query)
		goto footer;

	DanielDBG(fprintf(stderr,"(%s:%d)query=<%s> ", __FUNCTION__, __LINE__, query );)
	DanielDBG(fprintf(stderr,"url=<%s>\n", url);)

	value = websGetVar(wp, "action", "");
	DanielDBG(fprintf(stderr,"value=<%s>\n", value);)

	for( p=action_table ; p->action ; p++ )
	{
		if(!strcmp(value, p->action))
		{
			ret = p->execute(wp) ;

			if( ret == -1 )
				break ;
			else if( ret == 0 )
				goto DoNoThing;
			else if( ret == 1 )
				action = RESTART ;
			else if( ret == 2 )
				action = REBOOT ;
			else if( ret == 3 )
				action = NOTHING ;

			hit = 1 ;
		}

		if( hit == 1 )
			break ;
	}

	/* SES events */
	if (!strcmp(value, "NewSesNW")) {
		websWrite(wp, "Creating SES Network");
		nvram_set("ses_event", "3");
		action = NOTHING;
		hit = 1 ;
	}
	else if (!strcmp(value, "OpenWindow")) {
		/* verify that we are a psk/tkip network */
		if (nvram_match("wl0_crypto", "tkip") &&
		    (nvram_match("wl0_akm", "psk") || nvram_match("wl0_akm", "psk "))) {
			websWrite(wp, "Opening SES Window");
			nvram_set("ses_event", "4");
		}
		else {
			websWrite(wp, "Failed to open SES window; configuration incorrect");
		}
		action = NOTHING;
		hit = 1 ;
	}
	else if (!strcmp(value, "NewSesNWAndOW")) {
		websWrite(wp, "Creating SES Network and Opening SES Window");
		nvram_set("ses_event", "6");
		action = NOTHING;
		hit = 1 ;
	}
	else if (!strcmp(value, "ResetNWToDefault")) {
		websWrite(wp, "Restoring Network to Default");
		nvram_set("ses_event", "7");
		action = NOTHING;
		hit = 1 ;
	}

	/* Invalid action */
	if( hit == 0 )
	{
		websWrite(wp, "Invalid action %s<br>", value);
		action = NOTHING ;
		goto footer;
	}

	sys_commit();

	/* output apply_header */
	websWrite(wp, (char_t *) apply_header);

	/* print IP Address */
	memset( buf, '\0', sizeof(buf) );
	sprintf( buf, "<input type=\"hidden\" name=\"ip\" value=\"%s\">\n\
				   <input type=\"hidden\" name=\"change\" value=\"%s\">\n\
				   <input type=\"hidden\" name=\"ap_mode\" value=\"%s\">", \
				   nvram_safe_get( "lan_ipaddr" ),
				   nvram_safe_get( "restore_defaults" ),
				   nvram_safe_get( "ap_mode" ) );
	websWrite(wp, buf);

	DanielDBG(fprintf(stderr, "APPLYMSG=<%s>\n", APPLYMSG);)
	websWrite(wp, APPLYMSG);

footer:

#ifdef DanielAdd
	if( !strcmp(value, "restore" ) )
		websWrite(wp, (char_t *) restore_footer);
	else
		websWrite(wp, (char_t *) apply_footer);
#else
	websWrite(wp, (char_t *) apply_footer);
#endif

	websFooter(wp);
	websDone(wp, 200);
	sleep(1);

	if (action == RESTART)
		sys_restart();
	else if (action == REBOOT)
		sys_reboot();

DoNoThing:
	DanielDBG(fprintf(stderr, "End of %s()...\n", __FUNCTION__);)
	return 1;
}
#ifdef WEBS

void initHandlers(void)
{
	websAspDefine("nvram_get", ej_nvram_get);
	websAspDefine("nvram_match", ej_nvram_match);
	websAspDefine("nvram_list", ej_nvram_list);
	websUrlHandlerDefine("/apply.cgi", NULL, 0, apply_cgi, 0);

#ifdef HTTP_POST_METHOD
	websUrlHandlerDefine("/sysconf.cgi", NULL, 0, apply_cgi, 0);
#endif

	websSetPassword(nvram_safe_get("http_passwd"));

#if defined(LinksysWAP54G)       || defined(LinksysWAP54G4712) || \
	defined(LinksysWAP54GJP)     || defined(LinksysWAP54GEU) || \
	defined(LinksysWAP54GEU4712) || defined(LinksysWAP54GJP4712)
	websSetRealm("Linksys WAP54G");
#else
	websSetRealm("ap11g");
#endif

}

#else /* !WEBS */

static void do_auth(char *userid, char *passwd, char *realm)
{
	strncpy(userid, nvram_safe_get("http_username"), AUTH_MAX);
	strncpy(passwd, nvram_safe_get("http_passwd"), AUTH_MAX);

#if defined(LinksysWAP54G)   || defined(LinksysWAP54G4712) || \
	defined(LinksysWAP54GJP) || defined(LinksysWAP54GEU) || \
	defined(LinksysWAP54GEU) || defined(LinksysWAP54GEU4712) || \
	defined(LinksysWAP54GJP4712)
	strncpy(realm, "Linksys WAP54G", AUTH_MAX);
#else
	strncpy(realm, "ap11g", AUTH_MAX);
#endif

}

static void do_debug_auth(char *userid, char *passwd, char *realm)
{
	strncpy(userid, "Gemtek", AUTH_MAX);
	strncpy(passwd, "gemtekswd", AUTH_MAX);
}

static void do_apply_cgi(char *url, FILE *stream)
{
	char *path, *query;

	DanielDBG(fprintf(stderr,"(%s:%d)url=<%s>\n", __FUNCTION__, __LINE__, url);)

	/* Parse path */
	query = url;
	path = strsep(&query, "?") ? : url ;

	/* Reset CGI */
	init_cgi(query);

	DanielDBG(
	fprintf(stderr,"(%s:%d)url=<%s>\t", __FUNCTION__, __LINE__, url);
	fprintf(stderr,"path=<%s>\t", path);
	fprintf(stderr,"query=<%s>\n", query);)

	apply_cgi(stream, NULL, NULL, 0, url, path, query);
}

#if defined(linux)

static void do_upgrade_post(char *url, FILE *stream, int len, char *boundary)
{
	char upload_fifo[] = "/tmp/uploadXXXXXX";
	FILE *fifo = NULL;
	char *write_argv[] = { "write", upload_fifo, "linux", NULL };
	pid_t pid;
	char buf[1024];
	int count, ret = EINVAL;
#ifdef DetectModleNumber
	int cnt = 0 ;
	char *base = NULL ;
	char *p = NULL ;
#endif

	DanielDBG(cprintf("\nurl=<%s>\n", url);)
	DanielDBG(cprintf("Content-Length=<%d>\n", len);)
	DanielDBG(cprintf("boundary=<%s>\n", boundary);)

#ifdef BCM4712APBOARD
	system("/tmp/killall_daemons");
	sleep(2);
#endif

	/* Look for our part */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto err;

		len -= strlen(buf);

		DanielDBG(cprintf("buf=<%s>\n",buf);)

		if (!strncasecmp(buf, "Content-Disposition:", 20) && strstr(buf, "name=\"file\""))
			break;
	}

	DanielDBG(cprintf("buf=<%s>\n",buf);)
	DanielDBG(cprintf("Content-Length=<%d>\n", len);)

	/* Skip boundary and headers */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto err;

		len -= strlen(buf);

		DanielDBG(cprintf("buf=<%s>\n",buf); )

		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}

	DanielDBG(cprintf("buf=<%s>\n",buf);)
	DanielDBG(cprintf("Content-Length=<%d>\n", len);)

	/* Feed write from a temporary FIFO */
	if (!mktemp(upload_fifo) ||
		mkfifo(upload_fifo, S_IRWXU) < 0 ||
		_eval(write_argv, NULL, 0, &pid) ||
		!(fifo = fopen(upload_fifo, "w")))
		goto err;

	/* Set nonblock on the socket so we can timeout */
	if (fcntl(fileno(stream), F_SETFL, O_NONBLOCK) < 0)
		goto err;

#ifdef DetectModleNumber
	p = nvram_safe_get( "chk_fw_hdr" );
#endif

	/* Pipe the rest to the FIFO */
	cprintf("Upgrading\n");
	while (len > 0)
	{
		if (waitfor(fileno(stream), 5) <= 0)	/* waitfor() in src/router/shared/shutils.c */
			break;

		count = fread(buf, 1, MIN(len, sizeof(buf)), stream);
		len -= count;
#ifdef DetectModleNumber
		if( cnt == 0 && !strcmp( p, "Enabled" ) )
		{
			DanielDBG(fprintf(stderr,"count=%d, ", count);)
			DanielDBG(fprintf(stderr,"len=%d\n", len);)
			if( memcmp( ModleNumber, buf, sizeof(ModleNumber) ) )
			{
				fprintf( stderr, "Modle Number is not matched.\n" );
				goto my_err ;
			}

			base = &buf[sizeof(ModleNumber)] ;
			fwrite( base, 1, count-sizeof(ModleNumber), fifo );
			cnt++ ;
			DanielDBG(fprintf(stderr, "count-sizeof(ModleNumber)=%d\n", count-sizeof(ModleNumber));)
		}
		else
		{
			fwrite(buf, 1, count, fifo);
		}
#else
		fwrite(buf, 1, count, fifo);
#endif
		cprintf(".");
	}

my_err:
	fclose(fifo);
	fifo = NULL;
	cprintf("done\n");

	DanielDBG(cprintf("(%s:%d)ret=<%XH>, ", __FUNCTION__, __LINE__, ret );)
	DanielDBG(cprintf("pid=<%XH>\n", pid );)

	/* Wait for write to terminate */
	waitpid(pid, &ret, 0);

	DanielDBG(cprintf("(%s:%d)ret=<%XH>\n", __FUNCTION__, __LINE__, ret );)

	/* Reset nonblock on the socket */
	if (fcntl(fileno(stream), F_SETFL, 0) < 0)
	{
		DanielDBG(cprintf("goto err\n");)
		goto err;
	}

	/* Slurp anything remaining in the request */
	while (len-- > 0)
		(void) fgetc(stream);

err:
	if (fifo)
		fclose(fifo);

	DanielDBG(cprintf("unlink(upload_fifo)\n");)
	unlink(upload_fifo);

	DanielDBG(cprintf("(%s:%d)ret=<%d>\n", __FUNCTION__, __LINE__, ret );)
	fcntl(fileno(stream), F_SETOWN, -ret);
}

static void do_upgrade_cgi(char *url, FILE *stream)
{
	int ret;
	char buf[1024] ;

	websHeader(stream);
	websWrite(stream, (char_t *) apply_header);
	//websWrite(stream, (char_t *) upgrade_header);

	ret = fcntl(fileno(stream), F_GETOWN, 0);
	DanielDBG(cprintf("(%s:%d)ret=<%d>\n", __FUNCTION__, __LINE__, ret );)

	memset( buf, '\0', sizeof(buf) );
	sprintf( buf, "<input type=\"hidden\" name=\"ip\" value=\"%s\">\n\
				   <input type=\"hidden\" name=\"change\" value=\"%s\">\n\
				   <input type=\"hidden\" name=\"ap_mode\" value=\"%s\">", \
				   nvram_safe_get( "wan_ipaddr" ),
				   nvram_safe_get( "restore_defaults" ),
				   nvram_safe_get( "ap_mode" ) );
	websWrite(stream, buf);

	/* We could probably be more informative here... */
	if( ret )
	{
#ifdef DetectModleNumber
		DanielDBG(cprintf("(%s:%d)ret=<%xH>\n", __FUNCTION__, __LINE__, ret );)
		if( ret == -65280 )
			websWrite(stream, ""WRONGFIRMWARE"<br>");
#ifdef DetectDownGrade
		else if( ret == -65024 )
			websWrite(stream, ""CANNOTDOWNGRADEFIRMWARE"<br>");
#endif /* DetectDownGrade */
		else
			websWrite(stream, ""ERRORFIRMWARE"<br>");
#else /* !DetectModleNumber */
#ifdef DetectDownGrade
		if( ret == -65024 )
			websWrite(stream, ""CANNOTDOWNGRADEFIRMWARE"<br>");
		else
			websWrite(stream, ""ERRORFIRMWARE"<br>");
#else /* !DetectDownGrade */
		websWrite(stream, ""ERRORFIRMWARE"<br>");
#endif /* DetectDownGrade */
#endif /* DetectModleNumber */
	}
	else
	{
		websWrite(stream, "<center>"UPGRADECOMPLETE"</center><br>");
	}

	DanielDBG(cprintf("(%s:%d)ret=<%d>\n", __FUNCTION__, __LINE__, ret );)

	//websWrite(stream, (char_t *) upgrade_footer);
	websWrite(stream, (char_t *) apply_footer);
	websFooter(stream);
	websDone(stream, 200);

	/* Reboot if successful */
	if (ret == 0)
	{
		DanielDBG(cprintf("(%s:%d)System Reboot!!!\n", __FUNCTION__, __LINE__ );)
		sys_reboot();
	}
}

#ifdef DanielAdd
#ifdef BACKUP_RESTORE
static void do_restore_post(char *url, FILE *stream, int len, char *boundary)
{
	char upload_fifo[] = "/tmp/restoreXXXXXX";
	FILE *fifo = NULL;
	char buf[1024];
	int count ;
	char *base = NULL ;
	char *restore_argv[7] ;
	pid_t pid ;
	int ret, cnt = 0 ;
	int restore_ret = EINVAL;

	/* Look for our part */
	DanielDBG( cprintf("Look for our part\n"); )
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
		{
			DanielDBG(cprintf("fgets error(%d)!!!\n", __LINE__);)
			goto restore_err;
		}

		len -= strlen(buf);

		if (!strncasecmp(buf, "Content-Disposition:", 20) && strstr(buf, "name=\"file\""))
			break;
	}

	DanielDBG(cprintf("buf=<%s>\n",buf);)
	DanielDBG(cprintf("Content-Length=<%d>\n", len);)

	/* Skip boundary and headers */
	DanielDBG( cprintf("Skip boundary and headers\n"); )
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
		{
			DanielDBG(cprintf("fgets error(%d)!!!\n", __LINE__);)
			goto restore_err;
		}

		len -= strlen(buf);

		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}

	DanielDBG(cprintf("buf=<%s>\n",buf);)
	DanielDBG(cprintf("Content-Length=<%d>\n", len);)

	/* Feed write from a temporary FIFO */
	DanielDBG( cprintf("Feed write from a temporary FIFO\n"); )
	if (!mktemp(upload_fifo) ||	!(fifo = fopen(upload_fifo, "w")))
	{
		DanielDBG(cprintf("mktemp and fopen error(%d)!!!\n", __LINE__);)
		goto restore_err;
	}

	/* Set nonblock on the socket so we can timeout */
	DanielDBG( cprintf("Set nonblock on the socket so we can timeout\n"); )
	if (fcntl(fileno(stream), F_SETFL, O_NONBLOCK) < 0)
	{
		DanielDBG(cprintf("fcntl error(%d)!!!\n", __LINE__);)
		goto restore_err;
	}

	/* Pipe the rest to the FIFO */
	cprintf("Upgrading\n");
	while (len > 0)
	{
#if 0
		if (waitfor(fileno(stream), 5) <= 0)
			break;
#endif
		count = fread(buf, 1, MIN(len, sizeof(buf)), stream);
		len -= count;
		DanielDBG(cprintf("len=%d\n", len);)

		if( cnt == 0 )
		{   /* check restore header */
			if( memcmp( ModleNumber, buf, sizeof(ModleNumber) ) )
			{
				DanielDBG(cprintf("ModleNumber is not matched.\n");)
				cnt++ ;
				goto wrong_restore_hdr ;
			}
			else
			{
				if( memcmp(RESTOREFILE, &buf[sizeof(ModleNumber)], sizeof(RESTOREFILE)) )
					goto wrong_restore_hdr ;

				fwrite( &buf[sizeof(ModleNumber)+sizeof(RESTOREFILE)], 1,
				        count-sizeof(ModleNumber)-sizeof(RESTOREFILE), fifo );
				cprintf(".");
				cnt++ ;
			}
		}
		else
		{
			base = strstr(buf, "\r\n" );
			if( base != NULL )
			{
				fwrite(buf, 1, &base[0]-&buf[0], fifo);
				cprintf(".\n");
				DanielDBG(cprintf("test\n");)
				break ;
			}
			else
			{
				fwrite(buf, 1, count, fifo);
				cprintf(".");
			}
		}
	}

	fclose(fifo);
	fifo = NULL;
	cprintf("done\n");

	restore_argv[0] = "restore" ;
	restore_argv[1] = upload_fifo ;
	restore_argv[2] = "2" ;
	restore_argv[3] = "/tmp/config.txt" ;
	restore_argv[4] = "/tmp/restore_test" ;
#if defined(WX5520G) || defined(WX5520G4712)
	restore_argv[5] = "WX5520G" ;
#elif defined(BeWANAP54) || defined(BeWANAP544712)
	restore_argv[5] = "BeWANAP54" ;
#else
	restore_argv[5] = "linksyswap11" ;
#endif
	restore_argv[6] = NULL ;

	ret = _eval( restore_argv, NULL, 0, &pid);
	waitpid(pid, &ret, WUNTRACED);
	restore_ret = 0 ;

wrong_restore_hdr:
	/* Reset nonblock on the socket */
	DanielDBG(cprintf("Reset nonblock on the socket\n");)
	if (fcntl(fileno(stream), F_SETFL, 0) < 0)
	{
		DanielDBG(cprintf("fcntl error !!!(%d)\n", __LINE__);)
		goto restore_err;
	}

	/* Slurp anything remaining in the request */
	while (len-- > 0)
		(void) fgetc(stream);

restore_err:
	if(fifo)
		fclose(fifo);

	DanielDBG(cprintf("delete upload file.\n"); )
	unlink(upload_fifo);

	fcntl(fileno(stream), F_SETOWN, -restore_ret);
	DanielDBG(cprintf("(%s:%d)restore_ret=<%d>\n", __FUNCTION__, __LINE__, restore_ret );)
	DanielDBG(cprintf("End of %s();\n", __FUNCTION__);)
}

static void do_restore_cgi(char *url, FILE *stream)
{
	int ret ;

	DanielDBG(cprintf("%s();\n", __FUNCTION__);)
	ret = fcntl(fileno(stream), F_GETOWN, 0);
	DanielDBG(cprintf("(%s:%d)ret=<%d>\n", __FUNCTION__, __LINE__, ret );)

	websHeader(stream);
	if( ret == -1 )
	{	/* wrong header */
		websWrite(stream, (char_t *) RestoreErrorPage);
	}
	else
	{
		ret = start_restore_settings(stream) ;

		/* Reboot if successful */
		if( ret == 0 )
		{
			GTK_convert_nvram_parameter();
			nvram_commit();
			sleep(5);
			websWrite(stream, (char_t *) RestoreOKPage);
			DanielDBG(cprintf("(%s:%d)System Reboot!!!\n", __FUNCTION__, __LINE__ );)
			sys_reboot();
		}
		else
		{
			websWrite(stream, (char_t *) RestoreErrorPage);
		}
	}

	websFooter(stream);
	websDone(stream, 200);

	DanielDBG(cprintf("End of %s()...\n", __FUNCTION__);)
}
#endif /* end of BACKUP_RESTORE */
#ifdef HTTP_POST_METHOD
static void do_sysconf_post(char *url, FILE *stream, int len, char *boundary)
{
	char buf[1024], temp[1024];
	char *p, *foot, *b ;
	char *name, *value ;
	int count = 0 ;
#ifdef DectectSpecialCharacters
	struct special_character *sc ;
#endif

	foot = p = b =  NULL ;
	name = value = NULL ;

	DanielDBG(cprintf("%s()...\n", __FUNCTION__);)
	DanielDBG(fprintf(stderr, "url=<%s> ", url);)
	DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
	DanielDBG(fprintf(stderr, "boundary=<%s>\n", boundary);)

	memset( query_string, '\0', sizeof(query_string) );
	strcpy( query_string, "apply.cgi?" );

	/* get boundary */
	b = boundary ;
	while( *b == '-' )
		b++ ;
	DanielDBG(fprintf(stderr, "b=<%s>\n", b );)

	while (len > 0)
	{
		memset( buf, '\0', sizeof(buf) );
		memset( temp, '\0', sizeof(temp) );

		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
		{
			cprintf("fgets error!!!\n");
			continue ;
		}

		len -= strlen(buf);

		/* 1. skip boundary */
		p = strstr( buf, b ) ;
		if( p != NULL )
			continue ;

		/* 2. get name */
		if( !strncasecmp(buf, "Content-Disposition:", 20) )
		{
			count = 0 ;
			name = strchr( buf, '"' );
			name++ ;
			foot = strchr( name, '"' );
			if( foot != NULL )
				*foot = 0x00 ;
			sprintf( temp, "%s=", name );
			strcat( query_string, temp );
			DanielDBG(cprintf("name=<%s>\t\t", name);)
			count++ ;

#ifdef DectectSpecialCharacters
			for( sc=special_character_name_table ; sc->name ; sc++ )
			{
				if( !strcmp(name, sc->name) )
				{
					sc->flag = 1 ;
					DanielDBG(fprintf( stderr, "special_name=<%s>\t", name );)
					break ;
				}
			}
#endif
			continue ;
		}

		/* 3. skip \r\n or \n */
		if( (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))&&(count != 2) )
		{
			count++ ;
			continue ;
		}

		/* 4. get value of name */
		value = buf ;
		foot = strstr( buf, "\r\n" );
		if( foot != NULL )
		{
			*foot = 0x00 ;
			sprintf( temp, "%s&", value );

#ifdef DectectSpecialCharacters
			for( sc=special_character_name_table ; sc->name ; sc++ )
			{
				if( sc->flag == 1 )
				{
#ifdef CheckParameterStatus
					start_check_parameters( sc->name, value, "do_sysconf_post" );
#endif /* CheckParameterStatus */
					if(!(strcmp(sc->name,"wl_ssid")==0 && strcmp(value,"GenKeyWEP")==0)) // Vic Yu added
						nvram_set( sc->name, value );

					// Set WPA-PSK value , reason is ASCII character check issue .
					if(strcmp(sc->name,"GTK_wl_wpa_psk")==0)
						nvram_set( "wl_wpa_psk", value );
					sc->flag = 0 ;
				}
			}
#endif /* DectectSpecialCharacters */
		}
		else
		{
			sprintf( temp, "%s", "&" );
		}

	/* chaeck if value is equal to boundary ? */
		if( !strcmp( value, b ) )
			memset( temp, '\0', sizeof(temp) );

		DanielDBG(cprintf("value=<%s>\n", value);)

		strcat( query_string, temp );
	}

	query_string[strlen(query_string)-1] = '\0' ; /* delete '&' */

	DanielDBG(fprintf(stderr, "(%s:%d)len=<%d>\n", __FUNCTION__, __LINE__, len );)
#ifdef LinuxMozillaBug
	DanielDBG(
	cprintf("compare user_agent is equal to Linux ?\n");
	cprintf("user_agent=<%s>\n", user_agent );)

	if( !strcmp( user_agent, "Linux" ) )
	{
		do_sysconf_cgi(url, stream) ;
		return ;
	}
#endif

	/* Slurp anything remaining in the request */
	while( len-- > 0 )
		(void) fgetc(stream);

	DanielDBG(cprintf("query_string=<%s>\n", query_string);)
	DanielDBG(cprintf("End of %s()...\n", __FUNCTION__);)
}
static void do_sysconf_cgi(char *url, FILE *stream)
{
	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)
	DanielDBG(fprintf(stderr, "url=<%s>\n", url);)

	do_apply_cgi(query_string, stream);
}
#endif /* end of HTTP_POST_METHOD */

#ifdef UpgradePmon
static void do_pmon_post(char *url, FILE *stream, int len, char *boundary)
{
	char upload_fifo[] = "/tmp/uploadXXXXXX";
	FILE *fifo = NULL;
	char *write_argv[] = { "write", upload_fifo, "pmon", NULL };
	pid_t pid;
	char buf[1024];
	int count, ret = EINVAL;

	/* Look for our part */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto err;

		len -= strlen(buf);

		if (!strncasecmp(buf, "Content-Disposition:", 20) && strstr(buf, "name=\"file\""))
			break;
	}

	/* Skip boundary and headers */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto err;

		len -= strlen(buf);

		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}

	/* Feed write from a temporary FIFO */
	if (!mktemp(upload_fifo) ||
		mkfifo(upload_fifo, S_IRWXU) < 0 ||
		_eval(write_argv, NULL, 0, &pid) ||
		!(fifo = fopen(upload_fifo, "w")))
		goto err;

	/* Set nonblock on the socket so we can timeout */
	if (fcntl(fileno(stream), F_SETFL, O_NONBLOCK) < 0)
		goto err;

	/* Pipe the rest to the FIFO */
	cprintf("Upgrading");
	while (len > 0)
	{
		if (waitfor(fileno(stream), 5) <= 0)	/* waitfor() in src/router/shared/shutils.c */
			break;

		count = fread(buf, 1, MIN(len, sizeof(buf)), stream);
		len -= count;
		fwrite(buf, 1, count, fifo);
		cprintf(".");
	}

	fclose(fifo);
	fifo = NULL;
	cprintf("done\n");

	/* Wait for write to terminate */
	waitpid(pid, &ret, 0);

	/* Reset nonblock on the socket */
	if (fcntl(fileno(stream), F_SETFL, 0) < 0)
	{
		DanielDBG(cprintf("goto err\n");)
		goto err;
	}

	/* Slurp anything remaining in the request */
	while (len-- > 0)
		(void) fgetc(stream);

 err:
	if (fifo)
		fclose(fifo);

	//unlink(upload_fifo);

	fcntl(fileno(stream), F_SETOWN, -ret);
}
static void do_pmon_cgi(char *url, FILE *stream)
{
	int ret;

	ret = fcntl(fileno(stream), F_GETOWN, 0);

	websHeader(stream);
	websWrite(stream, (char_t *) upgrade_header);

	/* We could probably be more informative here... */
	if( ret )
	{
		websWrite(stream, "Error during upgrade<br>");
	}
	else
	{
		websWrite(stream, "<center>Upgrade complete</center><br>");
	}

	websWrite(stream, (char_t *) upgrade_footer);
	websFooter(stream);
	websDone(stream, 200);

	/* Reboot if successful */
	if (ret == 0)
		sys_reboot();

}
#endif /* end of UpgradePmon */

#ifdef MakeWwwPartition
static void change_working_dir(void)
{
	FILE *p_fp = NULL ;
	char buf[1024] ;

	p_fp = popen( "/bin/cat /tmp/var/run/httpd.pid", "r" );
	if( p_fp == NULL )
	{
		fprintf( stderr, "popen /bin/cat /tmp/var/run/httpd.pid error\n" );
		return -1 ;
	}

	memset( buf, '\0', sizeof(buf) );
	fgets( buf, sizeof(buf), p_fp );

	kill( atoi(buf), SIGUSR1 );

	pclose(p_fp);
}
static void do_www_post(char *url, FILE *stream, int len, char *boundary)
{
	char upload_fifo[] = "/tmp/uploadXXXXXX";
	FILE *fifo = NULL;
	char *write_argv[] = { "write", upload_fifo, "www", NULL };
	pid_t pid;
	char buf[1024];
	int count, ret = EINVAL;
	long flags = -1;
	char len_buf[20]; //test

	DanielDBG(fprintf(stderr, "change_working_dir() ;\n");)
	change_working_dir() ;

	DanielDBG(getcwd(buf, sizeof(buf));)
	DanielDBG(fprintf(stderr, "getcwd=<%s>\n", buf);)
	DanielDBG(memset(buf, '\0', sizeof(buf));)
	DanielDBG(fprintf(stderr, "/* umount www partition */\n");)
	/* umount www partition */
	system( "/tmp/umount_www_partition" );

	DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
	DanielDBG(fprintf(stderr, "/* Look for our part */\n" );)
	/* Look for our part */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto www_err;

		len -= strlen(buf);
		DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
		DanielDBG(fprintf(stderr, "buf=<%s>\n", buf);)

		if (!strncasecmp(buf, "Content-Disposition:", 20) && strstr(buf, "name=\"file\""))
			break;
	}

	DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
	DanielDBG(fprintf(stderr, "/* Skip boundary and headers */\n" );)
	/* Skip boundary and headers */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto www_err;

		len -= strlen(buf);
		DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
		DanielDBG(fprintf(stderr, "buf=<%s>\n", buf);)

		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}

	memset(len_buf, '\0', sizeof(len_buf) );
	sprintf( len_buf, "/bin/echo %d >/tmp/len", len-48 );
	system( len_buf );

	/* Feed write from a temporary FIFO */
	if (!mktemp(upload_fifo) ||
		mkfifo(upload_fifo, S_IRWXU) < 0 ||
		_eval(write_argv, NULL, 0, &pid) ||
		!(fifo = fopen(upload_fifo, "w")))
	{
		goto www_err;
	}

	DanielDBG(fprintf(stderr, "/* Set nonblock on the socket so we can timeout */\n");)
	/* Set nonblock on the socket so we can timeout */
	if ((flags = fcntl(fileno(stream), F_GETFL)) < 0 ||
	    fcntl(fileno(stream), F_SETFL, flags | O_NONBLOCK) < 0)
	{
		goto www_err;
	}

	/* Pipe the rest to the FIFO */
	cprintf("Upgrading");
	while (len > 0)
	{
		if (waitfor(fileno(stream), 5) <= 0)	/* waitfor() in src/router/shared/shutils.c */
			break;

		count = fread(buf, 1, MIN(len, sizeof(buf)), stream);

		len -= count;
		fwrite(buf, 1, count, fifo);
		cprintf(".");
	}

	fclose(fifo);
	fifo = NULL;
	cprintf("done\n");

	/* Wait for write to terminate */
	waitpid(pid, &ret, 0);

	/* Reset nonblock on the socket */
	if (fcntl(fileno(stream), F_SETFL, 0) < 0)
	{
		DanielDBG(cprintf("goto www_err\n");)
		goto www_err;
	}

	/* Slurp anything remaining in the request */
	while (len-- > 0)
		(void) fgetc(stream);

 www_err:
	if (fifo)
		fclose(fifo);

	unlink(upload_fifo);

	fcntl(fileno(stream), F_SETOWN, -ret);
}
static void do_www_cgi(char *url, FILE *stream)
{
	int ret;

	ret = fcntl(fileno(stream), F_GETOWN, 0);

	websHeader(stream);
	websWrite(stream, (char_t *) upgrade_header);

	/* We could probably be more informative here... */
	if( ret )
		websWrite(stream, "Error during upgrade<br>");
	else
		websWrite(stream, "<center>Upgrade complete</center><br>");

	websWrite(stream, (char_t *) upgrade_footer);
	websFooter(stream);
	websDone(stream, 200);

	DanielDBG(fprintf(stderr, "/* mount www partition / */\n");)
	/* mount www partition */
	system( "/bin/mount -t cramfs /dev/mtdblock/3 /www" );

	DanielDBG(fprintf(stderr, "/* change working directory */\n");)
	/* change working directory */
	chdir( "/www" );
#if 0
	/* Reboot if successful */
	if (ret == 0)
		sys_reboot();
#endif
}
static void do_all_post(char *url, FILE *stream, int len, char *boundary)
{
	char upload_fifo[] = "/tmp/uploadXXXXXX";
	FILE *fifo = NULL;
	char *write_argv[] = { "write", upload_fifo, "linuxwww", NULL };
	pid_t pid;
	char buf[1024];
	int count, ret = EINVAL;
	long flags = -1;

	DanielDBG(fprintf(stderr, "change_working_dir() ;\n");)
	change_working_dir() ;

	/* umount www partition */
	system( "/tmp/umount_www_partition" );

	DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
	DanielDBG(fprintf(stderr, "/* Look for our part */\n" );)
	/* Look for our part */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto all_err;

		len -= strlen(buf);
		DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
		DanielDBG(fprintf(stderr, "buf=<%s>\n", buf);)

		if (!strncasecmp(buf, "Content-Disposition:", 20) && strstr(buf, "name=\"file\""))
			break;
	}

	DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
	DanielDBG(fprintf(stderr, "/* Skip boundary and headers */\n" );)
	/* Skip boundary and headers */
	while (len > 0)
	{
		if (!fgets(buf, MIN(len + 1, sizeof(buf)), stream))
			goto all_err;

		len -= strlen(buf);
		DanielDBG(fprintf(stderr, "len=<%d>\n", len);)
		DanielDBG(fprintf(stderr, "buf=<%s>\n", buf);)

		if (!strcmp(buf, "\n") || !strcmp(buf, "\r\n"))
			break;
	}


	/* Feed write from a temporary FIFO */
	if (!mktemp(upload_fifo) ||
		mkfifo(upload_fifo, S_IRWXU) < 0 ||
		_eval(write_argv, NULL, 0, &pid) ||
		!(fifo = fopen(upload_fifo, "w")))
	{
		goto all_err;
	}

	DanielDBG(fprintf(stderr, "/* Set nonblock on the socket so we can timeout */\n");)
	/* Set nonblock on the socket so we can timeout */
	if ((flags = fcntl(fileno(stream), F_GETFL)) < 0 ||
	    fcntl(fileno(stream), F_SETFL, flags | O_NONBLOCK) < 0)
	{
		goto all_err;
	}

	/* Pipe the rest to the FIFO */
	cprintf("Upgrading");
	while (len > 0)
	{
		if (waitfor(fileno(stream), 5) <= 0)	/* waitfor() in src/router/shared/shutils.c */
			break;

		count = fread(buf, 1, MIN(len, sizeof(buf)), stream);

		len -= count;
		fwrite(buf, 1, count, fifo);
		cprintf(".");
	}

	fclose(fifo);
	fifo = NULL;
	cprintf("done\n");

	/* Wait for write to terminate */
	waitpid(pid, &ret, 0);

	/* Reset nonblock on the socket */
	if (fcntl(fileno(stream), F_SETFL, 0) < 0)
	{
		DanielDBG(cprintf("goto www_err\n");)
		goto all_err;
	}

	/* Slurp anything remaining in the request */
	while (len-- > 0)
		(void) fgetc(stream);

 all_err:
	if (fifo)
		fclose(fifo);

	unlink(upload_fifo);

	fcntl(fileno(stream), F_SETOWN, -ret);
}
static void do_all_cgi(char *url, FILE *stream)
{
	int ret;

	ret = fcntl(fileno(stream), F_GETOWN, 0);

	websHeader(stream);
	websWrite(stream, (char_t *) upgrade_header);

	/* We could probably be more informative here... */
	if( ret )
		websWrite(stream, "Error during upgrade<br>");
	else
		websWrite(stream, "<center>Upgrade complete</center><br>");

	websWrite(stream, (char_t *) upgrade_footer);
	websFooter(stream);
	websDone(stream, 200);

	DanielDBG(fprintf(stderr, "/* mount www partition / */\n");)
	/* mount www partition */
	system( "/bin/mount -t cramfs /dev/mtdblock/3 /www" );

	DanielDBG(fprintf(stderr, "/* change working directory */\n");)
	/* change working directory */
	chdir( "/www" );
#if 0
	/* Reboot if successful */
	if (ret == 0)
		sys_reboot();
#endif
}
#endif /* end of MakeWwwPartition */

#endif /* end of DanielAdd */

#elif defined(vxworks)

static void do_upgrade_post(char *url, FILE *stream, int len, char *boundary)
{
}

static void do_upgrade_cgi(char *url, FILE *stream)
{
}

#endif

// +++ Added by Vic Yu for debug page

#define DEBUG_CGI_STR_SIZE 9216
char debug_cgi_buf[DEBUG_CGI_STR_SIZE];
#define DebugCGIString "debug.cgi?"

char *ui_debug_header=
"<html lang=\"en\">\n"
"<head>\n"
"<title>Debug Result</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n"
"</head>\n"
"<body bgcolor=\"#BBBBBB\">\n"
"<center>\n"
"<p>\n"
"<form method=\"post\" action=\"debug.cgi\">\n"
"<p>\n"
"<table border=0 cellspacing=0 cellpadding=0 width=720 height=\"550\">\n"
"<tr bgcolor=\"#BBBBBB\">\n"
"<th valign=\"top\" height=100%%>\n"
"<font size=4 face=\"Tahoma, Arial\">\n"
"<textarea rows=30 cols=100>\n"
;

char *ui_debug_footer=
"</textarea>\n"
"<br>\n"
"<input type=\"text\" name=\"data1\" size=\"40\" value="">\n"
"<input type=\"hidden\" name=\"command\" value=\"ui_debug\">\n"
"<input type=\"button\" name=\"action\" value=\"Debug\" OnClick=\"document.forms[0].submit();\">\n"
"&nbsp;&nbsp;&nbsp;&nbsp;\n"
"<input type=\"button\" name=\"action\" value=\"Back to index.asp\" OnClick=\"window.location.href = 'index.asp';\">\n"
"</font>\n"
"</th>\n"
"</tr>\n"
"</table>\n"
"</form>\n"
"</center>\n"
"</body>\n"
"</html>\n"
;


void cgi_cmd_ui_debug(webs_t wp, char_t *urlPrefix, char_t *webDir, int arg, char_t *url, char_t *path, char_t *query)
{
	//fprintf(stderr, "CGI : cgi_cmd_ui_debug()\n");

	/* Add by Terence for Debug Page */
	FILE *fp = NULL ;
	char buf[1024];
	char temp[50];
	int count = 0;

	websWrite(wp, (char_t *) ui_debug_header);

	if(!strcmp(websGetVar(wp, "data1", ""), ""))
	{
		websWrite(wp, "cmd : command error\n");
	}
	else
	{
		if(!strcmp(websGetVar(wp, "data2", ""), ""))
		{
			sprintf(temp, "/tmp/network_diag");
		}
		else
		{
			sprintf(temp, "/tmp/%s", websGetVar(wp, "data2", ""));
		}

		sprintf(buf, "/usr/bin/killall %s", websGetVar(wp, "data3", ""));
		//printf("%s\n", buf);
		system(buf);

		sprintf(buf, "%s > %s", websGetVar(wp, "data1", ""), temp);
		system(buf);

		fp = fopen(temp, "r") ;

		if( fp == NULL )
		{
			return;
		}

		while(fgets( buf, sizeof(buf), fp ))
		{
			count++;
			websWrite(wp, buf);
			//websWrite(wp, "\n");
		}

		if(count == 0)
		{
			//websWrite(wp, "\n");
		}

		fclose(fp);
	}

	websWrite(wp, (char_t *) ui_debug_footer);
	websDone(wp, 200);
}

static void
do_debug_post ( char *url , FILE *stream , int len , char *boundary )
{
	char buf[DEBUG_CGI_STR_SIZE];

	//CGI_DBG(fprintf(stderr, "CGI : in do_post_post...\n");)

	/* Look for our part */
	while ( len > 0 ) {
		if ( !fgets ( buf , MIN ( len + 1 , sizeof ( buf ) ) , stream ) ) { return; }

		len -= strlen ( buf );

		if ( !strncasecmp ( buf , "Content-Disposition:" , 20 ) &&
		     strstr ( buf , "name=\"file\"" ) ) { break; }
	}

	/* Skip boundary and headers */
	while ( len > 0 ) {
		if ( !fgets ( buf , MIN ( len + 1 , sizeof ( buf ) ) , stream ) ) { return; }

		len -= strlen ( buf );

		if ( !strcmp ( buf , "\n" ) || !strcmp ( buf , "\r\n" ) ) { break; }
	}

	strcpy(debug_cgi_buf, buf);

	/* Slurp anything remaining in the request */
	while (len--)
		(void) fgetc(stream);
}

static void
do_debug_cgi ( char *url , FILE *stream )
{
	char *path = NULL , *query = NULL , *TempUrl = NULL;
	int StrSize = 0;

	/* create a get method string */
 	StrSize = strlen ( DebugCGIString ) + strlen ( debug_cgi_buf ) + 1;

 	TempUrl = (char*) malloc ( sizeof ( char ) * StrSize );

 	memset ( TempUrl , '\0' , StrSize );

 	TempUrl = strcat ( TempUrl , DebugCGIString );
 	TempUrl = strcat ( TempUrl , debug_cgi_buf );

 	query = TempUrl;
 	path = strsep ( &query , "?" ) ? : TempUrl;

 	init_cgi(query);

 	cgi_cmd_ui_debug(stream, NULL, NULL, 0, TempUrl, path, query);
 	//post_cgi_redirect(stream, NULL, NULL, 0, TempUrl, path, query);

 	free ( TempUrl );
}

// - - - Added by Vic Yu for debug page


static char no_cache[] =
"Cache-Control: no-cache\r\n"
"Pragma: no-cache\r\n"
"Expires: 0"
;

struct mime_handler mime_handlers[] =
{
	{ "Debug_command_page.asp", "text/html", no_cache, NULL, do_ej, do_debug_auth },
	{ "**.asp", "text/html", no_cache, NULL, do_ej, do_auth },
	{ "**.css", "text/css", no_cache, NULL, do_file, do_auth },
	//{ "**.gif", "image/gif", no_cache, NULL, do_file, do_auth },
	{ "**.gif", "application/zip", no_cache, NULL, do_file, do_auth },
	{ "**.jpg", "image/jpeg", no_cache, NULL, do_file, do_auth },
	{ "**.js", "text/javascript", no_cache, NULL, do_file, do_auth },
	{ "apply.cgi*", "text/html", no_cache, NULL, do_apply_cgi, do_auth },
	{ "upgrade.cgi*", "text/html", no_cache, do_upgrade_post, do_upgrade_cgi, do_auth },
#ifdef DanielAdd
	//{ "**.bin", "octet/stream", NULL, NULL, do_file, do_auth },
	{ "**.bin", "application/zip", AcceptRange, NULL, do_file, do_auth },
#ifdef BACKUP_RESTORE
	{ "restore.cgi*", "text/html", no_cache, do_restore_post, do_restore_cgi, do_auth },
#endif /* end of BACKUP_RESTORE */
#else
	{ "**.bin", "application/octet-stream", NULL, NULL, do_file, do_auth },
#endif
#ifdef HTTP_POST_METHOD
	{ "sysconf.cgi*", "text/html", no_cache, do_sysconf_post, do_sysconf_cgi, do_auth },
#endif
#ifdef UpgradePmon
	{ "pmon.cgi*", "text/html", no_cache, do_pmon_post, do_pmon_cgi, do_auth },
#endif
#ifdef MakeWwwPartition
	{ "www.cgi*", "text/html", no_cache, do_www_post, do_www_cgi, do_auth },
	{ "all.cgi*", "text/html", no_cache, do_all_post, do_all_cgi, do_auth },
#endif
#ifdef DOTEST
	{ "test.cgi*", "text/html", no_cache, do_test_post, do_test_cgi, do_auth },
#endif
	{ "debug.cgi*", "text/html", no_cache, do_debug_post, do_debug_cgi, do_debug_auth },	// Added by Vic Yu , for debug page
	{ NULL, NULL, NULL, NULL, NULL, NULL }
};
static int ej_APFirmwareVersion ( int eid , webs_t wp , int argc , char_t **argv )
{
	websWrite ( wp , "%s" , FirmwareVersion );

	return 0;
}
static int ej_SubAPFirmwareVersion ( int eid , webs_t wp , int argc , char_t **argv )
{
	websWrite ( wp , "%s" , SubFirmwareVersion );

	return 0;
}
static int ej_MyFirmwareVersion ( int eid , webs_t wp , int argc , char_t **argv )
{
#if defined(WX5520G) || defined(WX5520G4712)
	websWrite ( wp , "%s" , nvram_safe_get("MyFirmwareVersion") );
#else /* !WX5520G */
	websWrite ( wp , "%s" , MyFirmwareVersion );
#endif /* end of WX5520G */

	return 0;
}
static int GeneratePassPhraseKey()
{
	unsigned char	output_1[13];
	unsigned char	output_2[4][5];
	unsigned int	i = 0;
	unsigned int	j = 0;
	char key_buf[100] ;
	char temp[10] ;

	DanielDBG(fprintf(stderr, "wl_passphrase=<%s>\n", nvram_get("wl_passphrase") );)

	if( strlen(nvram_get("wl_passphrase")) != 0 )
	{
		if( !strcmp( nvram_get( "PassphraseKeyLength" ), "1" ) )
		{	/* 64 bits */
			for ( j = 0 ; j < 4 ; j++ )
			{
				memset( output_2, '\0', sizeof(output_2) );
				Get64bitkey(nvram_get("wl_passphrase") , output_2);
				memset( key_buf, '\0', sizeof(key_buf) );
				memset( temp, '\0', sizeof(temp) );

				for ( i = 0 ; i < 5 ; i++ )
				{
					sprintf( temp, "%02X",output_2[j][i]);
					strcat( key_buf, temp );
				}

				DanielDBG(fprintf(stderr, "key_buf(64 bits)=<%s>\n", key_buf );)
				memset( temp, '\0', sizeof(temp) );
				sprintf( temp, "wl_key%d", j+1 ) ;
				nvram_set( temp, key_buf );
			}
		}
		else
		{	/* 128 bits */
			Get128bitkey( nvram_get("wl_passphrase") , output_1 );
			memset( key_buf, '\0', sizeof(key_buf) );
			memset( temp, '\0', sizeof(temp) );

			for ( i = 0 ; i < 13 ; i++ )
			{
				sprintf( temp, "%02X",output_1[i]);
				strcat( key_buf, temp );
			}

			DanielDBG(fprintf(stderr, "key_buf(128 bits)=<%s>\n", key_buf );)
			nvram_set( "wl_key1", key_buf );
#if 1
			nvram_set( "wl_key2", "" );
			nvram_set( "wl_key3", "" );
			nvram_set( "wl_key4", "" );
#else
			nvram_set( "wl_key2", key_buf );
			nvram_set( "wl_key3", key_buf );
			nvram_set( "wl_key4", key_buf );
#endif
		}
	}

	return 0 ;
}
static int ej_GetKey ( int eid , webs_t wp , int argc , char_t **argv )
{
	unsigned char	output_1[13];
	unsigned char	output_2[4][5];
	unsigned int	i = 0;
	char *key_index ;
	int  index ;

	if( ejArgs(argc, argv, "%s", &key_index ) < 1 )
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	index = atoi(key_index) - 1 ;

	DanielDBG(fprintf(stderr, "wl_passphrase=<%s>\n", nvram_get("wl_passphrase") );)

	if ( strlen(nvram_get("wl_passphrase")) == 0 )
	{
		if( !strcmp( key_index, "1" ) )
		{
			DanielDBG(fprintf(stderr, "wl_key1=<%s>\n", ToUpperCase(nvram_get("wl_key1") ));)
			websWrite(wp, "%s",ToUpperCase(nvram_get("wl_key1")));
		}
		else if( !strcmp( key_index, "2" ) )
		{
			DanielDBG(fprintf(stderr, "wl_key2=<%s>\n", ToUpperCase(nvram_get("wl_key2") ));)
			websWrite(wp, "%s",ToUpperCase(nvram_get("wl_key2")));
		}
		else if( !strcmp( key_index, "3" ) )
		{
			DanielDBG(fprintf(stderr, "wl_key3=<%s>\n", ToUpperCase(nvram_get("wl_key3") ));)
			websWrite(wp, "%s",ToUpperCase(nvram_get("wl_key3")));
		}
		else if( !strcmp( key_index, "4" ) )
		{
			DanielDBG(fprintf(stderr, "wl_key4=<%s>\n", ToUpperCase(nvram_get("wl_key4") ));)
			websWrite(wp, "%s",ToUpperCase(nvram_get("wl_key4")));
		}
	}
	else
	{
		DanielDBG(fprintf(stderr, "PassphraseKeyLength=<%d>\n", atoi(nvram_get("PassphraseKeyLength")));)

		switch ( atoi(nvram_get("PassphraseKeyLength")) )
		{
			case 0:
				/* do nothing */
				break ;

			case 1:
				Get64bitkey(nvram_get("wl_passphrase") , output_2);

				for ( i = 0 ; i < 5 ; i++ )
				{
					websWrite(wp, "%02X",output_2[index][i]);
				}

				break;

			case 2:
				Get128bitkey( nvram_get("wl_passphrase") , output_1 );

#if defined(LinksysWAP54G)       || defined(LinksysWAP54G4712) || \
	defined(LinksysWAP54GEU)     || defined(WhiteWAP54GEU) || \
	defined(LinksysWAP54GEU4712) || defined(WhiteWAP54GJP) || \
	defined(LinksysWRE54G)       || defined(LinksysWAP54GJP) || \
	defined(LinksysWAP54GJP4712)
				for ( i = 0 ; i < 13 ; i++ )
				{
					websWrite(wp, "%02X",output_1[i]);
				}
#else
				for ( i = 0 ; i < 13 ; i++ )
				{
					websWrite(wp, "%02X",output_1[i]);
				}
#endif
				break;

			default:
				printf(" Function 'ej_GetKey' PassphraseKeyLength happens exception.\n");
				break;
		}	/* End of Switch */
	}

	return 0;
}
#ifdef DanielAdd
static int ej_Get_MAC_Addr ( int eid , webs_t wp , int argc , char_t **argv )
{
	char *interface_name ;
	char *boardtype = NULL ;

	boardtype = nvram_safe_get("boardtype");

	if( ejArgs(argc, argv, "%s", &interface_name) < 1 )
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if( !strcmp(interface_name, "LAN") )
	{
		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
			websWrite( wp, "%s", nvram_safe_get("et0macaddr") );
		else
			websWrite( wp, "%s", nvram_safe_get("et1macaddr") );
	}
	else if( !strcmp(interface_name, "WLAN") )
	{
		websWrite( wp, "%s", nvram_safe_get("wl0_hwaddr") );
	}

	return 0 ;
}
static int ej_Status_Pkt ( int eid , webs_t wp , int argc , char_t **argv )
{
	FILE *fp ;
	char buf[1024] ;
	char *interface_name, *name ;
	char *p, *q ;
	int i, j ;
	char *boardtype = NULL ;

	boardtype = nvram_safe_get("boardtype");

	if( ejArgs(argc, argv, "%s %s", &interface_name, &name ) < 2 )
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	DanielDBG(fprintf( stderr, "interface_name=%s ", interface_name );)
	DanielDBG(fprintf( stderr, "name=%s\n", name );)

	fp = fopen( "/proc/net/dev", "r" ) ;

	if( fp == NULL )
	{
		cprintf( "fopen /proc/net/dev error (fp)\n" );
		return 0 ;
	}

	while( !feof(fp) )
	{
		memset( buf, '\0', sizeof(buf) );
		fgets( buf, sizeof(buf), fp );
		p = buf ;

		while( *p == 0x20 )
			p++ ;

		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6)) )
		{
			if( !strncmp( p, "eth0:", 5 ) && !strcmp( interface_name, "LAN" ) )
				break ;
			else if( !strncmp( p, "eth1:", 5 ) && !strcmp( interface_name, "WLAN" ) )
				break ;
			else if( !strncmp( p, "wlan:", 5 ) && !strcmp( interface_name, "WLAN_5G" ) )
				break ;
		}
		else
		{
			if( !strncmp( p, "eth1:", 5 ) && !strcmp( interface_name, "LAN" ) )
				break ;
			else if( !strncmp( p, "eth2:", 5 ) && !strcmp( interface_name, "WLAN" ) )
				break ;
			else if( !strncmp( p, "wlan:", 5 ) && !strcmp( interface_name, "WLAN_5G" ) )
				break ;
		}
	}

	if( !strcmp( name, "Send_Good_Pkt" ) )
		j = 10 ;
	else if( !strcmp( name, "Send_Dropped_Pkt" ) )
		j = 12 ;
	else if( !strcmp( name, "Recv_Good_Pkt" ) )
		j = 2 ;
	else if( !strcmp( name, "Recv_Dropped_Pkt" ) )
		j = 4 ;

	p = buf ;

	for( i=0 ; i<j ; i++ )
	{
		while( *p == 0x20 )
			p++ ;

		while( *p != 0x20 )
			p++ ;
	}

	while( *p == 0x20 )
		p++ ;

	q = p ;
	while( *q != 0x20 )
		q++ ;

	*q = 0x00 ;

	websWrite( wp, "%s", p );

	fclose( fp );

	return 0;
}
static int ej_Print_View_Log ( int eid , webs_t wp , int argc , char_t **argv )
{
	char *base = NULL ;
	FILE *fp = NULL ;
	char buf[100] ;
	char time_index[100] ;
	char messages[100] ;
	char temp[1024] ;
	int local_client_time = atoi( local_time );
	time_t mytm ;
	char lastpage[10] ;
	char *page ;
	int log_cnt = 0 ;
	int page_start, page_end ;
	int i = 0 ;
	int j = 0 ;

#if 0
	if (ejArgs(argc, argv, "%s", &page) < 1)
	{
		DanielDBG(cprintf("Insufficient args\n");)
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}
#endif

	page = nvram_safe_get("curpage") ;
	DanielDBG(cprintf("curpage=%s, ", page);)

	/* get page_start & page_end */
	DanielDBG(cprintf("page_start=%d, ",(atoi(page)*16)-16);)
	DanielDBG(cprintf("page_end=%d\n",(atoi(page)*16)-1);)
	page_start = (atoi(page)*16)-16;
	page_end   = (atoi(page)*16)-1;

	DanielDBG(cprintf("current_time=%d\n", current_time );)

	if( current_time != 0 )
	{
		/* open log_info.txt */
		fp = fopen( "/tmp/log_info.txt", "r" ) ;
		if( fp == NULL )
		{
			DanielDBG(cprintf("open log_info.txt error. \n");)
			websWrite ( wp , "&nbsp;" );
			return 0 ;
		}

		memset( buf, '\0', sizeof(buf) );

		while( !feof(fp) )
		{
			fgets( buf, sizeof(buf), fp) ;
			j++ ;
		}

		fseek( fp, 0, SEEK_SET );

		for( i=0 ; i<(j-1) ; i++ )
		{
			memset( time_index, '\0', sizeof(time_index) );
			memset( messages, '\0', sizeof(messages) );

			if( (log_cnt>=page_start)&&(log_cnt<=page_end) )
			{
				DanielDBG(cprintf("buf=<%s>\n", buf);)
				fgets( buf, sizeof(buf), fp ) ;

				base = strchr( buf, '=' ) ;
				if( base == NULL )
				{
					DanielDBG(cprintf("= is not here.\n");)
				}

				memcpy( time_index, buf, &base[0]-&buf[0] );
				DanielDBG(cprintf("time_index=<%s>\t", time_index);)
				base = base + 1 ;
				strcpy( messages, base );
				messages[strlen(messages)-1] = '\0' ;

				DanielDBG(cprintf("messages=<%s>\n", messages);)
				DanielDBG(cprintf("local_client_time=%d\t", local_client_time);)
				DanielDBG(cprintf("current_time=%d\t", current_time);)
				DanielDBG(cprintf("time_index (integer) = %d\n", atoi( time_index ));)

				mytm = local_client_time - current_time + atoi( time_index ) ;
				DanielDBG(cprintf("mytm=%d\t", mytm);)
				DanielDBG(cprintf("mytm_time=%s\n", ctime(&mytm));)
#if defined( LinksysWAP54GJP) || defined( LinksysWAP54GJP4712)
				mytm += 32400 ;	/* + 9 hours */
#else
				mytm -= 28800 ;	/* + 8 hours */ // Modified by Vic Yu
#endif
				DanielDBG(cprintf("mytm=%d\t", mytm);)
				DanielDBG(cprintf("mytm_time=%s\n", ctime(&mytm));)

				sprintf( temp, "<tr bgcolor=\"#cccccc\"><td>%s</td><td>%s</td></tr>", ctime(&mytm), messages );
				websWrite ( wp , "%s" , temp );
			}
			else
			{
				fgets( buf, sizeof(buf), fp ) ;
			}

			log_cnt++ ;
		}

		/* how much pages ? */
		if( log_cnt%16 == 0 )
		{
			memset( lastpage, '\0', sizeof(lastpage) );
			sprintf( lastpage, "%d", log_cnt/16 ) ;
			DanielDBG(cprintf("lastpage=%s\n", lastpage );)
			nvram_set( "lastpage", lastpage );
		}
		else
		{
			sprintf( lastpage, "%d", (log_cnt/16)+1 ) ;
			DanielDBG(cprintf("lastpage=%s\n", lastpage );)
			nvram_set( "lastpage", lastpage );
		}

		fclose(fp);
	}
	else
	{
		return websWrite ( wp , "&nbsp;" );
	}

	return 0;
}
#ifdef SiteSurvay
#ifdef B_3_11_44_0
#if 0
char *ether_etoa(const unsigned char *e, char *a)
{
	char *c = a;
	int i;

	for (i = 0; i < ETHER_ADDR_LEN; i++)
	{
		if (i)
			*c++ = ':';
		c += sprintf(c, "%02X", e[i] & 0xff);
	}
	return a;
}
#endif
#else
char *ether_etoa(const unsigned char *n)
{
	static char buf[ETHER_ADDR_LEN * 3];
	char *c = buf;
	int i;

	for (i = 0; i < ETHER_ADDR_LEN; i++)
	{
		if (i)
			*c++ = ':';
		c += sprintf(c, "%02X", n[i] & 0xff);
	}
	return buf;
}
#endif /* end of B_3_11_44_0 */
#if 0
static int wl_ioctl(char *name, int cmd, void *buf, int len)
{
	struct ifreq ifr;
	wl_ioctl_t ioc;
	int ret = 0;
 	int s;

	/* open socket to kernel */
	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
	{
		perror("socket");
		return errno;
	}

	/* do it */
	ioc.cmd = cmd;
	ioc.buf = buf;
	ioc.len = len;
	strncpy(ifr.ifr_name, name, IFNAMSIZ);
	ifr.ifr_data = (caddr_t) &ioc;

	if ((ret = ioctl(s, SIOCDEVPRIVATE, &ifr)) < 0)
		perror(ifr.ifr_name);

	/* cleanup */
	close(s);
	return ret;
}
#endif /* if 0 */
int ParseScanresults(char *path, char *mode)
{	/* return: count of AP/Router */
	FILE *fp = NULL ;
	char buf[2048], tmp[100] ;
	int count = 0, isWPA = 0, isSSID = 0 ;
	struct site_survay_t *t ;
	char *p, *q ;
#ifdef SITESURVEY_QUEUE
	site_survey_t qt ;
	int isQueue = 0 ;

	if( !strcmp(mode, "queue") )
		isQueue = 1 ;
#endif

	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)
	p = q = NULL ;
	memset( site_survay_table, '\0', sizeof(site_survay_table) );
	t = site_survay_table ;

	fp = fopen( path, "r" ) ;

	if( fp == NULL )
	{
		DanielDBG(fprintf(stderr, "fopen /tmp/scanresults error\n");)
		return 0 ;
	}

	while(!feof(fp))
	{
		memset(buf, '\0', sizeof(buf));
		fgets( buf, sizeof(buf), fp );

		if( !strncmp(buf, "SSID:", 5 ) )
		{
			/* get SSID */
			p = strchr(buf, '"');
			p += 1 ;
			q = strchr(p, '"');
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, p, q-p);
			DanielDBG(fprintf(stderr, "SSID=<%s> ", tmp);)
			strcpy(t->SSID, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.SSID, tmp);
#endif

			memset(buf, '\0', sizeof(buf));
			fgets( buf, sizeof(buf), fp );

			/* get Mode */
			p = strstr(buf, "Mode:");
			p += 6 ;
			q = strstr(p, "RSSI:");
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, p, q-p-1);
			DanielDBG(fprintf(stderr, "Mode:%s ", tmp);)
			strcpy(t->Mode, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.Mode, tmp);
#endif

			/* get RSSI */
			q += 6 ;
			p = strstr(q, "dBm");
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, q, p-q);
			DanielDBG(fprintf(stderr, "RSSI:%s(dBm) ", tmp);)
			t->RSSI = atoi(tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				qt.RSSI = atoi(tmp) ;
#endif

			/* get noise */
			q = strstr(p, "noise:");
			q += 7 ;
			p = strstr(q, "dBm");
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, q, p-q);
			DanielDBG(fprintf(stderr, "noise:%s(dBm) ", tmp);)
			strcpy(t->noise, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.noise, tmp);
#endif

			/* get Channel */
			q = strstr(p, "Channel:");
			q += 9 ;
			p = strchr(q, 0x0a);
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, q, p-q);
			DanielDBG(fprintf(stderr, "Channel:%s \n", tmp);)
			strcpy(t->Channel, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.Channel, tmp);
#endif
			isSSID = 1 ;
		}
		else if( !strncmp(buf, "BSSID:", 6 ) )
		{
			/* get BSSID */
			p = strstr(buf, "BSSID:");
			p += 7 ;
			q = strchr(p, '\t');
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, p, q-p);
			DanielDBG(fprintf(stderr, "BSSID=%s ", tmp);)
			strcpy(t->BSSID, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.BSSID, tmp);
#endif

			/* get capability */
			q += 13 ;
			p = strchr(q, 0x0a);
			memset(tmp, '\0', sizeof(tmp));
			strncpy(tmp, q, p-q-1);
			DanielDBG(fprintf(stderr, "Capability=%s \n", tmp);)
			strcpy(t->Capability, tmp);
#ifdef SITESURVEY_QUEUE
			if( isQueue )
				strcpy(qt.Capability, tmp);
#endif
		}
		else if( !strncmp(buf, "Supported Rates:", 16 ) )
		{
			p = strstr(buf, "Supported Rates:");
			p += 17 ;
			DanielDBG(fprintf(stderr, "Supported Rates=%s\n", p);)
			if( strstr(p, "54") != NULL )
			{
				t->SupRate = 'g' ;
#ifdef SITESURVEY_QUEUE
				if( isQueue )
					qt.SupRate = 'g' ;
#endif
			}
			else
			{
				t->SupRate = 'b' ;
#ifdef SITESURVEY_QUEUE
				if( isQueue )
					qt.SupRate = 'b' ;
#endif
			}
		}
		//else if( !strncmp(buf, "WSEC->WPA", 9 ) )
		else if( !strncmp(buf, "WPA", 3 ) )
			isWPA = 1 ;
		else
		{
			if(isSSID)
			{
				if(isWPA)
				{
					t->WPA = '1' ;
#ifdef SITESURVEY_QUEUE
					if( isQueue )
						qt.WPA = '1' ;
#endif
				}
				else
				{
					t->WPA = '0' ;
#ifdef SITESURVEY_QUEUE
					if( isQueue )
						qt.WPA = '0' ;
#endif
				}

				isWPA = 0 ;
				t++;
#ifdef SITESURVEY_QUEUE
				if( isQueue )
					SL = AddItemToQueue(SL, &qt) ;
#endif
				count++;
				isSSID = 0 ;
			}
		}
	}

	fclose(fp);
	DanielDBG(fprintf(stderr, "count=%d\n", count);)
	return count ;
}
static int ej_Site_Survay ( int eid , webs_t wp , int argc , char_t **argv )
{
	char *mode, boardtype[10] ;
	char buf[2048] ;
	struct site_survay_t *tt ;
	int isSiteSurvay = 0 ;
	int i = 0 ;
	int count = 0 ;
	int rssi ;
	int isWEP = 0 ;

	mode = NULL ;
	memset(boardtype,0,10);
	strcpy(boardtype ,nvram_safe_get("boardtype"));

	if( ejArgs(argc, argv, "%s", &mode ) < 1 )
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if(!strcmp(mode, "all") || !strcmp(mode, "v1.1"))
	{	/* do site survay */
#ifndef AP_Repeater
		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
		{
			fprintf(stderr,"1.type=%s\n",boardtype);
			system( "/usr/sbin/wl -i eth1 scan" );
		}
		else
		{
			fprintf(stderr,"2.type=%s\n",boardtype);
			system( "/usr/sbin/wl -i eth2 scan" );
		}

		sleep(1);

		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
			system( "/usr/sbin/wl -i eth1 scanresults >/tmp/scanresults" );
		else
			system( "/usr/sbin/wl -i eth2 scanresults >/tmp/scanresults" );
#endif

		count = ParseScanresults("/tmp/scanresults", "buffer");
		DanielDBG(fprintf(stderr, "count=%d\n", count);)
		isSiteSurvay = 1 ;
	}

	if(isSiteSurvay)
	{
		if( !strcmp(mode, "all") )
			websWrite ( wp , "%s", sitesurvay_table_header );

		tt = site_survay_table ;

		for( i=0 ; i<count ; i++ )
		{
			if( strncmp(tt->Mode, "Managed", 7 ) )
			{
				websWrite ( wp , "<input type=\"hidden\" name=\"ap%d\" value=\"\">\n", i );
				tt++ ;
				continue ;
			}

			memset( buf, '\0', sizeof(buf) );
			/* -20 dBm - -100 dBm */
			rssi = abs(tt->RSSI)-20 ;
			rssi = (5*rssi)/4 ;
			rssi = 100 - rssi ;
			if( rssi > 100 )
				rssi = 100 ;
			else if( rssi < 0 )
				rssi = 0 ;

			if( !strcmp(tt->Capability, "ESS WEP") ||
				!strcmp(tt->Capability, "ESS WEP ShortSlot") ||
				!strcmp(tt->Capability, "ESS WEP ShortPre") ||
				!strcmp(tt->Capability, "ESS WEP ShortPre ShortSlot") ||
				!strcmp(tt->Capability, "ESS Pollable WEP") ||
				!strcmp(tt->Capability, "ESS WEP PBCC") )
				isWEP = 1 ;
			else
				isWEP = 0 ;

			if( !strcmp(mode, "all") )
			{
				sprintf( buf , "<tr>\n\
					<td height=\"25\" align=\"center\" valign=\"middle\" bgcolor=\"#FFFFFF\">\n\
					<input type=\"hidden\" name=\"ap_wpa%d\" value=\"%c\">\n\
					<input type=\"hidden\" name=\"ap_ssid%d\" value=\"%s\">\n\
					<input type=\"hidden\" name=\"ap_wep%d\" value=\"%d\">\n\
					<input type=\"radio\" name=\"ap%d\" value=\"%s\" onClick=\"SelAP(this.form,%d)\"></td>\n\
					<td align=\"center\" valign=\"middle\" class=\"black1\">%s</td>\n\
					<td align=\"center\" valign=\"middle\" class=\"black1\">%s</td>\n\
					<td align=\"center\" valign=\"middle\" class=\"black1\">%s</td>\n\
					<td align=\"center\" valign=\"middle\" class=\"black1\">%d%c</td>\n\
					<td align=\"center\" valign=\"middle\" class=\"black1\">%s</td>\n\
					</tr>\n",
					i,tt->WPA,
					i,tt->SSID,
					i,isWEP,
					i,tt->BSSID,i,
					tt->SSID,
					tt->BSSID,
					tt->Channel,
					rssi,'%',
					(tt->SupRate == 'g') ? "802.11b/g" : "802.11b" );
			}
			else if( !strcmp(mode, "v1.1") )
			{
				sprintf( buf , "<tr>\n\
					<td height=\"25\" valign=\"top\" bgcolor=\"#E7E7E7\">&nbsp;\n\
					<td align=\"right\"><img border=\"0\" src=\"UI_04.gif\" width=\"8\" height=\"25\"></td>\n\
					<td valign=\"top\" bgcolor=\"#FFFFFF\">&nbsp;</td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<input type=\"hidden\" name=\"ap_wpa%d\" value=\"%c\">\n\
					<input type=\"hidden\" name=\"ap_ssid%d\" value=\"%s\">\n\
					<input type=\"hidden\" name=\"ap_channel%d\" value=\"%s\">\n\
					<input type=\"hidden\" name=\"ap_wep%d\" value=\"%d\">\n\
					<input type=\"radio\" name=\"ap%d\" value=\"%s\" onClick=\"SelAP(this.form,%d)\"></td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<font face=\"arial\" style=\"font-size: 8pt\">%s</font></td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<font face=\"arial\" style=\"font-size: 8pt\">%s</font></td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<font face=\"arial\" style=\"font-size: 8pt\">%s</font></td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<font face=\"arial\" style=\"font-size: 8pt\">%d%c</font></td>\n\
					<td align=\"center\" valign=\"middle\">\n\
					<font face=\"arial\" style=\"font-size: 8pt\">%s</font></td>\n\
					<td></td>\n\
					</tr>\n",
					i,tt->WPA,
					i,tt->SSID,
					i,tt->Channel,
					i,isWEP,
					i,tt->BSSID,i,
					tt->SSID,
					tt->BSSID,
					tt->Channel,
					rssi,'%',
					(tt->SupRate == 'g') ? "802.11b/g" : "802.11b" );
			}

			websWrite ( wp , "%s", buf );
			tt++ ;
		}

		websWrite ( wp , "<input type=\"hidden\" name=\"ap_cnt\" value=\"%d\">\n", i );

		if( !strcmp(mode, "all") )
			websWrite ( wp , "%s", sitesurvay_table_footer );
	}

	unlink("/tmp/scanresults");

	return 0 ;
}
#endif /* end of SiteSurvay */
#ifdef Link
/* Return WAN link state */
static int ej_link(int eid, webs_t wp, int argc, char_t **argv)
{
	char *wan_ifname = "eth1" ;
	int s;
	struct ifreq ifr;
	struct ethtool_cmd ecmd;

	/* Open socket to kernel */
	if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		return websWrite(wp, "Open socket to kernel error\n");

	/* Check for hardware link */
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);
	ifr.ifr_data = (void *) &ecmd;
	ecmd.cmd = ETHTOOL_GSET;
	if (ioctl(s, SIOCETHTOOL, &ifr) < 0)
	{
		close(s);
		return websWrite(wp, "Unknown");
	}

	if (!ecmd.speed)
	{
		close(s);
		return websWrite(wp, "Disconnected");
	}

	/* Check for valid IP address */
	strncpy(ifr.ifr_name, wan_ifname, IFNAMSIZ);
	if (ioctl(s, SIOCGIFADDR, &ifr) < 0)
	{
		close(s);
		return websWrite(wp, "Connecting");
	}

	/* Otherwise we are probably configured */
	close(s);

	return 0 ;
}
#endif /* end of Link */
#ifdef RPTEST
static int ej_start_wlrp_test(int eid, webs_t wp, int argc, char_t **argv)
{
	websWrite(wp, "Trying...\n");

	system( "/sbin/rp_test" );

	return 0 ;
}
#endif /* RPTEST */
#ifdef BCM4712APBOARD
#ifdef AP_Client
int check_join_ap_client(void)
{
	FILE *p_fp = NULL ;
	char buf[1024] ;
	char *p = NULL ;
	int ret = 0 ;

	p_fp = popen( "/usr/sbin/wl dump", "r" );
	if( p_fp == NULL )
	{
		perror( "popen" );
		return -1 ;
	}

	while( !feof(p_fp) )
	{
		memset( buf, '\0', sizeof(buf) );
		fgets( buf, sizeof(buf), p_fp );

		if( !memcmp( buf, "current_bss.BSSID", 17 ) )
		{
			p = strstr( buf, "00:00:00:00:00:00" );
			if( p != NULL )
				ret = 1 ;

			break ;
		}
	}

	pclose(p_fp);
	return ret ;
}
int make_ap_client_script(void)
{
	FILE *fp = NULL ;
	char buf[100];
	char *on, *mode, *boardtype ;

	on = mode = boardtype = NULL ;
	on = nvram_safe_get("ap_client_wep");
	mode = nvram_safe_get("ap_client_wep_mode");
	DanielDBG(fprintf(stderr,"on=<%s> ", on);)
	DanielDBG(fprintf(stderr,"mode=<%s>\n", mode);)
	boardtype = nvram_safe_get("boardtype");

	fp = fopen( "/tmp/ap_client_restart", "w" );
	if( fp == NULL )
		return 0 ;

	bzero(buf, sizeof(buf));
	fprintf( fp, "#!/bin/sh\n" );

	//if( !strcmp(on, "off") )
	//{
		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
			sprintf( buf, "/usr/sbin/wl -i eth1 join \"%s\"", nvram_safe_get("ap_client_ssid") );
		else
			sprintf( buf, "/usr/sbin/wl -i eth2 join \"%s\"", nvram_safe_get("ap_client_ssid") );
	//}
#if 0
	else if( !strcmp(on, "wep") )
	{
		if( !strcmp(mode, "open") )
		{
			if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
				sprintf( buf, "/usr/sbin/wl -i eth1 join \"%s\" key %s imode bss amode open",
					 nvram_safe_get("ap_client_ssid"), nvram_safe_get("ap_client_wep_key") );
			else
				sprintf( buf, "/usr/sbin/wl -i eth2 join \"%s\" key %s imode bss amode open",
					 nvram_safe_get("ap_client_ssid"), nvram_safe_get("ap_client_wep_key") );
		}
		else if( !strcmp(mode, "shared") )
		{
			if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) || !memcmp(boardtype, "0x467", 5)) )
				sprintf( buf, "/usr/sbin/wl -i eth1 join \"%s\" key %s imode bss amode shared",
					 nvram_safe_get("ap_client_ssid"), nvram_safe_get("ap_client_wep_key") );
			else
				sprintf( buf, "/usr/sbin/wl -i eth2 join \"%s\" key %s imode bss amode shared",
					 nvram_safe_get("ap_client_ssid"), nvram_safe_get("ap_client_wep_key") );
		}
	}
	else if( !strcmp(on, "psk") )  // VIc Yu added , for WPA-PSK
	{
		fprintf( fp, "wl sup_wpa 1\n" );

		if( !strcmp(mode, "tkip") )  // TKIP
			fprintf( fp, "wl wsec 2\n" );
		else if( !strcmp(mode, "aes") )
			fprintf( fp, "wl wsec 4\n" );

		fprintf( fp, "wl sup_wpa  1\n" );
		fprintf( fp, "wl wpa_auth 2\n" );

		sprintf( buf, "wl set_pmk \"%s\"\n" , nvram_safe_get("ap_client_wep_key"));
		fprintf( fp, "%s", buf );

		sprintf( buf, "wl ssid \"%s\"\n" , nvram_safe_get("ap_client_ssid"));

		/*fprintf( fp, "nvram set wl0_auth_mode=\"psk\"\n" );

		if( !strcmp(mode, "tkip") )
			fprintf( fp, "nvram set wl0_crypto=\"tkip\"\n" );
		else if( !strcmp(mode, "aes") )
			fprintf( fp, "nvram set wl0_crypto=\"aes\"\n" );

		sprintf( buf, "nvram set wl0_wpa_psk=\"%s\"\n" , nvram_safe_get("ap_client_wep_key"));
		fprintf( fp, "%s", buf );

		if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6)) )
			sprintf( buf, "wlconf eth1 down\nwlconf eth1 up\n");
		else
			sprintf( buf, "wlconf eth2 down\nwlconf eth2 up\n");

		fprintf( fp, "%s", buf );
		sprintf( buf, "/usr/sbin/wl -i eth1 join \"%s\" \n",nvram_safe_get("ap_client_ssid"));
		*/
	}
#endif
	fprintf( fp, "%s\n", buf );
	fclose(fp);

	chmod( "/tmp/ap_client_restart", S_IRUSR | S_IWUSR | S_IXUSR );

	return 0 ;
}
static int ej_ap_client_restart(int eid, webs_t wp, int argc, char_t **argv)
{
	char *restart_argv[] = { "/tmp/ap_client_restart", NULL } ;
	int ret ;
	pid_t pid ;
	int i ;
	int val ;

	make_ap_client_script();

	ret = _eval( restart_argv, NULL, 0, &pid);
	DanielDBG(fprintf(stderr, "execute it..." );)
	waitpid(pid, &ret, WUNTRACED);
	DanielDBG(fprintf(stderr, "ok\n" );)

	val = check_join_ap_client() ;
	if(val == 1)
	{
		ret = _eval( restart_argv, NULL, 0, &pid);
		DanielDBG(fprintf(stderr, "execute it..." );)
		waitpid(pid, &ret, WUNTRACED);
		DanielDBG(fprintf(stderr, "ok\n" );)
	}

	return 0 ;
}
static int ej_detect_ap_mode(int eid, webs_t wp, int argc, char_t **argv)
{
	char *mode ;

	if( ejArgs(argc, argv, "%s", &mode ) < 1 )
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	if( !strcmp( mode, "ap_client" ) )
	{
		if(check_join_ap_client())
			websWrite ( wp , "no" );
		else
			websWrite ( wp , "yes" );
	}

	return 0 ;
}
#endif /* AP_Client */
#ifdef AP_Repeater
int do_detect_wdslink()
{
	FILE *p_fp = NULL ;
	char buf[1024] ;
	char *mac, *p, mac_buf[20] ;
	int ret = 0 ;

	mac = p = NULL ;
	mac = nvram_safe_get("ap_repeater_mac");

	if( *mac != (char *)0 )
	{
		strcpy(mac_buf, mac);

		if( *mac != (char *)0 )
			ret = start_detect_link();

		if( !ret )
		{
			system( "/bin/ping 127.0.0.1" );
			for( p=&mac_buf[0] ; *p ; p++ )
			{
				if( *p > 0x40 )
				{
					*p -= 0x40 ;

					if( *p > 0 )
						*p += 0x60 ;
				}
			}

			mac = &mac_buf[0] ;
			p_fp = popen( "/usr/sbin/brctl showmacs br0", "r" );
			if( p_fp == NULL )
			{
				perror( "popen" );
				return 0 ;
			}

			while( !feof(p_fp) )
			{
				memset( buf, '\0', sizeof(buf) );
				fgets( buf, sizeof(buf), p_fp );
				p = strstr( buf, mac );
				if( p != NULL )
				{
					ret = 1 ;
					break ;
				}
			}
		}
	}

	return ret ;
}
static int ej_detect_ap_repeater_mode(int eid, webs_t wp, int argc, char_t **argv)
{
	int isHere = 0 ;

	isHere = do_detect_wdslink();

	if( isHere )
		websWrite ( wp , "yes" );
	else
		websWrite ( wp , "no" );

	return 0 ;
}
#endif /* end of AP_Repeater */

#endif /* BCM4712APBOARD */

#endif

struct ej_handler ej_handlers[] =
{
	{ "nvram_get", ej_nvram_get },
	{ "nvram_match", ej_nvram_match },
	{ "nvram_list", ej_nvram_list },
	{ "APFirmwareVersion", ej_APFirmwareVersion },
#ifdef DanielAdd
	{ "Status_Pkt", ej_Status_Pkt },
	{ "GetKey", ej_GetKey },
	{ "MyFirmwareVersion", ej_MyFirmwareVersion },
	{ "SubAPFirmwareVersion", ej_SubAPFirmwareVersion },
#ifdef Link
	{ "link", ej_link },
#endif
#ifdef SiteSurvay
	{ "Site_Survay", ej_Site_Survay },
#endif
	{ "Print_View_Log", ej_Print_View_Log },
	{ "Get_MAC_Addr", ej_Get_MAC_Addr },
#ifdef RPTEST
	{ "start_wlrp_test", ej_start_wlrp_test },
#endif /* RPTEST */
#ifdef AP_Client
	{ "ap_client_restart", ej_ap_client_restart },
	{ "detect_ap_mode", ej_detect_ap_mode },
#endif /* end of AP_Client */
#ifdef AP_Repeater
	{ "detect_ap_repeater_mode", ej_detect_ap_repeater_mode },
#endif /* end of AP_Repeater */
#endif	/* DanielAdd */

// +++ Vic Yu added
	{ "GTK_nvram_get", ej_GTK_nvram_get },
	{ "ses_button_display", ej_ses_button_display},
	{ "GTK_setup_page_get", ej_GTK_setup_page_get},
	{ "GTK_security_page_get", ej_GTK_security_page_get},
	{ "GTK_Web_function_init", ej_GTK_Web_function_init},
	{ "GTK_SES_Encrypt_Get", ej_GTK_SES_Encrypt_Get},
	{ "GTK_SES_Status_Get", ej_GTK_SES_Status_Get},
	{ "GTK_DebugTest_Get", ej_GTK_DebugTest_Get},
	{ "GTK_MemorySpace", ej_GTK_MemorySpace },// Get total Memory space
	//{ "GTK_MemorySpace", ej_GTK_MemorySpace },

// - - - Vic Yu added
	{ NULL, NULL }
};


// +++ Vic Yu added

/*typedef struct {
	int	flag;					// flag , reserved .
	char	*web_param;			// Web UI defined parameter
	char	*bcm_param;			// Broadcom defined parameter
	char	*(*get_func)(char *param);			// Specific get value function if necessary
	char	*(*set_func)(char *param,char *value);	// Specific set value function if necessary
}Web_param_struct;
*/
char *parse_ipaddr_format(char *par_str,int ip_index)
{
	char	tmp_str[5];
	int	index;
	int	i,j=0;

	memset(tmp_str,0x0,5);

	if(strcmp(par_str,"")==0)
		return "0";

	index=ip_index;

	index--;
	for(i=0;i<15;i++)
	{
		if(!par_str[i])
			break;

		if(par_str[i]=='.')
		{
			index--;
			continue;
		}

		if(index==0)
		{
			tmp_str[j]=par_str[i];
			j++;
		}
		else	if(index<0)
			break;
		else
			continue;
	}

	tmp_str[j]='\0';

	return tmp_str;
}

static int GTK_convert_nvram_parameter(void)
{
	struct variable *v;
	char tmp[128], prefix[] = "wlXXXXXXXXXX_";

	//fprintf(stderr,"Enter convert function\n");

	//copy wl_*** to wl0_***  for synchronize Web UI and SES function
	snprintf(prefix, sizeof(prefix), "wl0_");
	for (v = variables; v < &variables[ARRAYSIZE(variables)]; v++)
	{
		if (!strncmp(v->name, "wl_", 3))
			//nvram_set(v->name, nvram_safe_get(strcat_r(prefix, &v->name[3], tmp)));
			nvram_set(strcat_r(prefix, &v->name[3], tmp), nvram_safe_get(v->name));
		if (!strncmp(v->name, "wl_unit", 7))
			break;
	}

	//sys_commit();

	return 0;
}


// ++++++++++  Web UI Get API Start  ++++++++++
static int *GTK_ipaddr_format_getfunc(char *param , char *ret_data)
{
	//char	ret_str[5];
	char	ip_addr[15];
	int	par_index;

	//memset(ret_str,0x0,5);
	memset(ip_addr,0x0,15);

	par_index=param[strlen(param)-1]-0x30;

	if(strncmp(param,"GTK_wan_ipaddr",14)==0)
		strcpy(ip_addr,nvram_safe_get( "lan_ipaddr" ));
	else if(strncmp(param,"GTK_wan_netmask",15)==0)
		strcpy(ip_addr,nvram_safe_get( "lan_netmask" ));
	else if(strncmp(param,"GTK_wan_gateway",15)==0)
		strcpy(ip_addr,nvram_safe_get( "lan_gateway" ));
	else if(strncmp(param,"GTK_radius_ipaddr",17)==0)
		strcpy(ip_addr,nvram_safe_get( "wl_radius_ipaddr" ));
	else
		return 0;

	strcpy(ret_data,parse_ipaddr_format(ip_addr,par_index));

	return 1;

}

// Get Security mode data
static int *GTK_wl_sec_mode_getfunc(char *param , char *ret_data)
{
	char		*wep,*wpa,*radius;

	wep=nvram_safe_get("wl_wep");
	wpa=nvram_safe_get("wl_akm");
	radius=nvram_safe_get("wl_auth_mode");

	if(strcmp(wep,"enabled")==0) // WEP enabled
	{
		if(strcmp(radius,"radius")==0)  // 802.1X enabled
		{
			strcpy(ret_data,"radius-wep");
		}
		else
		{
			strcpy(ret_data,"wep");
		}
	}
	else if(memcmp(wpa,"psk psk2",8)==0) // WPA-PSK and WPA2-PSK Mixed
	{
		strcpy(ret_data,"wpa-mixed");
	}
	else if(strcmp(wpa,"wpa")==0) // WPA enabled
	{
		strcpy(ret_data,"radius-wpa");
	}
	else if(strcmp(wpa,"psk")==0) // WPA-PSK enabled
	{
		strcpy(ret_data,"wpa-psk");
	}
	else if(strcmp(wpa,"wpa2")==0) // WPA2 enabled
	{
		strcpy(ret_data,"radius-wpa2");
	}
	else if(strcmp(wpa,"psk2")==0) // WPA2-PSK enabled
	{
		strcpy(ret_data,"wpa2-psk");
	}
	else
	{
		strcpy(ret_data,"none");
	}


	return 1;
}

// Get Authentication type data
static int *GTK_wl_auth_type_getfunc(char *param , char *ret_data)
{
	char		*wep,*wpa;
	char		*wep_auth,*wpa_crypto;

	wep=nvram_safe_get("wl_wep");
	wpa=nvram_safe_get("wl_akm");
	wep_auth=nvram_safe_get("wl_auth");
	wpa_crypto=nvram_safe_get("wl_crypto");

	if(strcmp(wep,"enabled")==0) // WEP enabled
	{
		if(strcmp(wep_auth,"1")==0)
			strcpy(ret_data,"shared");
		else
			strcpy(ret_data,"open");
	}
	else if(strcmp(wpa,"psk")==0 || strcmp(wpa,"wpa")==0 || strcmp(wpa,"psk2")==0|| strcmp(wpa,"wpa2")==0) // WPA-PSK or WPA2-PSK enabled
	{
		if(strcmp(wpa_crypto,"tkip")==0)
			strcpy(ret_data,"tkip");
		else if(strcmp(wpa_crypto,"aes")==0)
			strcpy(ret_data,"aes");
		else if(strcmp(wpa_crypto,"tkip+aes")==0)
			strcpy(ret_data,"tkip+aes");
	}
	else
	{
		strcpy(ret_data,"none");
	}


	return 1;
}

static int *GTK_tmp_key_index_getfunc(char *param , char *ret_data)
{
	char		*tmp_key_index;

	tmp_key_index=nvram_safe_get("GTK_tmp_key_index");
	strcpy(ret_data,tmp_key_index);

	return 1;
}

//static int *GTK_tmp_key_index_getfunc(char *param , char *ret_data)
//{

//}

// - - - - - - - - - -  Web UI Get API End  - - - - - - - - - - - -

// ++++++++++  Web UI Set API Start  ++++++++++

static int *GTK_wl_sec_mode_setfunc(char *param,char *value)
{
	if(strcmp(value,"wep")==0)  // WEP
	{
		nvram_set("wl_wep","enabled");  // WEP enable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","");  // WPA disable
		//nvram_set("wl0_akm","");  // WPA disable
		nvram_set("security_mode_page","4");
	}
	else if(strcmp(value,"radius-wep")==0)   // 802.1X Radius
	{
		nvram_set("wl_wep","enabled");  // WEP enable
		nvram_set("wl_auth_mode","radius");	 // Radius disable
		nvram_set("wl_akm","");  // WPA disable
		//nvram_set("wl0_akm","");  // WPA disable
		nvram_set("security_mode_page","2");
	}
	else if(strcmp(value,"radius-wpa")==0)
	{
		nvram_set("wl_wep","disabled");  // WEP disable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","wpa");  // WPA enable
		//nvram_set("wl0_akm","wpa");  // WPA enable
		nvram_set("security_mode_page","1");
	}
	else if(strcmp(value,"wpa-psk")==0)   // WPA-PSK
	{
		nvram_set("wl_wep","disabled");  // WEP disable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","psk");  // WPA-PSK enable
		//nvram_set("wl0_akm","psk");  // WPA-PSK enable
		nvram_set("security_mode_page","0");
	}
	else if(strcmp(value,"wpa2")==0)
	{
	}
	else if(strcmp(value,"wpa2-psk")==0)
	{
		nvram_set("wl_wep","disabled");  // WEP disable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","psk2");  // WPA2-PSK enable
		//nvram_set("wl0_akm","psk2");  // WPA2-PSK enable
	}
	else if(strcmp(value,"wpa-mixed")==0)
	{
		nvram_set("wl_wep","disabled");  // WEP disable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","psk psk2");  // WPA-PSK and WPA2-PSK enable
		//nvram_set("wl0_akm","psk psk2");  // WPA-PSK and WPA2-PSK enable
	}
	else
	{
		nvram_set("wl_wep","disabled");  // WEP disable
		nvram_set("wl_auth_mode","none");	 // Radius disable
		nvram_set("wl_akm","");  // WPA-PSK disable
		//nvram_set("wl0_akm","");  // WPA-PSK disable
		nvram_set("security_mode_page","4");
	}

	return 1;
}

static int *GTK_wl_auth_type_setfunc(char *param,char *value)
{
	char		*wep,*wpa;

	wep=nvram_safe_get("wl_wep");
	wpa=nvram_safe_get("wl_akm");

	if(strcmp(wep,"enabled")==0)  // WEP enabled
	{
		if(strcmp(value,"'shared")==0)
			nvram_set("wl_auth","1");  // shared
		else
			nvram_set("wl_auth","0");  // open
	}
	else if(strcmp(wpa,"wpa")==0 || strcmp(wpa,"psk")==0 ||strcmp(wpa,"wpa2")==0 ||strcmp(wpa,"psk2")==0 || memcmp(wpa,"psk psk2",8)==0)
	{
		if(strcmp(value,"aes")==0)
			nvram_set("wl_crypto","aes");  // AES
		else if(strcmp(value,"tkipaes")==0)
			nvram_set("wl_crypto","tkip+aes");  // TKIP+AES
		else
			nvram_set("wl_crypto","tkip");  // TKIP
	}
	else  // WEP and WPA did not enable
	{
		if(strcmp(value,"'shared")==0)
			nvram_set("wl_auth","1");  // shared
		else
			nvram_set("wl_auth","0");  // open
		nvram_set("wl_crypto","tkip");  // TKIP
	}

	return 1;
}

static int *GTK_tmp_key_index_setfunc(char *param,char *value)
{
	//fprintf(stderr,"param=%s, value=%s\n",param,value);
	nvram_set(param,value);

	if(strcmp(value,"1")==0 || strcmp(value,"2")==0)
		nvram_set("wl_key","2");
	else if(strcmp(value,"3")==0 || strcmp(value,"4")==0)
		nvram_set("wl_key","3");
	else
		nvram_set("wl_key","2");

	return 1;
}

//static int *GTK_tmp_key_index_setfunc(char *param,char *value)
//{

//}

// - - - - - - - - - -  Web UI Set API End  - - - - - - - - - - - -


// initial Web Parameter function
void Gemtek_Web_Param_init(void)
{
	static Web_param_struct	Gemtek_Web_param_table[]={

		// Lan-side Configuration
		{0	,"GTK_lan_Macaddr"	,"lan_hwaddr"		,NULL						,NULL					},
		{0	,"GTK_lan_ipaddr"		,"lan_ipaddr"		,NULL						,NULL					},

		// Wireless Configuration
		{0	,"GTK_wl_channel"		,"wl_channel"		,NULL						,NULL					},
		{0	,"GTK_wl_ssid"			,"wl_ssid"			,NULL						,NULL					},
		{0	,"GTK_wl_macaddr"		,"wan_hwaddr"		,NULL						,NULL					},
		{0	,"GTK_wl_gmode"		,"wl_gmode"		,NULL						,NULL					},
		{0	,"GTK_wl_ssidbrocast"	,"wl_closed"		,NULL						,NULL					},

		// Wireless Security Configuration
		{0	,"GTK_wl_sec_mode"	,0				,GTK_wl_sec_mode_getfunc		,GTK_wl_sec_mode_setfunc	},// Security mode , {none|wep|radius-wep|radius-wpa|wpa-psk|wpa2-psk|wpa-mixed}
		{0	,"GTK_wl_auth_type"	,0				,GTK_wl_auth_type_getfunc		,GTK_wl_auth_type_setfunc	},// Security authentication type ,{none}  WEP{open|shared} , WPA-PSK{tkip|aes|tkip+aes}
		// WEP
		{0	,"GTK_wl_key_index"	,"wl_key"			,NULL						,NULL					},// WEP Key index
		{0	,"GTK_wl_key_value1"	,"wl_key1"		,NULL						,NULL					},// WEP Key 1 value
		{0	,"GTK_wl_key_value2"	,"wl_key2"		,NULL						,NULL					},// WEP Key 2 value
		{0	,"GTK_wl_key_value3"	,"wl_key3"		,NULL						,NULL					},// WEP Key 3 value
		{0	,"GTK_wl_key_value4"	,"wl_key4"		,NULL						,NULL					},// WEP Key 4 value
		// Radius-WEP
		{0	,"GTK_wl_radius_ipaddr"	,"wl_radius_ipaddr"	,NULL						,NULL					},// Radius Server IP address
		{0	,"GTK_radius_ipaddr1"	,0				,GTK_ipaddr_format_getfunc		,NULL					},// Radius Server IP address 1
		{0	,"GTK_radius_ipaddr2"	,0				,GTK_ipaddr_format_getfunc		,NULL					},// Radius Server IP address 2
		{0	,"GTK_radius_ipaddr3"	,0				,GTK_ipaddr_format_getfunc		,NULL					},// Radius Server IP address 3
		{0	,"GTK_radius_ipaddr4"	,0				,GTK_ipaddr_format_getfunc		,NULL					},// Radius Server IP address 4
		{0	,"GTK_radius_port"		,"wl_radius_port"	,NULL						,NULL					},// Radius Port number
		{0	,"GTK_radius_key"		,"wl_radius_key"	,NULL						,NULL					},// Radius Key
		// WAP-PSK
		{0	,"GTK_wl_wpa_psk"		,"wl_wpa_psk"		,NULL						,NULL					},// WPA-PSK key value
		{0	,"GTK_wl_wpa_rekey"	,"wl_wpa_gtk_rekey",NULL						,NULL					},// WPA-PSK Group key renewal

		// WAN Configuration
		{0	,"GTK_wan_proto"		,"wan_proto"		,NULL						,NULL					},// static/dhcp
		{0	,"GTK_lan_dhcp"		,"lan_dhcp"		,NULL						,NULL					},// DHCP client 1:dhcp , 0 :static
		{0	,"GTK_wan_ipaddr"		,"lan_ipaddr"		,NULL						,NULL					},
		{0	,"GTK_wan_ipaddr1"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_ipaddr2"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_ipaddr3"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_ipaddr4"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_netmask"	,"lan_netmask"		,NULL						,NULL					},
		{0	,"GTK_wan_netmask1"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_netmask2"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_netmask3"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_netmask4"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_gateway"	,"lan_gateway"		,NULL						,NULL					},
		{0	,"GTK_wan_gateway1"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_gateway2"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_gateway3"	,0				,GTK_ipaddr_format_getfunc		,NULL					},
		{0	,"GTK_wan_gateway4"	,0				,GTK_ipaddr_format_getfunc		,NULL					},

		// Device Information
		{0	,"GTK_wl_devicename"	,"wan_hostname"	,NULL						,NULL					},
		// Passphrase
		{0	,"wl_passphrase"		,"wl_passphrase"	,NULL						,NULL					},
		{0	,"GTK_tmp_key_index"	,0				,GTK_tmp_key_index_getfunc		,GTK_tmp_key_index_setfunc	},

		{0	,"security_mode_page"	,"security_mode_page"	,NULL					,NULL					},
		//{0	,"GTK_wl_paramA"		,"BCM_paramA"	,GTK_test_getfunc				,GTK_web_test_setfunc		},
		{0	,0					,0				,0							,0						}
	};

	Gemtek_Web_param_ptr=malloc(sizeof(Gemtek_Web_param_table));
	memcpy(Gemtek_Web_param_ptr,Gemtek_Web_param_table,sizeof(Gemtek_Web_param_table));
	fprintf(stderr,"Web parameter initial success !\n");
}

// return 1: success , return -1: fail
int web_transfer_param(char *param_str, Web_param_struct *index)
{
	int i=0;
	Web_param_struct	*tmp_ptr;

	if(!Gemtek_Web_param_ptr)
		return -1;

	if(param_str==NULL)
		return -1;

	if(!strcmp(param_str,""))
		return -1;

	//memset(tmp_ptr,0x0,sizeof(Web_param_struct));

	// find parameter string index from Gemtek_Web_param_ptr[]
	for(tmp_ptr=Gemtek_Web_param_ptr; tmp_ptr->web_param; tmp_ptr++)
	{
		if(strcmp(param_str,tmp_ptr->web_param)==0) // paraemter index found
		{
			memcpy(index,tmp_ptr,sizeof(Web_param_struct));
			return 1;
		}
	}

	return -1;
}

// Web UI get function , usage is the same as "nvram_get( );"
static int ej_GTK_nvram_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char					*name, *c;
	char					ret_buf[32];
	int					ret = 0;
	Web_param_struct		param_index;

	memset(&param_index,0x0,sizeof(Web_param_struct));
	memset(ret_buf,0x0,32);

	if (ejArgs(argc, argv, "%s", &name) < 1)
	{
		websError(wp, 400, "Insufficient args\n");
		return -1;
	}

	// find argument info in Web defined structure table
	if(web_transfer_param(name,&param_index)!=-1)
	{
		if(param_index.get_func==NULL)
		{
			// Do not define get function,  call broadcom "nvram_safe_get( )" function
			c = nvram_safe_get(param_index.bcm_param);
		}
		else
		{
			// Use Web defined get function
			param_index.get_func(param_index.web_param,ret_buf);
			c=ret_buf;
		}

	}
	else
	{
		// argument doesn't be defined in Web defined structure table
		c = nvram_safe_get(name);
	}

	// replace special character
	for(; *c ;  c++ )
	{
		if( *c == 0x22 ) /* " */
			ret += websWrite( wp, "%c%c", 0x5c, 0x22 );
		else if( *c == 0x27 ) /* ' */
			ret += websWrite( wp, "%c%c", 0x5c, 0x27 );
		else if( *c == 0x5c ) /* \ */
			ret += websWrite( wp, "%c%c", 0x5c, 0x5c );
		else
			ret += websWrite(wp, "%c", *c);
	}

	return ret;
}

int do_GTK_Submit(webs_t wp)
{
	int		i;
	char		*input_value;
	char		input_name[24];
	Web_param_struct	*tmp;
	char		*page_value;

	if(!Gemtek_Web_param_ptr)
		return -1;

	//memset(input_name,0x0,24);

	for(tmp=Gemtek_Web_param_ptr; tmp->web_param; tmp++)
	{
		input_value=NULL;
		memset(input_name,0x0,24);

		// WPA-PSK key value doesn't need to set , see line 2849 do_sysconf_post()
		if(strcmp(tmp->web_param,"GTK_wl_wpa_psk")==0)
			continue;

		if (!(input_value = websGetVar(wp, tmp->web_param, NULL)))
			continue;

		if(strcmp(tmp->web_param,"wl_passphrase")==0 && !*input_value)
		{
			// Passphrase empty
			nvram_set("wl_passphrase","");
			continue;
		}

		if(*input_value) //Input value exist
		{
			//fprintf(stderr,"Input value = %s\n",input_value);

			if(tmp->set_func==NULL)
			{
				// Do not define set function
				if(!tmp->bcm_param)  // do no thing  with this parameter
					continue;
				else
				{
					strcpy(input_name,tmp->bcm_param);
					//fprintf(stderr,"1 ,name=%s , value=%s !\n",input_name,input_value);
					nvram_set(input_name,input_value);
				}
			}
			else
			{
				// Use defined set function
				strcpy(input_name,tmp->web_param);
				//fprintf(stderr,"2  ,name=%s , value=%s !\n",input_name,input_value);
				tmp->set_func(input_name,input_value);
			}
		}
		else
		{
			continue;
		}
	}

	// convert nvram parameter
	GTK_convert_nvram_parameter();

	input_value=NULL;
	input_value=websGetVar(wp ,"reboot_flag", "");

	page_value=websGetVar(wp ,"page", "");

	if(strcmp(input_value,"disabled")==0)
	{
		if(strcmp(page_value,"security_page")==0)
			return 1; // Restart
		else
			return 3;  // Only save
	}
	else
		return 2;  // Reboot
}

// Software SES button submit function
int do_GTK_SES_Submit(webs_t wp)
{
	char		*behavior_value;
	char		*ses_state;
	char		buf[1024];

	bzero(buf, sizeof(buf));

	// action value : ClickSES_SWBTN / ClickSES_ResetBTN
	behavior_value=websGetVar(wp, "ses_behavior", "");
	ses_state=nvram_safe_get("ses_fsm_current_states");

	if(!*behavior_value)
		return 0;

	if (!strcmp(behavior_value, "ClickSES_SWBTN"))
	{
		// Click SES SW button
		if(!strcmp(ses_state,"01:01"))
		{
			// SES Inactive
			//Creating SES Network and Opening SES Window
			nvram_set("ses_event", "6");
			//system("cat /proc/kmemory_ses/SES_Blink_On");
		}
		else
		{
			//SES Secured
			// verify that we are a psk/tkip network
			if (nvram_match("wl0_crypto", "tkip") && (nvram_match("wl0_akm", "psk") || nvram_match("wl0_akm", "psk ")))
			{
				//Opening SES Window
				nvram_set("ses_event", "4");
				//system("cat /proc/kmemory_ses/SES_Blink_On");
			}
			else
			{
				fprintf(stderr,"SES SW button Fail !");
				return 0;
			}
		}
		websWrite(wp, (char_t *) RedirectPage(buf, "SES_Wait.asp"));
	}
	else if (!strcmp(behavior_value, "ClickSES_ResetBTN"))
	{
		// Click SES Reset button
		//Creating SES Network
		nvram_set("ses_event", "3");
		websWrite(wp, (char_t *) RedirectPage(buf, "SES_ResetWait.asp"));
	}
	else
	{
		fprintf(stderr,("SES SW button behavior value Fail !"));
		return 0;
	}

	websFooter(wp);
	websDone(wp, 200);

	return 0; // Go to Nothing
}

// Software Debug test submit
int do_GTK_DebugTest_Submit(webs_t wp)
{
	char		*behavior_value;
	char		*ses_state;
	char		buf[1024];

	bzero(buf, sizeof(buf));

	// action value : ClickSES_SWBTN / ClickSES_ResetBTN
	behavior_value=websGetVar(wp, "ses_behavior", "");
	ses_state=nvram_safe_get("ses_fsm_current_states");

	if(!*behavior_value)
		return 0;

	if (!strcmp(behavior_value, "ClickSES_SWBTN"))
	{
		// Click SES SW button
		if(!strcmp(ses_state,"01:01"))
		{
			// SES Inactive
			//Creating SES Network and Opening SES Window
			nvram_set("ses_event", "6");
		}
		else
		{
			//SES Secured
			// verify that we are a psk/tkip network
			if (nvram_match("wl0_crypto", "tkip") && (nvram_match("wl0_akm", "psk") || nvram_match("wl0_akm", "psk ")))
			{
				//Opening SES Window
				nvram_set("ses_event", "4");
			}
			else
			{
				fprintf(stderr,"SES SW button Fail !");
				return 0;
			}
		}
		websWrite(wp, (char_t *) RedirectPage(buf, "SES_Wait.asp"));
	}
	else if (!strcmp(behavior_value, "ClickSES_ResetBTN"))
	{
		// Click SES Reset button
		//Creating SES Network
		nvram_set("ses_event", "3");
		websWrite(wp, (char_t *) RedirectPage(buf, "Wireless.asp"));
	}
	else
	{
		fprintf(stderr,("SES SW button behavior value Fail !"));
		return 0;
	}

	websFooter(wp);
	websDone(wp, 200);

	return 0; // Go to Nothing
}

#ifdef FCCTesting
int do_FCC_Process(webs_t wp)
{
	char		*rateset,*channel,*join_ssid,*rate,*txpwr1,*antdiv,*txant;
	char		cmd_string[64];
	char		buf[1024];

	bzero(buf, sizeof(buf));

	rateset=websGetVar(wp, "fcc_rateset", "");
	channel=websGetVar(wp, "fcc_channel", "");
	join_ssid=websGetVar(wp, "fcc_join_ssid", "");
	rate=websGetVar(wp, "fcc_rate", "");
	txpwr1=websGetVar(wp, "fcc_txpwr1", "");
	antdiv=websGetVar(wp, "fcc_antdiv", "");
	txant=websGetVar(wp, "fcc_txant", "");

	fprintf(stderr,"FCC command: wl down\n");
	system( "/usr/sbin/wl down" );
	fprintf(stderr,"FCC command: wl clk 1\n");
	system( "/usr/sbin/wl clk 1" );
	fprintf(stderr,"FCC command: wl band b\n");
	system( "/usr/sbin/wl band b" );
	fprintf(stderr,"FCC command: wl up\n");
	system( "/usr/sbin/wl up" );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl rateset %sb &",rateset);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl ssid %s &",nvram_safe_get("wl_ssid"));
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl channel %s &",channel);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl join %s &",join_ssid);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl rate %s &",rate);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl txpwr1 -o -q %s &",txpwr1);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl antdiv %s &",antdiv);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	memset(cmd_string,0,64);
	sprintf(cmd_string,"/usr/sbin/wl txant %s &",txant);
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );


	websWrite(wp, (char_t *) RedirectPage(buf, "fcc.asp"));
	websFooter(wp);
	websDone(wp, 200);
	return 0;
}
int do_FCC_Run(webs_t wp)
{
	char		*pkt_size,*pkt_count,*client_ip;
	char		cmd_string[64];
	char		buf[1024];
	char		*epi_cmd;

	bzero(buf, sizeof(buf));

	pkt_size=websGetVar(wp, "fcc_pkt_size", "");
	pkt_count=websGetVar(wp, "fcc_pkt_count", "");
	client_ip=websGetVar(wp, "fcc_client_ip", "");
	epi_cmd=websGetVar(wp, "epi_ttcp", "");

	memset(cmd_string,0,64);
	if(strcmp(epi_cmd,"tx")==0)
	{
		sprintf(cmd_string,"/usr/sbin/epi_ttcp -tsu -l %s -n %s %s &",pkt_size,pkt_count,client_ip);
	}
	else if(strcmp(epi_cmd,"rx")==0)
	{
		sprintf(cmd_string,"/usr/sbin/epi_ttcp -rsu &");
	}
	else
	{
	}
	fprintf(stderr,"%s\n",cmd_string);
	system( cmd_string );

	websWrite(wp, (char_t *) RedirectPage(buf, "fcc.asp"));
	websFooter(wp);
	websDone(wp, 200);
	return 0;
}
#endif


static int ej_ses_button_display(int eid, webs_t wp, int argc, char_t **argv)
{
	if (atoi(nvram_safe_get("ses_enable")) == 0) {
		return 1;
	}

	websWrite(wp, "<tr><th width=\"310\"> SES Button:&nbsp;&nbsp; </th>");
	websWrite(wp, "<td>&nbsp;&nbsp;</td>");
	websWrite(wp, "<td><input type=\"submit\" name=\"action\" value=\"NewSesNW\" ></td></tr>");
	websWrite(wp, "<tr><th width=\"310\"> SES Button:&nbsp;&nbsp; </th>");
	websWrite(wp, "<td>&nbsp;&nbsp;</td>");
	websWrite(wp, "<td><input type=\"submit\" name=\"action\" value=\"OpenWindow\" ></td></tr>");
	websWrite(wp, "<tr><th width=\"310\"> SES Button:&nbsp;&nbsp; </th>");
	websWrite(wp, "<td>&nbsp;&nbsp;</td>");
	websWrite(wp, "<td><input type=\"submit\" name=\"action\" value=\"NewSesNWAndOW\" ></td></tr>");
	websWrite(wp, "<tr><th width=\"310\"> SES Button:&nbsp;&nbsp; </th>");
	websWrite(wp, "<td>&nbsp;&nbsp;</td>");
	websWrite(wp, "<td><input type=\"submit\" name=\"action\" value=\"ResetNWToDefault\" ></td></tr>");


	return 1;
}

static int ej_GTK_setup_page_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *proto_state=nvram_safe_get("wan_proto");

	if(strcmp(proto_state,"dhcp")==0)
		websWrite ( wp , "Setup_dhcp.asp" );
	else
		websWrite ( wp , "Setup_static.asp" );

	return 0;
}

static int ej_GTK_security_page_get(int eid, webs_t wp, int argc, char_t **argv)
{
	char	security_mode[20];

	memset(security_mode,0x0,20);

	GTK_wl_sec_mode_getfunc("GTK_wl_sec_mode",security_mode);

	if(strcmp(security_mode,"wep")==0)
		websWrite ( wp , "WSecurity_WEP.asp" );
	else if(strcmp(security_mode,"radius-wep")==0)
		websWrite ( wp , "WSecurity_Radius_WEP.asp" );
	else if(strcmp(security_mode,"radius-wpa")==0)
		websWrite ( wp , "WSecurity_Radius_WPA.asp" );
	else if(strcmp(security_mode,"wpa-psk")==0)
		websWrite ( wp , "WSecurity_WPAPSK.asp" );
	else if(strcmp(security_mode,"wpa2-psk")==0)
		websWrite ( wp , "WSecurity_WPA2PSK.asp" );
	else if(strcmp(security_mode,"wpa-mixed")==0)
		websWrite ( wp , "WSecurity_WPA_Mixed.asp" );
	else
		websWrite ( wp , "WSecurity.asp" );

	return 0;
}

static int ej_GTK_Web_function_init(int eid, webs_t wp, int argc, char_t **argv)
{
	struct variable *v;
	char tmp[128], prefix[] = "wlXXXXXXXXXX_";

	//fprintf(stderr,"Enter initial function\n");

	//copy wl0_*** to wl_***  for synchronize Web UI and SES function
	snprintf(prefix, sizeof(prefix), "wl0_");
	for (v = variables; v < &variables[ARRAYSIZE(variables)]; v++)
	{
		if (!strncmp(v->name, "wl_", 3))
			nvram_set(v->name, nvram_safe_get(strcat_r(prefix, &v->name[3], tmp)));
		if (!strncmp(v->name, "wl_unit", 7))
			break;
	}

	//sleep(1);
	//sys_commit();
	//sleep(1);

	return 0;
}

static int ej_GTK_SES_Encrypt_Get(int eid, webs_t wp, int argc, char_t **argv)
{
	char		*wep,*wpa,*radius;

	wep=nvram_safe_get("wl0_wep");
	wpa=nvram_safe_get("wl0_akm");
	radius=nvram_safe_get("wl0_auth_mode");

	if(strcmp(wep,"enabled")==0) // WEP enabled
	{
		if(strcmp(radius,"radius")==0)  // 802.1X enabled
		{
			websWrite ( wp , WEB_RADIUS );
		}
		else
		{
			websWrite ( wp , WEB_WEP );
		}
	}
	else if(memcmp(wpa,"psk psk2",8)==0) // WPA-PSK and WPA2-PSK Mixed
	{
		websWrite ( wp , WEB_WPA2MIX );
	}
	else if(strcmp(wpa,"wpa")==0) // WPA enabled
	{
		websWrite ( wp , WEB_WPA );
	}
	else if(strcmp(wpa,"psk")==0) // WPA-PSK enabled
	{
		websWrite ( wp , WEB_WPAPSK );
	}
	else if(strcmp(wpa,"wpa2")==0) // WPA2 enabled
	{
		websWrite ( wp , WEB_WPA2 );
	}
	else if(strcmp(wpa,"psk2")==0) // WPA2-PSK enabled
	{
		websWrite ( wp , WEB_WPA2PSK );
	}
	else
	{
		websWrite ( wp , WEB_NOENCRYP );
	}


	return 0;
}

static int ej_GTK_SES_Status_Get(int eid, webs_t wp, int argc, char_t **argv)
{
	char *ses_status;

	ses_status=nvram_safe_get("ses_fsm_current_states");

	if(strcmp(ses_status,"01:01")==0)
		websWrite ( wp , WEB_SESINACT );
	else
		websWrite ( wp , WEB_SESACT );

	return 0;
}

static int ej_GTK_DebugTest_Get(int eid, webs_t wp, int argc, char_t **argv)
{
	int fd ;
	int ret = 0 ;
	unsigned char val[4] ;

	fd = open( "/dev/gpio/close_diag_signal", O_RDWR );

	if( fd == -1 )
	{
		return 0 ;
	}

	bzero(val, sizeof(val));
	ret = read(fd, val, sizeof(val));
	sleep(1);

	websWrite ( wp , "Value[0]=%x,Value[1]=%x,Value[2]=%x,Value[3]=%x", val[0],val[1],val[2],val[3]);

	close(fd);
	return 0;
}

static int ej_GTK_MemorySpace(int eid, webs_t wp, int argc, char_t **argv)
{
	FILE *fp = NULL ;
	char buf[1024], *p ;
	unsigned long total_mem=0,used_mem=0,free_mem=0;
	unsigned long shared_mem=0,buffer_mem=0,cache_mem=0;

	fp=fopen("/proc/meminfo","r");

	if(fp==NULL)// open file fail
	{
		fprintf(stderr,"/proc/meminfo Open Fail !\n");
		return 0;
	}

	while(!feof(fp))// search until end of file
	{
		memset(buf,'\0',sizeof(buf));
		fgets(buf,sizeof(buf),fp);
		p=buf;

		while(*p==0x20)
			p++;

		if(!strncmp(p,"Mem:",4))// find data
		{
			p=p+5;//do not need string "Mem:"
			while(*p==0x20)
				p++;

			// get all memory information parameter
			sscanf(p,"%u %u %u %u %u %u",&total_mem,&used_mem,&free_mem,&shared_mem,&buffer_mem,&cache_mem);
			break;
		}


	}
	websWrite(wp ," %u  Bytes",total_mem);
	fclose(fp);
	return 0;
}

/*static int ej_GTK_MemorySpace(int eid, webs_t wp, int argc, char_t **argv)
{

}*/
// - - - Vic Yu added

#endif /* !WEBS */
