/*
 * Copyright 2003 by Gemtek Technology Co., Ltd
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
#ifndef _ap_h_
#define _ap_h_

#ifndef DanielAdd
#define DanielAdd
#endif

#include <ap_defs.h>
#include <ap_dbg.h>

#define SERV_UDP_PORT 514
#define ASSOCLIST "/tmp/assoclist"
//#define B_3_11_19_0 /* add wl_ioctl() */
#define SetWatchDog
#define B_3_21_7_0 /* change definition of wlconfig \
					  change start_nas() and stop_nas() \
					  make /tmp/var/tmp/nvram myself */
#define ABBA	/* convert wireless parameters */
//#define Link
//#define UseFrisbeeCard /* for intersil */
//#define GET_WL_IOCTL
//#define SPROM
//#define FakeWiFiG /* src/router/shared/defaults.c, change default dtim to 1 */

#define NEWMACSWAP
#define DetectDownGrade
#define Associate_List
#define AssociateDaemon
#define SetAntDiv	/* for Antenna Selection */
#define PHYCONF		/* src/router/phyconf/phyconf.c */


#ifdef SiteSurvay
#include <wlioctl.h>
#endif

/* for my services */
extern void start_my_services() ;
extern void stop_my_services() ;

/* for FCC */
#ifdef FCCTesting
extern void start_fcc_test() ;
#endif

/* for LAN Configuration */
extern void Conf_ETH1(char *lan_ifname) ;
extern int start_configure_network(char *lan_ifname) ;
void Prepare_restore_file( void);

/* AP Syslogd */
extern int ap_syslogd(char *msg) ;

/* for wirell associate list */
extern void start_wl_assoclist() ;
extern void WirelessAssocList() ;


#ifdef UpgradePmon
/* for Pmon */
extern int start_upgrade_pmon() ;
#endif /* UpgradePmon */

/* for test */
extern int start_test_script(char *mode) ;
#if 0
extern void send_log() ;
extern void start_antdiv_test() ;
#endif
extern void start_mem_test() ;
#if 0
extern void start_chipdump_test() ;
extern void syserr(char *s) ;
#endif

/* for convertting parameters */
extern void convert_wireless_params(void) ;

/* check nvram parameter we need */
extern int check_nvram_params_exist(char *name) ;
extern int check_nvram_parameters(void) ;
extern int del_unnecessary_parameters(void) ;

/* for hardware link */
extern int start_link_test(void) ;

#ifdef PHYCONF
/* phyconf */
extern int start_phyconf(void);
#endif

#ifdef SiteSurvay
extern int check_ap_client(void) ; /* if current_bss.BSSID = 00:00:00:00:00:00, re-execute wl join again */
extern int make_scan_script(char *path);
#endif /* end of SiteSurvay */

#ifdef GET_WL_IOCTL
/* get ioctl value */
extern int start_get_wl_ioctl(void) ;
#endif

#ifdef SPROM
/* get sprom value */
extern void start_sprom_test(void) ;
#endif

#ifdef SetAntDiv
#define WL_IOCTL(name, cmd, buf, len) ((void) wl_ioctl((name), (cmd), (buf), (len)))
extern void start_antenna_selection(void) ;
#endif /* SetAntDiv */

#ifdef B_3_21_7_0
extern int make_nvram_list(void) ;
#endif /* B_3_21_7_0 */

extern void restart_httpd(void) ;
extern void CheckMACAddr(void) ;
extern void restart_lan(void) ;
extern void save_firmware_version(void) ;
extern void start_kill_easyconf(void) ;

#ifdef MakeWwwPartition
extern int check_www_dir(void) ;
extern int copy_upgrade_pages(void) ;
extern int get_path_len(void) ;
extern int start_read_mtd(char *mtd) ;
#endif /* MakeWwwPartition */

#ifdef RESTORE11ADEFAULTS
extern int restore_11A_defaults(void) ;
#endif /* RESTORE11ADEFAULTS */

#ifdef BCM4712APBOARD
extern int start_restore_defaults(void);
extern int start_MACAddrClone(void);
//extern int stop_diag_signal(void);
extern int start_my_lan(void);
extern int stop_my_lan(void);
extern unsigned int start_gpio(int count, char **option);
extern int check_ap_mode_params(void);
#if defined(AP_Client)
extern int check_ap_repeater(void) ;
#endif /* end of AP_Client */

#endif /* end of BCM4712APBOARD */

#ifdef DetectDownGrade
extern int CheckDownGrade(char option);
#endif /* end of DetectDownGrade */

#ifdef SETDEFVALS
extern int SetDefVals(char *name);
#endif /* end of SETDEFVALS */

/* scripts */
extern int make_scripts(void);
extern int make_killall_daemons_script(char *path);
extern int get_file_pid(char *file);

#ifdef MakeWwwPartition
extern int make_mount_www_partition_script(char *path);
extern int make_umount_www_partition_script(char *path);
extern int make_copy_upgrade_pages_script(char *path);
#endif /* end of MakeWwwPartition */

#ifdef AddRestoreHdr
extern int add_restore_hdr(char *path);
#endif /* end of AddRestoreHdr */

#ifdef AP_Repeater
extern int start_ap_repeater(void);
//extern int ap_repeater_script(char *path);
extern int SETDEFSSID(void);
extern int start_AutoScanOnBtn(void);
extern int start_AutoScan(void);
extern int start_detect_wds_link(void);
extern int start_AutoScanBlinking(void);
extern int start_APRepeaterDaemon(void);
#endif /* end of AP_Repeater */

#ifdef ABBA
#define XSTR(s) STR(s)
#define STR(s) #s
#endif

#define IFUP (IFF_UP | IFF_RUNNING | IFF_BROADCAST | IFF_MULTICAST)

// +++ Vic Yu added, Web UI parameter defined
typedef struct {
	int	flag;					// flag , reserved .
	char	*web_param;			// Web UI defined parameter
	char	*bcm_param;			// Broadcom defined parameter
	int	*(*get_func)(char *param , char *ret_data);			// Specific get value function if necessary
	int	*(*set_func)(char *param,char *value);	// Specific set value function if necessary
}Web_param_struct;

Web_param_struct		*Gemtek_Web_param_ptr;

extern void Gemtek_Web_Param_init(void);

// +++ Vic Yu added, Web UI parameter defined

#endif /* _ap_h_ */
