/*
 * Copyright 2003-2004 by Gemtek Technology Co., Ltd
 * 
 * All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
#ifndef __ap_shared_h__
#define __ap_shared_h__

#include <ap_defs.h>		

#ifndef SITESURVEY_QUEUE
#define SITESURVEY_QUEUE	
#endif 

#ifdef SITESURVEY_QUEUE
typedef struct _site_survey_t {
	char SSID[33];
	char Mode[10];
	int  RSSI;
	char noise[4];
	char Channel[3];	
	char BSSID[18];	
	char Capability[30];
	char SupRate;	
	char WPA;	
} site_survey_t ;

typedef struct __LIST {
	site_survey_t content[1] ;
    struct __LIST *next;
} SITESURVEY_LIST ;

extern void AssignContentToQueue(site_survey_t *a, site_survey_t *b);
extern SITESURVEY_LIST *AddItemToQueue(SITESURVEY_LIST *listpointer, site_survey_t *data); 
extern SITESURVEY_LIST *SortQueue(SITESURVEY_LIST *start);
extern void PrintQueue(SITESURVEY_LIST *listpointer);
extern SITESURVEY_LIST *RemoveItemFromQueue(SITESURVEY_LIST *listpointer);
extern void ClearQueue(SITESURVEY_LIST *listpointer); 

#endif /* end of SITESURVEY_QUEUE */

#ifdef AP_Repeater
extern int ap_repeater_script(char *path);
extern int SetAPRepeaterMode(char *macaddr, char *ssid, char *channel, char *wep, char *key_index, char *key);
extern int start_detect_link();		
extern int Get_WDS_Interface(char *wds_interface);
#endif /* end of AP_Repeater */

#endif /* end of __ap_shared_h__ */
