/* Copyright 2003-2004 by Gemtek Technology Co., Ltd
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
#include <ap_defs.h>
#include <ap_words.h> /* DanielAdd for different language word */

#ifdef AP_Repeater
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <bcmnvram.h>
#include <shutils.h>
#include <ap_dbg.h>
#endif /* end of AP_Repeater */

const char * const restore_footer =
"<center>\n"
"<br>\n"
"<input type=\"button\" name=\"action\" value=\""APPLYBTN"\" OnClick=\"self.close();\">\n"
"</center></form>\n"
"</body>\n"
;

#ifdef BACKUP_RESTORE
const char * const RestoreOKPage =
"<head>\n"
"<title>"RESTOREOK"</title>\n"
"</head>\n"
"<body>\n"
"<center>\n"
"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"350\">"
"<tr bgcolor=\"white\">\n"
"<th height=\"150\"><font size=\"4\" face=\"Verdana\">\n"
""APPLYMSG".\n"
"<br>\n"
"<br>\n"
"<input style=\"font-size: 8pt\" type=\"button\" name=\"restore\" value=\""APPLYBTN"\" OnClick=\"javascript: self.close();\">\n"
"</font></th></tr></table>\n"
"</center>\n"
"</body>"
;
const char * const RestoreErrorPage =
"<head>\n"
"<title>"RESTOREFAIL"</title>\n"
"</head>\n"
"<body>\n"
"<center>\n"
"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"300\">"
"<tr bgcolor=\"white\">\n"
"<th height=\"150\"><font size=\"4\" face=\"Verdana\">\n"
""RESTOREERROR"\n"
"<br>\n"
"<br>\n"
"<input style=\"font-size: 8pt\" type=\"button\" name=\"restore\" value=\""BACKBTN"\" OnClick=\"javascript: window.location.href=\'restore.asp\';\">\n"
"</font></th></tr></table>\n"
"</center>\n"
"</body>"
;
#endif /* end of BACKUP_RESTORE */

const char *const DummyViewLogPage =
"<head>\n"
"<title>Rediect</title>\n"
"<script language=\"JavaScript\">\n"
"<!--\n"
"function SetTime()\n"
"{\n"
"	var f = document.none ;\n"
"	var d = new Date();\n"
"	var t = d.getTime();\n"
"	var z = d.getTimezoneOffset();\n"
"	f.time.value = parseInt((t+500/1000-z*60)/1000);\n"
"	f.submit();\n"
"}\n"
"//-->\n"
"</script>\n"
"</head>\n"
"<body onLoad=\"SetTime()\">\n"
"<form name=\"none\" method=\"post\" action=\"sysconf.cgi\" enctype=\"multipart/form-data\">\n"
"<input type=\"hidden\" name=\"action\" value=\"view_log\">\n"
"<input type=\"hidden\" name=\"time\">\n"
"</form>\n"
"</body>"
;
const char AcceptRange[] =
"Accept-Range: bytes"
;

const char * const sitesurvay_table_header =
"          <tr>\n"
"            <td height=\"27\" valign=\"top\" bgcolor=\"#6666CC\">&nbsp;</td>\n"
"            <td valign=\"top\">\n"
"              <table width=\"100%\" border=\"1\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"white\">\n"
"                <tr>\n"
"                  <td bgcolor=\"#6666CC\" height=\"25\" width=\"27\">&nbsp;</td>\n"
"                  <td width=\"250\" height=\"25\" align=\"center\" valign=\"middle\" bgcolor=\"#6666CC\" class=\"white3\">SSID</td>\n"
"                  <td width=\"170\" height=\"25\" align=\"center\" valign=\"middle\" bgcolor=\"#6666CC\" class=\"white3\">MAC \n"
"                    address</td>\n"
"                  <td width=\"80\" height=\"25\" align=\"center\" valign=\"middle\" bgcolor=\"#6666CC\" class=\"white3\">Channel</td>\n"
"                  <td width=\"188\" height=\"25\" align=\"center\" valign=\"middle\" bgcolor=\"#6666CC\" class=\"white3\">Signal \n"
"                    Strength(%)</td>\n"
"                  <td width=\"95\" align=\"center\" valign=\"middle\" bgcolor=\"#6666CC\" class=\"white3\">Mode</td>\n"
"                </tr>\n"
;
const char * const sitesurvay_table_footer =
"                <tr>\n"
"                  <td height=\"50\" align=\"center\" valign=\"middle\" bgcolor=\"#FFFFFF\">&nbsp;</td>\n"
"                  <td>&nbsp;</td>\n"
"                  <td>&nbsp;</td>\n"
"                  <td>&nbsp;</td>\n"
"                  <td>&nbsp;</td>\n"
"                  <td>&nbsp;</td>\n"
"                </tr>\n"
"                <tr>\n"
"                  <td height=\"80\" align=\"center\" valign=\"middle\" bgcolor=\"#FFFFFF\">&nbsp;</td>\n"
"                  <td colspan=\"4\" align=\"center\" valign=\"middle\">&nbsp;&nbsp; <input type=\"button\" value=\" Connect \" style=\"font-family: Verdana; font-size: 11px;\" onClick=\"validate();\"> \n"
"                    &nbsp; <input type=\"button\" value=\" Refresh \" style=\"font-family: Verdana; font-size: 11px;\" onclick=\"window.location.reload()\"> \n"
"                    &nbsp; </td>\n"
"                  <td>&nbsp;</td>\n"
"                </tr>\n"
"              </table>\n"
"			</td>\n"
"          </tr>\n"
;

const char * const apply_header =
"<head>\n"
"<title>"APPLYTITLE"</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n"
"<script language=\"javascript\">\n"
"<!--\n"
"	var url=document.referrer;\n"
"	var page = '' ; \n"
"	var cnt=0;\n"
"	var d = new Date();\n"
"	var t = d.getTime();\n"
"	var z = d.getTimezoneOffset();\n"
"	var startTime = parseInt((t+500/1000-z*60)/1000);\n"
"	\n"
"	for( var i=0 ; i<url.length ; i++ )\n"
"	{\n"
"		if( url.charAt(i) == \'/\' )\n"
"			cnt++ ; \n"
"		if( cnt == 3 ) \n"
"			break ; \n"
"	}\n"
"	page = url.substring(i+1,url.length);\n"
"\n"
"function setTimer()\n"
"{\n"
"	var dd = new Date();\n"
"	var tt = dd.getTime();\n"
"	var zz = dd.getTimezoneOffset();\n"
"	var endTime = parseInt((tt+500/1000-zz*60)/1000);\n"
"	var time_interval = endTime-startTime;\n"
"	document.forms[0].action.disabled = true ;\n"
"	document.body.style.cursor = \"wait\";\n"
"	\n"
"	if( page == \'SharedKeys.asp\' || \n"
"		page == \"SharedKeys_5G.asp\" ||\n"
"		page == \"WEP.asp\" 	 ||\n"
"		page == \"WPA_Preshared.asp\" ||\n"
"		page == \"WPA_Radius.asp\" ||\n"
"		page == \"Radius_MD5.asp\" ||\n"
"		page == \'site.asp\' )\n"
"	{\n"
"		self.close(); "
"		self.opener.document.forms[0].submit();"
"	}\n"
"	else \n"
"	{ \n"
"		if( page == \"Setup_dhcp.asp\"    || \n"
"			page == \"Setup_static.asp\"   || \n"
"			page == \"AP_mode.asp\"  || \n"
"			page == \"Wireless.asp\" || \n"
"			page == \"WSecurity.asp\"    || \n"
"			page == \"WSecurity_Radius_WEP.asp\"      || \n"
"			page == \"WSecurity_Radius_WPA.asp\"      || \n"
"			page == \"WSecurity_WEP.asp\"    || \n"
"			page == \"WSecurity_WPA2PSK.asp\"    || \n"
"			page == \"WSecurity_WPA_Mixed.asp\"    || \n"
"			page == \"WSecurity_WPAPSK.asp\"    || \n"
"			page == \"WMACFilter.asp\"    || \n"
"			page == \"AdvancedWSettings.asp\"    || \n"
"			page == \"Administration.asp\"    || \n"
"			page == \"SNMP.asp\"    || \n"
"			page == \"Log.asp\"    || \n"
"			page == \"FactoryDefaults.asp\"    || \n"
"			page == \"index.asp\"    || \n"
"			page == \"fcc.asp\" 	 )\n"
"		{\n"
"			if( get_ap_mode() == \"2\" )\n"
"			{\n"
"				if( time_interval > 30 )\n"
"					setTimeout(\"redirect()\",0);\n	"
"				else\n"
"					setTimeout(\"redirect()\",(30-time_interval)*1000);\n"
"			}\n"
"			else\n"
"			{\n"
"				if( time_interval > 10 )\n"
"					setTimeout(\"redirect()\",0);\n	"
"				else\n"
"					setTimeout(\"redirect()\",(10-time_interval)*1000);\n"
"			}\n"
"		}\n"
"		else\n"
"			redirect();\n"
"	}\n"
"}\n"
"function redirect()\n"
"{\n"
"	var f = document.forms[0];\n"
"	var page = previous_page(); \n"
"	var ip = real_ip(); \n"
"	\n"
"	if( f.change.value == \"1\" )\n"
"		parent.window.location.href = \"http://"DEFIPADDR"/\"\n"
"	else\n"
"	{\n"
"		if( page == \"Setup_static.asp\" )\n"
"			parent.window.location.href = \'http://\'+ ip + \'/\' ; \n"
"		else\n"
"			window.location.href = document.referrer ; \n"
"	}\n"
"}\n"
"function closeWindow()\n"
"{\n"
"	//ReloadOpenerPage(\"setup.asp\"); \n"
" 	self.close(); \n"
"}\n"
"function ReloadOpenerPage(page)\n"
"{\n"
" 	self.opener.window.location.href = page ; \n"
"}\n"
"//-->\n"
"</script>\n"
"</head>\n"
"<body bgcolor=black ONDRAGSTART=\"window.event.returnValue=false\" ONCONTEXTMENU=\"window.event.returnValue=false\">\n"
"<form method=\"post\" action=\"sysconf.cgi\" enctype=\"multipart/form-data\">\n"
"<p>\n"
"<center>\n"
"<br>\n"
"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"557\">\n"
"<tr bgcolor=\"white\">\n"
"<th height=\"400\"><font size=\"4\" face=\"Verdana\">\n"
;

const char * const apply_footer =
"<br>\n"
"<br>\n"
"<input type=\"button\" name=\"action\" value=\""APPLYBTN"\" OnClick=\"setTimer()\">\n"
"</form>\n"
"</font></th>\n"
"</tr>\n"
"</table>\n"
"</center>\n"
"<script language=\"javascript\">\n"
"<!--\n"
"function previous_page()\n"
"{\n"
"	var page = document.referrer; \n"
"	var len = page.length; \n"
"	var cnt = 0; \n"
"	for( var i=0 ; i<len ; i++ ) \n"
"	{ \n"
"		var c = page.charAt(i); \n"
"		if( c == \'/\' ) \n"
"			cnt++; \n"
"		if( cnt == 3 ) \n"
"			break; \n"
"	} \n"
"	return ( page.substring(++i,len) ); \n"
"}\n"
"function real_ip()\n"
"{\n"
"	return ( document.forms[0].ip.value ); \n"
"}\n"
"function get_ap_mode()\n"
"{\n"
"	return ( document.forms[0].ap_mode.value ); \n"
"}\n"
"//-->\n"
"</script>\n"
"</body>\n"
;

const char * const upgrade_header =
"<head>\n"
"<title>"UPGRADETITLE"</title>\n"
"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n"
"<script language=\"javascript\">\n"
"<!--\n"
"	var url=document.referrer;\n"
"	var page = '' ; \n"
"	var cnt=0;\n"
"	var d = new Date();\n"
"	var t = d.getTime();\n"
"	var z = d.getTimezoneOffset();\n"
"	var startTime = parseInt((t+500/1000-z*60)/1000);\n"
"	for( var i=0 ; i<url.length ; i++ )\n"
"	{\n"
"		if( url.charAt(i) == \'/\' )\n"
"			cnt++ ; \n"
"		if( cnt == 3 ) \n"
"			break ; \n"
"	}\n"
"	page = url.substring(i+1,url.length);\n"
"\n"
"function setTimer()\n"
"{\n"
"	var dd = new Date();\n"
"	var tt = dd.getTime();\n"
"	var zz = dd.getTimezoneOffset();\n"
"	var endTime = parseInt((tt+500/1000-zz*60)/1000);\n"
"	var time_interval = endTime-startTime;\n"
"	document.forms[0].action.disabled = true ;\n"
"	document.body.style.cursor = \"wait\" ;\n"
"	\n"
"	if(page==\"Upgrade.asp\")\n"
"		clean_status();\n"
"}\n"
"function redirect()\n"
"{\n"
"	document.location.href = document.referrer ;\n"
"}\n"
"function clean_status()\n"
"{\n"
"	if(typeof self.opener != \"undefined\")\n"
"		if(typeof self.opener.ClearWinStatus() == \"function\")\n"
"			self.opener.ClearWinStatus();\n"
"	self.close();\n"
"}\n"
"//-->\n"
"</script>\n"
"</head>\n"
"<body bgcolor=black ONDRAGSTART=\"window.event.returnValue=false\" ONCONTEXTMENU=\"window.event.returnValue=false\">\n"
"<form method=\"post\" action=\"sysconf.cgi\" enctype=\"multipart/form-data\">\n"
"<center>\n"
"<br>\n"
"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"300\">\n"
"<tr bgcolor=\"white\">\n"
"<th height=\"140\"><font size=\"4\" face=\"Verdana\">\n"
;

const char * const upgrade_footer =
"<br>\n"
"<br>\n"
"<input type=\"button\" name=\"action\" value=\""APPLYBTN"\" OnClick=\"setTimer()\">\n"
"</form>\n"
"</font></th>\n"
"</tr>\n"
"</table>\n"
"</center>\n"
"<script language=\"javascript\">\n"
"<!--\n"
"	if(typeof self.opener != \"undefined\")\n"
"		if(typeof self.opener.ClearWinStatus == \"function\")\n"
"			self.opener.ClearWinStatus();\n"
"//-->\n"
"</script>\n"
"</body>\n"
;
#ifdef AP_Repeater
const char * const self_close =
"<script language=\"javascript\">\n"
"<!--\n"
"	if(typeof self.opener != \'undefined\')\n"
"	{\n"
"		if(typeof self.opener.ReloadPage() == \"function\")\n"
"			self.opener.ReloadPage();\n"
/*
"		if(self.opener.parent != \'undefined\')\n"
"			self.opener.parent.frames[1].document.DetectWDSLink.submit();\n"
*/
"	}\n"
"	self.close();\n"
"//-->\n"
"</script>\n"
;
int make_ap_repeater_mode_script(char *mode)
{
	FILE *fp = NULL ;
	char *boardtype, *mac ;

	DanielDBG(fprintf(stderr,"%s()...\n", __FUNCTION__ );)

	boardtype = mac = NULL ;
	boardtype = nvram_safe_get("boardtype");
	mac = nvram_safe_get("ap_repeater_mac");

	fp = fopen( "/tmp/ap_repeater_mode_restart", "w" );
	if( fp == NULL )
		return 0 ;

	fprintf( fp, "#!/bin/sh\n" );
	fprintf( fp, "nvram set wl_mode=\"ap\"\n" );
	fprintf( fp, "nvram set wl0_mode=\"ap\"\n" );
	fprintf( fp, "nvram set wl_lazywds=\"0\"\n" );
	fprintf( fp, "nvram set wl0_lazywds=\"0\"\n" );
	fprintf( fp, "nvram set wl_wds=\"\"\n" );
	fprintf( fp, "nvram set wl0_wds=\"\"\n" );


	if( !strcmp(mode, "start") )
	{
		fprintf( fp, "nvram set wl_wep=\"off\"\n" );
		fprintf( fp, "nvram set wl0_wep=\"off\"\n" );
		fprintf( fp, "nvram set d11g_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
		fprintf( fp, "nvram set wl0_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
	}
	else if( !strcmp(mode, "wep") )
	{
		fprintf( fp, "nvram set wl_wep=\"wep\"\n" );
		fprintf( fp, "nvram set wl0_wep=\"wep\"\n" );
		fprintf( fp, "nvram set wl_key=\"%s\"\n", nvram_safe_get("wl_key"));
		fprintf( fp, "nvram set wl0_key=\"%s\"\n", nvram_safe_get("wl_key"));
		fprintf( fp, "nvram set wl_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
		fprintf( fp, "nvram set wl0_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
		fprintf( fp, "nvram set wl_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
		fprintf( fp, "nvram set wl0_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
		fprintf( fp, "nvram set wl_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
		fprintf( fp, "nvram set wl0_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
		fprintf( fp, "nvram set wl_key4=\"%s\"\n", nvram_safe_get("wl_key4"));
		fprintf( fp, "nvram set wl0_key4=\"%s\"\n", nvram_safe_get("wl_key4"));
		fprintf( fp, "nvram set d11g_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
		fprintf( fp, "nvram set wl0_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
	}

	if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6 ) )
	{
		fprintf( fp, "wlconf eth1 down\n" );
		fprintf( fp, "wlconf eth1 up\n" );
		if( mac != NULL )
			fprintf( fp, "wl -i eth1 wds \"%s\"\n", mac);
	}
	else
{
		fprintf( fp, "wlconf eth2 down\n" );
		fprintf( fp, "wlconf eth2 up\n" );
		if( mac != NULL )
			fprintf( fp, "wl -i eth2 wds \"%s\"\n", mac);
	}

	fprintf( fp, "nvram commit\n" );
	fclose(fp);

	chmod( "/tmp/ap_repeater_mode_restart", S_IRUSR | S_IWUSR | S_IXUSR );

	return 0 ;
}
int make_ap_repeater_connect_script(void)
{
	FILE *fp = NULL ;
	char *path = "/tmp/connect" ;
	char *boardtype, *mac ;

	boardtype = mac = NULL ;
	boardtype = nvram_safe_get("boardtype");
	mac = nvram_safe_get("ap_repeater_mac");

	fp = fopen( path, "w" );
	if( fp == NULL )
	{
		DanielDBG(fprintf(stderr,"fopen %s error\n", path);)
		return -1 ;
	}

	fprintf( fp, "#!/bin/sh\n" );
	fprintf( fp, "nvram set wl_mode=\"ap\"\n" );
	fprintf( fp, "nvram set wl0_mode=\"ap\"\n" );
	fprintf( fp, "nvram set wl_lazywds=\"0\"\n" );
	fprintf( fp, "nvram set wl0_lazywds=\"0\"\n" );
	fprintf( fp, "nvram set wl_wds=\"\"\n" );
	fprintf( fp, "nvram set wl0_wds=\"\"\n" );
	fprintf( fp, "nvram set wl_wep=\"%s\"\n", nvram_safe_get("wl_wep"));
	fprintf( fp, "nvram set wl0_wep=\"%s\"\n", nvram_safe_get("wl_wep"));
	fprintf( fp, "nvram set wl_key=\"%s\"\n", nvram_safe_get("wl_key"));
	fprintf( fp, "nvram set wl0_key=\"%s\"\n", nvram_safe_get("wl_key"));
	fprintf( fp, "nvram set wl_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
	fprintf( fp, "nvram set wl0_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
	fprintf( fp, "nvram set wl_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
	fprintf( fp, "nvram set wl0_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
	fprintf( fp, "nvram set wl_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
	fprintf( fp, "nvram set wl0_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
	fprintf( fp, "nvram set wl_key4=\"%s\"\n", nvram_safe_get("wl_key4"));
	fprintf( fp, "nvram set wl0_key4=\"%s\"\n", nvram_safe_get("wl_key4"));
	fprintf( fp, "nvram set d11g_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
	fprintf( fp, "nvram set wl0_channel=\"%s\"\n", nvram_safe_get("ap_repeater_channel"));
	fprintf( fp, "nvram set wl_ssid=\"%s\"\n", nvram_safe_get("ap_repeater_ssid"));
	fprintf( fp, "nvram set wl0_ssid=\"%s\"\n", nvram_safe_get("ap_repeater_ssid"));

	if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6) )
	{
		fprintf( fp, "wlconf eth1 down\n" );
		fprintf( fp, "wlconf eth1 up\n" );
		if( mac != NULL )
			fprintf( fp, "wl -i eth1 wds \"%s\"\n", mac );
	}
	else
	{
		fprintf( fp, "wlconf eth2 down\n" );
		fprintf( fp, "wlconf eth2 up\n" );
		if( mac != NULL )
			fprintf( fp, "wl -i eth2 wds \"%s\"\n",mac );
	}

	fprintf( fp, "nvram commit\n" );

	fclose(fp);
	chmod( path, S_IRUSR | S_IWUSR | S_IXUSR );
	return 0 ;
}
#endif /* end of AP_Repeater */
