/*
 * CGI helper functions
 *
 * Copyright (C) 2001 Broadcom Corporation
 *
 * $Id: cgi.c,v 1.6 2002/10/04 04:46:16 mhuang Exp $
 */

#include <ap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

static char *query;	/* URL after '?' */
static int len;		/* Length of query */

static void unescape(char *s)
{
	unsigned int c;

	//DanielDBG(fprintf(stderr,"%s();\n", __FUNCTION__);)

	while( (s = strpbrk(s, "%+")) )
	{
		/* Parse %xx */
		if (*s == '%')
		{
			sscanf(s + 1, "%02x", &c);
			*s++ = (char) c;
			strncpy(s, s + 2, strlen(s) + 1);
			DanielDBG(fprintf(stderr, "/* Parse %xx */\n");)
		}
		/* Space is special */
		else if (*s == '+')
		{
			DanielDBG(fprintf(stderr, "/* Space is special */\n");)
			*s++ = ' ';
		}
	}
}

void init_cgi(char *q)
{
	query = q;

	if (!query)
	{
		len = 0;
		return;
	}

	len = strlen(query);
	HTTPDBG(
	fprintf(stderr, "len=<%d>\n", len );
	fprintf(stderr, "q=<%s>\n", q);)

	/* Parse into individual assignments */
	while( strsep(&q, "&;") );

	/* Unescape each assignment */
	for( q = query ; q < (query + len) ; )
	{
		unescape(q);

		for( q += strlen(q) ; q < (query + len) && !*q ; q++ );
	}
}
char *get_cgi(char *name)
{
	char *q;

	if (!query)
		return NULL;

	for( q = query ; q < (query + len) ; )
	{
		if( !strncmp(q, name, strlen(name)) &&
		    q[strlen(name)] == '=')
			return &q[strlen(name) + 1] ;

		for( q += strlen(q) ; q < (query + len) && !*q ; q++ );
	}

	return NULL;
}
