/*
 * SVID hsearch (with GNU extensions) for VxWorks (implemented with hashLib)
 *
 * Copyright (C) 2003 Broadcom Corporation
 *
 * $Id: vxsearch.h,v 1.1 2003/01/29 18:08:01 mhuang Exp $
 */

#ifndef _vxsearch_h_
#define _vxsearch_h_

#include <hashLib.h>

typedef enum {
	FIND,
	ENTER
} ACTION;

typedef struct entry {
	H_NODE_STRING node;
	char *key;
	void *data;
} ENTRY;

struct hsearch_data {
	ENTRY *table;
	unsigned int size;
	unsigned int filled;
	HASH_ID id;
};

extern ENTRY *hsearch(ENTRY item, ACTION action);
extern int hcreate(size_t nel);
extern void hdestroy(void);
extern int hsearch_r(ENTRY item, ACTION action, ENTRY **retval, struct hsearch_data *htab);
extern int hcreate_r(size_t nel, struct hsearch_data *htab);
extern void hdestroy_r(struct hsearch_data *htab);

#endif
