/*
 * Copyright 2003-2004 by Gemtek Technology Co., Ltd
 *
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Gemtek not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 */
#include <stdio.h>
#include <sys/socket.h>
#include <resolv.h>
#include <arpa/inet.h>
#include <errno.h>
#include <sys/types.h>
#include <linux/if_ether.h>
#include <string.h>
#include <errno.h>

#include <sys/ioctl.h>
#include <sys/time.h>
#include <linux/sockios.h>
#include <linux/if_arp.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <shutils.h>
#include <bcmnvram.h>
#include <ap_shared.h>

#define ETH_SIZE		6
#define DSTIPADDR 		"234.2.2.2"
#define DSTMACADDR		"01:00:5E:02:02:02"
#define DSTPORT			14675
#define UDP_HDR_LEN 	8
#define BUFSIZE 		1024

#define DanielDBG(x)

#if 0
#define DUMPBUF( buf, start, end ) ({ \
	int i ; \
	for( i=start ; i<=end ; i++ ) \
	{ \
		if( i%16 == 3 ) \
			fprintf( stderr, "%02x | ", buf[i]&0xFF ); \
		else if ( i%16 == 7 ) \
			fprintf( stderr, "%02x | ", buf[i]&0xFF ); \
		else if ( i%16 == 11 ) \
			fprintf( stderr, "%02x | ", buf[i]&0xFF ); \
		else if ( i%16 == 15 ) \
			fprintf( stderr, "%02x\n", buf[i]&0xFF ); \
		else if ( i%16 == 0 ) \
			fprintf( stderr, "%08x | %02x ", i, buf[i]&0xFF ); \
		else \
			fprintf( stderr, "%02x ", buf[i]&0xFF ); \
	} \
	fprintf( stderr, "\n" ); \
})
#endif /* if 0 */

#ifdef AP_Repeater
struct eth_packet {			/* 14 bytes */
	unsigned char dst_hwaddr[ETH_SIZE];
	unsigned char src_hwaddr[ETH_SIZE];
	unsigned short unknown;
};

struct ip_packet { 			 /* 20 bytes */
	uint header_len:4;       /* header length in words in 32bit words */
    uint version:4;          /* 4-bit version */
    uint serve_type:8;       /* how to service packet */
    uint packet_len:16;      /* total size of packet in bytes */
    uint ID:16;              /* fragment ID */
    uint frag_offset:13;     /* to help reassembly */
    uint more_frags:1;       /* flag for "more frags to follow" */
    uint dont_frag:1;        /* flag to permit fragmentation */
    uint __reserved:1;       /* always zero */
    uint time_to_live:8;     /* maximum router hop count */
    uint protocol:8;         /* ICMP, UDP, TCP */
    ushort hdr_chksum;      /* ones-comp. checksum of header */
	struct in_addr IPv4_src;	/* IP address of originator */
	struct in_addr IPv4_dst; /* IP address of destination */
};

struct udp_packet {			/* 8 bytes */
	ushort src_port;		/* source port */
	ushort dst_port;		/* destination port */
	ushort length;			/* length */
	ushort chksum;			/* checksum */
};

struct psuedohdr  {
  struct in_addr source_address;
  struct in_addr dest_address;
  uchar place_holder;
  uchar protocol;
  ushort length;
} psuedohdr;

struct igmp_packet {
  unsigned char type;
  unsigned char reserved_1;
  ushort checksum;
  ushort reserved_2;
  ushort NumGroupRecord;
  unsigned char RecortType;
  unsigned char data_len;
  ushort NumSrc;
  struct in_addr MulticastAddr;
} ;

int AssignRequestPkt(char *packet, char *modle);
int AssignIGMPV3MembershipReportPkt(char *packet);
int getdevindex(int sock, char *name);
unsigned short check_sum(unsigned short *addr,int len);
unsigned short trans_check(	unsigned char proto, char *packet,
						    int length, struct in_addr source_address,
							struct in_addr dest_address);
int ParseResponsePkt(char *packet);
int do_sndpkt(void);
int do_rcvpkt(void);
#endif /* end of AP_Repeater */

extern void PANIC(char *msg);
#define PANIC(msg)	{perror(msg); exit(0);}

#ifdef AP_Repeater
int AssignRequestPkt(char *packet, char *modle)
{
	struct eth_packet *eth = (struct eth_packet *)packet ;
	struct ip_packet *ip = (struct ip_packet *)&packet[sizeof(struct eth_packet)] ;
	struct udp_packet *udp =(struct udp_packet *)&packet[sizeof(struct eth_packet)+
		                                                 sizeof(struct ip_packet)] ;
	char *request_data = (char *)&packet[sizeof(struct eth_packet)+
		                                 sizeof(struct ip_packet)+
									     sizeof(struct udp_packet)] ;
	char msg[50] ;
	struct in_addr saddr, daddr;
	char *remote_macaddr, *local_macaddr, *local_ipaddr ;
	int msg_len = 0, SRCPORT = 0 ;

	remote_macaddr = local_macaddr = local_ipaddr = NULL ;
	remote_macaddr = nvram_safe_get("ap_repeater_mac");
	local_macaddr = nvram_safe_get("et0macaddr");
	local_ipaddr = nvram_safe_get("wan_ipaddr");

	if( remote_macaddr == NULL || local_macaddr == NULL || local_ipaddr == NULL )
		return -1 ;

	/* select message */
	memset( msg, '\0', sizeof(msg) );
	if( !strcmp(modle, "wap54g") )
	{
		memcpy( msg, "MacWriterSearch", 15 );
		msg_len = 15 ;
		SRCPORT = 1033 ;
	}
	else
	{
		memcpy( msg, "AP1128ClientSearchingFor", 24 );
		msg_len = 24 ;
		SRCPORT = 14675 ;
	}

	saddr.s_addr = inet_addr(local_ipaddr);
	daddr.s_addr = inet_addr(DSTIPADDR);

	/* ETH */
	ether_atoe(DSTMACADDR, eth->dst_hwaddr);
	ether_atoe(local_macaddr, eth->src_hwaddr);
	eth->unknown = (ushort)htons(0x0800);

	/* IP */
	ip->version = 4 ;
	ip->header_len = (sizeof(struct ip_packet))>>2 ;
	ip->serve_type = 0 ;
	ip->packet_len = htons(sizeof(struct ip_packet)+sizeof(struct udp_packet)+msg_len) ;
	ip->ID = htons(getpid());
	ip->frag_offset = 0 ;
	ip->more_frags = 0 ;
	ip->dont_frag = 0 ;
	ip->__reserved = 0 ;
	ip->time_to_live = 3 ;
	ip->protocol = IPPROTO_UDP ;
	inet_aton(local_ipaddr, &ip->IPv4_src) ;
	inet_aton(DSTIPADDR, &ip->IPv4_dst) ;
	ip->hdr_chksum = (ushort)check_sum((ushort *)ip, sizeof(struct ip_packet));

	/* UDP */
	udp->src_port = htons(SRCPORT);
	udp->dst_port = htons(DSTPORT);
	udp->length = htons(UDP_HDR_LEN+msg_len);
	memcpy(request_data, msg, msg_len);
	udp->chksum = trans_check( IPPROTO_UDP, (char *)udp,
	                           (sizeof(struct udp_packet)+msg_len), saddr, daddr);

	return 0;
}
int AssignIGMPV3MembershipReportPkt(char *packet)
{
	struct eth_packet *eth = (struct eth_packet *)packet ;
	struct ip_packet *ip = (struct ip_packet *)&packet[sizeof(struct eth_packet)] ;
	struct igmp_packet *igmp =(struct igmp_packet *)&packet[sizeof(struct eth_packet)+
		                                                 sizeof(struct ip_packet)] ;
	struct in_addr saddr, daddr;
	char *local_macaddr, *local_ipaddr ;

	local_macaddr = local_ipaddr = NULL ;
	local_macaddr = nvram_safe_get("et0macaddr");
	local_ipaddr = nvram_safe_get("wan_ipaddr");

	if( local_macaddr == NULL || local_ipaddr == NULL )
		return -1 ;

	saddr.s_addr = inet_addr(local_ipaddr);
	daddr.s_addr = inet_addr("224.0.0.22");

	/* ETH */
	ether_atoe("01:00:5E:00:00:16", eth->dst_hwaddr);
	ether_atoe(local_macaddr, eth->src_hwaddr);
	eth->unknown = (ushort)htons(0x0800);

	/* IP */
	ip->version = 4 ;
	ip->header_len = (sizeof(struct ip_packet))>>2 ;
	ip->serve_type = 0 ;
	ip->packet_len = htons(sizeof(struct ip_packet)+sizeof(struct igmp_packet)) ;
	ip->ID = htons(getpid());
	ip->frag_offset = 0 ;
	ip->more_frags = 0 ;
	ip->dont_frag = 0 ;
	ip->__reserved = 0 ;
	ip->time_to_live = 3 ;
	ip->protocol = IPPROTO_IGMP ;
	inet_aton(local_ipaddr, &ip->IPv4_src) ;
	inet_aton("224.0.0.22", &ip->IPv4_dst) ;
	ip->hdr_chksum = (ushort)check_sum((ushort *)ip, sizeof(struct ip_packet));

	/* IGMP */
	igmp->type = 0x22 ;
	igmp->reserved_1 = 0 ;
	igmp->reserved_2 = 0 ;
	igmp->NumGroupRecord = (ushort)htons(0x0001);
	igmp->RecortType = 0x04 ;
	igmp->data_len = 0 ;
	igmp->NumSrc = 0 ;
	inet_aton("234.2.2.2", &igmp->MulticastAddr) ;
	igmp->checksum = (ushort)check_sum((ushort *)igmp, sizeof(struct igmp_packet));

	return 0;
}
int getdevindex(int sock, char *name)
{
    struct ifreq ifr;

    memset(&ifr, 0, sizeof(ifr));
    strncpy(ifr.ifr_name, name, sizeof(ifr.ifr_name));

    if(ioctl(sock, SIOCGIFINDEX, &ifr) == -1)
        PANIC("I can't get device flags");

	return ifr.ifr_ifindex;
}
unsigned short check_sum(unsigned short *addr,int len)
{
	register int sum = 0;
	u_short answer = 0;
	register u_short *w = addr;
	register int nleft = len;

	/*
	 * Our algorithm is simple, using a 32 bit accumulator (sum), we add
	 * sequential 16 bit words to it, and at the end, fold back all the
	 * carry bits from the top 16 bits into the lower 16 bits.
	 */
	while (nleft > 1)  {
			sum += *w++;
			nleft -= 2;
	}

	/* mop up an odd byte, if necessary */
	if (nleft == 1) {
			*(u_char *)(&answer) = *(u_char *)w ;
			sum += answer;
	}

	/* add back carry outs from top 16 bits to low 16 bits */
	sum = (sum >> 16) + (sum & 0xffff);     /* add hi 16 to low 16 */
	sum += (sum >> 16);                     /* add carry */
	answer = ~sum;                          /* truncate to 16 bits */
	return(answer);
}
unsigned short trans_check(
	unsigned char proto,
	char *packet,
	int length,
	struct in_addr source_address,
	struct in_addr dest_address)
{
	char *psuedo_packet;
  	ushort answer;

  	psuedohdr.protocol = proto;
  	psuedohdr.length = htons(length);
  	psuedohdr.place_holder = 0;

  	psuedohdr.source_address = source_address;
  	psuedohdr.dest_address = dest_address;

    if((psuedo_packet = malloc(sizeof(psuedohdr) + length)) == NULL)
		PANIC("malloc");

	bzero(psuedo_packet,(sizeof(psuedohdr) + length));
  	memcpy(psuedo_packet,&psuedohdr,sizeof(psuedohdr));
  	memcpy((psuedo_packet + sizeof(psuedohdr)),packet,length);

  	answer = (ushort)check_sum((ushort *)psuedo_packet,(length + sizeof(psuedohdr)));
  	free(psuedo_packet);

  	return answer;
}
int ParseResponsePkt(char *packet)
{
	struct eth_packet *eth = (struct eth_packet *)packet;
	char *remote_macaddr, *p, mac_buf[20], mac[6] ;
	int ret = 0 ;

	remote_macaddr = NULL ;
	remote_macaddr = nvram_safe_get("ap_repeater_mac");

	if( remote_macaddr == NULL )
		return -1 ;

	bzero(mac_buf, 20);
	bzero(mac, 6);

	strcpy(mac_buf, remote_macaddr);
	for( p=&mac_buf[0] ; *p ; p++ )
	{
		if( *p > 0x40 )
		{
			*p -= 0x40 ;

			if( *p > 0 )
				*p += 0x60 ;
		}
	}

	remote_macaddr = &mac_buf[0] ;
	ether_atoe(mac_buf, mac);

	if( !memcmp(mac, eth->src_hwaddr, 6) )
		ret = 1 ;

	return ret ;
}
int do_sndpkt(void)
{
	int sockd ;
	char buffer[BUFSIZE];
	struct sockaddr_ll to;
	int pkt_len = 0 ;
	int to_len = sizeof(struct sockaddr_in) ;
	int bytes_read, retval, data_len ;
	fd_set rfds;
    struct timeval tv;
	int ret = 0 ;
	char interface[10] ;
	int i, j, rcv_cnt=0, snd_cnt=0 ;

	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)

	/* Check interface of WDS */
	memset(interface, '\0', sizeof(interface));
	Get_WDS_Interface(interface);

	if( strlen(interface) == 0 )
		return ret ;

	if( (sockd = socket(PF_PACKET,SOCK_RAW,htons(ETH_P_ALL))) == -1 )
		PANIC("Can't create socket");

	if( (to.sll_ifindex = getdevindex(sockd,interface)) == -1 )
		PANIC("Can't get interface");

	tv.tv_sec = 2;
	tv.tv_usec = 0;

	for( i=0 ; i<4 ; i++ )
	{
		bzero(buffer, sizeof(buffer));

		if( i % 2 == 0 )
		{
			if( AssignRequestPkt(buffer, "wap54g") == -1 )
				PANIC("AssignRequestPkt error");
			data_len = 15 ;
		}
		else
		{
			if( AssignRequestPkt(buffer, "wap11v2.8") == -1 )
				PANIC("AssignRequestPkt error");
			data_len = 24 ;
		}

		pkt_len = sizeof(struct eth_packet)+sizeof(struct ip_packet)+
			      sizeof(struct udp_packet)+data_len;
		snd_cnt = sendto(sockd, buffer, pkt_len, 0, (struct sockaddr *)&to, sizeof(to));

		if( snd_cnt < 0 )
			PANIC("I can't send the packet");

		for( j=0 ; j<4 ; j++ )
		{
			FD_ZERO(&rfds);
			FD_SET(sockd, &rfds);
			ret = 0 ;
			retval = select(sockd+1, &rfds, NULL, NULL, &tv);

			if(retval > 0)
			{
				if(FD_ISSET(sockd, &rfds))
				{
					bzero(buffer, sizeof(buffer));
					bytes_read = recvfrom(sockd, buffer, sizeof(buffer), 0, (struct sockaddr *)&to, &to_len);

					if(bytes_read>0)
						ret = ParseResponsePkt(buffer);
				}
			}
			else if( retval == 0)
				DanielDBG(fprintf( stderr, "(%s)recvfrom timeout\n", __FUNCTION__ ));
			else
				DanielDBG(fprintf( stderr, "(%s)select error\n", __FUNCTION__ ));

			if(ret)
				rcv_cnt++;
		}
	}

	DanielDBG(fprintf( stderr, "(%s)rcv_cnt=%d\n", __FUNCTION__, rcv_cnt ));
	if( rcv_cnt > 0 )
		ret = 1 ;

	close(sockd);
	DanielDBG(fprintf( stderr, "\n");)
	return ret ;
}
int do_rcvpkt(void)
{
	int sockd ;
	char buffer[BUFSIZE];
    fd_set rfds;
    struct timeval tv;
    int retval, bytes_read;
	int ret = 0 ;
	int i, rcv_cnt=0 ;

	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)

	if( (sockd = socket(PF_INET, SOCK_PACKET, htons(ETH_P_ALL))) < 0 )
		PANIC("Snooper socket");

	tv.tv_sec = 2;
	tv.tv_usec = 0;

	for( i=0 ; i<10 ; i++ )
	{
		FD_ZERO(&rfds);
		FD_SET(sockd, &rfds);
		ret = 0 ;
		retval = select(sockd+1, &rfds, NULL, NULL, &tv);

		if(retval > 0)
		{
			if(FD_ISSET(sockd, &rfds))
			{
				bzero(buffer, sizeof(buffer));
				bytes_read = recvfrom(sockd, buffer, sizeof(buffer), 0, 0, 0);

				if( bytes_read > 0 )
					ret = ParseResponsePkt(buffer);
			}
		}
		else if( retval == 0)
			DanielDBG(fprintf( stderr, "(%s)recvfrom timeout\n", __FUNCTION__ ));
		else
			DanielDBG(fprintf( stderr, "(%s)select error\n", __FUNCTION__ ));

		if(ret)
			rcv_cnt++;
	}

	if( rcv_cnt > 0 )
		ret = 1 ;

	close(sockd);
	DanielDBG(fprintf( stderr, "\n");)
	return ret ;
}
int start_detect_link()
{
	int ret = 0 ;

	if(do_sndpkt())
	{
		ret = 1 ;
		goto ToClose ;
	}

	if(do_rcvpkt())
		ret = 1 ;

ToClose:
	DanielDBG(printf("(%s)ret=%d\n", __FUNCTION__, ret);)
    return ret;
}
int Get_WDS_Interface(char *wds_interface)
{
	char buf[BUFSIZE];
	char *p ;
	FILE *p_fp = NULL ;
	int hit = 0 ;

	p = NULL ;
	p_fp = popen( "/sbin/ifconfig", "r" );
	if( p_fp == NULL )
	{
		perror( "popen" );
		return -1 ;
	}

	while( !feof(p_fp) )
	{
		memset( buf, '\0', sizeof(buf) );
		fgets( buf, sizeof(buf), p_fp );

		p = strstr( buf, "wds" );
		if( p != NULL )
		{
			memcpy(wds_interface, p, 6);
			hit = 1 ;
			break;
		}
	}

	pclose(p_fp);
	return 0 ;
}
#endif /* end of AP_Repeater */
#ifdef SITESURVEY_QUEUE
void AssignContentToQueue(site_survey_t *a, site_survey_t *b)
{
	memcpy(a->SSID, b->SSID, 33);
	memcpy(a->Mode, b->Mode, 10);
	a->RSSI = b->RSSI;
	memcpy(a->noise, b->noise, 4);
	memcpy(a->Channel, b->Channel, 3);
	memcpy(a->BSSID, b->BSSID, 18);
	memcpy(a->Capability, b->Capability, 30);
	a->SupRate = b->SupRate;
	a->WPA = b->WPA;
}
SITESURVEY_LIST *AddItemToQueue(SITESURVEY_LIST *listpointer, site_survey_t *data)
{
    SITESURVEY_LIST *lp = listpointer ;
	site_survey_t *p ;

    if( listpointer != NULL )
	{
		while( listpointer->next != NULL )
	    	listpointer = listpointer->next;

		listpointer->next = (SITESURVEY_LIST *)malloc(sizeof(SITESURVEY_LIST));
		listpointer = listpointer->next;
		listpointer->next = NULL ;
		p = &listpointer->content[0] ;
		AssignContentToQueue(p, data);
		return lp;
    }
    else
	{	/* first time to add */
		listpointer = (SITESURVEY_LIST *) malloc(sizeof(SITESURVEY_LIST));
		listpointer->next = NULL;
		p = &listpointer->content[0] ;
		AssignContentToQueue(p, data);
		return listpointer;
    }
}
SITESURVEY_LIST *SortQueue(SITESURVEY_LIST *start)
{
	SITESURVEY_LIST *lp, *lq, *lr, *ls, *tmp, *prev ;
	site_survey_t *p, *q, *r ;
	int i = 0 ;

	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)

	if( start == NULL )
		fprintf( stderr, "queue is empty!\n" );
	else if( start->next == NULL )
		return start ;
    else
	{
		for( lp=prev=start ; lp != NULL ; lp=lp->next, i++ )
		{
			p = &lp->content[0] ;
			for( lq=lp->next ; lq != NULL ; lq=lq->next )
			{
				q = &lq->content[0] ;
				if( p->RSSI < q->RSSI )
				{
					if( i == 0 )
					{
						if( lp->next == lq )
						{
							tmp = lq->next ;
							lq->next = lp ;
							lp->next = tmp ;
							tmp = lp ;
							lp = lq ;
							lq = tmp ;
							start = lp ;
						}
						else
						{
							tmp = lq->next ;
							for( lr=ls=start->next ; ls->next != lq ; ls=ls->next );
							lp->next = tmp ;
							ls->next = lp ;
							lq->next = lr ;
							tmp = lp ;
							lp = lq ;
							lq = tmp ;
							start = lp ;
						}
					}
					else
					{
						if( lp->next == lq )
						{
							tmp = lq->next ;
							prev->next = lq ;
							lq->next = lp ;
							lp->next = tmp ;
							tmp = lp ;
							lp = lq ;
							lq = tmp ;
						}
						else
						{
							tmp = lq->next ;
							for( lr=ls=start->next ; ls->next != lq ; ls=ls->next );
							prev->next = lq ;
							lq->next = lp->next ;
							lp->next = tmp ;
							ls->next = lp ;
							tmp = lp ;
							lp = lq ;
							lq = tmp ;
						}
					}
					p = &lp->content[0] ;
					q = &lq->content[0] ;
				}
			}
			prev = lp ;
		}
	}

	return start ;
}
void PrintQueue(SITESURVEY_LIST *listpointer)
{
    SITESURVEY_LIST *lp = listpointer ;
	site_survey_t *p ;

	DanielDBG(fprintf(stderr, "\n%s()...\n", __FUNCTION__);)

	if( lp == NULL )
		printf ("queue is empty!\n");
    else
	{
		while( lp != NULL )
		{
			p = &lp->content[0] ;
			printf ("%s %s %d(dbm) %s\n", p->SSID, p->Mode, p->RSSI, p->BSSID);
			lp = lp->next;
		}
	}

	printf ("\n");
}
SITESURVEY_LIST *RemoveItemFromQueue(SITESURVEY_LIST *listpointer)
{
    SITESURVEY_LIST *temp;
	site_survey_t *p = &listpointer->content[0] ;

    temp = listpointer->next;
    free(listpointer);

    return temp;
}
void ClearQueue(SITESURVEY_LIST *listpointer)
{
	DanielDBG(fprintf(stderr, "\n%s()...\n", __FUNCTION__);)

	while(listpointer != NULL)
		listpointer = RemoveItemFromQueue(listpointer);

	listpointer = (SITESURVEY_LIST *)0 ;
}
#endif /* end of SITESURVEY_QUEUE */
#ifdef AP_Repeater
int ap_repeater_script(char *path)
{
	FILE *fp = NULL ;
	char *boardtype, *mac ;

	DanielDBG(fprintf(stderr, "%s(\"%s\")...\n", __FUNCTION__, path);)

	boardtype = mac = NULL ;
	boardtype = nvram_safe_get("boardtype");
	mac = nvram_safe_get("ap_repeater_mac");

	fp = fopen( path, "w" );
	if( fp == NULL )
	{
		DanielDBG(fprintf(stderr,"fopen %s error\n", path);)
		return -1 ;
	}

	fprintf( fp, "#!/bin/sh\n" );
	fprintf( fp, "/usr/sbin/nvram set wl_mode=\"ap\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl0_mode=\"ap\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl_lazywds=\"0\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl0_lazywds=\"0\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl_wds=\"\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl0_wds=\"\"\n" );
	fprintf( fp, "/usr/sbin/nvram set wl_wep=\"%s\"\n", nvram_safe_get("wl_wep"));
	fprintf( fp, "/usr/sbin/nvram set wl0_wep=\"%s\"\n", nvram_safe_get("wl_wep"));
	fprintf( fp, "/usr/sbin/nvram set wl_key=\"%s\"\n", nvram_safe_get("wl_key"));
	fprintf( fp, "/usr/sbin/nvram set wl0_key=\"%s\"\n", nvram_safe_get("wl_key"));
	fprintf( fp, "/usr/sbin/nvram set wl_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
	fprintf( fp, "/usr/sbin/nvram set wl0_key1=\"%s\"\n", nvram_safe_get("wl_key1"));
	fprintf( fp, "/usr/sbin/nvram set wl_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
	fprintf( fp, "/usr/sbin/nvram set wl0_key2=\"%s\"\n", nvram_safe_get("wl_key2"));
	fprintf( fp, "/usr/sbin/nvram set wl_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
	fprintf( fp, "/usr/sbin/nvram set wl0_key3=\"%s\"\n", nvram_safe_get("wl_key3"));
	fprintf( fp, "/usr/sbin/nvram set wl_key4=\"%s\"\n", nvram_safe_get("wl_key4"));
	fprintf( fp, "/usr/sbin/nvram set wl0_key4=\"%s\"\n", nvram_safe_get("wl_key4"));		
	fprintf( fp, "/usr/sbin/nvram set d11g_channel=\"%s\"\n", nvram_safe_get("d11g_channel"));
	fprintf( fp, "/usr/sbin/nvram set wl0_channel=\"%s\"\n", nvram_safe_get("d11g_channel"));
	fprintf( fp, "/usr/sbin/nvram set wl_ssid=\"%s\"\n", nvram_safe_get("wl_ssid"));
	fprintf( fp, "/usr/sbin/nvram set wl0_ssid=\"%s\"\n", nvram_safe_get("wl_ssid"));

	if( boardtype && (!memcmp(boardtype, "0x0446", 6) || !memcmp(boardtype, "0x0467", 6)) )
	{
		fprintf( fp, "/usr/sbin/wlconf eth1 down\n" );
		fprintf( fp, "/usr/sbin/wlconf eth1 up\n" );
		if( strlen(mac) != 0 )
		{
			fprintf( fp, "/usr/sbin/nvram set ap_repeater_mac=\"%s\"\n", mac);
			fprintf( fp, "/usr/sbin/wl -i eth1 wds %s\n", mac );
		}
	}
	else
	{
		fprintf( fp, "/usr/sbin/wlconf eth2 down\n" );
		fprintf( fp, "/usr/sbin/wlconf eth2 up\n" );
		if( strlen(mac) != 0 )
		{
			fprintf( fp, "/usr/sbin/nvram set ap_repeater_mac=\"%s\"\n", mac);
			fprintf( fp, "/usr/sbin/wl -i eth2 wds %s\n",mac );
		}
	}

	fprintf( fp, "/usr/sbin/nvram commit\n" );
	fprintf( fp, "sleep 2" );
	fclose(fp);
	chmod( path, S_IRUSR | S_IWUSR | S_IXUSR );

	return 0 ;
}
int SetAPRepeaterMode(char *macaddr, char *ssid, char *channel, char *wep, char *key_index, char *key)
{
	int ret = 0 ;

	DanielDBG(fprintf(stderr, "%s()...\n", __FUNCTION__);)
	DanielDBG(fprintf(stderr, "macaddr=<%s>\n", macaddr);)
	DanielDBG(fprintf(stderr, "ssid=<%s>\n", ssid);)
	DanielDBG(fprintf(stderr, "channel=<%s>\n", channel);)
	DanielDBG(fprintf(stderr, "wep=<%s>\n", wep);)

	ap_repeater_script("/tmp/ap_repeater_prev");

	nvram_set("ap_repeater_mac", macaddr);
	nvram_set("ap_repeater_channel", channel);
	nvram_set("d11g_channel", channel);

	if( !strcmp(wep, "enabled") )// Modified by Vic Yu , wep ==> enabled
	{
		nvram_set("wl_wep", wep);

		if( !strcmp(key_index, "1") )
		{
			nvram_set("wl_key", key_index);
			nvram_set("wl_key1", key);
		}
		else if( !strcmp(key_index, "2") )
		{
			nvram_set("wl_key", key_index);
			nvram_set("wl_key2", key);
		}
		else if( !strcmp(key_index, "3") )
		{
			nvram_set("wl_key", key_index);
			nvram_set("wl_key3", key);
		}
		else if( !strcmp(key_index, "4") )
		{
			nvram_set("wl_key", key_index);
			nvram_set("wl_key4", key);
		}
	}

	ap_repeater_script("/tmp/ap_repeater_easyconf");
	nvram_set("wl_ssid", ssid);
	ap_repeater_script("/tmp/ap_repeater_easyconf_change_ssid");
	system("/tmp/ap_repeater_easyconf");

	return ret ;
}
#endif /* end of AP_Repeater */
