.SS HL
This is used to modify the IPv6 HOPLIMIT header field.  The HOPLIMIT field is 
similar to what is known as TTL value in IPv4.  Setting or incrementing the
HOPLIMIT field can potentially be very dangerous, so it should be avoided at
any cost.  
.TP
.B Don't ever set or increment the value on packets that leave your local network!
.B mangle
table.
.TP
.BI "--hl-set " "value"
Set the HOPLIMIT value to `value'.
.TP
.BI "--hl-dec " "value"
Decrement the HOPLIMIT value `value' times.
.TP
.BI "--hl-inc " "value"
Increment the HOPLIMIT value `value' times.
.SS LOG
Turn on kernel logging of matching packets.  When this option is set
for a rule, the Linux kernel will print some information on all
matching packets (like most IPv6 IPv6-header fields) via the kernel log
(where it can be read with
.I dmesg
or 
.IR syslogd (8)).
This is a "non-terminating target", i.e. rule traversal continues at
the next rule.  So if you want to LOG the packets you refuse, use two
separate rules with the same matching criteria, first using target LOG
then DROP (or REJECT).
.TP
.BI "--log-level " "level"
Level of logging (numeric or see \fIsyslog.conf\fP(5)).
.TP
.BI "--log-prefix " "prefix"
Prefix log messages with the specified prefix; up to 29 letters long,
and useful for distinguishing messages in the logs.
.TP
.B --log-tcp-sequence
Log TCP sequence numbers. This is a security risk if the log is
readable by users.
.TP
.B --log-tcp-options
Log options from the TCP packet header.
.TP
.B --log-ip-options
Log options from the IPv6 packet header.
.SS MARK
This is used to set the netfilter mark value associated with the
packet.  It is only valid in the
.B mangle
table.
.TP
.BI "--set-mark " "mark"
.SS REJECT
This is used to send back an error packet in response to the matched
packet: otherwise it is equivalent to 
.B DROP
so it is a terminating TARGET, ending rule traversal.
This target is only valid in the
.BR INPUT ,
.B FORWARD
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  The following option controls the nature of the error packet
returned:
.TP
.BI "--reject-with " "type"
The type given can be
.nf
.B " icmp6-no-route"
.B " no-route"
.B " icmp6-adm-prohibited"
.B " adm-prohibited"
.B " icmp6-addr-unreachable"
.B " addr-unreach"
.B " icmp6-port-unreachable"
.B " port-unreach"
.fi
which return the appropriate IPv6-ICMP error message (\fBport-unreach\fP is
the default). Finally, the option
.B tcp-reset
can be used on rules which only match the TCP protocol: this causes a
TCP RST packet to be sent back.  This is mainly useful for blocking 
.I ident
(113/tcp) probes which frequently occur when sending mail to broken mail
hosts (which won't accept your mail otherwise).

.SS ROUTE
This is used to explicitly override the core network stack's routing decision.
.B mangle
table.
.TP
.BI "--oif " "ifname"
Route the packet through `ifname' network interface
.TP
.BI "--gw " "IPv6_address"
Route the packet via this gateway
.TP
.BI "--continue "
Behave like a non-terminating target and continue traversing the rules
.SS TRACE
This target has no options.  It just turns on 
.B packet tracing
for all packets that match this rule.
