.SS BALANCE
This allows you to DNAT connections in a round-robin way over a given range of destination addresses.
.TP
.BI "--to-destination " "ipaddr-ipaddr"
Address range to round-robin over.
.SS CLASSIFY
This module allows you to set the skb->priority value (and thus classify the packet into a specific CBQ class).
.TP
.BI "--set-class " "MAJOR:MINOR"
Set the major and minor class value.
.SS CLUSTERIP
This module allows you to configure a simple cluster of nodes that share
a certain IP and MAC address without an explicit load balancer in front of
them.  Connections are statically distributed between the nodes in this
cluster.
.TP
.BI "--new "
Create a new ClusterIP.  You always have to set this on the first rule
for a given ClusterIP.
.TP
.BI "--hashmode " "mode"
Specify the hashing mode.  Has to be one of
.B sourceip, sourceip-sourceport, sourceip-sourceport-destport
.TP
.BI "--clustermac " "mac"
Specify the ClusterIP MAC address.  Has to be a link-layer multicast address
.TP
.BI "--total-nodes " "num"
Number of total nodes within this cluster.
.TP
.BI "--local-node " "num"
Local node number within this cluster.
.TP
.BI "--hash-init " "rnd"
Specify the random seed used for hash initialization.
.SS CONNMARK
This module sets the netfilter mark value associated with a connection
.TP
.B --set-mark mark[/mask]
Set connection mark. If a mask is specified then only those bits set in the
mask is modified.
.TP
.B --save-mark [--mask mask]
Copy the netfilter packet mark value to the connection mark. If a mask
is specified then only those bits are copied.
.TP
.B --restore-mark [--mask mask]
Copy the connection mark value to the packet. If a mask is specified
then only those bits are copied. This is only valid in the
.B mangle
table.
.SS DNAT
This target is only valid in the
.B nat
table, in the
.B PREROUTING
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  It specifies that the destination address of the packet
should be modified (and all future packets in this connection will
also be mangled), and rules should cease being examined.  It takes one
type of option:
.TP
.BR "--to-destination " "\fIipaddr\fP[-\fIipaddr\fP][:\fIport\fP-\fIport\fP]"
which can specify a single new destination IP address, an inclusive
range of IP addresses, and optionally, a port range (which is only
valid if the rule also specifies
.B "-p tcp"
or
.BR "-p udp" ).
If no port range is specified, then the destination port will never be
modified.
.RS
.PP
You can add several --to-destination options.  If you specify more
than one destination address, either via an address range or multiple
--to-destination options, a simple round-robin (one after another in
cycle) load balancing takes place between these adresses.
.SS DSCP
This target allows to alter the value of the DSCP bits within the TOS
header of the IPv4 packet.  As this manipulates a packet, it can only
be used in the mangle table.
.TP
.BI "--set-dscp " "value"
Set the DSCP field to a numerical value (can be decimal or hex)
.TP
.BI "--set-dscp-class " "class"
Set the DSCP field to a DiffServ class.
.SS ECN
This target allows to selectively work around known ECN blackholes.
It can only be used in the mangle table.
.TP
.BI "--ecn-tcp-remove"
Remove all ECN bits from the TCP header.  Of course, it can only be used
in conjunction with
.BR "-p tcp" .
.SS LOG
Turn on kernel logging of matching packets.  When this option is set
for a rule, the Linux kernel will print some information on all
matching packets (like most IP header fields) via the kernel log
(where it can be read with
.I dmesg
or 
.IR syslogd (8)).
This is a "non-terminating target", i.e. rule traversal continues at
the next rule.  So if you want to LOG the packets you refuse, use two
separate rules with the same matching criteria, first using target LOG
then DROP (or REJECT).
.TP
.BI "--log-level " "level"
Level of logging (numeric or see \fIsyslog.conf\fP(5)).
.TP
.BI "--log-prefix " "prefix"
Prefix log messages with the specified prefix; up to 29 letters long,
and useful for distinguishing messages in the logs.
.TP
.B --log-tcp-sequence
Log TCP sequence numbers. This is a security risk if the log is
readable by users.
.TP
.B --log-tcp-options
Log options from the TCP packet header.
.TP
.B --log-ip-options
Log options from the IP packet header.
.SS MARK
This is used to set the netfilter mark value associated with the
packet.  It is only valid in the
.B mangle
table.  It can for example be used in conjunction with iproute2.
.TP
.BI "--set-mark " "mark"
.SS MASQUERADE
This target is only valid in the
.B nat
table, in the
.B POSTROUTING
chain.  It should only be used with dynamically assigned IP (dialup)
connections: if you have a static IP address, you should use the SNAT
target.  Masquerading is equivalent to specifying a mapping to the IP
address of the interface the packet is going out, but also has the
effect that connections are
.I forgotten
when the interface goes down.  This is the correct behavior when the
next dialup is unlikely to have the same interface address (and hence
any established connections are lost anyway).  It takes one option:
.TP
.BR "--to-ports " "\fIport\fP[-\fIport\fP]"
This specifies a range of source ports to use, overriding the default
.B SNAT
source port-selection heuristics (see above).  This is only valid
if the rule also specifies
.B "-p tcp"
or
.BR "-p udp" .
.SS MIRROR
This is an experimental demonstration target which inverts the source
and destination fields in the IP header and retransmits the packet.
It is only valid in the
.BR INPUT ,
.B FORWARD
and
.B PREROUTING
chains, and user-defined chains which are only called from those
chains.  Note that the outgoing packets are
.B NOT
seen by any packet filtering chains, connection tracking or NAT, to
avoid loops and other problems.
.SS NETMAP
This target allows you to statically map a whole network of addresses onto
another network of addresses.  It can only be used from rules in the
.B nat
table.
.TP
.BI "--to "  "address[/mask]"
Network address to map to.  The resulting address will be constructed in the
following way: All 'one' bits in the mask are filled in from the new `address'.
All bits that are zero in the mask are filled in from the original address.
.SS NOTRACK
This target disables connection tracking for all packets matching that rule.
.TP
It can only be used in the
.B raw
table.
.SS REDIRECT
This target is only valid in the
.B nat
table, in the
.B PREROUTING
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  It alters the destination IP address to send the packet to
the machine itself (locally-generated packets are mapped to the
127.0.0.1 address).  It takes one option:
.TP
.BR "--to-ports " "\fIport\fP[-\fIport\fP]"
This specifies a destination port or range of ports to use: without
this, the destination port is never altered.  This is only valid
if the rule also specifies
.B "-p tcp"
or
.BR "-p udp" .
.SS REJECT
This is used to send back an error packet in response to the matched
packet: otherwise it is equivalent to
.B DROP
so it is a terminating TARGET, ending rule traversal.
This target is only valid in the
.BR INPUT ,
.B FORWARD
and
.B OUTPUT
chains, and user-defined chains which are only called from those
chains.  The following option controls the nature of the error packet
returned:
.TP
.BI "--reject-with " "type"
The type given can be
.nf
.B " icmp-net-unreachable"
.B " icmp-host-unreachable"
.B " icmp-port-unreachable"
.B " icmp-proto-unreachable"
.B " icmp-net-prohibited"
.B " icmp-host-prohibited or"
.B " icmp-admin-prohibited (*)"
.fi
which return the appropriate ICMP error message (\fBport-unreachable\fP is
the default).  The option
.B tcp-reset
can be used on rules which only match the TCP protocol: this causes a
TCP RST packet to be sent back.  This is mainly useful for blocking 
.I ident
(113/tcp) probes which frequently occur when sending mail to broken mail
hosts (which won't accept your mail otherwise).
.TP
(*) Using icmp-admin-prohibited with kernels that do not support it will result in a plain DROP instead of REJECT
.SS ROUTE
This is used to explicitly override the core network stack's routing decision.
.B mangle
table.
.TP
.BI "--oif " "ifname"
Route the packet through `ifname' network interface
.TP
.BI "--iif " "ifname"
Change the packet's incoming interface to `ifname'
.TP
.BI "--gw " "IP_address"
Route the packet via this gateway
.TP
.BI "--continue "
Behave like a non-terminating target and continue traversing the rules.  Not valid in combination with `--iif'
.SS SNAT
This target is only valid in the
.B nat
table, in the
.B POSTROUTING
chain.  It specifies that the source address of the packet should be
modified (and all future packets in this connection will also be
mangled), and rules should cease being examined.  It takes one type
of option:
.TP
.BR "--to-source  " "\fIipaddr\fP[-\fIipaddr\fP][:\fIport\fP-\fIport\fP]"
which can specify a single new source IP address, an inclusive range
of IP addresses, and optionally, a port range (which is only valid if
the rule also specifies
.B "-p tcp"
or
.BR "-p udp" ).
If no port range is specified, then source ports below 512 will be
mapped to other ports below 512: those between 512 and 1023 inclusive
will be mapped to ports below 1024, and other ports will be mapped to
1024 or above. Where possible, no port alteration will occur.
.RS
.PP
You can add several --to-source options.  If you specify more
than one source address, either via an address range or multiple
--to-source options, a simple round-robin (one after another in
cycle) takes place between these adresses.
.SS TCPMSS
This target allows to alter the MSS value of TCP SYN packets, to control
the maximum size for that connection (usually limiting it to your
outgoing interface's MTU minus 40).  Of course, it can only be used
in conjunction with
.BR "-p tcp" .
.br
This target is used to overcome criminally braindead ISPs or servers
which block ICMP Fragmentation Needed packets.  The symptoms of this
problem are that everything works fine from your Linux
firewall/router, but machines behind it can never exchange large
packets:
.PD 0
.RS 0.1i
.TP 0.3i
1)
Web browsers connect, then hang with no data received.
.TP
2)
Small mail works fine, but large emails hang.
.TP
3)
ssh works fine, but scp hangs after initial handshaking.
.RE
.PD
Workaround: activate this option and add a rule to your firewall
configuration like:
.nf
 iptables -A FORWARD -p tcp --tcp-flags SYN,RST SYN \\
             -j TCPMSS --clamp-mss-to-pmtu
.fi
.TP
.BI "--set-mss " "value"
Explicitly set MSS option to specified value.
.TP
.B "--clamp-mss-to-pmtu"
Automatically clamp MSS value to (path_MTU - 40).
.TP
These options are mutually exclusive.
.SS TOS
This is used to set the 8-bit Type of Service field in the IP header.
It is only valid in the
.B mangle
table.
.TP
.BI "--set-tos " "tos"
You can use a numeric TOS values, or use
.nf
 iptables -j TOS -h
.fi
to see the list of valid TOS names.
.SS TRACE
This target has no options.  It just turns on 
.B packet tracing
for all packets that match this rule.
.SS TTL
This is used to modify the IPv4 TTL header field.  The TTL field determines
how many hops (routers) a packet can traverse until it's time to live is
exceeded.
.TP
Setting or incrementing the TTL field can potentially be very dangerous,
so it should be avoided at any cost.  
.TP
.B Don't ever set or increment the value on packets that leave your local network!
.B mangle
table.
.TP
.BI "--ttl-set " "value"
Set the TTL value to `value'.
.TP
.BI "--ttl-dec " "value"
Decrement the TTL value `value' times.
.TP
.BI "--ttl-inc " "value"
Increment the TTL value `value' times.
.SS ULOG
This target provides userspace logging of matching packets.  When this
target is set for a rule, the Linux kernel will multicast this packet
through a
.IR netlink 
socket. One or more userspace processes may then subscribe to various 
multicast groups and receive the packets.
Like LOG, this is a "non-terminating target", i.e. rule traversal
continues at the next rule.
.TP
.BI "--ulog-nlgroup " "nlgroup"
This specifies the netlink group (1-32) to which the packet is sent.
Default value is 1.
.TP
.BI "--ulog-prefix " "prefix"
Prefix log messages with the specified prefix; up to 32 characters
long, and useful for distinguishing messages in the logs.
.TP
.BI "--ulog-cprange " "size"
Number of bytes to be copied to userspace.  A value of 0 always copies
the entire packet, regardless of its size.  Default is 0.
.TP
.BI "--ulog-qthreshold " "size"
Number of packet to queue inside kernel.  Setting this value to, e.g. 10
accumulates ten packets inside the kernel and transmits them as one
netlink multipart message to userspace.  Default is 1 (for backwards
compatibility).
.br
