#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/poll.h>

#define TIME1970 2208988800UL

extern long get_offset( long gmtime, int tz_index );

char *timeZones[] =
{"International Date Line West",
 "Midway Island, Samoa",
 "Hawaii",
 "Alaska",
 "Pacific Time, Tijuana",
 "Arizona, Mazatlan",
 "Chihuahua, La Paz",
 "Mountain Time",
 "Central America",
 "Central Time",
 "Guadalajara, Mexico City, Monterrey",
 "Saskatchewan",
 "Bogota, Lima, Quito",
 "Eastern Time",
 "Indiana",
 "Atlantic Time",
 "Caracas, La Paz",
 "Santiago",
 "Newfoundland",
 "Brasilia",
 "Buenos Aires, Georgetown",
 "Greenland",
 "Mid-Atlantic",
 "Azores",
 "Cape Verde Is.",
 "Casablanca, Monrovia",
 "Greenwich Mean Time: Dublin, Edinburgh, Lisbon, London",
 "Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
 "Belgrade, Bratislava, Budapest, Ljubljana, Prague",
 "Brussels, Copenhagen, Madrid, Paris",
 "Sarajevo, Skopje, Warsaw, Zagreb",
 "West Central Africa",
 "Athens, Istanbul, Minsk",
 "Bucharest",
 "Cairo",
 "Harare, Pretoria",
 "Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
 "Jerusalem",
 "Baghdad",
 "Kuwait, Riyadh",
 "Moscow, St. Petersburg, Volgograd",
 "Nairobi",
 "Tehran",
 "Abu Dhabi, Muscat",
 "Baku, Tbilisi, Yerevan",
 "Kabul",
 "Ekaterinburg",
 "Islamabad, Karachi, Tashkent",
 "Chennai, Kolkata, Mumbai, New Delhi",
 "Kathmandu",
 "Almaty, Novosibirsk",
 "Astana, Dhaka",
 "Sri Jayawardenepura",
 "Rangoon",
 "Bangkok, Hanoi, Jakarta",
 "Krasnoyarsk",
 "Beijing, Chongquing, Hong Kong, Urumqi",
 "Irkutsk, Ulaan Bataar",
 "Kuala Lumpur, Singapore",
 "Perth",
 "Taipei",
 "Osaka, Sapporo, Tokyo",
 "Seoul",
 "Yakutsk",
 "Adelaide",
 "Darwin",
 "Brisbane",
 "Canberra, Melbourne, Sydney",
 "Guam, Port Moresby",
 "Hobart",
 "Vladivostok",
 "Magadan",
 "Solomon Is., New Caledonia",
 "Auckland, Wellington",
 "Fiji, Kamchatka, Marshall Is.",
 NULL };


int sntp(char *ntpserver, int tz_index)
{
  struct hostent *h;
  char **clist;
  int s;
  struct sockaddr_in to;
  unsigned int reply[12];
  int rep_siz;
  char msg[48];
  int retval;
  static int errHide= 0;
  struct timeval ntp_time;
  struct pollfd poll_fd;
  long gmtime;

  memset( msg, 0, 48 );
  msg[0] = 0x1b;

  h = gethostbyname( ntpserver );

  if( !h ) {
    if ( errHide == 0 ) {
      switch( h_errno ) {
        case HOST_NOT_FOUND:
          fprintf( stderr, "sntp: host not found\n" );
          break;
        case NO_ADDRESS:
          fprintf( stderr, "sntp: no IP addresses for that record.\n" );
          break;
        case NO_RECOVERY:
          fprintf( stderr, "sntp: non recoverable name server error.\n" );
          break;
        case TRY_AGAIN:
          fprintf( stderr, "sntp: try again later.\n" );
          break;
        default:
          fprintf( stderr, "sntp: unknown error (%d).\n", h_errno );
      }
      errHide++;
    }
    return 0;
  }

  errHide = 0;

  if( h->h_addrtype == AF_INET ) {
    to.sin_port = htons( 123 );
    to.sin_family = AF_INET;
    if( ( s = socket( PF_INET, SOCK_DGRAM, 0 ) ) == -1 )
      perror( "socket" );
    poll_fd.fd = s; /* We'll be polling shortly */
    poll_fd.events = POLLIN;
    for( clist = h->h_addr_list; *clist != NULL; clist++ ) {
      memcpy( (char *) &to.sin_addr.s_addr, *clist, h->h_length );
      retval =  sendto( s, msg, sizeof( msg ), 0, (struct sockaddr *) &to, sizeof( to ) );
      if( retval == -1 )
        perror( "sendto" );
      if( poll( &poll_fd, 1, 1000 ) ) {
        rep_siz = recv( s, reply, sizeof( reply ), 0 );
        if( rep_siz == sizeof( reply ) ) {
          gmtime = ntohl( reply[10] ) - TIME1970;
          /*      fprintf( stderr, "offset_secs == %d\n", get_offset( gmtime, tz_index )); */
          ntp_time.tv_sec = gmtime + get_offset( gmtime, tz_index );
          ntp_time.tv_usec = 0;
          settimeofday( &ntp_time, 0 );
          if ( s >= 0 )
             close(s);
          return 1;
        }
      }
    }
  }

  if ( s >= 0 )
    close(s);

  return 0;
}

int main(int argc, char **argv ) {
  char *servers[2];
  int tz_index = -1;
  int server_num = 0;
  unsigned int wait_time;
  int i, e;

  memset( servers, 0, sizeof( servers ) );

  for( i = 1; i < argc; i++ ) {

    if( strcmp( argv[i], "-s" ) == 0 ) {
      if( server_num < 2 ) {
        servers[server_num++] = strdup( argv[++i] );
      }
    } else if( strcmp( argv[i], "-t" ) == 0 ) {
      i++;
      for ( e = 0; timeZones[e] != NULL; e++ ) {
        if ( strcmp( timeZones[e], argv[i] ) == 0 ) {
          tz_index = e;
        }
      }
      if( tz_index == -1 ) {
        fprintf( stderr, "Invalid timezone: %s\n", argv[i] );
        exit(1);
      }

    } else {
      fprintf( stderr, "Unknown option: %s\n", argv[i] );
      exit(1);
    }
  }

  if ( server_num == 0 ) {
    fprintf( stderr, "No servers specified.\n" );
    exit(1);
  }

  if( tz_index == -1 ) {
    fprintf( stderr, "No timezone specified.\n" );
    exit(1);
  }

  for( ;; ) {
    wait_time = 5;
    for( i = 0; i < server_num; i++ ) {
      if( sntp( servers[i], tz_index ) ) {
        wait_time = 360;
        //fprintf( stderr, "Time set..\n" );
        break;
      }
    }
    sleep( wait_time ); // Poll server every minute
  }
}
