#ifdef BUILD_SNMP_ATMFORUM_MIB
/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.create-dataset.conf,v 5.3 2002/12/05 00:29:45 hardaker Exp $
 */
/* handler code is based on atmctl.c and atmMibHelper.c */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "atmForumHelper.h"
#include "atmMibHelper.h"
#include "atmMibDefs.h"
#include "autoconfig.h"
#include <bcmtypes.h>
#include <bcmatmapi.h>
#include <atmapidrv.h>

extern int getVccAddrs( int numAddrs, PATM_VCC_ADDR pAddrs );
extern int getAal5CpcsIfIndex( void );

#ifdef DO_ATMFAAL1PROFILETABLE
void
atmForumMibHelper_fillatmfAAL1ProfileTable
    (ATM_FORUM_MIB_ATMFAAL1PROFILETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL1PROFILETABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL1ProfileIndex =;
    p->atmfAAL1Subtype =;
    p->atmfAAL1CBRRate =;
    p->atmfAAL1ClkRecoveryType =;
    p->atmfAAL1FEC =;
    p->atmfAAL1SDT =;
    p->atmfAAL1PartiallyFilledCells =;
    p->atmfAAL1CellLossIntegrPeriod =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL1PROFILETABLE */

#ifdef DO_ATMFAAL2LESPROFILETABLE
void
atmForumMibHelper_fillatmfAAL2LESProfileTable
    (ATM_FORUM_MIB_ATMFAAL2LESPROFILETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL2LESPROFILETABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL2CpsCIDLowerLimit =;
    p->atmfAAL2CpsCIDUpperLimit =;
    p->atmfAAL2CpsOptimisation =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL2LESPROFILETABLE */

#ifdef DO_ATMFATMSERVICETYPETABLE
void atmForumMibHelper_setServiceTypeDefValues(ATM_FORUM_MIB_ATMFATMSERVICETYPETABLE * pEntry)
{
  memcpy(pEntry->atmfAtmServiceProviderName,ATMF_DEF_SERVICE_NAME,strlen(ATMF_DEF_SERVICE_NAME));
  pEntry->atmfAtmServiceProviderName_len = strlen(ATMF_DEF_SERVICE_NAME);

  memcpy(pEntry->atmfAtmServiceName,ATMF_DEF_SERVICE_NAME,strlen(ATMF_DEF_SERVICE_NAME));
  pEntry->atmfAtmServiceName_len = strlen(ATMF_DEF_SERVICE_NAME);

  /* client name could be ppp, mpeg-2 ... */
  memcpy(pEntry->atmfAtmServiceClient,ATMF_DEF_SERVICE_NAME,strlen(ATMF_DEF_SERVICE_NAME));
  pEntry->atmfAtmServiceClient_len = strlen(ATMF_DEF_SERVICE_NAME);

  pEntry->atmfAtmServiceTMCategory = ATMF_DEF_TDT_SERVICE_CAT;
  pEntry->atmfAtmServiceTMConformanceDef = ATMF_DEF_CONFORMANCE_DEF;
}

int atmForumMibHelper_getServiceTypeCount()
{
  return (atmMibHelper_getTotalVccCount());
}

void
atmForumMibHelper_fillatmfAtmServiceTypeTable
    (ATM_FORUM_MIB_ATMFATMSERVICETYPETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFATMSERVICETYPETABLE *p = pTable;
    int totalVccCount, i;

    /* for now hard coded index; but this should be true index of service of vccs */
    totalVccCount = atmMibHelper_getTotalVccCount();
    
    for (i = 1; i <= totalVccCount; i++) {
      atmForumMibHelper_setServiceTypeDefValues(p);
      p->pTableBeginning = pTable;
      p->atmfAtmServiceTypeIndex = i;
      if (i == totalVccCount) {
        /* the last row */
        p->next = NULL;
      }
      else {
        p->next = (p+1);
        p++;
      }
    } /* for all services */
}
#endif                          /* DO_ATMFATMSERVICETYPETABLE */

#ifdef DO_ATMFVPCABRTABLE
void
atmForumMibHelper_fillatmfVpcAbrTable(ATM_FORUM_MIB_ATMFVPCABRTABLE *
                                      pTable)
{
    ATM_FORUM_MIB_ATMFVPCABRTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfVpcAbrPortIndex =;
    p->atmfVpcAbrVpi =;
    p->atmfVpcAbrTransmitIcr =;
    p->atmfVpcAbrTransmitNrm =;
    p->atmfVpcAbrTransmitTrm =;
    p->atmfVpcAbrTransmitCdf =;
    p->atmfVpcAbrTransmitRif =;
    p->atmfVpcAbrTransmitRdf =;
    p->atmfVpcAbrTransmitAdtf =;
    p->atmfVpcAbrTransmitCrm =;

    p->next = NULL;
}
#endif                          /* DO_ATMFVPCABRTABLE */

#ifdef DO_ATMFAAL2TRUNKINGPROFILETABLE
void
atmForumMibHelper_fillatmfAAL2TrunkingProfileTable
    (ATM_FORUM_MIB_ATMFAAL2TRUNKINGPROFILETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL2TRUNKINGPROFILETABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL2Vcci =;
    p->atmfAAL2SignalingVcci =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL2TRUNKINGPROFILETABLE */

#ifdef DO_ATMFATMSERVICECONNINFOTABLE
/* get index to ConnServiceTypeRowIndex from AtmServiceConnInfotable */
int atmForumMibHelper_getConnServiceTypeRowIndex(int port, int vpi, int vci)
{
  /* first, check to see if atmServiceconn row is available for this port/vpi/vci */
  /* if not, create one (port/vpi/vci mapping to index) */
  return 1;
}

/* get index to AAL5ProfileRowIndex from AtmServiceConnInfotable */
int atmForumMibHelper_getAal5ProfileRowIndex(int port, int vpi, int vci)
{
  /* first, check to see if atmServiceconn row is available for this port/vpi/vci */
  /* if not, create one (port/vpi/vci mapping to index) */
  return 1;
}

void atmForumHelper_setConnInfoDefValues(ATM_FORUM_MIB_ATMFATMSERVICECONNINFOTABLE * pEntry)
{
  pEntry->atmfAtmServiceSignalId = ATMF_DEF_SERVICE_SIGNAL_ID_VCCI;
  pEntry->atmfAtmServiceConnName[0] = (unsigned char)NULL;
  pEntry->atmfAtmServiceConnAALType = ATMF_CONN_AAL_TYPE_AAL5;
}

void
atmForumMibHelper_fillatmfAtmServiceConnInfoTable
    (ATM_FORUM_MIB_ATMFATMSERVICECONNINFOTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFATMSERVICECONNINFOTABLE *p = pTable;
    int atmPortCount, atmVccCount;
    int i;
    int port=0, vpi=0, vci=0;
    PATM_VCC_ADDR pAddrs, pFreeAddrs;

    atmPortCount = atmMibHelper_getAtmIfCount();
    atmVccCount = atmMibHelper_getTotalVccCount();

    /* get all the vccs configured on this port */
    /* allocate memory for ATM_VCC_ADDR to whole addresses of these configured vcc */
    pAddrs = (PATM_VCC_ADDR)malloc( atmVccCount*(sizeof(ATM_VCC_ADDR) + sizeof(UINT8)));

    if (pAddrs) {
      pFreeAddrs = pAddrs;
      if ( getVccAddrs(atmVccCount, pAddrs ) == 0 ) {
        for ( i = 1; i <= atmVccCount; i++, pAddrs++ ) {
          port = pAddrs->ulInterfaceId;
          vpi = pAddrs->usVpi;
          vci = pAddrs->usVci;
          atmForumHelper_setConnInfoDefValues(p);
          p->pTableBeginning = pTable;
          p->atmfAtmServicePortIndex = port;
          p->atmfAtmServiceVpi = vpi;
          p->atmfAtmServiceVci = vci;
         
          /* p->atmfAtmServiceConnServiceIndex = 
             atmForumMibHelper_getConnServiceTypeRowIndex(int port, int vpi, int vci); */
          p->atmfAtmServiceConnServiceIndex = i;

          /* p->atmfAtmServiceConnAALIndex = atmForumMibHelper_getAal5ProfileRowIndex(port,vpi,vci); */
          p->atmfAtmServiceConnAALIndex = i;

          if ( i == atmVccCount ) {
            /* the last row */
            p->next = NULL;
          }
          else {
            p->next = (p+1);
            p++;
          }
        } /* for each Vcc */
      }
      free(pFreeAddrs);
    } /* pAddrs */
}
#endif                          /* DO_ATMFATMSERVICECONNINFOTABLE */

#ifdef DO_ATMFNETPREFIXTABLE
void
atmForumMibHelper_fillatmfNetPrefixTable(ATM_FORUM_MIB_ATMFNETPREFIXTABLE *
                                         pTable)
{
    ATM_FORUM_MIB_ATMFNETPREFIXTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfNetPrefixPort =;
    p->atmfNetPrefixPrefix =;
    p->atmfNetPrefixStatus =;

    p->next = NULL;
}
#endif                          /* DO_ATMFNETPREFIXTABLE */

#ifdef DO_ATMFVCCABRTABLE
void
atmForumMibHelper_fillatmfVccAbrTable(ATM_FORUM_MIB_ATMFVCCABRTABLE *
                                      pTable)
{
    ATM_FORUM_MIB_ATMFVCCABRTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfVccAbrPortIndex =;
    p->atmfVccAbrVpi =;
    p->atmfVccAbrVci =;
    p->atmfVccAbrTransmitIcr =;
    p->atmfVccAbrTransmitNrm =;
    p->atmfVccAbrTransmitTrm =;
    p->atmfVccAbrTransmitCdf =;
    p->atmfVccAbrTransmitRif =;
    p->atmfVccAbrTransmitRdf =;
    p->atmfVccAbrTransmitAdtf =;
    p->atmfVccAbrTransmitCrm =;

    p->next = NULL;
}
#endif                          /* DO_ATMFVCCABRTABLE */

#ifdef DO_ATMFAAL5PROFILETABLE
void atmForumHelper_setAal5ProfileDefValues(ATM_FORUM_MIB_ATMFAAL5PROFILETABLE *pEntry)
{
  pEntry->atmfAAL5MaxCpcsSduSizeForward = ATMF_AAL5_MAX_CPCS_SDU_SIZE;
  pEntry->atmfAAL5MaxCpcsSduSizeBackward = ATMF_AAL5_MAX_CPCS_SDU_SIZE;
  pEntry->atmfAAL5AALMode = ATMF_AAL5_AAL_MODE_MESSAGE_UNASSURED;
  pEntry->atmfAAL5SscsType = ATMF_AAL5_AAL_SSCS_NULL;
}

void
atmForumMibHelper_fillatmfAAL5ProfileTable
    (ATM_FORUM_MIB_ATMFAAL5PROFILETABLE * pTable)
{
  ATM_FORUM_MIB_ATMFAAL5PROFILETABLE *p = pTable;
  int i;
  int profileCount;

  /* for testing only */
  profileCount = atmMibHelper_getTotalVccCount();

  if ( profileCount > 0 ) {
    for ( i = 1; i <= profileCount; i++) {
      atmForumHelper_setAal5ProfileDefValues(p);
      p->pTableBeginning = pTable;
      /* p->atmfAAL5ProfileIndex = atmForumMibHelper_getAal5ProfileRowIndex(port,vpi,vci) */
      p->atmfAAL5ProfileIndex = i;

      if ( i == profileCount ) {
        /* The last row */
        p->next = NULL;
      }
      else {
        p->next = (p+1);
        p++;
      }
    } /* for */
  }
}
#endif                          /* DO_ATMFAAL5PROFILETABLE */

#ifdef DO_ATMFATMSERVICECONNINFOEXTENSIONTABLE
void
atmForumMibHelper_fillatmfAtmServiceConnInfoExtensionTable
    (ATM_FORUM_MIB_ATMFATMSERVICECONNINFOEXTENSIONTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFATMSERVICECONNINFOEXTENSIONTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->atmfAtmServicePhyMacIdentifier = ATMF_SERVICE_PHY_MAC_ID_SINGLE_LATENCY;

    p->next = NULL;
}
#endif                          /* DO_ATMFATMSERVICECONNINFOEXTENSIONTABLE */

#ifdef DO_ATMFAAL34PROFILETABLE
void
atmForumMibHelper_fillatmfAAL34ProfileTable
    (ATM_FORUM_MIB_ATMFAAL34PROFILETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL34PROFILETABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL34ProfileIndex =;
    p->atmfAAL34MaxCpcsSduSizeForward =;
    p->atmfAAL34MaxCpcsSduSizeBackward =;
    p->atmfAAL34MIDRangeLow =;
    p->atmfAAL34MIDRangeHigh =;
    p->atmfAAL34AALMode =;
    p->atmfAAL34SscsType =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL34PROFILETABLE */

#ifdef DO_ATMFSRVCREGTABLE
void
atmForumMibHelper_fillatmfSrvcRegTable(ATM_FORUM_MIB_ATMFSRVCREGTABLE *
                                       pTable)
{
    ATM_FORUM_MIB_ATMFSRVCREGTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfSrvcRegPort =;
    p->atmfSrvcRegServiceID =;
    p->atmfSrvcRegATMAddress =;
    p->atmfSrvcRegAddressIndex =;
    p->atmfSrvcRegParm1 =;

    p->next = NULL;
}
#endif                          /* DO_ATMFSRVCREGTABLE */

#ifdef DO_ATMFADDRESSREGISTRATIONADMINTABLE
void
atmForumMibHelper_fillatmfAddressRegistrationAdminTable
    (ATM_FORUM_MIB_ATMFADDRESSREGISTRATIONADMINTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFADDRESSREGISTRATIONADMINTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAddressRegistrationAdminIndex =;
    p->atmfAddressRegistrationAdminStatus =;

    p->next = NULL;
}
#endif                          /* DO_ATMFADDRESSREGISTRATIONADMINTABLE */

#ifdef DO_ATMFATMSTATSTABLE
void
atmForumMibHelper_fillatmfAtmStatsTable(ATM_FORUM_MIB_ATMFATMSTATSTABLE *
                                        pTable)
{
    ATM_FORUM_MIB_ATMFATMSTATSTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAtmStatsIndex =;
    p->atmfAtmStatsReceivedCells =;
    p->atmfAtmStatsDroppedReceivedCells =;
    p->atmfAtmStatsTransmittedCells =;

    p->next = NULL;
}
#endif                          /* DO_ATMFATMSTATSTABLE */

#ifdef DO_ATMFAAL5PROFILEEXTENSIONTABLE
void
atmForumMibHelper_fillatmfAAL5ProfileExtensionTable
    (ATM_FORUM_MIB_ATMFAAL5PROFILEEXTENSIONTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL5PROFILEEXTENSIONTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL5Vcci =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL5PROFILEEXTENSIONTABLE */

#ifdef DO_ATMFAAL2COMMONPROFILETABLE
void
atmForumMibHelper_fillatmfAAL2CommonProfileTable
    (ATM_FORUM_MIB_ATMFAAL2COMMONPROFILETABLE * pTable)
{
    ATM_FORUM_MIB_ATMFAAL2COMMONPROFILETABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAAL2ProfileIndex =;
    p->atmfAAL2ApplicationIdentifier =;
    p->atmfAAL2ConfigResponsibility =;
    p->atmfAAL2CpsMaxMultiplexedChannels =;
    p->atmfAAL2CpsMaxSduLength =;
    p->atmfAAL2SscsMaxSssarSduLength =;
    p->atmfAAL2SscsSstedStatus =;
    p->atmfAAL2SscsSsadtStatus =;
    p->atmfAAL2SscsServiceCategory =;
    p->atmfAAL2SscsAudioServiceTransport =;
    p->atmfAAL2SscsProfileSource =;
    p->atmfAAL2SscsIeeeOui =;
    p->atmfAAL2SscsPredefinedProfileIdentifier =;
    p->atmfAAL2SscsPcmEncoding =;
    p->atmfAAL2SscsFaxDemodulationTransport =;
    p->atmfAAL2SscsCasSignalingTransport =;
    p->atmfAAL2SscsDtmfDigitPacketTransport =;
    p->atmfAAL2SscsMfR1DigitPacketTransport =;
    p->atmfAAL2SscsMfR2DigitPacketTransport =;
    p->atmfAAL2SscsCircuitModeDataTransport =;
    p->atmfAAL2SscsCircuitModeDataNumChannels =;
    p->atmfAAL2SscsFrameModeDataTransport =;
    p->atmfAAL2SscsFrameModeDataMaxLength =;
    p->atmfAAL2SscopSduLength =;
    p->atmfAAL2SscopUuFieldLength =;

    p->next = NULL;
}
#endif                          /* DO_ATMFAAL2COMMONPROFILETABLE */

#ifdef DO_ATMFVPCTABLE
void
atmForumMibHelper_fillatmfVpcTable(ATM_FORUM_MIB_ATMFVPCTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFVPCTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfVpcPortIndex =;
    p->atmfVpcVpi =;
    p->atmfVpcOperStatus =;
    p->atmfVpcTransmitTrafficDescriptorType =;
    p->atmfVpcTransmitTrafficDescriptorParam1 =;
    p->atmfVpcTransmitTrafficDescriptorParam2 =;
    p->atmfVpcTransmitTrafficDescriptorParam3 =;
    p->atmfVpcTransmitTrafficDescriptorParam4 =;
    p->atmfVpcTransmitTrafficDescriptorParam5 =;
    p->atmfVpcReceiveTrafficDescriptorType =;
    p->atmfVpcReceiveTrafficDescriptorParam1 =;
    p->atmfVpcReceiveTrafficDescriptorParam2 =;
    p->atmfVpcReceiveTrafficDescriptorParam3 =;
    p->atmfVpcReceiveTrafficDescriptorParam4 =;
    p->atmfVpcReceiveTrafficDescriptorParam5 =;
    p->atmfVpcQoSCategory =;
    p->atmfVpcTransmitQoSClass =;
    p->atmfVpcReceiveQoSClass =;
    p->atmfVpcBestEffortIndicator =;
    p->atmfVpcServiceCategory =;

    p->next = NULL;
}
#endif                          /* DO_ATMFVPCTABLE */

#ifdef DO_ATMFATMLAYERTABLE
void
atmForumMibHelper_fillatmfAtmLayerTable(ATM_FORUM_MIB_ATMFATMLAYERTABLE *
                                        pTable)
{
    ATM_FORUM_MIB_ATMFATMLAYERTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->atmfAtmLayerIndex = 0;   /* getAtmCellIfIndex(); */
    p->atmfAtmLayerMaxVPCs = ATM_INTF_MAX_VPCS;
    p->atmfAtmLayerMaxVCCs = ATM_INTF_MAX_VCCS;
    p->atmfAtmLayerConfiguredVPCs = ATM_INTF_CONF_VPCS;
    p->atmfAtmLayerConfiguredVCCs = atmMibHelper_getTotalVccCount();
    p->atmfAtmLayerMaxVpiBits = ATM_INTF_CURRENT_MAX_VPI_BITS;
    p->atmfAtmLayerMaxVciBits = ATM_INTF_CURRENT_MAX_VCI_BITS;
    p->atmfAtmLayerUniType =  ATMF_ATMLAYER_UNI_TYPE_PRIVATE;
    p->atmfAtmLayerUniVersion = ATMF_ATMLAYER_UNI_VERSION_UNSUPPORTED;
    p->atmfAtmLayerDeviceType = ATMF_ATMLAYER_DEVICE_TYPE_USER;
    p->atmfAtmLayerIlmiVersion = ATMF_ATMLAYER_ILMI_VERSION_4_POINT_0;
    p->atmfAtmLayerNniSigVersion = ATMF_ATMLAYER_NNISIG_VERSION_UNSUPPORTED;
    p->atmfAtmLayerMaxSvpcVpi = ATMF_ATMLAYER_MAX_SVPC_VPI;
    p->atmfAtmLayerMaxSvccVpi = ATMF_ATMLAYER_MAX_SVCC_VPI;
    p->atmfAtmLayerMinSvccVci = ATMF_ATMLAYER_MAX_SVCC_VCI;
    p->next = NULL;
}
#endif                          /* DO_ATMFATMLAYERTABLE */

#ifdef DO_ATMFADDRESSTABLE
void
atmForumMibHelper_fillatmfAddressTable(ATM_FORUM_MIB_ATMFADDRESSTABLE *
                                       pTable)
{
    ATM_FORUM_MIB_ATMFADDRESSTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->index =;

    p->atmfAddressPort =;
    p->atmfAddressAtmAddress =;
    p->atmfAddressStatus =;
    p->atmfAddressOrgScope =;

    p->next = NULL;
}
#endif                          /* DO_ATMFADDRESSTABLE */

#ifdef DO_ATMFPORTTABLE
void
atmForumMibHelper_fillatmfPortTable(ATM_FORUM_MIB_ATMFPORTTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFPORTTABLE *p = pTable;

    p->pTableBeginning = pTable;
    p->atmfPortIndex = 0;  /* getAtmCellIfIndex(); */
    memcpy(p->atmfPortMyIfName,ATM_CELL_LAYER_IFNAME,strlen(ATM_CELL_LAYER_IFNAME));
    p->atmfPortMyIfName_len = strlen(ATM_CELL_LAYER_IFNAME);
    p->atmfPortMyIfIdentifier = getAtmCellIfIndex();
    p->next = NULL;
}
#endif                          /* DO_ATMFPORTTABLE */

#ifdef DO_ATMFVCCTABLE
/* default to atmfTrafficDescrTypes 3 which is atmfNoClpNoScr */
static oid defAtmfTrafficDescriptor[ATMF_TRAFDESC_OIDLEN]  = { 1, 3, 6, 1, 4, 1, 353, 1, 4, 3 };
void atmForumMibHelper_updateTdType(oid *pEntry, int type)
{
  int mappedType;

  switch (type)
    {
    case TDT_ATM_NO_TRAFFIC_DESCRIPTOR:
    case TDT_ATM_NO_CLP_NO_SCR:
    case TDT_ATM_CLP_NO_TAGGING_NO_SCR:
    case TDT_ATM_CLP_TAGGING_NO_SCR:
      mappedType = ATMF_NO_CLP_NO_SCR;
      break;
    case TDT_ATM_NO_CLP_SCR:
      mappedType = ATMF_NO_CLP_SCR;
      break;
    case TDT_ATM_CLP_NO_TAGGING_SCR:
      mappedType = ATMF_CLP_NO_TAGGING_SCR;
      break;
    case TDT_ATM_CLP_TAGGING_SCR:
      mappedType = ATMF_CLP_TAGGING_SCR;
      break;
    case TDT_ATM_CLP_NO_TAGGING_MCR:
      mappedType = ATMF_CLP_NO_TAGGING_MCR;
      break;
    default:
      mappedType = ATMF_NO_CLP_NO_SCR;
      break;
    }
  pEntry[ATM_TRAFDESC_OIDLEN-1]=(oid)mappedType;
}

void atmForumMibHelper_updateOperStatus(ATM_FORUM_MIB_ATMFVCCTABLE * pEntry, UINT8 status)
{
  if (status == OPRSTS_UP)
    pEntry->atmfVccOperStatus = ATMF_VCC_STATUS_LOCAL_UP_END2END_UNKNOWN;
  else
    pEntry->atmfVccOperStatus = ATMF_VCC_STATUS_LOCAL_DOWN;
}

void atmForumHelper_setVccDefValues(ATM_FORUM_MIB_ATMFVCCTABLE * pEntry)
{
  pEntry->atmfVccPortIndex = ATMF_DEF_PORT_INDEX;
  pEntry->atmfVccOperStatus = ATMF_VCC_STATUS_LOCAL_DOWN;
  memcpy(pEntry->atmfVccTransmitTrafficDescriptorType,defAtmfTrafficDescriptor,
         sizeof(defAtmfTrafficDescriptor));
  pEntry->atmfVccTransmitTrafficDescriptorType_len = ATMF_TRAFDESC_OIDLEN;
  pEntry->atmfVccTransmitTrafficDescriptorParam1 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccTransmitTrafficDescriptorParam2 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccTransmitTrafficDescriptorParam3 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccTransmitTrafficDescriptorParam4 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccTransmitTrafficDescriptorParam5 = ATMF_DEF_TDT_PARAM;
  memcpy(pEntry->atmfVccReceiveTrafficDescriptorType,defAtmfTrafficDescriptor,
         sizeof(defAtmfTrafficDescriptor));
  pEntry->atmfVccReceiveTrafficDescriptorType_len = ATMF_TRAFDESC_OIDLEN;
  pEntry->atmfVccReceiveTrafficDescriptorParam1 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccReceiveTrafficDescriptorParam2 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccReceiveTrafficDescriptorParam3 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccReceiveTrafficDescriptorParam4 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccReceiveTrafficDescriptorParam5 = ATMF_DEF_TDT_PARAM;
  pEntry->atmfVccBestEffortIndicator = ATMF_DEF_BEST_EFFORT;
  pEntry->atmfVccTransmitFrameDiscard = ATMF_DEF_FRAME_DISCARD;
  pEntry->atmfVccReceiveFrameDiscard = ATMF_DEF_FRAME_DISCARD;
  pEntry->atmfVccServiceCategory = ATMF_DEF_TDT_SERVICE_CAT;
}

void
atmForumMibHelper_fillatmfVccTable(ATM_FORUM_MIB_ATMFVCCTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFVCCTABLE   *p = pTable;
    ATM_VCC_CFG cfg;
    PATM_VCC_ADDR pAddrs, pFreeAddrs = NULL;
    UINT32 atmTdtSize = 0;
    PATM_TRAFFIC_DESCR_PARM_ENTRY pTdt, pTdtEntry, pFreeTdt = NULL;
    int atmPortCount, atmVccCount;
    int i, nRet;

    atmPortCount = atmMibHelper_getAtmIfCount();
    atmVccCount = atmMibHelper_getTotalVccCount();
    BcmAtm_GetTrafficDescrTableSize(&atmTdtSize);

    /* get all the vccs configured on this port */
    /* allocate memory for ATM_VCC_ADDR to whole addresses of these configured vcc */
    pAddrs = (PATM_VCC_ADDR)malloc( atmVccCount*(sizeof(ATM_VCC_ADDR) + sizeof(UINT8)));
      
    /* allocate memory for Traffic descriptor table */
    pTdt = (PATM_TRAFFIC_DESCR_PARM_ENTRY) malloc(atmTdtSize * sizeof(ATM_TRAFFIC_DESCR_PARM_ENTRY) );
    if (pTdt) {
      pFreeTdt = pTdt;
      pTdt->ulStructureId = ID_ATM_TRAFFIC_DESCR_PARM_ENTRY;
      BcmAtm_GetTrafficDescrTable(pTdt, atmTdtSize);
    }

    if (pAddrs) {
      pFreeAddrs = pAddrs;
      if ( getVccAddrs(atmVccCount, pAddrs ) == 0 ) {
        for ( i = 1; i <= atmVccCount; i++, pAddrs++ ) {
          atmForumHelper_setVccDefValues(p);
          p->pTableBeginning = pTable;
          //          p->index = getAal5CpcsIfIndex();
          memset( &cfg, 0, sizeof(cfg) );
          cfg.ulStructureId = ID_ATM_VCC_CFG;
          nRet = (int) BcmAtm_GetVccCfg( pAddrs, &cfg );
          if ( nRet == 0 ) {
            p->atmfVccPortIndex = pAddrs->ulInterfaceId;
            p->atmfVccVpi = pAddrs->usVpi;
            p->atmfVccVci = pAddrs->usVci;
            atmForumMibHelper_updateOperStatus(p,cfg.ulAtmVclOperStatus);
            pTdtEntry = &pTdt[cfg.ulAtmVclTransmitTrafficDescrIndex-1];
            atmForumMibHelper_updateTdType(p->atmfVccTransmitTrafficDescriptorType,
                                           pTdtEntry->ulTrafficDescrType);
            p->atmfVccTransmitTrafficDescriptorParam1 = pTdtEntry->ulTrafficDescrParm1;
            p->atmfVccTransmitTrafficDescriptorParam2 = pTdtEntry->ulTrafficDescrParm2;
            p->atmfVccTransmitTrafficDescriptorParam3 = pTdtEntry->ulTrafficDescrParm3;
            p->atmfVccTransmitTrafficDescriptorParam4 = pTdtEntry->ulTrafficDescrParm4;
            p->atmfVccTransmitTrafficDescriptorParam5 = pTdtEntry->ulTrafficDescrParm5;
            /* tx is the same as tx descriptor in our implentation */
            atmForumMibHelper_updateTdType(p->atmfVccReceiveTrafficDescriptorType,
                                           pTdtEntry->ulTrafficDescrType);
            p->atmfVccReceiveTrafficDescriptorParam1 = pTdtEntry->ulTrafficDescrParm1;
            p->atmfVccReceiveTrafficDescriptorParam2 = pTdtEntry->ulTrafficDescrParm2;
            p->atmfVccReceiveTrafficDescriptorParam3 = pTdtEntry->ulTrafficDescrParm3;
            p->atmfVccReceiveTrafficDescriptorParam4 = pTdtEntry->ulTrafficDescrParm4;
            p->atmfVccReceiveTrafficDescriptorParam5 = pTdtEntry->ulTrafficDescrParm5;
            p->atmfVccServiceCategory = pTdtEntry->ulServiceCategory;
            p->atmfVccTransmitFrameDiscard  = pTdtEntry->ulTrafficFrameDiscard;
            p->atmfVccReceiveFrameDiscard  = pTdtEntry->ulTrafficFrameDiscard;
                
            if ( i == atmVccCount ) {
              /* the last row */
              p->next = NULL;
            }
            else {
              p->next = (p+1);
              p++;
            }
          }  /* getVccCfg ok */
        } /* for each Vcc */
      } /* get vcc addrs ok */
      free(pFreeAddrs);
      if (pFreeTdt)
        free(pFreeTdt);
    } /* pAddrs */
}
#endif                          /* DO_ATMFVCCTABLE */

#ifdef DO_ATMFATMSERVICETYPEEXTENSIONTABLE
void atmForumHelper_setServiceTypeExtDefValues(ATM_FORUM_MIB_ATMFATMSERVICETYPEEXTENSIONTABLE * pEntry)
{
  memcpy(pEntry->atmfAtmServiceLayer2ProtocolId,AUTOCONFIG_LAYER2_LLC_ENCAP,
         strlen(AUTOCONFIG_LAYER2_LLC_ENCAP));
  pEntry->atmfAtmServiceLayer2ProtocolId_len = strlen(AUTOCONFIG_LAYER2_LLC_ENCAP);
  memcpy(pEntry->atmfAtmServiceLayer3ProtocolId,AUTOCONFIG_LAYER3_BRIDGE_LLC_SNAP_NO_FCS,
         strlen(AUTOCONFIG_LAYER3_BRIDGE_LLC_SNAP_NO_FCS));
  pEntry->atmfAtmServiceLayer3ProtocolId_len = strlen(AUTOCONFIG_LAYER3_BRIDGE_LLC_SNAP_NO_FCS);
}

void
atmForumMibHelper_fillatmfAtmServiceTypeExtensionTable
    (ATM_FORUM_MIB_ATMFATMSERVICETYPEEXTENSIONTABLE * pTable)
{
    ATM_FORUM_MIB_ATMFATMSERVICETYPEEXTENSIONTABLE *p = pTable;
    int totalServiceTypeCount;
    int i;
    
    totalServiceTypeCount = atmForumMibHelper_getServiceTypeCount();
    for (i = 1; i <= totalServiceTypeCount; i++) {
      atmForumHelper_setServiceTypeExtDefValues(p);
      p->pTableBeginning = pTable;
      /* get index from serviceTypeType table */
      p->index = i;      
      if (i == totalServiceTypeCount) {
        /* the last row */
        p->next = NULL;
      }
      else {
        p->next = (p+1);
        p++;
      }
    } /* for all services */
}
#endif                          /* DO_ATMFATMSERVICETYPEEXTENSIONTABLE */

#endif                          /* BUILD_SNMP_ATMFORUM_MIB */
