#ifdef BUILD_SNMP_ATM_MIB

/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.iterate.conf,v 5.2 2002/07/17 14:41:53 dts12 Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "atmMIB.h"
#include "atmMibHelper.h"
#include "atmMibDefs.h"

#ifdef ATMIFCONFTBL
void atmInterfaceConf_contextFree(void *context, netsnmp_iterator_info *dont_care)
{
   ATMMIBLOG_DEBUG(("atmInterfaceConf_contextFree: Dealloc at address %p \n", ((ATM_INTERFACE_CONF_TABLE*)context)->pTableBeginning ));
   free( ((ATM_INTERFACE_CONF_TABLE*)context)->pTableBeginning );
}
#endif

#ifdef ATMIFTCTBL
void atmInterfaceTC_contextFree(void *context, netsnmp_iterator_info *dont_care)
{
   ATMMIBLOG_DEBUG(("atmInterfaceTC_contextFree: Dealloc at address %p \n", ((ATM_INTERFACE_TC_TABLE*)context)->pTableBeginning ));
   free( ((ATM_INTERFACE_TC_TABLE*)context)->pTableBeginning );
}
#endif

#ifdef ATMTRAFFDESCTBL
void atmTrafDesc_contextFree(void *context, netsnmp_iterator_info *dont_care)
{
   ATMMIBLOG_DEBUG(("atmTrafDesc_contextFree: Dealloc at address %p \n", ((ATM_TRAFDESC_TABLE*)context)->pTableBeginning ));
   free( ((ATM_TRAFDESC_TABLE*)context)->pTableBeginning );
}
#endif

#ifdef ATMVCLTBL
void atmVcl_contextFree(void *context, netsnmp_iterator_info *dont_care)
{
   ATMMIBLOG_DEBUG(("atmTrafDesc_contextFree: Dealloc at address %p \n", ((ATM_VCL_TABLE*)context)->pTableBeginning ));
   free( ((ATM_VCL_TABLE*)context)->pTableBeginning );
}
#endif

#ifdef AAL5VCCTBL
void aal5Vcc_contextFree(void *context, netsnmp_iterator_info *dont_care)
{
   ATMMIBLOG_DEBUG(("aal5Vcc_contextFree: Dealloc at address %p \n", ((AAL5_VCC_TABLE*)context)->pTableBeginning ));
   free( ((AAL5_VCC_TABLE*)context)->pTableBeginning );
}
#endif

#ifdef AAL5VCCTBL
/** Initialize the aal5VccTable table by defining its contents and how it's structured */
void
initialize_table_aal5VccTable(void)
{
    static oid aal5VccTable_oid[] = {1,3,6,1,2,1,37,1,12};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /* create the table structure itself */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /* if your table is read only, it's easiest to change the
       HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("aal5VccTable",
                                             aal5VccTable_handler,
                                             aal5VccTable_oid,
                                             OID_LENGTH(aal5VccTable_oid),
                                             HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo)
        return; /* mallocs failed */

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /* index: ifIndex */
                                  ASN_INTEGER, /* index: aal5VccVpi */
                                  ASN_INTEGER, /* index: aal5VccVci */
                             0);

    table_info->min_column = 3;
    table_info->max_column = 5;

    /* iterator access routines */
    iinfo->get_first_data_point = aal5VccTable_get_first_data_point;
    iinfo->get_next_data_point = aal5VccTable_get_next_data_point;
    iinfo->free_loop_context_at_end = aal5Vcc_contextFree;

    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_aal5VccTable",
                "Registering table aal5VccTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}
#endif /* AAL5VCCTBL */

#ifdef ATMVCLTBL
/** Initialize the atmVclTable table by defining its contents and how it's structured */
void
initialize_table_atmVclTable(void)
{
    static oid atmVclTable_oid[] = {1,3,6,1,2,1,37,1,7};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /* create the table structure itself */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /* if your table is read only, it's easiest to change the
       HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("atmVclTable",
                                             atmVclTable_handler,
                                             atmVclTable_oid,
                                             OID_LENGTH(atmVclTable_oid),
                                             HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo)
        return; /* mallocs failed */

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /* index: ifIndex */
                                  ASN_INTEGER, /* index: atmVclVpi */
                                  ASN_INTEGER, /* index: atmVclVci */
                             0);

    table_info->min_column = 3;
    table_info->max_column = 15;

    /* iterator access routines */
    iinfo->get_first_data_point = atmVclTable_get_first_data_point;
    iinfo->get_next_data_point = atmVclTable_get_next_data_point;
    iinfo->free_loop_context_at_end = atmVcl_contextFree;

    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_atmVclTable",
                "Registering table atmVclTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}
#endif /* ATMVCLTBL */

#ifdef ATMTRAFFDESCTBL
/** Initialize the atmTrafficDescrParamTable table by defining its contents and how it's structured */
void
initialize_table_atmTrafficDescrParamTable(void)
{
    static oid atmTrafficDescrParamTable_oid[] = {1,3,6,1,2,1,37,1,5};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /* create the table structure itself */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /* if your table is read only, it's easiest to change the
       HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("atmTrafficDescrParamTable",
                                             atmTrafficDescrParamTable_handler,
                                             atmTrafficDescrParamTable_oid,
                                             OID_LENGTH(atmTrafficDescrParamTable_oid),
                                             HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo)
        return; /* mallocs failed */

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /* index: atmTrafficDescrParamIndex */
                             0);

    table_info->min_column = 2;
    table_info->max_column = 11;

    /* iterator access routines */
    iinfo->get_first_data_point = atmTrafficDescrParamTable_get_first_data_point;
    iinfo->get_next_data_point = atmTrafficDescrParamTable_get_next_data_point;
    iinfo->free_loop_context_at_end = atmTrafDesc_contextFree;

    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_atmTrafficDescrParamTable",
                "Registering table atmTrafficDescrParamTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}
#endif /* ATMTRAFFDESCTBL */

#ifdef ATMIFTCTBL
/** Initialize the atmInterfaceTCTable table by defining its contents and how it's structured */
void
initialize_table_atmInterfaceTCTable(void)
{
    static oid atmInterfaceTCTable_oid[] = {1,3,6,1,2,1,37,1,4};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /* create the table structure itself */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /* if your table is read only, it's easiest to change the
       HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("atmInterfaceTCTable",
                                             atmInterfaceTCTable_handler,
                                             atmInterfaceTCTable_oid,
                                             OID_LENGTH(atmInterfaceTCTable_oid),
                                             HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo)
        return; /* mallocs failed */

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /* index: ifIndex */
                             0);

    table_info->min_column = 1;
    table_info->max_column = 2;

    /* iterator access routines */
    iinfo->get_first_data_point = atmInterfaceTCTable_get_first_data_point;
    iinfo->get_next_data_point = atmInterfaceTCTable_get_next_data_point;
    iinfo->free_loop_context_at_end = atmInterfaceTC_contextFree;

    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_atmInterfaceTCTable",
                "Registering table atmInterfaceTCTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}
#endif /* ATMIFTCTBL */

#ifdef ATMIFCONFTBL
/** Initialize the atmInterfaceConfTable table by defining its contents and how it's structured */
void
initialize_table_atmInterfaceConfTable(void)
{
    static oid atmInterfaceConfTable_oid[] = {1,3,6,1,2,1,37,1,2};
    netsnmp_table_registration_info *table_info;
    netsnmp_handler_registration *my_handler;
    netsnmp_iterator_info *iinfo;

    /* create the table structure itself */
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);

    /* if your table is read only, it's easiest to change the
       HANDLER_CAN_RWRITE definition below to HANDLER_CAN_RONLY */
    my_handler = netsnmp_create_handler_registration("atmInterfaceConfTable",
                                             atmInterfaceConfTable_handler,
                                             atmInterfaceConfTable_oid,
                                             OID_LENGTH(atmInterfaceConfTable_oid),
                                             HANDLER_CAN_RONLY);

    if (!my_handler || !table_info || !iinfo)
        return; /* mallocs failed */

    /***************************************************
     * Setting up the table's definition
     */
    netsnmp_table_helper_add_indexes(table_info,
                                  ASN_INTEGER, /* index: ifIndex */
                             0);

    table_info->min_column = 1;
    table_info->max_column = 15;

    /* iterator access routines */
    iinfo->get_first_data_point = (Netsnmp_First_Data_Point*)atmInterfaceConfTable_get_first_data_point;
    iinfo->get_next_data_point = (Netsnmp_Next_Data_Point*)atmInterfaceConfTable_get_next_data_point;
    iinfo->free_loop_context_at_end = atmInterfaceConf_contextFree;

    iinfo->table_reginfo = table_info;

    /***************************************************
     * registering the table with the master agent
     */
    DEBUGMSGTL(("initialize_table_atmInterfaceConfTable",
                "Registering table atmInterfaceConfTable as a table iterator\n"));
    netsnmp_register_table_iterator(my_handler, iinfo);
}
#endif /* ATMIFCONFTBL */

/** Initializes the atmMIB module */
void
init_atmMIB(void)
{

  /* here we initialize all the tables we're planning on supporting */
#ifdef AAL5VCCTBL
    initialize_table_aal5VccTable();
#endif

#ifdef ATMVCLTBL
    initialize_table_atmVclTable();
#endif

#ifdef ATMTRAFFDESCTBL
    initialize_table_atmTrafficDescrParamTable();
#endif

#ifdef ATMIFTCTBL
    initialize_table_atmInterfaceTCTable();
#endif

#ifdef ATMIFCONFTBL
    initialize_table_atmInterfaceConfTable();
#endif
}


#ifdef AAL5VCCTBL
/** returns the first data point within the aal5VccTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
aal5VccTable_get_first_data_point(void **my_loop_context, void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{
    netsnmp_variable_list *vptr;
    int  totalVccCount;
   AAL5_VCC_TABLE* pAal5VccTable;

   /* Check the total number of VCCs for all the ATM interfaces
   ** in order to allocate enough room for the table. */
   totalVccCount = atmMibHelper_getTotalVccCount();

    if ( totalVccCount > 0 )
    {
       pAal5VccTable= calloc( totalVccCount, sizeof(AAL5_VCC_TABLE) );
       ATMMIBLOG_DEBUG(("aal5VccTable_get_first_data_point: Alloc at address %p", pAal5VccTable));
    }
    else
    {
       /* No entries in the AAL5 VCC table */
       return( NULL );
    }

    if ( atmMibHelper_fillAal5VccTable( pAal5VccTable ) != 0 )
    {
      /* Error occurred while filling the traffic descriptor table */
      return( NULL );
    }

    *my_loop_context = (AAL5_VCC_TABLE*)pAal5VccTable;
    *my_data_context = (AAL5_VCC_TABLE*)pAal5VccTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5ifIndex, sizeof(pAal5VccTable->aal5ifIndex) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5VccVpi, sizeof(pAal5VccTable->aal5VccVpi) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5VccVci, sizeof(pAal5VccTable->aal5VccVci) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as aal5VccTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
aal5VccTable_get_next_data_point(void **my_loop_context, void **my_data_context,
                         netsnmp_variable_list *put_index_data,
                         netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    AAL5_VCC_TABLE*  pAal5VccTable;

    ATMMIBLOG_DEBUG(("Entered aal5VccTable_get_next_data_point"));

    pAal5VccTable = (AAL5_VCC_TABLE*)*my_loop_context;

    pAal5VccTable = pAal5VccTable->next;

    if (pAal5VccTable == NULL)
       return NULL;

    *my_loop_context = (AAL5_VCC_TABLE*)pAal5VccTable;
    *my_data_context = (AAL5_VCC_TABLE*)pAal5VccTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5ifIndex, sizeof(pAal5VccTable->aal5ifIndex) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5VccVpi, sizeof(pAal5VccTable->aal5VccVpi) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAal5VccTable->aal5VccVci, sizeof(pAal5VccTable->aal5VccVci) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the aal5VccTable table, if anything else needs to be done */
int
aal5VccTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_request_info* request;
   AAL5_VCC_TABLE* data;

    ATMMIBLOG_DEBUG(("Entered aal5VccTable_handler"));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /* perform anything here that you need to do.  The request have
           already been processed by the master table_dataset handler, but
           this gives you chance to act on the request in some other way
           if need be. */

        /* the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the aal5VccTable table in question */
        data = (AAL5_VCC_TABLE*) netsnmp_extract_iterator_context(request);
        if (data == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            /* XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /* extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /* table_info->colnum contains the column number requested */
        /* table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info==NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            /* the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_AAL5VCCCRCERRORS:
                        snmp_set_var_typed_value(var, ASN_COUNTER, (u_char *)&data->aal5VccCrcErrors, sizeof(data->aal5VccCrcErrors) );
                        break;

                    case COLUMN_AAL5VCCSARTIMEOUTS:
                        snmp_set_var_typed_value(var, ASN_COUNTER, (u_char *)&data->aal5VccSarTimeOuts, sizeof(data->aal5VccSarTimeOuts) );
                        break;

                    case COLUMN_AAL5VCCOVERSIZEDSDUS:
                        snmp_set_var_typed_value(var, ASN_COUNTER, (u_char *)&data->aal5VccOverSizedSDUs, sizeof(data->aal5VccOverSizedSDUs) );
                        break;

                    default:
                        /* We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in aal5VccTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                /* set handling... */

            default:
                snmp_log(LOG_ERR, "problem encountered in aal5VccTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}
#endif /* AAL5VCCTBL */


#ifdef ATMVCLTBL
/** returns the first data point within the atmVclTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
atmVclTable_get_first_data_point(void **my_loop_context, void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    int  totalVccCount;
   ATM_VCL_TABLE* pAtmVclTable;

   /* Check the total number of VCCs for all the ATM interfaces
   ** in order to allocate enough room for the table. */
   totalVccCount = atmMibHelper_getTotalVccCount();

    if ( totalVccCount > 0 )
    {
   pAtmVclTable = calloc( totalVccCount, sizeof(ATM_VCL_TABLE) );
   ATMMIBLOG_DEBUG(("atmVclTable_get_first_data_point: Alloc at address %p", pAtmVclTable));
    }
    else
    {
       /* No entries in the VCL table */
       return( NULL );
    }

    if ( atmMibHelper_fillAtmVclTable( pAtmVclTable ) != 0 )
    {
      /* Error occurred while filling the ATM VCL table */
      return( NULL );
    }

    *my_loop_context = (ATM_VCL_TABLE*)pAtmVclTable;
    *my_data_context = (ATM_VCL_TABLE*)pAtmVclTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->ifIndex, sizeof(pAtmVclTable->ifIndex) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->atmVclVpi, sizeof(pAtmVclTable->atmVclVpi) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->atmVclVci, sizeof(pAtmVclTable->atmVclVci) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as atmVclTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
atmVclTable_get_next_data_point(void **my_loop_context, void **my_data_context,
                         netsnmp_variable_list *put_index_data,
                         netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    ATM_VCL_TABLE*  pAtmVclTable;

    ATMMIBLOG_DEBUG(("Entered atmVclTable_get_next_data_point"));

    pAtmVclTable = (ATM_VCL_TABLE*)*my_loop_context;
    pAtmVclTable = pAtmVclTable->next;

    if (pAtmVclTable == NULL)
       return NULL;

    *my_loop_context = (ATM_VCL_TABLE*)pAtmVclTable;
    *my_data_context = (ATM_VCL_TABLE*)pAtmVclTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->ifIndex, sizeof(pAtmVclTable->ifIndex) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->atmVclVpi, sizeof(pAtmVclTable->atmVclVpi) );
    vptr = vptr->next_variable;
    snmp_set_var_value(vptr, (u_char *)&pAtmVclTable->atmVclVci, sizeof(pAtmVclTable->atmVclVci) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the atmVclTable table, if anything else needs to be done */
int
atmVclTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_request_info* request;
   ATM_VCL_TABLE* data;

    ATMMIBLOG_DEBUG(("Entered atmVclTable_handler"));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /* perform anything here that you need to do.  The request have
           already been processed by the master table_dataset handler, but
           this gives you chance to act on the request in some other way
           if need be. */

        /* the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the atmVclTable table in question */
        data = (ATM_VCL_TABLE*) netsnmp_extract_iterator_context(request);
        if (data == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            /* XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /* extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /* table_info->colnum contains the column number requested */
        /* table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info==NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            /* the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_ATMVCLADMINSTATUS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclAdminStatus, sizeof(data->atmVclAdminStatus) );
                        break;

                    case COLUMN_ATMVCLOPERSTATUS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclOperStatus, sizeof(data->atmVclOperStatus) );
                        break;

                    case COLUMN_ATMVCLLASTCHANGE:
                        snmp_set_var_typed_value(var, ASN_TIMETICKS, (u_char *)&data->atmVclLastChange, sizeof(data->atmVclLastChange) );
                        break;

                    case COLUMN_ATMVCLRECEIVETRAFFICDESCRINDEX:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclReceiveTrafficDescrIndex, sizeof(data->atmVclReceiveTrafficDescrIndex) );
                        break;

                    case COLUMN_ATMVCLTRANSMITTRAFFICDESCRINDEX:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclTransmitTrafficDescrIndex, sizeof(data->atmVclTransmitTrafficDescrIndex) );
                        break;

                    case COLUMN_ATMVCCAALTYPE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVccAalType, sizeof(data->atmVccAalType) );
                        break;

                    case COLUMN_ATMVCCAAL5CPCSTRANSMITSDUSIZE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVccAal5CpcsTransmitSduSize, sizeof(data->atmVccAal5CpcsTransmitSduSize) );
                        break;

                    case COLUMN_ATMVCCAAL5CPCSRECEIVESDUSIZE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVccAal5CpcsReceiveSduSize, sizeof(data->atmVccAal5CpcsReceiveSduSize) );
                        break;

                    case COLUMN_ATMVCCAAL5ENCAPSTYPE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVccAal5EncapsType, sizeof(data->atmVccAal5EncapsType) );
                        break;

                    case COLUMN_ATMVCLCROSSCONNECTIDENTIFIER:
                        snmp_set_var_typed_value(var, SNMP_NOSUCHOBJECT,(u_char*)NULL,0);
                        break;

                    case COLUMN_ATMVCLROWSTATUS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclRowStatus, sizeof(data->atmVclRowStatus) );
                        break;

                    case COLUMN_ATMVCLCASTTYPE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclCastType, sizeof(data->atmVclCastType) );
                        break;

                    case COLUMN_ATMVCLCONNKIND:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmVclConnKind, sizeof(data->atmVclConnKind) );
                        break;

                    default:
                        /* We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in atmVclTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                /* set handling... */

            default:
                snmp_log(LOG_ERR, "problem encountered in atmVclTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}
#endif /* ATMVCLTBL */


#ifdef ATMTRAFFDESCTBL
/** returns the first data point within the atmTrafficDescrParamTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
atmTrafficDescrParamTable_get_first_data_point(void **my_loop_context, void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
   int trafDescIndexCount;
   ATM_TRAFDESC_TABLE*  pAtmTrafDescTable;

   ATMMIBLOG_DEBUG(("Entered atmTrafficDescrParamTable_get_first_data_point"));

   trafDescIndexCount = atmMibHelper_getTrafDescIndexCount();
   if ( trafDescIndexCount > 0 )
   {
      pAtmTrafDescTable = calloc( trafDescIndexCount, sizeof(ATM_TRAFDESC_TABLE) );
      ATMMIBLOG_DEBUG(("atmTrafficDescrParamTable_get_first_data_point: Alloc at address %p", pAtmTrafDescTable));
   }
   else
   {
      /* No entries in the traffic descriptor table */
      return( NULL );
   }

    if ( atmMibHelper_fillAtmTrafDescTable( pAtmTrafDescTable ) != 0 )
    {
      /* Error occurred while filling the traffic descriptor table */
      return( NULL );
    }

    *my_loop_context = (ATM_TRAFDESC_TABLE*)pAtmTrafDescTable;
    *my_data_context = (ATM_TRAFDESC_TABLE*)pAtmTrafDescTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmTrafDescTable->atmTrafficDescrParamIndex, sizeof(pAtmTrafDescTable->atmTrafficDescrParamIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as atmTrafficDescrParamTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
atmTrafficDescrParamTable_get_next_data_point(void **my_loop_context, void **my_data_context,
                         netsnmp_variable_list *put_index_data,
                         netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    ATM_TRAFDESC_TABLE*  pAtmTrafDescTable;

    ATMMIBLOG_DEBUG(("Entered atmTrafficDescrParamTable_get_next_data_point"));

    pAtmTrafDescTable = (ATM_TRAFDESC_TABLE*)*my_loop_context;
    pAtmTrafDescTable = pAtmTrafDescTable->next;

    if (pAtmTrafDescTable == NULL)
       return NULL;

    *my_loop_context = (ATM_TRAFDESC_TABLE*)pAtmTrafDescTable;
    *my_data_context = (ATM_TRAFDESC_TABLE*)pAtmTrafDescTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmTrafDescTable->atmTrafficDescrParamIndex, sizeof(pAtmTrafDescTable->atmTrafficDescrParamIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the atmTrafficDescrParamTable table, if anything else needs to be done */
int
atmTrafficDescrParamTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_request_info* request;
   ATM_TRAFDESC_TABLE* data;

   ATMMIBLOG_DEBUG(("Entered atmTrafficDescrParamTable_handler"));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /* perform anything here that you need to do.  The request have
           already been processed by the master table_dataset handler, but
           this gives you chance to act on the request in some other way
           if need be. */

        /* the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the atmTrafficDescrParamTable table in question */
        data = (ATM_TRAFDESC_TABLE*) netsnmp_extract_iterator_context(request);
        if ( data == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            /* XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /* extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /* table_info->colnum contains the column number requested */
        /* table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info==NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            /* the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_ATMTRAFFICDESCRTYPE:
                        snmp_set_var_typed_value(var, ASN_OBJECT_ID, (u_char *)data->atmTrafficDescrType, ATM_TRAFDESC_OIDLEN * sizeof(oid ) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRPARAM1:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrParam1, sizeof(data->atmTrafficDescrParam1) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRPARAM2:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrParam2, sizeof(data->atmTrafficDescrParam2) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRPARAM3:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrParam3, sizeof(data->atmTrafficDescrParam3) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRPARAM4:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrParam4, sizeof(data->atmTrafficDescrParam4) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRPARAM5:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrParam5, sizeof(data->atmTrafficDescrParam5) );
                        break;

                    case COLUMN_ATMTRAFFICQOSCLASS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficQoSClass, sizeof(data->atmTrafficQoSClass) );
                        break;

                    case COLUMN_ATMTRAFFICDESCRROWSTATUS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficDescrRowStatus, sizeof(data->atmTrafficDescrRowStatus) );
                        break;

                    case COLUMN_ATMSERVICECATEGORY:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmServiceCategory, sizeof(data->atmServiceCategory) );
                        break;

                    case COLUMN_ATMTRAFFICFRAMEDISCARD:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmTrafficFrameDiscard, sizeof(data->atmTrafficFrameDiscard) );
                        break;

                    default:
                        /* We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in atmTrafficDescrParamTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                /* set handling... */

            default:
                snmp_log(LOG_ERR, "problem encountered in atmTrafficDescrParamTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}
#endif /* ATMTRAFFDESCTBL */


#ifdef ATMIFTCTBL
/** returns the first data point within the atmInterfaceTCTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
atmInterfaceTCTable_get_first_data_point(void **my_loop_context, void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    int ifCount;
    ATM_INTERFACE_TC_TABLE*  pAtmIfTCTable;

    ATMMIBLOG_DEBUG(("Entered atmInterfaceTCTable_get_first_data_point"));

    ifCount = atmMibHelper_getAtmIfCount();
    pAtmIfTCTable = calloc( ifCount, sizeof(ATM_INTERFACE_TC_TABLE) );
    ATMMIBLOG_DEBUG(("atmInterfaceTCTable_get_first_data_point: Alloc at address %p", pAtmTrafDescTable));

    if ( pAtmIfTCTable == NULL )
    {
       ATMMIBLOG_ERROR(("CANNOT ALLOCATE MEMORY: file %s, line %u", __FILE__, __LINE__ ));
       return( NULL );
    }

    atmMibHelper_fillAtmIfTCTable( pAtmIfTCTable );

    *my_loop_context = (ATM_INTERFACE_TC_TABLE*)pAtmIfTCTable;
    *my_data_context = (ATM_INTERFACE_TC_TABLE*)pAtmIfTCTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmIfTCTable->ifIndex, sizeof(pAtmIfTCTable->ifIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as atmInterfaceTCTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
atmInterfaceTCTable_get_next_data_point(void **my_loop_context, void **my_data_context,
                         netsnmp_variable_list *put_index_data,
                         netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    ATM_INTERFACE_TC_TABLE*  pAtmIfTCTable;

    ATMMIBLOG_DEBUG(("Entered atmInterfaceTCTable_get_next_data_point"));

    pAtmIfTCTable = (ATM_INTERFACE_TC_TABLE*)*my_loop_context;
    pAtmIfTCTable = pAtmIfTCTable->next;

    if (pAtmIfTCTable == NULL)
       return NULL;

    *my_loop_context = (ATM_INTERFACE_TC_TABLE*)pAtmIfTCTable;
    *my_data_context = (ATM_INTERFACE_TC_TABLE*)pAtmIfTCTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmIfTCTable->ifIndex, sizeof(pAtmIfTCTable->ifIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the atmInterfaceTCTable table, if anything else needs to be done */
int
atmInterfaceTCTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_request_info* request;
   ATM_INTERFACE_TC_TABLE* data;

   ATMMIBLOG_DEBUG(("Entered atmInterfaceTCTable_handler"));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /* perform anything here that you need to do.  The request have
           already been processed by the master table_dataset handler, but
           this gives you chance to act on the request in some other way
           if need be. */

        /* the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the atmInterfaceTCTable table in question */
        data = (ATM_INTERFACE_TC_TABLE*) netsnmp_extract_iterator_context(request);
        if ( data == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            /* XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /* extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /* table_info->colnum contains the column number requested */
        /* table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info==NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            /* the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_ATMINTERFACEOCDEVENTS:
                        snmp_set_var_typed_value(var, ASN_COUNTER, (u_char *)&data->atmInterfaceOCDEvents, sizeof(data->atmInterfaceOCDEvents) );
                        break;

                    case COLUMN_ATMINTERFACETCALARMSTATE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceTCAlarmState, sizeof(data->atmInterfaceTCAlarmState) );
                        break;

                    default:
                        /* We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in atmInterfaceTCTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                /* set handling... */

            default:
                snmp_log(LOG_ERR, "problem encountered in atmInterfaceTCTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}
#endif /* ATMIFTCTBL */


#ifdef ATMIFCONFTBL
/** returns the first data point within the atmInterfaceConfTable table data.

    Set the my_loop_context variable to the first data point structure
    of your choice (from which you can find the next one).  This could
    be anything from the first node in a linked list, to an integer
    pointer containing the beginning of an array variable.

    Set the my_data_context variable to something to be returned to
    you later that will provide you with the data to return in a given
    row.  This could be the same pointer as what my_loop_context is
    set to, or something different.

    The put_index_data variable contains a list of snmp variable
    bindings, one for each index in your table.  Set the values of
    each appropriately according to the data matching the first row
    and return the put_index_data variable at the end of the function.
*/
netsnmp_variable_list *
atmInterfaceConfTable_get_first_data_point(void **my_loop_context, void **my_data_context,
                          netsnmp_variable_list *put_index_data,
                          netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
   int ifCount;
   ATM_INTERFACE_CONF_TABLE*  pAtmIfConfTable;

   ATMMIBLOG_DEBUG(("Entered atmInterfaceConfTable_get_first_data_point"));

   ifCount = atmMibHelper_getAtmIfCount();
   pAtmIfConfTable = calloc( ifCount, sizeof(ATM_INTERFACE_CONF_TABLE) );
   ATMMIBLOG_DEBUG(("atmInterfaceConfTable_get_first_data_point: Alloc at address %p", pAtmIfConfTable));

   if ( pAtmIfConfTable == NULL )
   {
      ATMMIBLOG_ERROR(("CANNOT ALLOCATE MEMORY: file %s, line %u", __FILE__, __LINE__ ));
      return( NULL );
   }

   atmMibHelper_fillAtmIfConfTable( pAtmIfConfTable );

    *my_loop_context = (ATM_INTERFACE_CONF_TABLE*)pAtmIfConfTable;
    *my_data_context = (ATM_INTERFACE_CONF_TABLE*)pAtmIfConfTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmIfConfTable->ifIndex, sizeof(pAtmIfConfTable->ifIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** functionally the same as atmInterfaceConfTable_get_first_data_point, but
   my_loop_context has already been set to a previous value and should
   be updated to the next in the list.  For example, if it was a
   linked list, you might want to cast it and the return
   my_loop_context->next.  The my_data_context pointer should be set
   to something you need later and the indexes in put_index_data
   updated again. */

netsnmp_variable_list *
atmInterfaceConfTable_get_next_data_point(void **my_loop_context, void **my_data_context,
                         netsnmp_variable_list *put_index_data,
                         netsnmp_iterator_info *mydata)
{

    netsnmp_variable_list *vptr;
    ATM_INTERFACE_CONF_TABLE*  pAtmIfConfTable;

    ATMMIBLOG_DEBUG(("Entered atmInterfaceConfTable_get_next_data_point"));

    pAtmIfConfTable = (ATM_INTERFACE_CONF_TABLE*)*my_loop_context;
    pAtmIfConfTable = pAtmIfConfTable->next;

    if (pAtmIfConfTable == NULL)
       return NULL;

    *my_loop_context = (ATM_INTERFACE_CONF_TABLE*)pAtmIfConfTable;
    *my_data_context = (ATM_INTERFACE_CONF_TABLE*)pAtmIfConfTable;

    vptr = put_index_data;

    snmp_set_var_value(vptr, (u_char *)&pAtmIfConfTable->ifIndex, sizeof(pAtmIfConfTable->ifIndex) );
    vptr = vptr->next_variable;

    return put_index_data;
}

/** handles requests for the atmInterfaceConfTable table, if anything else needs to be done */
int
atmInterfaceConfTable_handler(
    netsnmp_mib_handler               *handler,
    netsnmp_handler_registration      *reginfo,
    netsnmp_agent_request_info        *reqinfo,
    netsnmp_request_info              *requests) {

    netsnmp_table_request_info *table_info;
    netsnmp_variable_list *var;
    netsnmp_request_info* request;
   ATM_INTERFACE_CONF_TABLE* data;

   ATMMIBLOG_DEBUG(("Entered atmInterfaceConfTable_handler"));

    for(request = requests; request; request = request->next) {
        var = request->requestvb;
        if (request->processed != 0)
            continue;

        /* perform anything here that you need to do.  The request have
           already been processed by the master table_dataset handler, but
           this gives you chance to act on the request in some other way
           if need be. */

        /* the following extracts the my_data_context pointer set in
           the loop functions above.  You can then use the results to
           help return data for the columns of the atmInterfaceConfTable table in question */
        data = (ATM_INTERFACE_CONF_TABLE*) netsnmp_extract_iterator_context(request);
        if (data == NULL) {
            if (reqinfo->mode == MODE_GET) {
                netsnmp_set_request_error(reqinfo, request, SNMP_NOSUCHINSTANCE);
                continue;
            }
            /* XXX: no row existed, if you support creation and this is a
               set, start dealing with it here, else continue */
        }

        /* extracts the information about the table from the request */
        table_info = netsnmp_extract_table_info(request);
        /* table_info->colnum contains the column number requested */
        /* table_info->indexes contains a linked list of snmp variable
           bindings for the indexes of the table.  Values in the list
           have been set corresponding to the indexes of the
           request */
        if (table_info==NULL) {
            continue;
        }

        switch(reqinfo->mode) {
            /* the table_iterator helper should change all GETNEXTs
               into GETs for you automatically, so you don't have to
               worry about the GETNEXT case.  Only GETs and SETs need
               to be dealt with here */
            case MODE_GET:
                switch(table_info->colnum) {
                    case COLUMN_ATMINTERFACEMAXVPCS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceMaxVpcs, sizeof(data->atmInterfaceMaxVpcs));
                        break;

                    case COLUMN_ATMINTERFACEMAXVCCS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceMaxVccs, sizeof(data->atmInterfaceMaxVccs));
                        break;

                    case COLUMN_ATMINTERFACECONFVPCS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceConfVpcs, sizeof(data->atmInterfaceConfVpcs));
                        break;

                    case COLUMN_ATMINTERFACECONFVCCS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceConfVccs, sizeof(data->atmInterfaceConfVccs));
                        break;

                    case COLUMN_ATMINTERFACEMAXACTIVEVPIBITS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceMaxActiveVpiBits, sizeof(data->atmInterfaceMaxActiveVpiBits));
                        break;

                    case COLUMN_ATMINTERFACEMAXACTIVEVCIBITS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceMaxActiveVciBits, sizeof(data->atmInterfaceMaxActiveVciBits));
                        break;

                    case COLUMN_ATMINTERFACEILMIVPI:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceIlmiVpi, sizeof(data->atmInterfaceIlmiVpi));
                        break;

                    case COLUMN_ATMINTERFACEILMIVCI:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceIlmiVci, sizeof(data->atmInterfaceIlmiVci));
                        break;

                    case COLUMN_ATMINTERFACEADDRESSTYPE:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceAddressType, sizeof(data->atmInterfaceAddressType));
                        break;

                    case COLUMN_ATMINTERFACEADMINADDRESS:
                        snmp_set_var_typed_value(var, ASN_OCTET_STR, (u_char *)data->atmInterfaceAdminAddress, strlen(data->atmInterfaceAdminAddress));
                        break;

                    case COLUMN_ATMINTERFACEMYNEIGHBORIPADDRESS:
                        snmp_set_var_typed_value(var, ASN_IPADDRESS, (u_char *)data->atmInterfaceMyNeighborIpAddress, sizeof(data->atmInterfaceMyNeighborIpAddress));
                        break;

                    case COLUMN_ATMINTERFACEMYNEIGHBORIFNAME:
                        snmp_set_var_typed_value(var, ASN_OCTET_STR, (u_char *)data->atmInterfaceMyNeighborIfName, strlen(data->atmInterfaceMyNeighborIfName));
                        break;

                    case COLUMN_ATMINTERFACECURRENTMAXVPIBITS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceCurrentMaxVpiBits, sizeof(data->atmInterfaceCurrentMaxVpiBits));
                        break;

                    case COLUMN_ATMINTERFACECURRENTMAXVCIBITS:
                        snmp_set_var_typed_value(var, ASN_INTEGER, (u_char *)&data->atmInterfaceCurrentMaxVciBits, sizeof(data->atmInterfaceCurrentMaxVciBits) );
                        break;

                    case COLUMN_ATMINTERFACESUBSCRADDRESS:
                        snmp_set_var_typed_value(var, ASN_OCTET_STR, (u_char *)&data->atmInterfaceSubscrAddress, strlen(data->atmInterfaceSubscrAddress) );
                        break;

                    default:
                        /* We shouldn't get here */
                        snmp_log(LOG_ERR, "problem encountered in atmInterfaceConfTable_handler: unknown column\n");
                }
                break;

            case MODE_SET_RESERVE1:
                /* set handling... */

            default:
                snmp_log(LOG_ERR, "problem encountered in atmInterfaceConfTable_handler: unsupported mode\n");
        }
    }
    return SNMP_ERR_NOERROR;
}

#endif /* ATMIFCONFTBL */

#else
void
init_atmMIB(void)
{
}
#endif /* BUILD_SNMP_ATM_MIB */
