/*
  File autogenerated by gengetopt version 2.7.1
  generated with the following command:
  gengetopt 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h      --help           Print help and exit\n");
  printf("   -V      --version        Print version and exit\n");
  printf("   -d      --decode         Decode a compressed lzma file (default=off)\n");
  printf("   -sINT   --dictsize=INT   Dictionary size in bit (default=20)\n");
  printf("   -bINT   --fastbytes=INT  Number of fast bytes (default=32)\n");
  printf("   -x      --high           Use better, slower compression (default=off)\n");
}



int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;	

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->decode_given = 0 ;
  args_info->dictsize_given = 0 ;
  args_info->fastbytes_given = 0 ;
  args_info->high_given = 0 ;
#define clear_args() { \
  args_info->decode_flag = 0;\
  args_info->dictsize_arg = 20 ;\
  args_info->fastbytes_arg = 32 ;\
  args_info->high_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "decode",	0, NULL, 'd' },
        { "dictsize",	1, NULL, 's' },
        { "fastbytes",	1, NULL, 'b' },
        { "high",	0, NULL, 'x' },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVds:b:x", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'd':	/* Decode a compressed lzma file.  */
          if (args_info->decode_given)
            {
              fprintf (stderr, "%s: `--decode' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->decode_given = 1;
          args_info->decode_flag = !(args_info->decode_flag);
          break;

        case 's':	/* Dictionary size in bit.  */
          if (args_info->dictsize_given)
            {
              fprintf (stderr, "%s: `--dictsize' (`-s') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->dictsize_given = 1;
          args_info->dictsize_arg = atoi (optarg);
          break;

        case 'b':	/* Number of fast bytes.  */
          if (args_info->fastbytes_given)
            {
              fprintf (stderr, "%s: `--fastbytes' (`-b') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->fastbytes_given = 1;
          args_info->fastbytes_arg = atoi (optarg);
          break;

        case 'x':	/* Use better, slower compression.  */
          if (args_info->high_given)
            {
              fprintf (stderr, "%s: `--high' (`-x') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->high_given = 1;
          args_info->high_flag = !(args_info->high_flag);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}
