/*
 * offset.c: Calculate pt_regs and task_struct offsets.
 *
 * Copyright (C) 1996 David S. Miller
 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002 Ralf Baechle
 * Copyright (C) 1999, 2000 Silicon Graphics, Inc.
 *
 * Kevin Kissell, kevink@mips.com and Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 2000 MIPS Technologies, Inc.
 */
#include <linux/config.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/gdb-stub.h>
#include <asm/ptrace.h>
#include <asm/processor.h>

#define text(t) __asm__("\n@@@" t)
#define _offset(type, member) (&(((type *)NULL)->member))

#define offset(string, ptr, member) \
	__asm__("\n@@@" string "%0" : : "i" (_offset(ptr, member)))
#define constant(string, member) \
	__asm__("\n@@@" string "%x0" : : "ri" (member))
#define size(string, size) \
	__asm__("\n@@@" string "%0" : : "i" (sizeof(size)))
#define linefeed text("")

text("/* DO NOT TOUCH, AUTOGENERATED BY OFFSET.C */");
linefeed;
text("#ifndef _MIPS_OFFSET_H");
text("#define _MIPS_OFFSET_H");
linefeed;

void output_ptreg_defines(void)
{
	text("/* MIPS pt_regs offsets. */");
	offset("#define PT_R0     ", struct pt_regs, regs[0]);
	offset("#define PT_R1     ", struct pt_regs, regs[1]);
	offset("#define PT_R2     ", struct pt_regs, regs[2]);
	offset("#define PT_R3     ", struct pt_regs, regs[3]);
	offset("#define PT_R4     ", struct pt_regs, regs[4]);
	offset("#define PT_R5     ", struct pt_regs, regs[5]);
	offset("#define PT_R6     ", struct pt_regs, regs[6]);
	offset("#define PT_R7     ", struct pt_regs, regs[7]);
	offset("#define PT_R8     ", struct pt_regs, regs[8]);
	offset("#define PT_R9     ", struct pt_regs, regs[9]);
	offset("#define PT_R10    ", struct pt_regs, regs[10]);
	offset("#define PT_R11    ", struct pt_regs, regs[11]);
	offset("#define PT_R12    ", struct pt_regs, regs[12]);
	offset("#define PT_R13    ", struct pt_regs, regs[13]);
	offset("#define PT_R14    ", struct pt_regs, regs[14]);
	offset("#define PT_R15    ", struct pt_regs, regs[15]);
	offset("#define PT_R16    ", struct pt_regs, regs[16]);
	offset("#define PT_R17    ", struct pt_regs, regs[17]);
	offset("#define PT_R18    ", struct pt_regs, regs[18]);
	offset("#define PT_R19    ", struct pt_regs, regs[19]);
	offset("#define PT_R20    ", struct pt_regs, regs[20]);
	offset("#define PT_R21    ", struct pt_regs, regs[21]);
	offset("#define PT_R22    ", struct pt_regs, regs[22]);
	offset("#define PT_R23    ", struct pt_regs, regs[23]);
	offset("#define PT_R24    ", struct pt_regs, regs[24]);
	offset("#define PT_R25    ", struct pt_regs, regs[25]);
	offset("#define PT_R26    ", struct pt_regs, regs[26]);
	offset("#define PT_R27    ", struct pt_regs, regs[27]);
	offset("#define PT_R28    ", struct pt_regs, regs[28]);
	offset("#define PT_R29    ", struct pt_regs, regs[29]);
	offset("#define PT_R30    ", struct pt_regs, regs[30]);
	offset("#define PT_R31    ", struct pt_regs, regs[31]);
	offset("#define PT_HI     ", struct pt_regs, hi);
	offset("#define PT_LO     ", struct pt_regs, lo);
	offset("#define PT_EPC    ", struct pt_regs, cp0_epc);
	offset("#define PT_BVADDR ", struct pt_regs, cp0_badvaddr);
	offset("#define PT_STATUS ", struct pt_regs, cp0_status);
	offset("#define PT_CAUSE  ", struct pt_regs, cp0_cause);
	size("#define PT_SIZE   ", struct pt_regs);
	linefeed;
}

void output_task_defines(void)
{
	text("/* MIPS task_struct offsets. */");
	offset("#define TASK_STATE         ", struct task_struct, state);
	offset("#define TASK_FLAGS         ", struct task_struct, flags);
	constant("  #define _PT_TRACESYS        ", PT_TRACESYS);
	offset("#define TASK_SIGPENDING    ", struct task_struct, sigpending);
	offset("#define TASK_NEED_RESCHED  ", struct task_struct, need_resched);
	offset("#define TASK_PTRACE        ", struct task_struct, ptrace);
	offset("#define TASK_COUNTER       ", struct task_struct, counter);
	offset("#define TASK_NICE          ", struct task_struct, nice);
	offset("#define TASK_MM            ", struct task_struct, mm);
	offset("#define TASK_PROCESSOR     ", struct task_struct, processor);
	offset("#define TASK_PID           ", struct task_struct, pid);
	size(  "#define TASK_STRUCT_SIZE   ", struct task_struct);
	linefeed;

	text("/* MIPS task_struct allocation info. */");
	constant("#define _THREAD_ORDER    ", THREAD_ORDER);
	constant("#define _THREAD_SIZE     ", THREAD_SIZE);
	constant("#define _THREAD_MASK     ", THREAD_MASK);
	linefeed;
}

void output_thread_defines(void)
{
	text("/* MIPS specific thread_struct offsets. */");
	offset("#define THREAD_REG16   ", struct task_struct, thread.reg16);
	offset("#define THREAD_REG17   ", struct task_struct, thread.reg17);
	offset("#define THREAD_REG18   ", struct task_struct, thread.reg18);
	offset("#define THREAD_REG19   ", struct task_struct, thread.reg19);
	offset("#define THREAD_REG20   ", struct task_struct, thread.reg20);
	offset("#define THREAD_REG21   ", struct task_struct, thread.reg21);
	offset("#define THREAD_REG22   ", struct task_struct, thread.reg22);
	offset("#define THREAD_REG23   ", struct task_struct, thread.reg23);
	offset("#define THREAD_REG29   ", struct task_struct, thread.reg29);
	offset("#define THREAD_REG30   ", struct task_struct, thread.reg30);
	offset("#define THREAD_REG31   ", struct task_struct, thread.reg31);
	offset("#define THREAD_STATUS  ", struct task_struct, \
	       thread.cp0_status);
	offset("#define THREAD_FPU     ", struct task_struct, thread.fpu);
	offset("#define THREAD_BVADDR  ", struct task_struct, \
	       thread.cp0_badvaddr);
	offset("#define THREAD_BUADDR  ", struct task_struct, \
	       thread.cp0_baduaddr);
	offset("#define THREAD_ECODE   ", struct task_struct, \
	       thread.error_code);
	offset("#define THREAD_TRAPNO  ", struct task_struct, thread.trap_no);
	offset("#define THREAD_MFLAGS  ", struct task_struct, thread.mflags);
	offset("#define THREAD_CURDS   ", struct task_struct, \
	       thread.current_ds);
	offset("#define THREAD_TRAMP   ", struct task_struct, \
	       thread.irix_trampoline);
	offset("#define THREAD_OLDCTX  ", struct task_struct, \
	       thread.irix_oldctx);
	linefeed;
}

void output_mm_defines(void)
{
	text("/* Linux mm_struct offsets. */");
	offset("#define MM_USERS      ", struct mm_struct, mm_users);
	offset("#define MM_PGD        ", struct mm_struct, pgd);
	offset("#define MM_CONTEXT    ", struct mm_struct, context);
	linefeed;
	constant("#define _PAGE_SIZE     ", PAGE_SIZE);
	constant("#define _PAGE_SHIFT    ", PAGE_SHIFT);
	linefeed;
	constant("#define _PGD_T_SIZE    ", sizeof(pgd_t));
	constant("#define _PMD_T_SIZE    ", sizeof(pmd_t));
	constant("#define _PTE_T_SIZE    ", sizeof(pte_t));
	linefeed;
	constant("#define _PGD_T_LOG2    ", PGD_T_LOG2);
	constant("#define _PMD_T_LOG2    ", PMD_T_LOG2);
	constant("#define _PTE_T_LOG2    ", PTE_T_LOG2);
	linefeed;
	constant("#define _PMD_SHIFT     ", PMD_SHIFT);
	constant("#define _PGDIR_SHIFT   ", PGDIR_SHIFT);
	linefeed;
	constant("#define _PGD_ORDER     ", PGD_ORDER);
#ifdef PMD_ORDER
	constant("#define _PMD_ORDER     ", PMD_ORDER);
#endif
	constant("#define _PTE_ORDER     ", PTE_ORDER);
	linefeed;
	constant("#define _PTRS_PER_PGD  ", PTRS_PER_PGD);
	constant("#define _PTRS_PER_PMD  ", PTRS_PER_PMD);
	constant("#define _PTRS_PER_PTE  ", PTRS_PER_PTE);
	linefeed;
}

void output_sc_defines(void)
{
	text("/* Linux sigcontext offsets. */");
	offset("#define SC_REGS       ", struct sigcontext, sc_regs);
	offset("#define SC_FPREGS     ", struct sigcontext, sc_fpregs);
	offset("#define SC_MDHI       ", struct sigcontext, sc_mdhi);
	offset("#define SC_MDLO       ", struct sigcontext, sc_mdlo);
	offset("#define SC_PC         ", struct sigcontext, sc_pc);
	offset("#define SC_STATUS     ", struct sigcontext, sc_status);
	offset("#define SC_FPC_CSR    ", struct sigcontext, sc_fpc_csr);
	offset("#define SC_FPC_EIR    ", struct sigcontext, sc_fpc_eir);
	offset("#define SC_CAUSE      ", struct sigcontext, sc_cause);
	offset("#define SC_BADVADDR   ", struct sigcontext, sc_badvaddr);
	linefeed;

#ifdef CONFIG_MIPS64
	text("/* Linux 32-bit sigcontext offsets. */");
	offset("#define SC32_FPREGS     ", struct sigcontext32, sc_fpregs);
	offset("#define SC32_FPC_CSR    ", struct sigcontext32, sc_fpc_csr);
	offset("#define SC32_FPC_EIR    ", struct sigcontext32, sc_fpc_eir);
	linefeed;
#endif
}

void output_signal_defined(void)
{
	text("/* Linux signal numbers. */");
	constant("#define _SIGHUP     ", SIGHUP);
	constant("#define _SIGINT     ", SIGINT);
	constant("#define _SIGQUIT    ", SIGQUIT);
	constant("#define _SIGILL     ", SIGILL);
	constant("#define _SIGTRAP    ", SIGTRAP);
	constant("#define _SIGIOT     ", SIGIOT);
	constant("#define _SIGABRT    ", SIGABRT);
	constant("#define _SIGEMT     ", SIGEMT);
	constant("#define _SIGFPE     ", SIGFPE);
	constant("#define _SIGKILL    ", SIGKILL);
	constant("#define _SIGBUS     ", SIGBUS);
	constant("#define _SIGSEGV    ", SIGSEGV);
	constant("#define _SIGSYS     ", SIGSYS);
	constant("#define _SIGPIPE    ", SIGPIPE);
	constant("#define _SIGALRM    ", SIGALRM);
	constant("#define _SIGTERM    ", SIGTERM);
	constant("#define _SIGUSR1    ", SIGUSR1);
	constant("#define _SIGUSR2    ", SIGUSR2);
	constant("#define _SIGCHLD    ", SIGCHLD);
	constant("#define _SIGPWR     ", SIGPWR);
	constant("#define _SIGWINCH   ", SIGWINCH);
	constant("#define _SIGURG     ", SIGURG);
	constant("#define _SIGIO      ", SIGIO);
	constant("#define _SIGSTOP    ", SIGSTOP);
	constant("#define _SIGTSTP    ", SIGTSTP);
	constant("#define _SIGCONT    ", SIGCONT);
	constant("#define _SIGTTIN    ", SIGTTIN);
	constant("#define _SIGTTOU    ", SIGTTOU);
	constant("#define _SIGVTALRM  ", SIGVTALRM);
	constant("#define _SIGPROF    ", SIGPROF);
	constant("#define _SIGXCPU    ", SIGXCPU);
	constant("#define _SIGXFSZ    ", SIGXFSZ);
}

void output_gdbreg_defines(void)
{
	text("/* MIPS struct gdb_regs offsets. */");
	offset("#define GDB_FR_REG0     ", struct gdb_regs, reg0);
	offset("#define GDB_FR_REG1     ", struct gdb_regs, reg1);
	offset("#define GDB_FR_REG2     ", struct gdb_regs, reg2);
	offset("#define GDB_FR_REG3     ", struct gdb_regs, reg3);
	offset("#define GDB_FR_REG4     ", struct gdb_regs, reg4);
	offset("#define GDB_FR_REG5     ", struct gdb_regs, reg5);
	offset("#define GDB_FR_REG6     ", struct gdb_regs, reg6);
	offset("#define GDB_FR_REG7     ", struct gdb_regs, reg7);
	offset("#define GDB_FR_REG8     ", struct gdb_regs, reg8);
	offset("#define GDB_FR_REG9     ", struct gdb_regs, reg9);
	offset("#define GDB_FR_REG10    ", struct gdb_regs, reg10);
	offset("#define GDB_FR_REG11    ", struct gdb_regs, reg11);
	offset("#define GDB_FR_REG12    ", struct gdb_regs, reg12);
	offset("#define GDB_FR_REG13    ", struct gdb_regs, reg13);
	offset("#define GDB_FR_REG14    ", struct gdb_regs, reg14);
	offset("#define GDB_FR_REG15    ", struct gdb_regs, reg15);
	offset("#define GDB_FR_REG16    ", struct gdb_regs, reg16);
	offset("#define GDB_FR_REG17    ", struct gdb_regs, reg17);
	offset("#define GDB_FR_REG18    ", struct gdb_regs, reg18);
	offset("#define GDB_FR_REG19    ", struct gdb_regs, reg19);
	offset("#define GDB_FR_REG20    ", struct gdb_regs, reg20);
	offset("#define GDB_FR_REG21    ", struct gdb_regs, reg21);
	offset("#define GDB_FR_REG22    ", struct gdb_regs, reg22);
	offset("#define GDB_FR_REG23    ", struct gdb_regs, reg23);
	offset("#define GDB_FR_REG24    ", struct gdb_regs, reg24);
	offset("#define GDB_FR_REG25    ", struct gdb_regs, reg25);
	offset("#define GDB_FR_REG26    ", struct gdb_regs, reg26);
	offset("#define GDB_FR_REG27    ", struct gdb_regs, reg27);
	offset("#define GDB_FR_REG28    ", struct gdb_regs, reg28);
	offset("#define GDB_FR_REG29    ", struct gdb_regs, reg29);
	offset("#define GDB_FR_REG30    ", struct gdb_regs, reg30);
	offset("#define GDB_FR_REG31    ", struct gdb_regs, reg31);
	linefeed;

	offset("#define GDB_FR_STATUS   ", struct gdb_regs, cp0_status);
	offset("#define GDB_FR_HI       ", struct gdb_regs, hi);
	offset("#define GDB_FR_LO       ", struct gdb_regs, lo);
#ifdef CONFIG_CPU_HAS_SMARTMIPS
	offset("#define GDB_FR_ACX      ", struct gdb_regs, acx);
#endif
	offset("#define GDB_FR_BADVADDR ", struct gdb_regs, cp0_badvaddr);
	offset("#define GDB_FR_CAUSE    ", struct gdb_regs, cp0_cause);
	offset("#define GDB_FR_EPC      ", struct gdb_regs, cp0_epc);
	linefeed;

	offset("#define GDB_FR_FPR0        ", struct gdb_regs, fpr0);
	offset("#define GDB_FR_FPR1        ", struct gdb_regs, fpr1);
	offset("#define GDB_FR_FPR2        ", struct gdb_regs, fpr2);
	offset("#define GDB_FR_FPR3        ", struct gdb_regs, fpr3);
	offset("#define GDB_FR_FPR4        ", struct gdb_regs, fpr4);
	offset("#define GDB_FR_FPR5        ", struct gdb_regs, fpr5);
	offset("#define GDB_FR_FPR6        ", struct gdb_regs, fpr6);
	offset("#define GDB_FR_FPR7        ", struct gdb_regs, fpr7);
	offset("#define GDB_FR_FPR8        ", struct gdb_regs, fpr8);
	offset("#define GDB_FR_FPR9        ", struct gdb_regs, fpr9);
	offset("#define GDB_FR_FPR10        ", struct gdb_regs, fpr10);
	offset("#define GDB_FR_FPR11        ", struct gdb_regs, fpr11);
	offset("#define GDB_FR_FPR12        ", struct gdb_regs, fpr12);
	offset("#define GDB_FR_FPR13        ", struct gdb_regs, fpr13);
	offset("#define GDB_FR_FPR14        ", struct gdb_regs, fpr14);
	offset("#define GDB_FR_FPR15        ", struct gdb_regs, fpr15);
	offset("#define GDB_FR_FPR16        ", struct gdb_regs, fpr16);
	offset("#define GDB_FR_FPR17        ", struct gdb_regs, fpr17);
	offset("#define GDB_FR_FPR18        ", struct gdb_regs, fpr18);
	offset("#define GDB_FR_FPR19        ", struct gdb_regs, fpr19);
	offset("#define GDB_FR_FPR20        ", struct gdb_regs, fpr20);
	offset("#define GDB_FR_FPR21        ", struct gdb_regs, fpr21);
	offset("#define GDB_FR_FPR22        ", struct gdb_regs, fpr22);
	offset("#define GDB_FR_FPR23        ", struct gdb_regs, fpr23);
	offset("#define GDB_FR_FPR24        ", struct gdb_regs, fpr24);
	offset("#define GDB_FR_FPR25        ", struct gdb_regs, fpr25);
	offset("#define GDB_FR_FPR26        ", struct gdb_regs, fpr26);
	offset("#define GDB_FR_FPR27        ", struct gdb_regs, fpr27);
	offset("#define GDB_FR_FPR28        ", struct gdb_regs, fpr28);
	offset("#define GDB_FR_FPR29        ", struct gdb_regs, fpr29);
	offset("#define GDB_FR_FPR30        ", struct gdb_regs, fpr30);
	offset("#define GDB_FR_FPR31        ", struct gdb_regs, fpr31);
	linefeed;

	offset("#define GDB_FR_FSR          ", struct gdb_regs, cp1_fsr);
	offset("#define GDB_FR_FIR          ", struct gdb_regs, cp1_fir);
	offset("#define GDB_FR_FRP          ", struct gdb_regs, frame_ptr);
	offset("#define GDB_FR_DUMMY        ", struct gdb_regs, dummy);

	offset("#define GDB_FR_CP0_INDEX    ", struct gdb_regs, cp0_index);
	offset("#define GDB_FR_CP0_RANDOM   ", struct gdb_regs, cp0_random);
	offset("#define GDB_FR_CP0_ENTRYLO0 ", struct gdb_regs, cp0_entrylo0);
	offset("#define GDB_FR_CP0_ENTRYLO1 ", struct gdb_regs, cp0_entrylo1);
	offset("#define GDB_FR_CP0_CONTEXT  ", struct gdb_regs, cp0_context);
	offset("#define GDB_FR_CP0_PAGEMASK ", struct gdb_regs, cp0_pagemask);
	offset("#define GDB_FR_CP0_WIRED    ", struct gdb_regs, cp0_wired);
	offset("#define GDB_FR_CP0_REG7     ", struct gdb_regs, cp0_reg7);
	offset("#define GDB_FR_CP0_REG8     ", struct gdb_regs, cp0_reg8);
	offset("#define GDB_FR_CP0_REG9     ", struct gdb_regs, cp0_reg9);
	offset("#define GDB_FR_CP0_ENTRYHI  ", struct gdb_regs, cp0_entryhi);
	offset("#define GDB_FR_CP0_REG11    ", struct gdb_regs, cp0_reg11);
	offset("#define GDB_FR_CP0_REG12    ", struct gdb_regs, cp0_reg12);
	offset("#define GDB_FR_CP0_REG13    ", struct gdb_regs, cp0_reg13);
	offset("#define GDB_FR_CP0_REG14    ", struct gdb_regs, cp0_reg14);
	offset("#define GDB_FR_CP0_PRID     ", struct gdb_regs, cp0_prid);
	size("#define GDB_FR_SIZE         ", struct gdb_regs);
}

text("#endif /* !(_MIPS_OFFSET_H) */");
