#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "tomato.h"

void trim( char *str)
{
        char *copied, *tail = NULL;
        if ( str == NULL )
                return ;

        for( copied = str; *str; str++ )
        {
                if ( (unsigned char)*str > 0x20 )
                {
                        *copied++ = *str;
                        tail = copied;
                }
                else {
                        if ( tail )
                        	*copied++ = *str;
                }
        }

        if ( tail )
                *tail = 0;
        else
                *copied = 0;
        return ;
}

int strncmp_ex(char *str1, char *str2)
{
	return strncmp(str1, str2, strlen(str2));
}

int get_cpuinfo(char *system_type, char *cpu_model, char *bogomips, char *cpuclk)

{
	FILE *fd;
        char *next;
	char buff[1024];
	char title[128], value[512];
	int okcount=0;
                                                                                                              
	fd = fopen ("/proc/cpuinfo", "r");
	while (fgets(buff, sizeof(buff), fd)) {
		next = buff;
		strcpy(title, strsep(&next, ":"));
		if (next == NULL) continue;
		strcpy(value, next);
		trim(value);
		if (strncmp_ex(title, "system type")==0) {
			okcount++;
			//printf("system type: %s\n", value);
			if (strncmp_ex(value, "Broadcom BCM5354")==0) {
				strcpy(system_type, "Broadcom BCM5354");
			}
			else {
				strcpy(system_type, value);
			}
		}
		if (strncmp_ex(title, "cpu model")==0) {
			okcount++;
			//printf("cpu model: %s\n", value);
			strcpy(cpu_model, value);
		}
		if (strncmp_ex(title, "BogoMIPS")==0) {
			okcount++;
			//printf("bogomips: %s\n", value);
			strcpy(bogomips, value);
		}
		if (strncmp_ex(title, "cpu MHz")==0) {
			okcount++;
			//printf("cpuclk: %s\n", value);
			strcpy(cpuclk, value);
		}

		//fprintf (stderr, "%s - %s", title, value);
	}
	fclose(fd);
	return (okcount==3);
}

