#ifndef _LINUX_BYTEORDER_PDP_ENDIAN_H
#define _LINUX_BYTEORDER_PDP_ENDIAN_H

/*
 * Could have been named NUXI-endian, but we use the same name as in glibc.
 * hopefully only the PDP and its evolutions (old VAXen in compatibility mode)
 * should ever use this braindead byteorder.
 * This file *should* work, but has not been tested.
 *
 * little-endian is 1234; big-endian is 4321; nuxi/pdp-endian is 3412
 *
 * I thought vaxen were NUXI-endian, but was told they were correct-endian
 * (little-endian), though indeed there existed NUXI-endian machines
 * (DEC PDP-11 and old VAXen in compatibility mode).
 * This makes this file a bit useless, but as a proof-of-concept.
 *
 * But what does a __u64 look like: is it 34127856 or 78563412 ???
 * I don't dare imagine! Hence, no 64-bit byteorder support yet.
 * Hopefully, there 64-bit pdp-endian support shouldn't ever be required.
 *
 */

#ifndef __PDP_ENDIAN
#define __PDP_ENDIAN 3412
#endif
#ifndef __PDP_ENDIAN_BITFIELD
#define __PDP_ENDIAN_BITFIELD
#endif

#include <linux/byteorder/swab.h>
#include <linux/byteorder/swabb.h>

#define __constant_htonl(x) ___constant_swahb32((x))
#define __constant_ntohl(x) ___constant_swahb32((x))
#define __constant_htons(x) ___constant_swab16((x))
#define __constant_ntohs(x) ___constant_swab16((x))
